// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class DescribeRouteTablesRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters.
     * + `association.route-table-association-id` - The ID of an association ID for the route table.
     * + `association.route-table-id` - The ID of the route table involved in the association.
     * + `association.subnet-id` - The ID of the subnet involved in the association.
     * + `association.main` - Indicates whether the route table is the main route table for the VPC (`true` | `false`). Route tables that do not have an association ID are not returned in the response.
     * + `owner-id` - The ID of the Amazon Web Services account that owns the route table.
     * + `route-table-id` - The ID of the route table.
     * + `route.destination-cidr-block` - The IPv4 CIDR range specified in a route in the table.
     * + `route.destination-ipv6-cidr-block` - The IPv6 CIDR range specified in a route in the route table.
     * + `route.destination-prefix-list-id` - The ID (prefix) of the Amazon Web Service specified in a route in the table.
     * + `route.egress-only-internet-gateway-id` - The ID of an egress-only Internet gateway specified in a route in the route table.
     * + `route.gateway-id` - The ID of a gateway specified in a route in the table.
     * + `route.instance-id` - The ID of an instance specified in a route in the table.
     * + `route.nat-gateway-id` - The ID of a NAT gateway.
     * + `route.transit-gateway-id` - The ID of a transit gateway.
     * + `route.origin` - Describes how the route was created. `CreateRouteTable` indicates that the route was automatically created when the route table was created; `CreateRoute` indicates that the route was manually added to the route table; `EnableVgwRoutePropagation` indicates that the route was propagated by route propagation.
     * + `route.state` - The state of a route in the route table (`active` | `blackhole`). The blackhole state indicates that the route's target isn't available (for example, the specified gateway isn't attached to the VPC, the specified NAT instance has been terminated, and so on).
     * + `route.vpc-peering-connection-id` - The ID of a VPC peering connection specified in a route in the table.
     * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     * + `vpc-id` - The ID of the VPC for the route table.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * One or more route table IDs.
     *
     * Default: Describes all your route tables.
     */
    public val routeTableIds: List<String>? = builder.routeTableIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeRouteTablesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRouteTablesRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("routeTableIds=$routeTableIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (routeTableIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRouteTablesRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (routeTableIds != other.routeTableIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeRouteTablesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters.
         * + `association.route-table-association-id` - The ID of an association ID for the route table.
         * + `association.route-table-id` - The ID of the route table involved in the association.
         * + `association.subnet-id` - The ID of the subnet involved in the association.
         * + `association.main` - Indicates whether the route table is the main route table for the VPC (`true` | `false`). Route tables that do not have an association ID are not returned in the response.
         * + `owner-id` - The ID of the Amazon Web Services account that owns the route table.
         * + `route-table-id` - The ID of the route table.
         * + `route.destination-cidr-block` - The IPv4 CIDR range specified in a route in the table.
         * + `route.destination-ipv6-cidr-block` - The IPv6 CIDR range specified in a route in the route table.
         * + `route.destination-prefix-list-id` - The ID (prefix) of the Amazon Web Service specified in a route in the table.
         * + `route.egress-only-internet-gateway-id` - The ID of an egress-only Internet gateway specified in a route in the route table.
         * + `route.gateway-id` - The ID of a gateway specified in a route in the table.
         * + `route.instance-id` - The ID of an instance specified in a route in the table.
         * + `route.nat-gateway-id` - The ID of a NAT gateway.
         * + `route.transit-gateway-id` - The ID of a transit gateway.
         * + `route.origin` - Describes how the route was created. `CreateRouteTable` indicates that the route was automatically created when the route table was created; `CreateRoute` indicates that the route was manually added to the route table; `EnableVgwRoutePropagation` indicates that the route was propagated by route propagation.
         * + `route.state` - The state of a route in the route table (`active` | `blackhole`). The blackhole state indicates that the route's target isn't available (for example, the specified gateway isn't attached to the VPC, the specified NAT instance has been terminated, and so on).
         * + `route.vpc-peering-connection-id` - The ID of a VPC peering connection specified in a route in the table.
         * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * + `vpc-id` - The ID of the VPC for the route table.
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * One or more route table IDs.
         *
         * Default: Describes all your route tables.
         */
        public var routeTableIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeRouteTablesRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.routeTableIds = x.routeTableIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeRouteTablesRequest = DescribeRouteTablesRequest(this)
    }
}
