// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the Amazon EBS features supported by the instance type.
 */
public class EbsInfo private constructor(builder: Builder) {
    /**
     * Describes the optimized EBS performance for the instance type.
     */
    public val ebsOptimizedInfo: aws.sdk.kotlin.services.ec2.model.EbsOptimizedInfo? = builder.ebsOptimizedInfo
    /**
     * Indicates whether the instance type is Amazon EBS-optimized. For more information, see [Amazon EBS-optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) in *Amazon EC2 User Guide*.
     */
    public val ebsOptimizedSupport: aws.sdk.kotlin.services.ec2.model.EbsOptimizedSupport? = builder.ebsOptimizedSupport
    /**
     * Indicates whether Amazon EBS encryption is supported.
     */
    public val encryptionSupport: aws.sdk.kotlin.services.ec2.model.EbsEncryptionSupport? = builder.encryptionSupport
    /**
     * Indicates whether non-volatile memory express (NVMe) is supported.
     */
    public val nvmeSupport: aws.sdk.kotlin.services.ec2.model.EbsNvmeSupport? = builder.nvmeSupport

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.EbsInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsInfo(")
        append("ebsOptimizedInfo=$ebsOptimizedInfo,")
        append("ebsOptimizedSupport=$ebsOptimizedSupport,")
        append("encryptionSupport=$encryptionSupport,")
        append("nvmeSupport=$nvmeSupport)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ebsOptimizedInfo?.hashCode() ?: 0
        result = 31 * result + (ebsOptimizedSupport?.hashCode() ?: 0)
        result = 31 * result + (encryptionSupport?.hashCode() ?: 0)
        result = 31 * result + (nvmeSupport?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsInfo

        if (ebsOptimizedInfo != other.ebsOptimizedInfo) return false
        if (ebsOptimizedSupport != other.ebsOptimizedSupport) return false
        if (encryptionSupport != other.encryptionSupport) return false
        if (nvmeSupport != other.nvmeSupport) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.EbsInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the optimized EBS performance for the instance type.
         */
        public var ebsOptimizedInfo: aws.sdk.kotlin.services.ec2.model.EbsOptimizedInfo? = null
        /**
         * Indicates whether the instance type is Amazon EBS-optimized. For more information, see [Amazon EBS-optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) in *Amazon EC2 User Guide*.
         */
        public var ebsOptimizedSupport: aws.sdk.kotlin.services.ec2.model.EbsOptimizedSupport? = null
        /**
         * Indicates whether Amazon EBS encryption is supported.
         */
        public var encryptionSupport: aws.sdk.kotlin.services.ec2.model.EbsEncryptionSupport? = null
        /**
         * Indicates whether non-volatile memory express (NVMe) is supported.
         */
        public var nvmeSupport: aws.sdk.kotlin.services.ec2.model.EbsNvmeSupport? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.EbsInfo) : this() {
            this.ebsOptimizedInfo = x.ebsOptimizedInfo
            this.ebsOptimizedSupport = x.ebsOptimizedSupport
            this.encryptionSupport = x.encryptionSupport
            this.nvmeSupport = x.nvmeSupport
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.EbsInfo = EbsInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EbsOptimizedInfo] inside the given [block]
         */
        public fun ebsOptimizedInfo(block: aws.sdk.kotlin.services.ec2.model.EbsOptimizedInfo.Builder.() -> kotlin.Unit) {
            this.ebsOptimizedInfo = aws.sdk.kotlin.services.ec2.model.EbsOptimizedInfo.invoke(block)
        }
    }
}
