// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The Amazon EC2 launch template that can be used by a Spot Fleet to configure Amazon EC2 instances. You must specify either the ID or name of the launch template in the request, but not both.
 *
 * For information about launch templates, see [Launch an instance from a launch template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html) in the *Amazon EC2 User Guide*.
 */
public class FleetLaunchTemplateSpecification private constructor(builder: Builder) {
    /**
     * The ID of the launch template.
     *
     * You must specify the `LaunchTemplateId` or the `LaunchTemplateName`, but not both.
     */
    public val launchTemplateId: kotlin.String? = builder.launchTemplateId
    /**
     * The name of the launch template.
     *
     * You must specify the `LaunchTemplateName` or the `LaunchTemplateId`, but not both.
     */
    public val launchTemplateName: kotlin.String? = builder.launchTemplateName
    /**
     * The launch template version number, `$Latest`, or `$Default`. You must specify a value, otherwise the request fails.
     *
     * If the value is `$Latest`, Amazon EC2 uses the latest version of the launch template.
     *
     * If the value is `$Default`, Amazon EC2 uses the default version of the launch template.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.FleetLaunchTemplateSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FleetLaunchTemplateSpecification(")
        append("launchTemplateId=$launchTemplateId,")
        append("launchTemplateName=$launchTemplateName,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = launchTemplateId?.hashCode() ?: 0
        result = 31 * result + (launchTemplateName?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FleetLaunchTemplateSpecification

        if (launchTemplateId != other.launchTemplateId) return false
        if (launchTemplateName != other.launchTemplateName) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.FleetLaunchTemplateSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the launch template.
         *
         * You must specify the `LaunchTemplateId` or the `LaunchTemplateName`, but not both.
         */
        public var launchTemplateId: kotlin.String? = null
        /**
         * The name of the launch template.
         *
         * You must specify the `LaunchTemplateName` or the `LaunchTemplateId`, but not both.
         */
        public var launchTemplateName: kotlin.String? = null
        /**
         * The launch template version number, `$Latest`, or `$Default`. You must specify a value, otherwise the request fails.
         *
         * If the value is `$Latest`, Amazon EC2 uses the latest version of the launch template.
         *
         * If the value is `$Default`, Amazon EC2 uses the default version of the launch template.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.FleetLaunchTemplateSpecification) : this() {
            this.launchTemplateId = x.launchTemplateId
            this.launchTemplateName = x.launchTemplateName
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.FleetLaunchTemplateSpecification = FleetLaunchTemplateSpecification(this)
    }
}
