// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the properties of the Dedicated Host.
 */
public class Host private constructor(builder: Builder) {
    /**
     * The time that the Dedicated Host was allocated.
     */
    public val allocationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.allocationTime
    /**
     * Indicates whether the Dedicated Host supports multiple instance types of the same instance family. If the value is `on`, the Dedicated Host supports multiple instance types in the instance family. If the value is `off`, the Dedicated Host supports a single instance type only.
     */
    public val allowsMultipleInstanceTypes: aws.sdk.kotlin.services.ec2.model.AllowsMultipleInstanceTypes? = builder.allowsMultipleInstanceTypes
    /**
     * Whether auto-placement is on or off.
     */
    public val autoPlacement: aws.sdk.kotlin.services.ec2.model.AutoPlacement? = builder.autoPlacement
    /**
     * The Availability Zone of the Dedicated Host.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The ID of the Availability Zone in which the Dedicated Host is allocated.
     */
    public val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * Information about the instances running on the Dedicated Host.
     */
    public val availableCapacity: aws.sdk.kotlin.services.ec2.model.AvailableCapacity? = builder.availableCapacity
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [Ensuring Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ID of the Dedicated Host.
     */
    public val hostId: kotlin.String? = builder.hostId
    /**
     * The hardware specifications of the Dedicated Host.
     */
    public val hostProperties: aws.sdk.kotlin.services.ec2.model.HostProperties? = builder.hostProperties
    /**
     * Indicates whether host recovery is enabled or disabled for the Dedicated Host.
     */
    public val hostRecovery: aws.sdk.kotlin.services.ec2.model.HostRecovery? = builder.hostRecovery
    /**
     * The reservation ID of the Dedicated Host. This returns a `null` response if the Dedicated Host doesn't have an associated reservation.
     */
    public val hostReservationId: kotlin.String? = builder.hostReservationId
    /**
     * The IDs and instance type that are currently running on the Dedicated Host.
     */
    public val instances: List<HostInstance>? = builder.instances
    /**
     * Indicates whether the Dedicated Host is in a host resource group. If **memberOfServiceLinkedResourceGroup** is `true`, the host is in a host resource group; otherwise, it is not.
     */
    public val memberOfServiceLinkedResourceGroup: kotlin.Boolean? = builder.memberOfServiceLinkedResourceGroup
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on which the Dedicated Host is allocated.
     */
    public val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The ID of the Amazon Web Services account that owns the Dedicated Host.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The time that the Dedicated Host was released.
     */
    public val releaseTime: aws.smithy.kotlin.runtime.time.Instant? = builder.releaseTime
    /**
     * The Dedicated Host's state.
     */
    public val state: aws.sdk.kotlin.services.ec2.model.AllocationState? = builder.state
    /**
     * Any tags assigned to the Dedicated Host.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.Host = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Host(")
        append("allocationTime=$allocationTime,")
        append("allowsMultipleInstanceTypes=$allowsMultipleInstanceTypes,")
        append("autoPlacement=$autoPlacement,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("availableCapacity=$availableCapacity,")
        append("clientToken=$clientToken,")
        append("hostId=$hostId,")
        append("hostProperties=$hostProperties,")
        append("hostRecovery=$hostRecovery,")
        append("hostReservationId=$hostReservationId,")
        append("instances=$instances,")
        append("memberOfServiceLinkedResourceGroup=$memberOfServiceLinkedResourceGroup,")
        append("outpostArn=$outpostArn,")
        append("ownerId=$ownerId,")
        append("releaseTime=$releaseTime,")
        append("state=$state,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationTime?.hashCode() ?: 0
        result = 31 * result + (allowsMultipleInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (autoPlacement?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (availableCapacity?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (hostId?.hashCode() ?: 0)
        result = 31 * result + (hostProperties?.hashCode() ?: 0)
        result = 31 * result + (hostRecovery?.hashCode() ?: 0)
        result = 31 * result + (hostReservationId?.hashCode() ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (memberOfServiceLinkedResourceGroup?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (releaseTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Host

        if (allocationTime != other.allocationTime) return false
        if (allowsMultipleInstanceTypes != other.allowsMultipleInstanceTypes) return false
        if (autoPlacement != other.autoPlacement) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (availableCapacity != other.availableCapacity) return false
        if (clientToken != other.clientToken) return false
        if (hostId != other.hostId) return false
        if (hostProperties != other.hostProperties) return false
        if (hostRecovery != other.hostRecovery) return false
        if (hostReservationId != other.hostReservationId) return false
        if (instances != other.instances) return false
        if (memberOfServiceLinkedResourceGroup != other.memberOfServiceLinkedResourceGroup) return false
        if (outpostArn != other.outpostArn) return false
        if (ownerId != other.ownerId) return false
        if (releaseTime != other.releaseTime) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.Host = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time that the Dedicated Host was allocated.
         */
        public var allocationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the Dedicated Host supports multiple instance types of the same instance family. If the value is `on`, the Dedicated Host supports multiple instance types in the instance family. If the value is `off`, the Dedicated Host supports a single instance type only.
         */
        public var allowsMultipleInstanceTypes: aws.sdk.kotlin.services.ec2.model.AllowsMultipleInstanceTypes? = null
        /**
         * Whether auto-placement is on or off.
         */
        public var autoPlacement: aws.sdk.kotlin.services.ec2.model.AutoPlacement? = null
        /**
         * The Availability Zone of the Dedicated Host.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The ID of the Availability Zone in which the Dedicated Host is allocated.
         */
        public var availabilityZoneId: kotlin.String? = null
        /**
         * Information about the instances running on the Dedicated Host.
         */
        public var availableCapacity: aws.sdk.kotlin.services.ec2.model.AvailableCapacity? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [Ensuring Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The ID of the Dedicated Host.
         */
        public var hostId: kotlin.String? = null
        /**
         * The hardware specifications of the Dedicated Host.
         */
        public var hostProperties: aws.sdk.kotlin.services.ec2.model.HostProperties? = null
        /**
         * Indicates whether host recovery is enabled or disabled for the Dedicated Host.
         */
        public var hostRecovery: aws.sdk.kotlin.services.ec2.model.HostRecovery? = null
        /**
         * The reservation ID of the Dedicated Host. This returns a `null` response if the Dedicated Host doesn't have an associated reservation.
         */
        public var hostReservationId: kotlin.String? = null
        /**
         * The IDs and instance type that are currently running on the Dedicated Host.
         */
        public var instances: List<HostInstance>? = null
        /**
         * Indicates whether the Dedicated Host is in a host resource group. If **memberOfServiceLinkedResourceGroup** is `true`, the host is in a host resource group; otherwise, it is not.
         */
        public var memberOfServiceLinkedResourceGroup: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on which the Dedicated Host is allocated.
         */
        public var outpostArn: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the Dedicated Host.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The time that the Dedicated Host was released.
         */
        public var releaseTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Dedicated Host's state.
         */
        public var state: aws.sdk.kotlin.services.ec2.model.AllocationState? = null
        /**
         * Any tags assigned to the Dedicated Host.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.Host) : this() {
            this.allocationTime = x.allocationTime
            this.allowsMultipleInstanceTypes = x.allowsMultipleInstanceTypes
            this.autoPlacement = x.autoPlacement
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.availableCapacity = x.availableCapacity
            this.clientToken = x.clientToken
            this.hostId = x.hostId
            this.hostProperties = x.hostProperties
            this.hostRecovery = x.hostRecovery
            this.hostReservationId = x.hostReservationId
            this.instances = x.instances
            this.memberOfServiceLinkedResourceGroup = x.memberOfServiceLinkedResourceGroup
            this.outpostArn = x.outpostArn
            this.ownerId = x.ownerId
            this.releaseTime = x.releaseTime
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.Host = Host(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AvailableCapacity] inside the given [block]
         */
        public fun availableCapacity(block: aws.sdk.kotlin.services.ec2.model.AvailableCapacity.Builder.() -> kotlin.Unit) {
            this.availableCapacity = aws.sdk.kotlin.services.ec2.model.AvailableCapacity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.HostProperties] inside the given [block]
         */
        public fun hostProperties(block: aws.sdk.kotlin.services.ec2.model.HostProperties.Builder.() -> kotlin.Unit) {
            this.hostProperties = aws.sdk.kotlin.services.ec2.model.HostProperties.invoke(block)
        }
    }
}
