// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an image.
 */
public class Image private constructor(builder: Builder) {
    /**
     * The architecture of the image.
     */
    public val architecture: aws.sdk.kotlin.services.ec2.model.ArchitectureValues? = builder.architecture
    /**
     * Any block device mapping entries.
     */
    public val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The boot mode of the image. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val bootMode: aws.sdk.kotlin.services.ec2.model.BootModeValues? = builder.bootMode
    /**
     * The date and time the image was created.
     */
    public val creationDate: kotlin.String? = builder.creationDate
    /**
     * The date and time to deprecate the AMI, in UTC, in the following format: *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute.
     */
    public val deprecationTime: kotlin.String? = builder.deprecationTime
    /**
     * The description of the AMI that was provided during image creation.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether enhanced networking with ENA is enabled.
     */
    public val enaSupport: kotlin.Boolean? = builder.enaSupport
    /**
     * The hypervisor type of the image.
     */
    public val hypervisor: aws.sdk.kotlin.services.ec2.model.HypervisorType? = builder.hypervisor
    /**
     * The ID of the AMI.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The location of the AMI.
     */
    public val imageLocation: kotlin.String? = builder.imageLocation
    /**
     * The Amazon Web Services account alias (for example, `amazon`, `self`) or the Amazon Web Services account ID of the AMI owner.
     */
    public val imageOwnerAlias: kotlin.String? = builder.imageOwnerAlias
    /**
     * The type of image.
     */
    public val imageType: aws.sdk.kotlin.services.ec2.model.ImageTypeValues? = builder.imageType
    /**
     * If `v2.0`, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI will have `HttpTokens` automatically set to `required` so that, by default, the instance requires that IMDSv2 is used when requesting instance metadata. In addition, `HttpPutResponseHopLimit` is set to `2`. For more information, see [Configure the AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val imdsSupport: aws.sdk.kotlin.services.ec2.model.ImdsSupportValues? = builder.imdsSupport
    /**
     * The kernel associated with the image, if any. Only applicable for machine images.
     */
    public val kernelId: kotlin.String? = builder.kernelId
    /**
     * The name of the AMI that was provided during image creation.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of the Amazon Web Services account that owns the image.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * This value is set to `windows` for Windows AMIs; otherwise, it is blank.
     */
    public val platform: aws.sdk.kotlin.services.ec2.model.PlatformValues? = builder.platform
    /**
     * The platform details associated with the billing code of the AMI. For more information, see [Understanding AMI billing](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val platformDetails: kotlin.String? = builder.platformDetails
    /**
     * Any product codes associated with the AMI.
     */
    public val productCodes: List<ProductCode>? = builder.productCodes
    /**
     * Indicates whether the image has public launch permissions. The value is `true` if this image has public launch permissions or `false` if it has only implicit and explicit launch permissions.
     */
    public val public: kotlin.Boolean? = builder.public
    /**
     * The RAM disk associated with the image, if any. Only applicable for machine images.
     */
    public val ramdiskId: kotlin.String? = builder.ramdiskId
    /**
     * The device name of the root device volume (for example, `/dev/sda1`).
     */
    public val rootDeviceName: kotlin.String? = builder.rootDeviceName
    /**
     * The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.
     */
    public val rootDeviceType: aws.sdk.kotlin.services.ec2.model.DeviceType? = builder.rootDeviceType
    /**
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public val sriovNetSupport: kotlin.String? = builder.sriovNetSupport
    /**
     * The current state of the AMI. If the state is `available`, the image is successfully registered and can be used to launch an instance.
     */
    public val state: aws.sdk.kotlin.services.ec2.model.ImageState? = builder.state
    /**
     * The reason for the state change.
     */
    public val stateReason: aws.sdk.kotlin.services.ec2.model.StateReason? = builder.stateReason
    /**
     * Any tags assigned to the image.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val tpmSupport: aws.sdk.kotlin.services.ec2.model.TpmSupportValues? = builder.tpmSupport
    /**
     * The operation of the Amazon EC2 instance and the billing code that is associated with the AMI. `usageOperation` corresponds to the [lineitem/Operation](https://docs.aws.amazon.com/cur/latest/userguide/Lineitem-columns.html#Lineitem-details-O-Operation) column on your Amazon Web Services Cost and Usage Report and in the [Amazon Web Services Price List API](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html). You can view these fields on the **Instances** or **AMIs** pages in the Amazon EC2 console, or in the responses that are returned by the [DescribeImages](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html) command in the Amazon EC2 API, or the [describe-images](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-images.html) command in the CLI.
     */
    public val usageOperation: kotlin.String? = builder.usageOperation
    /**
     * The type of virtualization of the AMI.
     */
    public val virtualizationType: aws.sdk.kotlin.services.ec2.model.VirtualizationType? = builder.virtualizationType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.Image = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Image(")
        append("architecture=$architecture,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("bootMode=$bootMode,")
        append("creationDate=$creationDate,")
        append("deprecationTime=$deprecationTime,")
        append("description=$description,")
        append("enaSupport=$enaSupport,")
        append("hypervisor=$hypervisor,")
        append("imageId=$imageId,")
        append("imageLocation=$imageLocation,")
        append("imageOwnerAlias=$imageOwnerAlias,")
        append("imageType=$imageType,")
        append("imdsSupport=$imdsSupport,")
        append("kernelId=$kernelId,")
        append("name=$name,")
        append("ownerId=$ownerId,")
        append("platform=$platform,")
        append("platformDetails=$platformDetails,")
        append("productCodes=$productCodes,")
        append("public=$public,")
        append("ramdiskId=$ramdiskId,")
        append("rootDeviceName=$rootDeviceName,")
        append("rootDeviceType=$rootDeviceType,")
        append("sriovNetSupport=$sriovNetSupport,")
        append("state=$state,")
        append("stateReason=$stateReason,")
        append("tags=$tags,")
        append("tpmSupport=$tpmSupport,")
        append("usageOperation=$usageOperation,")
        append("virtualizationType=$virtualizationType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = architecture?.hashCode() ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (bootMode?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (deprecationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enaSupport?.hashCode() ?: 0)
        result = 31 * result + (hypervisor?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (imageLocation?.hashCode() ?: 0)
        result = 31 * result + (imageOwnerAlias?.hashCode() ?: 0)
        result = 31 * result + (imageType?.hashCode() ?: 0)
        result = 31 * result + (imdsSupport?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (platformDetails?.hashCode() ?: 0)
        result = 31 * result + (productCodes?.hashCode() ?: 0)
        result = 31 * result + (public?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceName?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceType?.hashCode() ?: 0)
        result = 31 * result + (sriovNetSupport?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tpmSupport?.hashCode() ?: 0)
        result = 31 * result + (usageOperation?.hashCode() ?: 0)
        result = 31 * result + (virtualizationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Image

        if (architecture != other.architecture) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (bootMode != other.bootMode) return false
        if (creationDate != other.creationDate) return false
        if (deprecationTime != other.deprecationTime) return false
        if (description != other.description) return false
        if (enaSupport != other.enaSupport) return false
        if (hypervisor != other.hypervisor) return false
        if (imageId != other.imageId) return false
        if (imageLocation != other.imageLocation) return false
        if (imageOwnerAlias != other.imageOwnerAlias) return false
        if (imageType != other.imageType) return false
        if (imdsSupport != other.imdsSupport) return false
        if (kernelId != other.kernelId) return false
        if (name != other.name) return false
        if (ownerId != other.ownerId) return false
        if (platform != other.platform) return false
        if (platformDetails != other.platformDetails) return false
        if (productCodes != other.productCodes) return false
        if (public != other.public) return false
        if (ramdiskId != other.ramdiskId) return false
        if (rootDeviceName != other.rootDeviceName) return false
        if (rootDeviceType != other.rootDeviceType) return false
        if (sriovNetSupport != other.sriovNetSupport) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false
        if (tags != other.tags) return false
        if (tpmSupport != other.tpmSupport) return false
        if (usageOperation != other.usageOperation) return false
        if (virtualizationType != other.virtualizationType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.Image = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The architecture of the image.
         */
        public var architecture: aws.sdk.kotlin.services.ec2.model.ArchitectureValues? = null
        /**
         * Any block device mapping entries.
         */
        public var blockDeviceMappings: List<BlockDeviceMapping>? = null
        /**
         * The boot mode of the image. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var bootMode: aws.sdk.kotlin.services.ec2.model.BootModeValues? = null
        /**
         * The date and time the image was created.
         */
        public var creationDate: kotlin.String? = null
        /**
         * The date and time to deprecate the AMI, in UTC, in the following format: *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute.
         */
        public var deprecationTime: kotlin.String? = null
        /**
         * The description of the AMI that was provided during image creation.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether enhanced networking with ENA is enabled.
         */
        public var enaSupport: kotlin.Boolean? = null
        /**
         * The hypervisor type of the image.
         */
        public var hypervisor: aws.sdk.kotlin.services.ec2.model.HypervisorType? = null
        /**
         * The ID of the AMI.
         */
        public var imageId: kotlin.String? = null
        /**
         * The location of the AMI.
         */
        public var imageLocation: kotlin.String? = null
        /**
         * The Amazon Web Services account alias (for example, `amazon`, `self`) or the Amazon Web Services account ID of the AMI owner.
         */
        public var imageOwnerAlias: kotlin.String? = null
        /**
         * The type of image.
         */
        public var imageType: aws.sdk.kotlin.services.ec2.model.ImageTypeValues? = null
        /**
         * If `v2.0`, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI will have `HttpTokens` automatically set to `required` so that, by default, the instance requires that IMDSv2 is used when requesting instance metadata. In addition, `HttpPutResponseHopLimit` is set to `2`. For more information, see [Configure the AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var imdsSupport: aws.sdk.kotlin.services.ec2.model.ImdsSupportValues? = null
        /**
         * The kernel associated with the image, if any. Only applicable for machine images.
         */
        public var kernelId: kotlin.String? = null
        /**
         * The name of the AMI that was provided during image creation.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the image.
         */
        public var ownerId: kotlin.String? = null
        /**
         * This value is set to `windows` for Windows AMIs; otherwise, it is blank.
         */
        public var platform: aws.sdk.kotlin.services.ec2.model.PlatformValues? = null
        /**
         * The platform details associated with the billing code of the AMI. For more information, see [Understanding AMI billing](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var platformDetails: kotlin.String? = null
        /**
         * Any product codes associated with the AMI.
         */
        public var productCodes: List<ProductCode>? = null
        /**
         * Indicates whether the image has public launch permissions. The value is `true` if this image has public launch permissions or `false` if it has only implicit and explicit launch permissions.
         */
        public var public: kotlin.Boolean? = null
        /**
         * The RAM disk associated with the image, if any. Only applicable for machine images.
         */
        public var ramdiskId: kotlin.String? = null
        /**
         * The device name of the root device volume (for example, `/dev/sda1`).
         */
        public var rootDeviceName: kotlin.String? = null
        /**
         * The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.
         */
        public var rootDeviceType: aws.sdk.kotlin.services.ec2.model.DeviceType? = null
        /**
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         */
        public var sriovNetSupport: kotlin.String? = null
        /**
         * The current state of the AMI. If the state is `available`, the image is successfully registered and can be used to launch an instance.
         */
        public var state: aws.sdk.kotlin.services.ec2.model.ImageState? = null
        /**
         * The reason for the state change.
         */
        public var stateReason: aws.sdk.kotlin.services.ec2.model.StateReason? = null
        /**
         * Any tags assigned to the image.
         */
        public var tags: List<Tag>? = null
        /**
         * If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var tpmSupport: aws.sdk.kotlin.services.ec2.model.TpmSupportValues? = null
        /**
         * The operation of the Amazon EC2 instance and the billing code that is associated with the AMI. `usageOperation` corresponds to the [lineitem/Operation](https://docs.aws.amazon.com/cur/latest/userguide/Lineitem-columns.html#Lineitem-details-O-Operation) column on your Amazon Web Services Cost and Usage Report and in the [Amazon Web Services Price List API](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html). You can view these fields on the **Instances** or **AMIs** pages in the Amazon EC2 console, or in the responses that are returned by the [DescribeImages](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html) command in the Amazon EC2 API, or the [describe-images](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-images.html) command in the CLI.
         */
        public var usageOperation: kotlin.String? = null
        /**
         * The type of virtualization of the AMI.
         */
        public var virtualizationType: aws.sdk.kotlin.services.ec2.model.VirtualizationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.Image) : this() {
            this.architecture = x.architecture
            this.blockDeviceMappings = x.blockDeviceMappings
            this.bootMode = x.bootMode
            this.creationDate = x.creationDate
            this.deprecationTime = x.deprecationTime
            this.description = x.description
            this.enaSupport = x.enaSupport
            this.hypervisor = x.hypervisor
            this.imageId = x.imageId
            this.imageLocation = x.imageLocation
            this.imageOwnerAlias = x.imageOwnerAlias
            this.imageType = x.imageType
            this.imdsSupport = x.imdsSupport
            this.kernelId = x.kernelId
            this.name = x.name
            this.ownerId = x.ownerId
            this.platform = x.platform
            this.platformDetails = x.platformDetails
            this.productCodes = x.productCodes
            this.public = x.public
            this.ramdiskId = x.ramdiskId
            this.rootDeviceName = x.rootDeviceName
            this.rootDeviceType = x.rootDeviceType
            this.sriovNetSupport = x.sriovNetSupport
            this.state = x.state
            this.stateReason = x.stateReason
            this.tags = x.tags
            this.tpmSupport = x.tpmSupport
            this.usageOperation = x.usageOperation
            this.virtualizationType = x.virtualizationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.Image = Image(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.StateReason] inside the given [block]
         */
        public fun stateReason(block: aws.sdk.kotlin.services.ec2.model.StateReason.Builder.() -> kotlin.Unit) {
            this.stateReason = aws.sdk.kotlin.services.ec2.model.StateReason.invoke(block)
        }
    }
}
