// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class ImportKeyPairRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * A unique name for the key pair.
     */
    public val keyName: kotlin.String? = builder.keyName
    /**
     * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is performed for you.
     */
    public val publicKeyMaterial: kotlin.ByteArray? = builder.publicKeyMaterial
    /**
     * The tags to apply to the imported key pair.
     */
    public val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ImportKeyPairRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportKeyPairRequest(")
        append("dryRun=$dryRun,")
        append("keyName=$keyName,")
        append("publicKeyMaterial=$publicKeyMaterial,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (publicKeyMaterial?.contentHashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportKeyPairRequest

        if (dryRun != other.dryRun) return false
        if (keyName != other.keyName) return false
        if (publicKeyMaterial != null) {
            if (other.publicKeyMaterial == null) return false
            if (!publicKeyMaterial.contentEquals(other.publicKeyMaterial)) return false
        } else if (other.publicKeyMaterial != null) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ImportKeyPairRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * A unique name for the key pair.
         */
        public var keyName: kotlin.String? = null
        /**
         * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is performed for you.
         */
        public var publicKeyMaterial: kotlin.ByteArray? = null
        /**
         * The tags to apply to the imported key pair.
         */
        public var tagSpecifications: List<TagSpecification>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ImportKeyPairRequest) : this() {
            this.dryRun = x.dryRun
            this.keyName = x.keyName
            this.publicKeyMaterial = x.publicKeyMaterial
            this.tagSpecifications = x.tagSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ImportKeyPairRequest = ImportKeyPairRequest(this)
    }
}
