// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The tags specification for the resources that are created during instance launch.
 */
public class LaunchTemplateTagSpecificationRequest private constructor(builder: Builder) {
    /**
     * The type of resource to tag.
     *
     * The `Valid Values` are all the resource types that can be tagged. However, when creating a launch template, you can specify tags for the following resource types only: `instance` | `volume` | `elastic-gpu` | `network-interface` | `spot-instances-request`
     *
     * To tag a resource after it has been created, see [CreateTags](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html).
     */
    public val resourceType: aws.sdk.kotlin.services.ec2.model.ResourceType? = builder.resourceType
    /**
     * The tags to apply to the resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.LaunchTemplateTagSpecificationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateTagSpecificationRequest(")
        append("resourceType=$resourceType,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceType?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LaunchTemplateTagSpecificationRequest

        if (resourceType != other.resourceType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.LaunchTemplateTagSpecificationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of resource to tag.
         *
         * The `Valid Values` are all the resource types that can be tagged. However, when creating a launch template, you can specify tags for the following resource types only: `instance` | `volume` | `elastic-gpu` | `network-interface` | `spot-instances-request`
         *
         * To tag a resource after it has been created, see [CreateTags](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html).
         */
        public var resourceType: aws.sdk.kotlin.services.ec2.model.ResourceType? = null
        /**
         * The tags to apply to the resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.LaunchTemplateTagSpecificationRequest) : this() {
            this.resourceType = x.resourceType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.LaunchTemplateTagSpecificationRequest = LaunchTemplateTagSpecificationRequest(this)
    }
}
