// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The information to include in the launch template.
 *
 * You must specify at least one parameter for the launch template data.
 */
public class RequestLaunchTemplateData private constructor(builder: Builder) {
    /**
     * The block device mapping.
     */
    public val blockDeviceMappings: List<LaunchTemplateBlockDeviceMappingRequest>? = builder.blockDeviceMappings
    /**
     * The Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity Reservation preference defaults to `open`, which enables it to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
     */
    public val capacityReservationSpecification: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest? = builder.capacityReservationSpecification
    /**
     * The CPU options for the instance. For more information, see [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val cpuOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptionsRequest? = builder.cpuOptions
    /**
     * The credit option for CPU usage of the instance. Valid only for T instances.
     */
    public val creditSpecification: aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest? = builder.creditSpecification
    /**
     * Indicates whether to enable the instance for stop protection. For more information, see [Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     */
    public val disableApiStop: kotlin.Boolean? = builder.disableApiStop
    /**
     * If you set this parameter to `true`, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch, use [ModifyInstanceAttribute](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html). Alternatively, if you set `InstanceInitiatedShutdownBehavior` to `terminate`, you can terminate the instance by running the shutdown command from the instance.
     */
    public val disableApiTermination: kotlin.Boolean? = builder.disableApiTermination
    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     */
    public val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * An elastic GPU to associate with the instance.
     */
    public val elasticGpuSpecifications: List<ElasticGpuSpecification>? = builder.elasticGpuSpecifications
    /**
     * The elastic inference accelerator for the instance.
     */
    public val elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAccelerator>? = builder.elasticInferenceAccelerators
    /**
     * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see [ What is Amazon Web Services Nitro Enclaves?](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html) in the *Amazon Web Services Nitro Enclaves User Guide*.
     *
     * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
     */
    public val enclaveOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptionsRequest? = builder.enclaveOptions
    /**
     * Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance meets the [hibernation prerequisites](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html). For more information, see [Hibernate your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val hibernationOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptionsRequest? = builder.hibernationOptions
    /**
     * The name or Amazon Resource Name (ARN) of an IAM instance profile.
     */
    public val iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest? = builder.iamInstanceProfile
    /**
     * The ID of the AMI.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     *
     * Default: `stop`
     */
    public val instanceInitiatedShutdownBehavior: aws.sdk.kotlin.services.ec2.model.ShutdownBehavior? = builder.instanceInitiatedShutdownBehavior
    /**
     * The market (purchasing) option for the instances.
     */
    public val instanceMarketOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest? = builder.instanceMarketOptions
    /**
     * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
     *
     * If you specify `InstanceRequirements`, you can't specify `InstanceType`.
     */
    public val instanceRequirements: aws.sdk.kotlin.services.ec2.model.InstanceRequirementsRequest? = builder.instanceRequirements
    /**
     * The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon Elastic Compute Cloud User Guide*.
     *
     * If you specify `InstanceType`, you can't specify `InstanceRequirements`.
     */
    public val instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = builder.instanceType
    /**
     * The ID of the kernel.
     *
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [User provided kernels](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val kernelId: kotlin.String? = builder.kernelId
    /**
     * The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html).
     *
     * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
     */
    public val keyName: kotlin.String? = builder.keyName
    /**
     * The license configurations.
     */
    public val licenseSpecifications: List<LaunchTemplateLicenseConfigurationRequest>? = builder.licenseSpecifications
    /**
     * The maintenance options for the instance.
     */
    public val maintenanceOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest? = builder.maintenanceOptions
    /**
     * The metadata options for the instance. For more information, see [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val metadataOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest? = builder.metadataOptions
    /**
     * The monitoring for the instance.
     */
    public val monitoring: aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoringRequest? = builder.monitoring
    /**
     * One or more network interfaces. If you specify a network interface, you must specify any security groups and subnets as part of the network interface.
     */
    public val networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>? = builder.networkInterfaces
    /**
     * The placement for the instance.
     */
    public val placement: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacementRequest? = builder.placement
    /**
     * The options for the instance hostname. The default values are inherited from the subnet.
     */
    public val privateDnsNameOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest? = builder.privateDnsNameOptions
    /**
     * The ID of the RAM disk.
     *
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [User provided kernels](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val ramDiskId: kotlin.String? = builder.ramDiskId
    /**
     * One or more security group IDs. You can create a security group using [CreateSecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html). You cannot specify both a security group ID and security name in the same request.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * One or more security group names. For a nondefault VPC, you must use security group IDs instead. You cannot specify both a security group ID and security name in the same request.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The tags to apply to the resources that are created during instance launch.
     *
     * You can specify tags for the following resources only:
     * + Instances
     * + Volumes
     * + Elastic graphics
     * + Spot Instance requests
     * + Network interfaces
     *
     * To tag a resource after it has been created, see [CreateTags](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html).
     *
     * To tag the launch template itself, you must use the [TagSpecification](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html) parameter.
     */
    public val tagSpecifications: List<LaunchTemplateTagSpecificationRequest>? = builder.tagSpecifications
    /**
     * The user data to make available to the instance. You must provide base64-encoded text. User data is limited to 16 KB. For more information, see [Run commands on your Linux instance at launch](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html) (Linux) or [Work with instance user data](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instancedata-add-user-data.html) (Windows) in the *Amazon Elastic Compute Cloud User Guide*.
     *
     * If you are creating the launch template for use with Batch, the user data must be provided in the [ MIME multi-part archive format](https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive). For more information, see [Amazon EC2 user data in launch templates](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the *Batch User Guide*.
     */
    public val userData: kotlin.String? = builder.userData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.RequestLaunchTemplateData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestLaunchTemplateData(")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("capacityReservationSpecification=$capacityReservationSpecification,")
        append("cpuOptions=$cpuOptions,")
        append("creditSpecification=$creditSpecification,")
        append("disableApiStop=$disableApiStop,")
        append("disableApiTermination=$disableApiTermination,")
        append("ebsOptimized=$ebsOptimized,")
        append("elasticGpuSpecifications=$elasticGpuSpecifications,")
        append("elasticInferenceAccelerators=$elasticInferenceAccelerators,")
        append("enclaveOptions=$enclaveOptions,")
        append("hibernationOptions=$hibernationOptions,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceInitiatedShutdownBehavior=$instanceInitiatedShutdownBehavior,")
        append("instanceMarketOptions=$instanceMarketOptions,")
        append("instanceRequirements=$instanceRequirements,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("licenseSpecifications=$licenseSpecifications,")
        append("maintenanceOptions=$maintenanceOptions,")
        append("metadataOptions=$metadataOptions,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("placement=$placement,")
        append("privateDnsNameOptions=$privateDnsNameOptions,")
        append("ramDiskId=$ramDiskId,")
        append("securityGroupIds=$securityGroupIds,")
        append("securityGroups=$securityGroups,")
        append("tagSpecifications=$tagSpecifications,")
        append("userData=$userData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDeviceMappings?.hashCode() ?: 0
        result = 31 * result + (capacityReservationSpecification?.hashCode() ?: 0)
        result = 31 * result + (cpuOptions?.hashCode() ?: 0)
        result = 31 * result + (creditSpecification?.hashCode() ?: 0)
        result = 31 * result + (disableApiStop?.hashCode() ?: 0)
        result = 31 * result + (disableApiTermination?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (elasticGpuSpecifications?.hashCode() ?: 0)
        result = 31 * result + (elasticInferenceAccelerators?.hashCode() ?: 0)
        result = 31 * result + (enclaveOptions?.hashCode() ?: 0)
        result = 31 * result + (hibernationOptions?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceInitiatedShutdownBehavior?.hashCode() ?: 0)
        result = 31 * result + (instanceMarketOptions?.hashCode() ?: 0)
        result = 31 * result + (instanceRequirements?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (licenseSpecifications?.hashCode() ?: 0)
        result = 31 * result + (maintenanceOptions?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (privateDnsNameOptions?.hashCode() ?: 0)
        result = 31 * result + (ramDiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestLaunchTemplateData

        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (capacityReservationSpecification != other.capacityReservationSpecification) return false
        if (cpuOptions != other.cpuOptions) return false
        if (creditSpecification != other.creditSpecification) return false
        if (disableApiStop != other.disableApiStop) return false
        if (disableApiTermination != other.disableApiTermination) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (elasticGpuSpecifications != other.elasticGpuSpecifications) return false
        if (elasticInferenceAccelerators != other.elasticInferenceAccelerators) return false
        if (enclaveOptions != other.enclaveOptions) return false
        if (hibernationOptions != other.hibernationOptions) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceInitiatedShutdownBehavior != other.instanceInitiatedShutdownBehavior) return false
        if (instanceMarketOptions != other.instanceMarketOptions) return false
        if (instanceRequirements != other.instanceRequirements) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (licenseSpecifications != other.licenseSpecifications) return false
        if (maintenanceOptions != other.maintenanceOptions) return false
        if (metadataOptions != other.metadataOptions) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (placement != other.placement) return false
        if (privateDnsNameOptions != other.privateDnsNameOptions) return false
        if (ramDiskId != other.ramDiskId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (securityGroups != other.securityGroups) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (userData != other.userData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.RequestLaunchTemplateData = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The block device mapping.
         */
        public var blockDeviceMappings: List<LaunchTemplateBlockDeviceMappingRequest>? = null
        /**
         * The Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity Reservation preference defaults to `open`, which enables it to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
         */
        public var capacityReservationSpecification: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest? = null
        /**
         * The CPU options for the instance. For more information, see [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var cpuOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptionsRequest? = null
        /**
         * The credit option for CPU usage of the instance. Valid only for T instances.
         */
        public var creditSpecification: aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest? = null
        /**
         * Indicates whether to enable the instance for stop protection. For more information, see [Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
         */
        public var disableApiStop: kotlin.Boolean? = null
        /**
         * If you set this parameter to `true`, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch, use [ModifyInstanceAttribute](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html). Alternatively, if you set `InstanceInitiatedShutdownBehavior` to `terminate`, you can terminate the instance by running the shutdown command from the instance.
         */
        public var disableApiTermination: kotlin.Boolean? = null
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         */
        public var ebsOptimized: kotlin.Boolean? = null
        /**
         * An elastic GPU to associate with the instance.
         */
        public var elasticGpuSpecifications: List<ElasticGpuSpecification>? = null
        /**
         * The elastic inference accelerator for the instance.
         */
        public var elasticInferenceAccelerators: List<LaunchTemplateElasticInferenceAccelerator>? = null
        /**
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see [ What is Amazon Web Services Nitro Enclaves?](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html) in the *Amazon Web Services Nitro Enclaves User Guide*.
         *
         * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
         */
        public var enclaveOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptionsRequest? = null
        /**
         * Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance meets the [hibernation prerequisites](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html). For more information, see [Hibernate your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var hibernationOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptionsRequest? = null
        /**
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         */
        public var iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest? = null
        /**
         * The ID of the AMI.
         */
        public var imageId: kotlin.String? = null
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         *
         * Default: `stop`
         */
        public var instanceInitiatedShutdownBehavior: aws.sdk.kotlin.services.ec2.model.ShutdownBehavior? = null
        /**
         * The market (purchasing) option for the instances.
         */
        public var instanceMarketOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest? = null
        /**
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
         *
         * If you specify `InstanceRequirements`, you can't specify `InstanceType`.
         */
        public var instanceRequirements: aws.sdk.kotlin.services.ec2.model.InstanceRequirementsRequest? = null
        /**
         * The instance type. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon Elastic Compute Cloud User Guide*.
         *
         * If you specify `InstanceType`, you can't specify `InstanceRequirements`.
         */
        public var instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = null
        /**
         * The ID of the kernel.
         *
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [User provided kernels](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var kernelId: kotlin.String? = null
        /**
         * The name of the key pair. You can create a key pair using [CreateKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html) or [ImportKeyPair](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html).
         *
         * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured to allow users another way to log in.
         */
        public var keyName: kotlin.String? = null
        /**
         * The license configurations.
         */
        public var licenseSpecifications: List<LaunchTemplateLicenseConfigurationRequest>? = null
        /**
         * The maintenance options for the instance.
         */
        public var maintenanceOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest? = null
        /**
         * The metadata options for the instance. For more information, see [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var metadataOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest? = null
        /**
         * The monitoring for the instance.
         */
        public var monitoring: aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoringRequest? = null
        /**
         * One or more network interfaces. If you specify a network interface, you must specify any security groups and subnets as part of the network interface.
         */
        public var networkInterfaces: List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>? = null
        /**
         * The placement for the instance.
         */
        public var placement: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacementRequest? = null
        /**
         * The options for the instance hostname. The default values are inherited from the subnet.
         */
        public var privateDnsNameOptions: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest? = null
        /**
         * The ID of the RAM disk.
         *
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [User provided kernels](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var ramDiskId: kotlin.String? = null
        /**
         * One or more security group IDs. You can create a security group using [CreateSecurityGroup](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html). You cannot specify both a security group ID and security name in the same request.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * One or more security group names. For a nondefault VPC, you must use security group IDs instead. You cannot specify both a security group ID and security name in the same request.
         */
        public var securityGroups: List<String>? = null
        /**
         * The tags to apply to the resources that are created during instance launch.
         *
         * You can specify tags for the following resources only:
         * + Instances
         * + Volumes
         * + Elastic graphics
         * + Spot Instance requests
         * + Network interfaces
         *
         * To tag a resource after it has been created, see [CreateTags](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html).
         *
         * To tag the launch template itself, you must use the [TagSpecification](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html) parameter.
         */
        public var tagSpecifications: List<LaunchTemplateTagSpecificationRequest>? = null
        /**
         * The user data to make available to the instance. You must provide base64-encoded text. User data is limited to 16 KB. For more information, see [Run commands on your Linux instance at launch](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html) (Linux) or [Work with instance user data](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instancedata-add-user-data.html) (Windows) in the *Amazon Elastic Compute Cloud User Guide*.
         *
         * If you are creating the launch template for use with Batch, the user data must be provided in the [ MIME multi-part archive format](https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive). For more information, see [Amazon EC2 user data in launch templates](https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html) in the *Batch User Guide*.
         */
        public var userData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.RequestLaunchTemplateData) : this() {
            this.blockDeviceMappings = x.blockDeviceMappings
            this.capacityReservationSpecification = x.capacityReservationSpecification
            this.cpuOptions = x.cpuOptions
            this.creditSpecification = x.creditSpecification
            this.disableApiStop = x.disableApiStop
            this.disableApiTermination = x.disableApiTermination
            this.ebsOptimized = x.ebsOptimized
            this.elasticGpuSpecifications = x.elasticGpuSpecifications
            this.elasticInferenceAccelerators = x.elasticInferenceAccelerators
            this.enclaveOptions = x.enclaveOptions
            this.hibernationOptions = x.hibernationOptions
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceInitiatedShutdownBehavior = x.instanceInitiatedShutdownBehavior
            this.instanceMarketOptions = x.instanceMarketOptions
            this.instanceRequirements = x.instanceRequirements
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.licenseSpecifications = x.licenseSpecifications
            this.maintenanceOptions = x.maintenanceOptions
            this.metadataOptions = x.metadataOptions
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.placement = x.placement
            this.privateDnsNameOptions = x.privateDnsNameOptions
            this.ramDiskId = x.ramDiskId
            this.securityGroupIds = x.securityGroupIds
            this.securityGroups = x.securityGroups
            this.tagSpecifications = x.tagSpecifications
            this.userData = x.userData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.RequestLaunchTemplateData = RequestLaunchTemplateData(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest] inside the given [block]
         */
        public fun capacityReservationSpecification(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.Builder.() -> kotlin.Unit) {
            this.capacityReservationSpecification = aws.sdk.kotlin.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptionsRequest] inside the given [block]
         */
        public fun cpuOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptionsRequest.Builder.() -> kotlin.Unit) {
            this.cpuOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateCpuOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest] inside the given [block]
         */
        public fun creditSpecification(block: aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest.Builder.() -> kotlin.Unit) {
            this.creditSpecification = aws.sdk.kotlin.services.ec2.model.CreditSpecificationRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptionsRequest] inside the given [block]
         */
        public fun enclaveOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptionsRequest.Builder.() -> kotlin.Unit) {
            this.enclaveOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateEnclaveOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptionsRequest] inside the given [block]
         */
        public fun hibernationOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptionsRequest.Builder.() -> kotlin.Unit) {
            this.hibernationOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateHibernationOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest] inside the given [block]
         */
        public fun iamInstanceProfile(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.Builder.() -> kotlin.Unit) {
            this.iamInstanceProfile = aws.sdk.kotlin.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest] inside the given [block]
         */
        public fun instanceMarketOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.Builder.() -> kotlin.Unit) {
            this.instanceMarketOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceRequirementsRequest] inside the given [block]
         */
        public fun instanceRequirements(block: aws.sdk.kotlin.services.ec2.model.InstanceRequirementsRequest.Builder.() -> kotlin.Unit) {
            this.instanceRequirements = aws.sdk.kotlin.services.ec2.model.InstanceRequirementsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest] inside the given [block]
         */
        public fun maintenanceOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.Builder.() -> kotlin.Unit) {
            this.maintenanceOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest] inside the given [block]
         */
        public fun metadataOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.Builder.() -> kotlin.Unit) {
            this.metadataOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoringRequest] inside the given [block]
         */
        public fun monitoring(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoringRequest.Builder.() -> kotlin.Unit) {
            this.monitoring = aws.sdk.kotlin.services.ec2.model.LaunchTemplatesMonitoringRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacementRequest] inside the given [block]
         */
        public fun placement(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacementRequest.Builder.() -> kotlin.Unit) {
            this.placement = aws.sdk.kotlin.services.ec2.model.LaunchTemplatePlacementRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest] inside the given [block]
         */
        public fun privateDnsNameOptions(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest.Builder.() -> kotlin.Unit) {
            this.privateDnsNameOptions = aws.sdk.kotlin.services.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest.invoke(block)
        }
    }
}
