// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for RunScheduledInstances.
 */
public class RunScheduledInstancesRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see [Ensuring Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The number of instances.
     *
     * Default: 1
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The launch specification. You must match the instance type, Availability Zone, network, and platform of the schedule that you purchased.
     */
    public val launchSpecification: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesLaunchSpecification? = builder.launchSpecification
    /**
     * The Scheduled Instance ID.
     */
    public val scheduledInstanceId: kotlin.String? = builder.scheduledInstanceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.RunScheduledInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RunScheduledInstancesRequest(")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("instanceCount=$instanceCount,")
        append("launchSpecification=$launchSpecification,")
        append("scheduledInstanceId=$scheduledInstanceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (launchSpecification?.hashCode() ?: 0)
        result = 31 * result + (scheduledInstanceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RunScheduledInstancesRequest

        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (instanceCount != other.instanceCount) return false
        if (launchSpecification != other.launchSpecification) return false
        if (scheduledInstanceId != other.scheduledInstanceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.RunScheduledInstancesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see [Ensuring Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        public var clientToken: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The number of instances.
         *
         * Default: 1
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The launch specification. You must match the instance type, Availability Zone, network, and platform of the schedule that you purchased.
         */
        public var launchSpecification: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesLaunchSpecification? = null
        /**
         * The Scheduled Instance ID.
         */
        public var scheduledInstanceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.RunScheduledInstancesRequest) : this() {
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.instanceCount = x.instanceCount
            this.launchSpecification = x.launchSpecification
            this.scheduledInstanceId = x.scheduledInstanceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.RunScheduledInstancesRequest = RunScheduledInstancesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstancesLaunchSpecification] inside the given [block]
         */
        public fun launchSpecification(block: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesLaunchSpecification.Builder.() -> kotlin.Unit) {
            this.launchSpecification = aws.sdk.kotlin.services.ec2.model.ScheduledInstancesLaunchSpecification.invoke(block)
        }
    }
}
