// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Spot Fleet request.
 */
public class SpotFleetRequestConfig private constructor(builder: Builder) {
    /**
     * The progress of the Spot Fleet request. If there is an error, the status is `error`. After all requests are placed, the status is `pending_fulfillment`. If the size of the fleet is equal to or greater than its target capacity, the status is `fulfilled`. If the size of the fleet is decreased, the status is `pending_termination` while Spot Instances are terminating.
     */
    public val activityStatus: aws.sdk.kotlin.services.ec2.model.ActivityStatus? = builder.activityStatus
    /**
     * The creation date and time of the request.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The configuration of the Spot Fleet request.
     */
    public val spotFleetRequestConfig: aws.sdk.kotlin.services.ec2.model.SpotFleetRequestConfigData? = builder.spotFleetRequestConfig
    /**
     * The ID of the Spot Fleet request.
     */
    public val spotFleetRequestId: kotlin.String? = builder.spotFleetRequestId
    /**
     * The state of the Spot Fleet request.
     */
    public val spotFleetRequestState: aws.sdk.kotlin.services.ec2.model.BatchState? = builder.spotFleetRequestState
    /**
     * The tags for a Spot Fleet resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.SpotFleetRequestConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpotFleetRequestConfig(")
        append("activityStatus=$activityStatus,")
        append("createTime=$createTime,")
        append("spotFleetRequestConfig=$spotFleetRequestConfig,")
        append("spotFleetRequestId=$spotFleetRequestId,")
        append("spotFleetRequestState=$spotFleetRequestState,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityStatus?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (spotFleetRequestConfig?.hashCode() ?: 0)
        result = 31 * result + (spotFleetRequestId?.hashCode() ?: 0)
        result = 31 * result + (spotFleetRequestState?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpotFleetRequestConfig

        if (activityStatus != other.activityStatus) return false
        if (createTime != other.createTime) return false
        if (spotFleetRequestConfig != other.spotFleetRequestConfig) return false
        if (spotFleetRequestId != other.spotFleetRequestId) return false
        if (spotFleetRequestState != other.spotFleetRequestState) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.SpotFleetRequestConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The progress of the Spot Fleet request. If there is an error, the status is `error`. After all requests are placed, the status is `pending_fulfillment`. If the size of the fleet is equal to or greater than its target capacity, the status is `fulfilled`. If the size of the fleet is decreased, the status is `pending_termination` while Spot Instances are terminating.
         */
        public var activityStatus: aws.sdk.kotlin.services.ec2.model.ActivityStatus? = null
        /**
         * The creation date and time of the request.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration of the Spot Fleet request.
         */
        public var spotFleetRequestConfig: aws.sdk.kotlin.services.ec2.model.SpotFleetRequestConfigData? = null
        /**
         * The ID of the Spot Fleet request.
         */
        public var spotFleetRequestId: kotlin.String? = null
        /**
         * The state of the Spot Fleet request.
         */
        public var spotFleetRequestState: aws.sdk.kotlin.services.ec2.model.BatchState? = null
        /**
         * The tags for a Spot Fleet resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.SpotFleetRequestConfig) : this() {
            this.activityStatus = x.activityStatus
            this.createTime = x.createTime
            this.spotFleetRequestConfig = x.spotFleetRequestConfig
            this.spotFleetRequestId = x.spotFleetRequestId
            this.spotFleetRequestState = x.spotFleetRequestState
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.SpotFleetRequestConfig = SpotFleetRequestConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotFleetRequestConfigData] inside the given [block]
         */
        public fun spotFleetRequestConfig(block: aws.sdk.kotlin.services.ec2.model.SpotFleetRequestConfigData.Builder.() -> kotlin.Unit) {
            this.spotFleetRequestConfig = aws.sdk.kotlin.services.ec2.model.SpotFleetRequestConfigData.invoke(block)
        }
    }
}
