// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a stale rule in a security group.
 */
public class StaleIpPermission private constructor(builder: Builder) {
    /**
     * The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of `-1` indicates all ICMP types.
     */
    public val fromPort: kotlin.Int? = builder.fromPort
    /**
     * The IP protocol name (for `tcp`, `udp`, and `icmp`) or number (see [Protocol Numbers)](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml).
     */
    public val ipProtocol: kotlin.String? = builder.ipProtocol
    /**
     * The IP ranges. Not applicable for stale security group rules.
     */
    public val ipRanges: List<String>? = builder.ipRanges
    /**
     * The prefix list IDs. Not applicable for stale security group rules.
     */
    public val prefixListIds: List<String>? = builder.prefixListIds
    /**
     * The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of `-1` indicates all ICMP types.
     */
    public val toPort: kotlin.Int? = builder.toPort
    /**
     * The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of the VPC peering connection.
     */
    public val userIdGroupPairs: List<UserIdGroupPair>? = builder.userIdGroupPairs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.StaleIpPermission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StaleIpPermission(")
        append("fromPort=$fromPort,")
        append("ipProtocol=$ipProtocol,")
        append("ipRanges=$ipRanges,")
        append("prefixListIds=$prefixListIds,")
        append("toPort=$toPort,")
        append("userIdGroupPairs=$userIdGroupPairs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fromPort ?: 0
        result = 31 * result + (ipProtocol?.hashCode() ?: 0)
        result = 31 * result + (ipRanges?.hashCode() ?: 0)
        result = 31 * result + (prefixListIds?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        result = 31 * result + (userIdGroupPairs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StaleIpPermission

        if (fromPort != other.fromPort) return false
        if (ipProtocol != other.ipProtocol) return false
        if (ipRanges != other.ipRanges) return false
        if (prefixListIds != other.prefixListIds) return false
        if (toPort != other.toPort) return false
        if (userIdGroupPairs != other.userIdGroupPairs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.StaleIpPermission = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of `-1` indicates all ICMP types.
         */
        public var fromPort: kotlin.Int? = null
        /**
         * The IP protocol name (for `tcp`, `udp`, and `icmp`) or number (see [Protocol Numbers)](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml).
         */
        public var ipProtocol: kotlin.String? = null
        /**
         * The IP ranges. Not applicable for stale security group rules.
         */
        public var ipRanges: List<String>? = null
        /**
         * The prefix list IDs. Not applicable for stale security group rules.
         */
        public var prefixListIds: List<String>? = null
        /**
         * The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of `-1` indicates all ICMP types.
         */
        public var toPort: kotlin.Int? = null
        /**
         * The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of the VPC peering connection.
         */
        public var userIdGroupPairs: List<UserIdGroupPair>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.StaleIpPermission) : this() {
            this.fromPort = x.fromPort
            this.ipProtocol = x.ipProtocol
            this.ipRanges = x.ipRanges
            this.prefixListIds = x.prefixListIds
            this.toPort = x.toPort
            this.userIdGroupPairs = x.userIdGroupPairs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.StaleIpPermission = StaleIpPermission(this)
    }
}
