// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a Traffic Mirror session.
 */
public class TrafficMirrorSession private constructor(builder: Builder) {
    /**
     * The description of the Traffic Mirror session.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the Traffic Mirror session's network interface.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The ID of the account that owns the Traffic Mirror session.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The number of bytes in each packet to mirror. These are the bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet
     */
    public val packetLength: kotlin.Int? = builder.packetLength
    /**
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
     *
     * Valid values are 1-32766.
     */
    public val sessionNumber: kotlin.Int? = builder.sessionNumber
    /**
     * The tags assigned to the Traffic Mirror session.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ID of the Traffic Mirror filter.
     */
    public val trafficMirrorFilterId: kotlin.String? = builder.trafficMirrorFilterId
    /**
     * The ID for the Traffic Mirror session.
     */
    public val trafficMirrorSessionId: kotlin.String? = builder.trafficMirrorSessionId
    /**
     * The ID of the Traffic Mirror target.
     */
    public val trafficMirrorTargetId: kotlin.String? = builder.trafficMirrorTargetId
    /**
     * The virtual network ID associated with the Traffic Mirror session.
     */
    public val virtualNetworkId: kotlin.Int? = builder.virtualNetworkId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.TrafficMirrorSession = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficMirrorSession(")
        append("description=$description,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("ownerId=$ownerId,")
        append("packetLength=$packetLength,")
        append("sessionNumber=$sessionNumber,")
        append("tags=$tags,")
        append("trafficMirrorFilterId=$trafficMirrorFilterId,")
        append("trafficMirrorSessionId=$trafficMirrorSessionId,")
        append("trafficMirrorTargetId=$trafficMirrorTargetId,")
        append("virtualNetworkId=$virtualNetworkId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (packetLength ?: 0)
        result = 31 * result + (sessionNumber ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorFilterId?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorSessionId?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorTargetId?.hashCode() ?: 0)
        result = 31 * result + (virtualNetworkId ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrafficMirrorSession

        if (description != other.description) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (ownerId != other.ownerId) return false
        if (packetLength != other.packetLength) return false
        if (sessionNumber != other.sessionNumber) return false
        if (tags != other.tags) return false
        if (trafficMirrorFilterId != other.trafficMirrorFilterId) return false
        if (trafficMirrorSessionId != other.trafficMirrorSessionId) return false
        if (trafficMirrorTargetId != other.trafficMirrorTargetId) return false
        if (virtualNetworkId != other.virtualNetworkId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.TrafficMirrorSession = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of the Traffic Mirror session.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the Traffic Mirror session's network interface.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The ID of the account that owns the Traffic Mirror session.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The number of bytes in each packet to mirror. These are the bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet
         */
        public var packetLength: kotlin.Int? = null
        /**
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
         *
         * Valid values are 1-32766.
         */
        public var sessionNumber: kotlin.Int? = null
        /**
         * The tags assigned to the Traffic Mirror session.
         */
        public var tags: List<Tag>? = null
        /**
         * The ID of the Traffic Mirror filter.
         */
        public var trafficMirrorFilterId: kotlin.String? = null
        /**
         * The ID for the Traffic Mirror session.
         */
        public var trafficMirrorSessionId: kotlin.String? = null
        /**
         * The ID of the Traffic Mirror target.
         */
        public var trafficMirrorTargetId: kotlin.String? = null
        /**
         * The virtual network ID associated with the Traffic Mirror session.
         */
        public var virtualNetworkId: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.TrafficMirrorSession) : this() {
            this.description = x.description
            this.networkInterfaceId = x.networkInterfaceId
            this.ownerId = x.ownerId
            this.packetLength = x.packetLength
            this.sessionNumber = x.sessionNumber
            this.tags = x.tags
            this.trafficMirrorFilterId = x.trafficMirrorFilterId
            this.trafficMirrorSessionId = x.trafficMirrorSessionId
            this.trafficMirrorTargetId = x.trafficMirrorTargetId
            this.virtualNetworkId = x.virtualNetworkId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.TrafficMirrorSession = TrafficMirrorSession(this)
    }
}
