// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a volume.
 */
public class Volume private constructor(builder: Builder) {
    /**
     * Information about the volume attachments.
     */
    public val attachments: List<VolumeAttachment>? = builder.attachments
    /**
     * The Availability Zone for the volume.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The time stamp when volume creation was initiated.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * Indicates whether the volume is encrypted.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * Indicates whether the volume was created using fast snapshot restore.
     */
    public val fastRestored: kotlin.Boolean? = builder.fastRestored
    /**
     * The number of I/O operations per second (IOPS). For `gp3`, `io1`, and `io2` volumes, this represents the number of IOPS that are provisioned for the volume. For `gp2` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the volume encryption key for the volume.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Indicates whether Amazon EBS Multi-Attach is enabled.
     */
    public val multiAttachEnabled: kotlin.Boolean? = builder.multiAttachEnabled
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    public val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The size of the volume, in GiBs.
     */
    public val size: kotlin.Int? = builder.size
    /**
     * The snapshot from which the volume was created, if applicable.
     */
    public val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The volume state.
     */
    public val state: aws.sdk.kotlin.services.ec2.model.VolumeState? = builder.state
    /**
     * Any tags assigned to the volume.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The throughput that the volume supports, in MiB/s.
     */
    public val throughput: kotlin.Int? = builder.throughput
    /**
     * The ID of the volume.
     */
    public val volumeId: kotlin.String? = builder.volumeId
    /**
     * The volume type.
     */
    public val volumeType: aws.sdk.kotlin.services.ec2.model.VolumeType? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.Volume = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Volume(")
        append("attachments=$attachments,")
        append("availabilityZone=$availabilityZone,")
        append("createTime=$createTime,")
        append("encrypted=$encrypted,")
        append("fastRestored=$fastRestored,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("multiAttachEnabled=$multiAttachEnabled,")
        append("outpostArn=$outpostArn,")
        append("size=$size,")
        append("snapshotId=$snapshotId,")
        append("state=$state,")
        append("tags=$tags,")
        append("throughput=$throughput,")
        append("volumeId=$volumeId,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachments?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (fastRestored?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (multiAttachEnabled?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (size ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Volume

        if (attachments != other.attachments) return false
        if (availabilityZone != other.availabilityZone) return false
        if (createTime != other.createTime) return false
        if (encrypted != other.encrypted) return false
        if (fastRestored != other.fastRestored) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (multiAttachEnabled != other.multiAttachEnabled) return false
        if (outpostArn != other.outpostArn) return false
        if (size != other.size) return false
        if (snapshotId != other.snapshotId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (throughput != other.throughput) return false
        if (volumeId != other.volumeId) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.Volume = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about the volume attachments.
         */
        public var attachments: List<VolumeAttachment>? = null
        /**
         * The Availability Zone for the volume.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The time stamp when volume creation was initiated.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the volume is encrypted.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * Indicates whether the volume was created using fast snapshot restore.
         */
        public var fastRestored: kotlin.Boolean? = null
        /**
         * The number of I/O operations per second (IOPS). For `gp3`, `io1`, and `io2` volumes, this represents the number of IOPS that are provisioned for the volume. For `gp2` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         */
        public var iops: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the volume encryption key for the volume.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Indicates whether Amazon EBS Multi-Attach is enabled.
         */
        public var multiAttachEnabled: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        public var outpostArn: kotlin.String? = null
        /**
         * The size of the volume, in GiBs.
         */
        public var size: kotlin.Int? = null
        /**
         * The snapshot from which the volume was created, if applicable.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * The volume state.
         */
        public var state: aws.sdk.kotlin.services.ec2.model.VolumeState? = null
        /**
         * Any tags assigned to the volume.
         */
        public var tags: List<Tag>? = null
        /**
         * The throughput that the volume supports, in MiB/s.
         */
        public var throughput: kotlin.Int? = null
        /**
         * The ID of the volume.
         */
        public var volumeId: kotlin.String? = null
        /**
         * The volume type.
         */
        public var volumeType: aws.sdk.kotlin.services.ec2.model.VolumeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.Volume) : this() {
            this.attachments = x.attachments
            this.availabilityZone = x.availabilityZone
            this.createTime = x.createTime
            this.encrypted = x.encrypted
            this.fastRestored = x.fastRestored
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.multiAttachEnabled = x.multiAttachEnabled
            this.outpostArn = x.outpostArn
            this.size = x.size
            this.snapshotId = x.snapshotId
            this.state = x.state
            this.tags = x.tags
            this.throughput = x.throughput
            this.volumeId = x.volumeId
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.Volume = Volume(this)
    }
}
