// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an IPv6 CIDR block associated with a VPC.
 */
public class VpcIpv6CidrBlockAssociation private constructor(builder: Builder) {
    /**
     * The association ID for the IPv6 CIDR block.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The IPv6 CIDR block.
     */
    public val ipv6CidrBlock: kotlin.String? = builder.ipv6CidrBlock
    /**
     * Information about the state of the CIDR block.
     */
    public val ipv6CidrBlockState: aws.sdk.kotlin.services.ec2.model.VpcCidrBlockState? = builder.ipv6CidrBlockState
    /**
     * The ID of the IPv6 address pool from which the IPv6 CIDR block is allocated.
     */
    public val ipv6Pool: kotlin.String? = builder.ipv6Pool
    /**
     * The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses, for example, `us-east-1-wl1-bos-wlz-1`.
     */
    public val networkBorderGroup: kotlin.String? = builder.networkBorderGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VpcIpv6CidrBlockAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcIpv6CidrBlockAssociation(")
        append("associationId=$associationId,")
        append("ipv6CidrBlock=$ipv6CidrBlock,")
        append("ipv6CidrBlockState=$ipv6CidrBlockState,")
        append("ipv6Pool=$ipv6Pool,")
        append("networkBorderGroup=$networkBorderGroup)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (ipv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlockState?.hashCode() ?: 0)
        result = 31 * result + (ipv6Pool?.hashCode() ?: 0)
        result = 31 * result + (networkBorderGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcIpv6CidrBlockAssociation

        if (associationId != other.associationId) return false
        if (ipv6CidrBlock != other.ipv6CidrBlock) return false
        if (ipv6CidrBlockState != other.ipv6CidrBlockState) return false
        if (ipv6Pool != other.ipv6Pool) return false
        if (networkBorderGroup != other.networkBorderGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VpcIpv6CidrBlockAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The association ID for the IPv6 CIDR block.
         */
        public var associationId: kotlin.String? = null
        /**
         * The IPv6 CIDR block.
         */
        public var ipv6CidrBlock: kotlin.String? = null
        /**
         * Information about the state of the CIDR block.
         */
        public var ipv6CidrBlockState: aws.sdk.kotlin.services.ec2.model.VpcCidrBlockState? = null
        /**
         * The ID of the IPv6 address pool from which the IPv6 CIDR block is allocated.
         */
        public var ipv6Pool: kotlin.String? = null
        /**
         * The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses, for example, `us-east-1-wl1-bos-wlz-1`.
         */
        public var networkBorderGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VpcIpv6CidrBlockAssociation) : this() {
            this.associationId = x.associationId
            this.ipv6CidrBlock = x.ipv6CidrBlock
            this.ipv6CidrBlockState = x.ipv6CidrBlockState
            this.ipv6Pool = x.ipv6Pool
            this.networkBorderGroup = x.networkBorderGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VpcIpv6CidrBlockAssociation = VpcIpv6CidrBlockAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpcCidrBlockState] inside the given [block]
         */
        public fun ipv6CidrBlockState(block: aws.sdk.kotlin.services.ec2.model.VpcCidrBlockState.Builder.() -> kotlin.Unit) {
            this.ipv6CidrBlockState = aws.sdk.kotlin.services.ec2.model.VpcCidrBlockState.invoke(block)
        }
    }
}
