// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.AllocateAddressResponse
import aws.sdk.kotlin.services.ec2.model.DomainType
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class AllocateAddressOperationDeserializer: HttpDeserialize<AllocateAddressResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AllocateAddressResponse {
        if (!response.status.isSuccess()) {
            throwAllocateAddressError(context, response)
        }
        val builder = AllocateAddressResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAllocateAddressOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAllocateAddressError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw Ec2Exception("Failed to parse response as 'ec2Query' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> Ec2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAllocateAddressOperationBody(builder: AllocateAddressResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val ALLOCATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("allocationId"))
    val CARRIERIP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("carrierIp"))
    val CUSTOMEROWNEDIP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("customerOwnedIp"))
    val CUSTOMEROWNEDIPV4POOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("customerOwnedIpv4Pool"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("domain"))
    val NETWORKBORDERGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("networkBorderGroup"))
    val PUBLICIP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("publicIp"))
    val PUBLICIPV4POOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("publicIpv4Pool"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("AllocateAddressResult"))
        field(ALLOCATIONID_DESCRIPTOR)
        field(CARRIERIP_DESCRIPTOR)
        field(CUSTOMEROWNEDIP_DESCRIPTOR)
        field(CUSTOMEROWNEDIPV4POOL_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(NETWORKBORDERGROUP_DESCRIPTOR)
        field(PUBLICIP_DESCRIPTOR)
        field(PUBLICIPV4POOL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOCATIONID_DESCRIPTOR.index -> builder.allocationId = deserializeString()
                CARRIERIP_DESCRIPTOR.index -> builder.carrierIp = deserializeString()
                CUSTOMEROWNEDIP_DESCRIPTOR.index -> builder.customerOwnedIp = deserializeString()
                CUSTOMEROWNEDIPV4POOL_DESCRIPTOR.index -> builder.customerOwnedIpv4Pool = deserializeString()
                DOMAIN_DESCRIPTOR.index -> builder.domain = deserializeString().let { DomainType.fromValue(it) }
                NETWORKBORDERGROUP_DESCRIPTOR.index -> builder.networkBorderGroup = deserializeString()
                PUBLICIP_DESCRIPTOR.index -> builder.publicIp = deserializeString()
                PUBLICIPV4POOL_DESCRIPTOR.index -> builder.publicIpv4Pool = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
