// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.DeleteFleetErrorItem
import aws.sdk.kotlin.services.ec2.model.DeleteFleetSuccessItem
import aws.sdk.kotlin.services.ec2.model.DeleteFleetsResponse
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DeleteFleetsOperationDeserializer: HttpDeserialize<DeleteFleetsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteFleetsResponse {
        if (!response.status.isSuccess()) {
            throwDeleteFleetsError(context, response)
        }
        val builder = DeleteFleetsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteFleetsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteFleetsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw Ec2Exception("Failed to parse response as 'ec2Query' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> Ec2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteFleetsOperationBody(builder: DeleteFleetsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val SUCCESSFULFLEETDELETIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("successfulFleetDeletionSet"), XmlCollectionName("item"))
    val UNSUCCESSFULFLEETDELETIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("unsuccessfulFleetDeletionSet"), XmlCollectionName("item"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("DeleteFleetsResult"))
        field(SUCCESSFULFLEETDELETIONS_DESCRIPTOR)
        field(UNSUCCESSFULFLEETDELETIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SUCCESSFULFLEETDELETIONS_DESCRIPTOR.index -> builder.successfulFleetDeletions =
                    deserializer.deserializeList(SUCCESSFULFLEETDELETIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DeleteFleetSuccessItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeleteFleetSuccessItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNSUCCESSFULFLEETDELETIONS_DESCRIPTOR.index -> builder.unsuccessfulFleetDeletions =
                    deserializer.deserializeList(UNSUCCESSFULFLEETDELETIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DeleteFleetErrorItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeleteFleetErrorItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
