// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.InstanceInterruptionBehavior
import aws.sdk.kotlin.services.ec2.model.RequestSpotInstancesRequest
import aws.sdk.kotlin.services.ec2.model.RequestSpotLaunchSpecification
import aws.sdk.kotlin.services.ec2.model.SpotInstanceType
import aws.sdk.kotlin.services.ec2.model.TagSpecification
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class RequestSpotInstancesOperationSerializer: HttpSerialize<RequestSpotInstancesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RequestSpotInstancesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeRequestSpotInstancesOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeRequestSpotInstancesOperationBody(context: ExecutionContext, input: RequestSpotInstancesRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val AVAILABILITYZONEGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AvailabilityZoneGroup"))
    val BLOCKDURATIONMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("BlockDurationMinutes"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClientToken"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val INSTANCECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("InstanceCount"))
    val INSTANCEINTERRUPTIONBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("InstanceInterruptionBehavior"))
    val LAUNCHGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("LaunchGroup"))
    val LAUNCHSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("LaunchSpecification"))
    val SPOTPRICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SpotPrice"))
    val TAGSPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("TagSpecification"), FormUrlFlattened)
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("Type"))
    val VALIDFROM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("ValidFrom"))
    val VALIDUNTIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("ValidUntil"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("RequestSpotInstancesRequest"))
        trait(QueryLiteral("Action", "RequestSpotInstances"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(AVAILABILITYZONEGROUP_DESCRIPTOR)
        field(BLOCKDURATIONMINUTES_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(INSTANCECOUNT_DESCRIPTOR)
        field(INSTANCEINTERRUPTIONBEHAVIOR_DESCRIPTOR)
        field(LAUNCHGROUP_DESCRIPTOR)
        field(LAUNCHSPECIFICATION_DESCRIPTOR)
        field(SPOTPRICE_DESCRIPTOR)
        field(TAGSPECIFICATIONS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(VALIDFROM_DESCRIPTOR)
        field(VALIDUNTIL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.availabilityZoneGroup?.let { field(AVAILABILITYZONEGROUP_DESCRIPTOR, it) }
        input.blockDurationMinutes?.let { field(BLOCKDURATIONMINUTES_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.instanceCount?.let { field(INSTANCECOUNT_DESCRIPTOR, it) }
        input.instanceInterruptionBehavior?.let { field(INSTANCEINTERRUPTIONBEHAVIOR_DESCRIPTOR, it.value) }
        input.launchGroup?.let { field(LAUNCHGROUP_DESCRIPTOR, it) }
        input.launchSpecification?.let { field(LAUNCHSPECIFICATION_DESCRIPTOR, it, ::serializeRequestSpotLaunchSpecificationDocument) }
        input.spotPrice?.let { field(SPOTPRICE_DESCRIPTOR, it) }
        if (input.tagSpecifications != null) {
            listField(TAGSPECIFICATIONS_DESCRIPTOR) {
                for (el0 in input.tagSpecifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagSpecificationDocument))
                }
            }
        }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
        input.validFrom?.let { field(VALIDFROM_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        input.validUntil?.let { field(VALIDUNTIL_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
    }
    return serializer.toByteArray()
}
