// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.ec2.model.*
import aws.sdk.kotlin.services.ec2.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "EC2"
const val ServiceApiVersion: String = "2016-11-15"
const val SdkVersion: String = "0.10.1-beta"

internal class DefaultEc2Client(override val config: Ec2Client.Config) : Ec2Client {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Accepts the Convertible Reserved Instance exchange quote described in the GetReservedInstancesExchangeQuote call.
     */
    override suspend fun acceptReservedInstancesExchangeQuote(input: AcceptReservedInstancesExchangeQuoteRequest): AcceptReservedInstancesExchangeQuoteResponse {
        val op = SdkHttpOperation.build<AcceptReservedInstancesExchangeQuoteRequest, AcceptReservedInstancesExchangeQuoteResponse> {
            serializer = AcceptReservedInstancesExchangeQuoteOperationSerializer()
            deserializer = AcceptReservedInstancesExchangeQuoteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptReservedInstancesExchangeQuote"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     */
    override suspend fun acceptTransitGatewayMulticastDomainAssociations(input: AcceptTransitGatewayMulticastDomainAssociationsRequest): AcceptTransitGatewayMulticastDomainAssociationsResponse {
        val op = SdkHttpOperation.build<AcceptTransitGatewayMulticastDomainAssociationsRequest, AcceptTransitGatewayMulticastDomainAssociationsResponse> {
            serializer = AcceptTransitGatewayMulticastDomainAssociationsOperationSerializer()
            deserializer = AcceptTransitGatewayMulticastDomainAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptTransitGatewayMulticastDomainAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Accepts a transit gateway peering attachment request. The peering attachment must be
     * in the pendingAcceptance state.
     */
    override suspend fun acceptTransitGatewayPeeringAttachment(input: AcceptTransitGatewayPeeringAttachmentRequest): AcceptTransitGatewayPeeringAttachmentResponse {
        val op = SdkHttpOperation.build<AcceptTransitGatewayPeeringAttachmentRequest, AcceptTransitGatewayPeeringAttachmentResponse> {
            serializer = AcceptTransitGatewayPeeringAttachmentOperationSerializer()
            deserializer = AcceptTransitGatewayPeeringAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptTransitGatewayPeeringAttachment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Accepts a request to attach a VPC to a transit gateway.
     * The VPC attachment must be in the pendingAcceptance state.
     * Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests.
     * Use RejectTransitGatewayVpcAttachment to reject a VPC attachment request.
     */
    override suspend fun acceptTransitGatewayVpcAttachment(input: AcceptTransitGatewayVpcAttachmentRequest): AcceptTransitGatewayVpcAttachmentResponse {
        val op = SdkHttpOperation.build<AcceptTransitGatewayVpcAttachmentRequest, AcceptTransitGatewayVpcAttachmentResponse> {
            serializer = AcceptTransitGatewayVpcAttachmentOperationSerializer()
            deserializer = AcceptTransitGatewayVpcAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptTransitGatewayVpcAttachment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Accepts one or more interface VPC endpoint connection requests to your VPC endpoint
     * service.
     */
    override suspend fun acceptVpcEndpointConnections(input: AcceptVpcEndpointConnectionsRequest): AcceptVpcEndpointConnectionsResponse {
        val op = SdkHttpOperation.build<AcceptVpcEndpointConnectionsRequest, AcceptVpcEndpointConnectionsResponse> {
            serializer = AcceptVpcEndpointConnectionsOperationSerializer()
            deserializer = AcceptVpcEndpointConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptVpcEndpointConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must
     * be in the pending-acceptance state, and you must be the owner of the peer VPC.
     * Use DescribeVpcPeeringConnections to view your outstanding VPC
     * peering connection requests.
     * For an inter-Region VPC peering connection request, you must accept the VPC peering
     * connection in the Region of the accepter VPC.
     */
    override suspend fun acceptVpcPeeringConnection(input: AcceptVpcPeeringConnectionRequest): AcceptVpcPeeringConnectionResponse {
        val op = SdkHttpOperation.build<AcceptVpcPeeringConnectionRequest, AcceptVpcPeeringConnectionResponse> {
            serializer = AcceptVpcPeeringConnectionOperationSerializer()
            deserializer = AcceptVpcPeeringConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptVpcPeeringConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP).
     * You can perform this operation at most once every 10 seconds, even if you specify different
     * address ranges each time.
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise
     * it from Amazon Web Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current
     * location and start advertising it through Amazon Web Services.
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services
     * because of BGP propagation delays.
     * To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.
     */
    override suspend fun advertiseByoipCidr(input: AdvertiseByoipCidrRequest): AdvertiseByoipCidrResponse {
        val op = SdkHttpOperation.build<AdvertiseByoipCidrRequest, AdvertiseByoipCidrResponse> {
            serializer = AdvertiseByoipCidrOperationSerializer()
            deserializer = AdvertiseByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdvertiseByoipCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate
     * it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address
     * pool and can be allocated to a different Amazon Web Services account.
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool created
     * from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon Web Services resources using bring your own
     * IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide.
     * &#91;EC2-VPC&#93; If you release an Elastic IP address, you might be able to recover it. You cannot recover an
     * Elastic IP address that you released after it is allocated to another Amazon Web Services account. You cannot recover an Elastic IP
     * address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in this operation.
     * An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate
     * 5 Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     */
    override suspend fun allocateAddress(input: AllocateAddressRequest): AllocateAddressResponse {
        val op = SdkHttpOperation.build<AllocateAddressRequest, AllocateAddressResponse> {
            serializer = AllocateAddressOperationSerializer()
            deserializer = AllocateAddressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AllocateAddress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance
     * type or instance family, the Availability Zone in which to allocate the host, and the number of
     * hosts to allocate.
     */
    override suspend fun allocateHosts(input: AllocateHostsRequest): AllocateHostsResponse {
        val op = SdkHttpOperation.build<AllocateHostsRequest, AllocateHostsResponse> {
            serializer = AllocateHostsOperationSerializer()
            deserializer = AllocateHostsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AllocateHosts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allocate a CIDR from an IPAM pool. In IPAM, an allocation is a CIDR assignment from an IPAM pool to another resource or IPAM pool. For more information, see <a href="/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate CIDRs in the Amazon VPC IPAM User Guide.
     */
    override suspend fun allocateIpamPoolCidr(input: AllocateIpamPoolCidrRequest): AllocateIpamPoolCidrResponse {
        val op = SdkHttpOperation.build<AllocateIpamPoolCidrRequest, AllocateIpamPoolCidrResponse> {
            serializer = AllocateIpamPoolCidrOperationSerializer()
            deserializer = AllocateIpamPoolCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AllocateIpamPoolCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing
     * security groups with the specified security groups.
     */
    override suspend fun applySecurityGroupsToClientVpnTargetNetwork(input: ApplySecurityGroupsToClientVpnTargetNetworkRequest): ApplySecurityGroupsToClientVpnTargetNetworkResponse {
        val op = SdkHttpOperation.build<ApplySecurityGroupsToClientVpnTargetNetworkRequest, ApplySecurityGroupsToClientVpnTargetNetworkResponse> {
            serializer = ApplySecurityGroupsToClientVpnTargetNetworkOperationSerializer()
            deserializer = ApplySecurityGroupsToClientVpnTargetNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ApplySecurityGroupsToClientVpnTargetNetwork"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns one or more IPv6 addresses to the specified network interface. You can
     * specify one or more specific IPv6 addresses, or you can specify the number of IPv6
     * addresses to be automatically assigned from within the subnet's IPv6 CIDR block range.
     * You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per Network Interface Per Instance Type
     * in the Amazon Elastic Compute Cloud User Guide.
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * You can optionally use Prefix Delegation on the network interface. You must specify
     * either the IPV6 Prefix Delegation prefixes, or the IPv6 Prefix Delegation count. For
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">
     * Assigning prefixes to Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun assignIpv6Addresses(input: AssignIpv6AddressesRequest): AssignIpv6AddressesResponse {
        val op = SdkHttpOperation.build<AssignIpv6AddressesRequest, AssignIpv6AddressesResponse> {
            serializer = AssignIpv6AddressesOperationSerializer()
            deserializer = AssignIpv6AddressesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssignIpv6Addresses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * You can specify one or more specific secondary IP addresses, or you can specify the number
     * of secondary IP addresses to be automatically assigned within the subnet's CIDR block range.
     * The number of secondary IP addresses that you can assign to an instance varies by instance type.
     * For information about instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types in the Amazon Elastic Compute Cloud User Guide. For more information about
     * Elastic IP addresses, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     * When you move a secondary private IP address to another network interface, any Elastic IP address
     * that is associated with the IP address is also moved.
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network
     * interface to another, check network/interfaces/macs/mac/local-ipv4s in the instance
     * metadata to confirm that the remapping is complete.
     * You must specify either the IP addresses or the IP address count in the request.
     * You can optionally use Prefix Delegation on the network interface. You must specify
     * either the IPv4 Prefix Delegation prefixes, or the IPv4 Prefix Delegation count. For
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">
     * Assigning prefixes to Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun assignPrivateIpAddresses(input: AssignPrivateIpAddressesRequest): AssignPrivateIpAddressesResponse {
        val op = SdkHttpOperation.build<AssignPrivateIpAddressesRequest, AssignPrivateIpAddressesResponse> {
            serializer = AssignPrivateIpAddressesOperationSerializer()
            deserializer = AssignPrivateIpAddressesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssignPrivateIpAddresses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates an Elastic IP address, or carrier IP address (for instances that are in
     * subnets in Wavelength Zones) with an instance or a network interface. Before you can use an
     * Elastic IP address, you must allocate it to your account.
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     * &#91;EC2-Classic, VPC in an EC2-VPC-only account&#93; If the Elastic IP address is already
     * associated with a different instance, it is disassociated from that instance and associated
     * with the specified instance. If you associate an Elastic IP address with an instance that has
     * an existing Elastic IP address, the existing address is disassociated from the instance, but
     * remains allocated to your account.
     * &#91;VPC in an EC2-Classic account&#93; If you don't specify a private IP address, the Elastic
     * IP address is associated with the primary IP address. If the Elastic IP address is already
     * associated with a different instance or a network interface, you get an error unless you allow
     * reassociation. You cannot associate an Elastic IP address with an instance or network
     * interface that has an existing Elastic IP address.
     * &#91;Subnets in Wavelength Zones&#93; You can associate an IP address from the telecommunication
     * carrier to the instance or network interface.
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2
     * doesn't return an error, and you may be charged for each time the Elastic IP address is
     * remapped to the same instance. For more information, see the Elastic IP
     * Addresses section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon EC2
     * Pricing.
     */
    override suspend fun associateAddress(input: AssociateAddressRequest): AssociateAddressResponse {
        val op = SdkHttpOperation.build<AssociateAddressRequest, AssociateAddressResponse> {
            serializer = AssociateAddressOperationSerializer()
            deserializer = AssociateAddressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateAddress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify the Client VPN endpoint (ModifyClientVpnEndpoint) and change the VPC that's associated with it.
     */
    override suspend fun associateClientVpnTargetNetwork(input: AssociateClientVpnTargetNetworkRequest): AssociateClientVpnTargetNetworkResponse {
        val op = SdkHttpOperation.build<AssociateClientVpnTargetNetworkRequest, AssociateClientVpnTargetNetworkResponse> {
            serializer = AssociateClientVpnTargetNetworkOperationSerializer()
            deserializer = AssociateClientVpnTargetNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateClientVpnTargetNetwork"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP options with the VPC.
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly renew the lease using the operating system on the instance.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets
     * in the Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun associateDhcpOptions(input: AssociateDhcpOptionsRequest): AssociateDhcpOptionsResponse {
        val op = SdkHttpOperation.build<AssociateDhcpOptionsRequest, AssociateDhcpOptionsResponse> {
            serializer = AssociateDhcpOptionsOperationSerializer()
            deserializer = AssociateDhcpOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateDhcpOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate.
     * This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate Manager for Nitro Enclaves in the Amazon Web Services Nitro Enclaves
     * User Guide.
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 bucket that only the associated IAM role can access. The private key of the certificate
     * is encrypted with an Amazon Web Services managed key that has an attached attestation-based key policy.
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call s3:GetObject
     * on the Amazon S3 bucket returned by the command. To enable the IAM role to access the KMS key,
     * you must grant it permission to call kms:Decrypt on the KMS key returned by the command.
     * For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy">
     * Grant the role permission to access the certificate and encryption key in the
     * Amazon Web Services Nitro Enclaves User Guide.
     */
    override suspend fun associateEnclaveCertificateIamRole(input: AssociateEnclaveCertificateIamRoleRequest): AssociateEnclaveCertificateIamRoleResponse {
        val op = SdkHttpOperation.build<AssociateEnclaveCertificateIamRoleRequest, AssociateEnclaveCertificateIamRoleResponse> {
            serializer = AssociateEnclaveCertificateIamRoleOperationSerializer()
            deserializer = AssociateEnclaveCertificateIamRoleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateEnclaveCertificateIamRole"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates an IAM instance profile with a running or stopped instance. You cannot
     * associate more than one IAM instance profile with an instance.
     */
    override suspend fun associateIamInstanceProfile(input: AssociateIamInstanceProfileRequest): AssociateIamInstanceProfileResponse {
        val op = SdkHttpOperation.build<AssociateIamInstanceProfileRequest, AssociateIamInstanceProfileResponse> {
            serializer = AssociateIamInstanceProfileOperationSerializer()
            deserializer = AssociateIamInstanceProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateIamInstanceProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates one or more targets with an event window. Only one type of target (instance IDs,
     * Dedicated Host IDs, or tags) can be specified with an event window.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    override suspend fun associateInstanceEventWindow(input: AssociateInstanceEventWindowRequest): AssociateInstanceEventWindowResponse {
        val op = SdkHttpOperation.build<AssociateInstanceEventWindowRequest, AssociateInstanceEventWindowResponse> {
            serializer = AssociateInstanceEventWindowOperationSerializer()
            deserializer = AssociateInstanceEventWindowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateInstanceEventWindow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway
     * attached to your VPC with a route table in your VPC. This association causes traffic
     * from the subnet or gateway to be routed according to the routes in the route table. The
     * action returns an association ID, which you need in order to disassociate the route
     * table later. A route table can be associated with multiple subnets.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun associateRouteTable(input: AssociateRouteTableRequest): AssociateRouteTableResponse {
        val op = SdkHttpOperation.build<AssociateRouteTableRequest, AssociateRouteTableResponse> {
            serializer = AssociateRouteTableOperationSerializer()
            deserializer = AssociateRouteTableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateRouteTable"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR
     * block with your subnet. An IPv6 CIDR block must have a prefix length of /64.
     */
    override suspend fun associateSubnetCidrBlock(input: AssociateSubnetCidrBlockRequest): AssociateSubnetCidrBlockResponse {
        val op = SdkHttpOperation.build<AssociateSubnetCidrBlockRequest, AssociateSubnetCidrBlockResponse> {
            serializer = AssociateSubnetCidrBlockOperationSerializer()
            deserializer = AssociateSubnetCidrBlockOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateSubnetCidrBlock"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast domain.
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html">DescribeTransitGatewayAttachments
     * to see the state of the attachment.
     */
    override suspend fun associateTransitGatewayMulticastDomain(input: AssociateTransitGatewayMulticastDomainRequest): AssociateTransitGatewayMulticastDomainResponse {
        val op = SdkHttpOperation.build<AssociateTransitGatewayMulticastDomainRequest, AssociateTransitGatewayMulticastDomainResponse> {
            serializer = AssociateTransitGatewayMulticastDomainOperationSerializer()
            deserializer = AssociateTransitGatewayMulticastDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateTransitGatewayMulticastDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified attachment with the specified transit gateway route table. You can
     * associate only one route table with an attachment.
     */
    override suspend fun associateTransitGatewayRouteTable(input: AssociateTransitGatewayRouteTableRequest): AssociateTransitGatewayRouteTableResponse {
        val op = SdkHttpOperation.build<AssociateTransitGatewayRouteTableRequest, AssociateTransitGatewayRouteTableResponse> {
            serializer = AssociateTransitGatewayRouteTableOperationSerializer()
            deserializer = AssociateTransitGatewayRouteTableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateTransitGatewayRouteTable"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This API action is currently in limited preview only.
     * If you are interested in using this feature, contact your account manager.
     * Associates a branch network interface with a trunk network interface.
     * Before you create the association, run the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">create-network-interface command and set
     * --interface-type to trunk. You must also create a network interface for each branch network interface that you want to associate with the trunk network interface.
     */
    override suspend fun associateTrunkInterface(input: AssociateTrunkInterfaceRequest): AssociateTrunkInterfaceResponse {
        val op = SdkHttpOperation.build<AssociateTrunkInterfaceRequest, AssociateTrunkInterfaceResponse> {
            serializer = AssociateTrunkInterfaceOperationSerializer()
            deserializer = AssociateTrunkInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateTrunkInterface"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block,
     * an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that
     * you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP). The IPv6 CIDR block size is fixed
     * at /56.
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6
     * pool, or an Amazon-provided IPv6 CIDR block.
     * For more information about associating CIDR blocks with your VPC and applicable
     * restrictions, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing">VPC and subnet sizing in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun associateVpcCidrBlock(input: AssociateVpcCidrBlockRequest): AssociateVpcCidrBlockResponse {
        val op = SdkHttpOperation.build<AssociateVpcCidrBlockRequest, AssociateVpcCidrBlockResponse> {
            serializer = AssociateVpcCidrBlockOperationSerializer()
            deserializer = AssociateVpcCidrBlockOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateVpcCidrBlock"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's
     * security groups. You cannot link an EC2-Classic instance to more than one VPC at a time. You
     * can only link an instance that's in the running state. An instance is
     * automatically unlinked from a VPC when it's stopped - you can link it to the VPC again when
     * you restart it.
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change the security groups, you must first unlink the instance, and then link it again.
     * Linking your instance to a VPC is sometimes referred to as attaching your instance.
     */
    override suspend fun attachClassicLinkVpc(input: AttachClassicLinkVpcRequest): AttachClassicLinkVpcResponse {
        val op = SdkHttpOperation.build<AttachClassicLinkVpcRequest, AttachClassicLinkVpcResponse> {
            serializer = AttachClassicLinkVpcOperationSerializer()
            deserializer = AttachClassicLinkVpcOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachClassicLinkVpc"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet and
     * the VPC. For more information about your VPC and internet gateway, see the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun attachInternetGateway(input: AttachInternetGatewayRequest): AttachInternetGatewayResponse {
        val op = SdkHttpOperation.build<AttachInternetGatewayRequest, AttachInternetGatewayResponse> {
            serializer = AttachInternetGatewayOperationSerializer()
            deserializer = AttachInternetGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachInternetGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a network interface to an instance.
     */
    override suspend fun attachNetworkInterface(input: AttachNetworkInterfaceRequest): AttachNetworkInterfaceResponse {
        val op = SdkHttpOperation.build<AttachNetworkInterfaceRequest, AttachNetworkInterfaceResponse> {
            serializer = AttachNetworkInterfaceOperationSerializer()
            deserializer = AttachNetworkInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachNetworkInterface"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance
     * with the specified device name.
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
     * After you attach an EBS volume, you must make it available. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html">Make an EBS volume available for use.
     * If a volume has an Amazon Web Services Marketplace product code:
     * The volume can be attached only to a stopped instance.
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * You must be subscribed to the product.
     * The instance type and operating system of the instance must support the product. For
     * example, you can't detach a volume from a Windows instance and attach it to a Linux
     * instance.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attach an Amazon EBS volume to an instance in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun attachVolume(input: AttachVolumeRequest): AttachVolumeResponse {
        val op = SdkHttpOperation.build<AttachVolumeRequest, AttachVolumeResponse> {
            serializer = AttachVolumeOperationSerializer()
            deserializer = AttachVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a virtual private gateway to a VPC. You can attach one virtual private
     * gateway to one VPC at a time.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    override suspend fun attachVpnGateway(input: AttachVpnGatewayRequest): AttachVpnGatewayResponse {
        val op = SdkHttpOperation.build<AttachVpnGatewayRequest, AttachVpnGatewayResponse> {
            serializer = AttachVpnGatewayOperationSerializer()
            deserializer = AttachVpnGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachVpnGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as
     * firewall rules that grant access to networks. You must configure ingress authorization rules to
     * enable clients to access resources in Amazon Web Services or on-premises networks.
     */
    override suspend fun authorizeClientVpnIngress(input: AuthorizeClientVpnIngressRequest): AuthorizeClientVpnIngressResponse {
        val op = SdkHttpOperation.build<AuthorizeClientVpnIngressRequest, AuthorizeClientVpnIngressResponse> {
            serializer = AuthorizeClientVpnIngressOperationSerializer()
            deserializer = AuthorizeClientVpnIngressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AuthorizeClientVpnIngress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * &#91;VPC only&#93; Adds the specified outbound (egress) rules to a security group for use with a VPC.
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address
     * ranges, or to the instances that are associated with the specified source security groups.
     * You specify a protocol for each rule (for example, TCP).
     * For the TCP and UDP protocols, you must also specify the destination port or port range.
     * For the ICMP protocol, you must also specify the ICMP type and code.
     * You can use -1 for the type or code to mean all types or all codes.
     * Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.
     * For information about VPC security group quotas, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas.
     */
    override suspend fun authorizeSecurityGroupEgress(input: AuthorizeSecurityGroupEgressRequest): AuthorizeSecurityGroupEgressResponse {
        val op = SdkHttpOperation.build<AuthorizeSecurityGroupEgressRequest, AuthorizeSecurityGroupEgressResponse> {
            serializer = AuthorizeSecurityGroupEgressOperationSerializer()
            deserializer = AuthorizeSecurityGroupEgressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AuthorizeSecurityGroupEgress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified inbound (ingress) rules to a security group.
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR
     * address range, or from the instances that are associated with the specified destination security
     * groups.
     * You specify a protocol for each rule (for example, TCP).
     * For TCP and UDP, you must also specify the destination port or port range.
     * For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code.
     * You can use -1 to mean all types or all codes.
     * Rule changes are propagated to instances within the security group as quickly as possible.
     * However, a small delay might occur.
     * For more information about VPC security group quotas, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas.
     */
    override suspend fun authorizeSecurityGroupIngress(input: AuthorizeSecurityGroupIngressRequest): AuthorizeSecurityGroupIngressResponse {
        val op = SdkHttpOperation.build<AuthorizeSecurityGroupIngressRequest, AuthorizeSecurityGroupIngressResponse> {
            serializer = AuthorizeSecurityGroupIngressOperationSerializer()
            deserializer = AuthorizeSecurityGroupIngressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AuthorizeSecurityGroupIngress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Bundles an Amazon instance store-backed Windows instance.
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not preserved.
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     */
    override suspend fun bundleInstance(input: BundleInstanceRequest): BundleInstanceResponse {
        val op = SdkHttpOperation.build<BundleInstanceRequest, BundleInstanceResponse> {
            serializer = BundleInstanceOperationSerializer()
            deserializer = BundleInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BundleInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a bundling operation for an instance store-backed Windows instance.
     */
    override suspend fun cancelBundleTask(input: CancelBundleTaskRequest): CancelBundleTaskResponse {
        val op = SdkHttpOperation.build<CancelBundleTaskRequest, CancelBundleTaskResponse> {
            serializer = CancelBundleTaskOperationSerializer()
            deserializer = CancelBundleTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelBundleTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity Reservation's state to
     * cancelled.
     * Instances running in the reserved capacity continue running until you stop them. Stopped
     * instances that target the Capacity Reservation can no longer launch. Modify these instances to either
     * target a different Capacity Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation
     * that has matching attributes and sufficient capacity.
     */
    override suspend fun cancelCapacityReservation(input: CancelCapacityReservationRequest): CancelCapacityReservationResponse {
        val op = SdkHttpOperation.build<CancelCapacityReservationRequest, CancelCapacityReservationResponse> {
            serializer = CancelCapacityReservationOperationSerializer()
            deserializer = CancelCapacityReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelCapacityReservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation
     * Fleet, the following happens:
     * The Capacity Reservation Fleet's status changes to cancelled.
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running
     * in the Capacity Reservations at the time of cancelling the Fleet continue to run in
     * shared capacity.
     * The Fleet stops creating new Capacity Reservations.
     */
    override suspend fun cancelCapacityReservationFleets(input: CancelCapacityReservationFleetsRequest): CancelCapacityReservationFleetsResponse {
        val op = SdkHttpOperation.build<CancelCapacityReservationFleetsRequest, CancelCapacityReservationFleetsResponse> {
            serializer = CancelCapacityReservationFleetsOperationSerializer()
            deserializer = CancelCapacityReservationFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelCapacityReservationFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is
     * in the process of transferring the final disk image, the command fails and returns an exception.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a Virtual Machine Using the Amazon
     * EC2 CLI.
     */
    override suspend fun cancelConversionTask(input: CancelConversionTaskRequest): CancelConversionTaskResponse {
        val op = SdkHttpOperation.build<CancelConversionTaskRequest, CancelConversionTaskResponse> {
            serializer = CancelConversionTaskOperationSerializer()
            deserializer = CancelConversionTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelConversionTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     */
    override suspend fun cancelExportTask(input: CancelExportTaskRequest): CancelExportTaskResponse {
        val op = SdkHttpOperation.build<CancelExportTaskRequest, CancelExportTaskResponse> {
            serializer = CancelExportTaskOperationSerializer()
            deserializer = CancelExportTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelExportTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an in-process import virtual machine or import snapshot task.
     */
    override suspend fun cancelImportTask(input: CancelImportTaskRequest): CancelImportTaskResponse {
        val op = SdkHttpOperation.build<CancelImportTaskRequest, CancelImportTaskResponse> {
            serializer = CancelImportTaskOperationSerializer()
            deserializer = CancelImportTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelImportTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    override suspend fun cancelReservedInstancesListing(input: CancelReservedInstancesListingRequest): CancelReservedInstancesListingResponse {
        val op = SdkHttpOperation.build<CancelReservedInstancesListingRequest, CancelReservedInstancesListingResponse> {
            serializer = CancelReservedInstancesListingOperationSerializer()
            deserializer = CancelReservedInstancesListingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelReservedInstancesListing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the specified Spot Fleet requests.
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances.
     * You must specify whether the Spot Fleet should also terminate its Spot Instances. If you
     * terminate the instances, the Spot Fleet request enters the
     * cancelled_terminating state. Otherwise, the Spot Fleet request enters
     * the cancelled_running state and the instances continue to run until they
     * are interrupted or you terminate them manually.
     */
    override suspend fun cancelSpotFleetRequests(input: CancelSpotFleetRequestsRequest): CancelSpotFleetRequestsResponse {
        val op = SdkHttpOperation.build<CancelSpotFleetRequestsRequest, CancelSpotFleetRequestsResponse> {
            serializer = CancelSpotFleetRequestsOperationSerializer()
            deserializer = CancelSpotFleetRequestsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelSpotFleetRequests"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels one or more Spot Instance requests.
     * Canceling a Spot Instance request does not terminate running Spot Instances
     * associated with the request.
     */
    override suspend fun cancelSpotInstanceRequests(input: CancelSpotInstanceRequestsRequest): CancelSpotInstanceRequestsResponse {
        val op = SdkHttpOperation.build<CancelSpotInstanceRequestsRequest, CancelSpotInstanceRequestsResponse> {
            serializer = CancelSpotInstanceRequestsOperationSerializer()
            deserializer = CancelSpotInstanceRequestsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelSpotInstanceRequests"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Determines whether a product code is associated with an instance. This action can only
     * be used by the owner of the product code. It is useful when a product code owner must
     * verify whether another user's instance is eligible for support.
     */
    override suspend fun confirmProductInstance(input: ConfirmProductInstanceRequest): ConfirmProductInstanceResponse {
        val op = SdkHttpOperation.build<ConfirmProductInstanceRequest, ConfirmProductInstanceResponse> {
            serializer = ConfirmProductInstanceOperationSerializer()
            deserializer = ConfirmProductInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ConfirmProductInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     */
    override suspend fun copyFpgaImage(input: CopyFpgaImageRequest): CopyFpgaImageResponse {
        val op = SdkHttpOperation.build<CopyFpgaImageRequest, CopyFpgaImageResponse> {
            serializer = CopyFpgaImageOperationSerializer()
            deserializer = CopyFpgaImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopyFpgaImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a
     * Region to an Outpost. You can't copy an AMI from an Outpost to a Region, from one Outpost
     * to another, or within the same Outpost. To copy an AMI to another partition, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html">CreateStoreImageTask.
     * To copy an AMI from one Region to another, specify the source Region using the
     * SourceRegion parameter, and specify the
     * destination Region using its endpoint. Copies of encrypted backing snapshots for
     * the AMI are encrypted. Copies of unencrypted backing snapshots remain unencrypted,
     * unless you set Encrypted during the copy operation. You cannot
     * create an unencrypted copy of an encrypted backing snapshot.
     * To copy an AMI from a Region to an Outpost, specify the source Region using the
     * SourceRegion parameter, and specify the
     * ARN of the destination Outpost using DestinationOutpostArn.
     * Backing snapshots copied to an Outpost are encrypted by default using the default
     * encryption key for the Region, or a different key that you specify in the request using
     * KmsKeyId. Outposts do not support unencrypted
     * snapshots. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami">
     * Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide.
     * For more information about the prerequisites and limits when copying an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copying an AMI
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun copyImage(input: CopyImageRequest): CopyImageResponse {
        val op = SdkHttpOperation.build<CopyImageRequest, CopyImageResponse> {
            serializer = CopyImageOperationSerializer()
            deserializer = CopyImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopyImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a
     * snapshot within the same Region, from one Region to another, or from a Region to an Outpost.
     * You can't copy a snapshot from an Outpost to a Region, from one Outpost to another, or within
     * the same Outpost.
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted.
     * Copies of unencrypted snapshots remain unencrypted, unless you enable encryption for the
     * snapshot copy operation. By default, encrypted snapshot copies use the default Key Management Service (KMS)
     * KMS key; however, you can specify a different KMS key. To copy an encrypted
     * snapshot that has been shared from another account, you must have permissions for the KMS key
     * used to encrypt the snapshot.
     * Snapshots copied to an Outpost are encrypted by default using the default
     * encryption key for the Region, or a different key that you specify in the request using
     * KmsKeyId. Outposts do not support unencrypted
     * snapshots. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami">
     * Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide.
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not
     * be used for any purpose.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html">Copy an Amazon EBS snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun copySnapshot(input: CopySnapshotRequest): CopySnapshotResponse {
        val op = SdkHttpOperation.build<CopySnapshotRequest, CopySnapshotResponse> {
            serializer = CopySnapshotOperationSerializer()
            deserializer = CopySnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopySnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Capacity Reservation with the specified attributes.
     * Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration. This
     * gives you the flexibility to selectively add capacity reservations and still get the Regional RI discounts for that usage.
     * By creating Capacity Reservations, you ensure that you always have access to Amazon EC2 capacity when you need it, for as long as you need it.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity Reservations in the Amazon EC2 User Guide.
     * Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to
     * fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try
     * again at a later time, try in a different Availability Zone, or request a smaller
     * capacity reservation. If your application is flexible across instance types and sizes,
     * try to create a Capacity Reservation with different instance attributes.
     * Your request could also fail if the requested quantity exceeds your On-Demand Instance
     * limit for the selected instance type. If your request fails due to limit constraints,
     * increase your On-Demand Instance limit for the required instance type and try again. For
     * more information about increasing your instance limits, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service
     * Quotas in the Amazon EC2 User Guide.
     */
    override suspend fun createCapacityReservation(input: CreateCapacityReservationRequest): CreateCapacityReservationResponse {
        val op = SdkHttpOperation.build<CreateCapacityReservationRequest, CreateCapacityReservationResponse> {
            serializer = CreateCapacityReservationOperationSerializer()
            deserializer = CreateCapacityReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCapacityReservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Capacity Reservation Fleet. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a Capacity
     * Reservation Fleet in the Amazon EC2 User Guide.
     */
    override suspend fun createCapacityReservationFleet(input: CreateCapacityReservationFleetRequest): CreateCapacityReservationFleetResponse {
        val op = SdkHttpOperation.build<CreateCapacityReservationFleetRequest, CreateCapacityReservationFleetResponse> {
            serializer = CreateCapacityReservationFleetOperationSerializer()
            deserializer = CreateCapacityReservationFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCapacityReservationFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a carrier gateway.   For more information about carrier gateways, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway">Carrier gateways in the Amazon Web Services Wavelength Developer Guide.
     */
    override suspend fun createCarrierGateway(input: CreateCarrierGatewayRequest): CreateCarrierGatewayResponse {
        val op = SdkHttpOperation.build<CreateCarrierGatewayRequest, CreateCarrierGatewayResponse> {
            serializer = CreateCarrierGatewayOperationSerializer()
            deserializer = CreateCarrierGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCarrierGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to
     * enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions
     * are terminated.
     */
    override suspend fun createClientVpnEndpoint(input: CreateClientVpnEndpointRequest): CreateClientVpnEndpointResponse {
        val op = SdkHttpOperation.build<CreateClientVpnEndpointRequest, CreateClientVpnEndpointResponse> {
            serializer = CreateClientVpnEndpointOperationSerializer()
            deserializer = CreateClientVpnEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateClientVpnEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc resources or networks.
     */
    override suspend fun createClientVpnRoute(input: CreateClientVpnRouteRequest): CreateClientVpnRouteResponse {
        val op = SdkHttpOperation.build<CreateClientVpnRouteRequest, CreateClientVpnRouteResponse> {
            serializer = CreateClientVpnRouteOperationSerializer()
            deserializer = CreateClientVpnRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateClientVpnRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information to Amazon Web Services about your VPN customer gateway device. The
     * customer gateway is the appliance at your end of the VPN connection. (The device on the
     * Amazon Web Services side of the VPN connection is the virtual private gateway.) You
     * must provide the internet-routable IP address of the customer gateway's external
     * interface. The IP address must be static and can be behind a device performing network
     * address translation (NAT).
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's
     * BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your
     * network. If you don't have an ASN already, you can use a private ASN (in the 64512 -
     * 65534 range).
     * Amazon EC2 supports all 4-byte ASN numbers in the range of 1 - 2147483647, with
     * the exception of the following:
     * 7224 - reserved in the us-east-1 Region
     * 9059 - reserved in the eu-west-1 Region
     * 17943 - reserved in the ap-southeast-1 Region
     * 10124 - reserved in the ap-northeast-1 Region
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     * To create more than one customer gateway with the same VPN type, IP address, and
     * BGP ASN, specify a unique device name for each customer gateway. Identical requests
     * return information about the existing customer gateway and do not create new
     * customer gateways.
     */
    override suspend fun createCustomerGateway(input: CreateCustomerGatewayRequest): CreateCustomerGatewayResponse {
        val op = SdkHttpOperation.build<CreateCustomerGatewayRequest, CreateCustomerGatewayResponse> {
            serializer = CreateCustomerGatewayOperationSerializer()
            deserializer = CreateCustomerGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomerGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a default subnet with a size /20 IPv4 CIDR block in the
     * specified Availability Zone in your default VPC. You can have only one default subnet
     * per Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Creating a default
     * subnet in the Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createDefaultSubnet(input: CreateDefaultSubnetRequest): CreateDefaultSubnetResponse {
        val op = SdkHttpOperation.build<CreateDefaultSubnetRequest, CreateDefaultSubnetResponse> {
            serializer = CreateDefaultSubnetOperationSerializer()
            deserializer = CreateDefaultSubnetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDefaultSubnet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a default VPC with a size /16 IPv4 CIDR block and a default subnet
     * in each Availability Zone. For more information about the components of a default VPC,
     * see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPC and
     * default subnets in the Amazon Virtual Private Cloud User Guide. You cannot
     * specify the components of the default VPC yourself.
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have
     * more than one default VPC per Region.
     * If your account supports EC2-Classic, you cannot use this action to create a default VPC
     * in a Region that supports EC2-Classic. If you want a default VPC in a Region that
     * supports EC2-Classic, see "I really want a default VPC for my existing EC2 account. Is
     * that possible?" in the <a href="http://aws.amazon.com/vpc/faqs/#Default_VPCs">Default VPCs
     * FAQ.
     */
    override suspend fun createDefaultVpc(input: CreateDefaultVpcRequest): CreateDefaultVpcResponse {
        val op = SdkHttpOperation.build<CreateDefaultVpcRequest, CreateDefaultVpcResponse> {
            serializer = CreateDefaultVpcOperationSerializer()
            deserializer = CreateDefaultVpcOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDefaultVpc"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a set of DHCP options for your VPC. After creating the set, you must
     * associate it with the VPC, causing all existing and new instances that you launch in
     * the VPC to use this set of DHCP options. The following are the individual DHCP
     * options you can specify. For more information about the options, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132.
     * domain-name-servers - The IP addresses of up to four domain name
     * servers, or AmazonProvidedDNS. The default DHCP option set specifies
     * AmazonProvidedDNS. If specifying more than one domain name server, specify the
     * IP addresses in a single parameter, separated by commas. To have your instance
     * receive a custom DNS hostname as specified in domain-name, you must
     * set domain-name-servers to a custom DNS server.
     * domain-name - If you're using AmazonProvidedDNS in
     * us-east-1, specify ec2.internal. If you're using
     * AmazonProvidedDNS in another Region, specify
     * region.compute.internal (for example,
     * ap-northeast-1.compute.internal). Otherwise, specify a domain
     * name (for example, ExampleCompany.com). This value is used to complete
     * unqualified DNS hostnames. Important: Some
     * Linux operating systems accept multiple domain names separated by spaces.
     * However, Windows and other Linux operating systems treat the value as a single
     * domain, which results in unexpected behavior. If your DHCP options set is
     * associated with a VPC that has instances with multiple operating systems,
     * specify only one domain name.
     * ntp-servers - The IP addresses of up to four Network Time Protocol (NTP)
     * servers.
     * netbios-name-servers - The IP addresses of up to four NetBIOS name
     * servers.
     * netbios-node-type - The NetBIOS node type (1, 2, 4, or 8). We recommend that
     * you specify 2 (broadcast and multicast are not currently supported). For more information
     * about these node types, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132.
     * Your VPC automatically starts out with a set of DHCP options that includes only a DNS
     * server that we provide (AmazonProvidedDNS). If you create a set of options, and if your
     * VPC has an internet gateway, make sure to set the domain-name-servers
     * option either to AmazonProvidedDNS or to a domain name server of your
     * choice. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createDhcpOptions(input: CreateDhcpOptionsRequest): CreateDhcpOptionsResponse {
        val op = SdkHttpOperation.build<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse> {
            serializer = CreateDhcpOptionsOperationSerializer()
            deserializer = CreateDhcpOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDhcpOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * &#91;IPv6 only&#93; Creates an egress-only internet gateway for your VPC. An egress-only
     * internet gateway is used to enable outbound communication over IPv6 from instances in
     * your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6
     * connection with your instance.
     */
    override suspend fun createEgressOnlyInternetGateway(input: CreateEgressOnlyInternetGatewayRequest): CreateEgressOnlyInternetGatewayResponse {
        val op = SdkHttpOperation.build<CreateEgressOnlyInternetGatewayRequest, CreateEgressOnlyInternetGatewayResponse> {
            serializer = CreateEgressOnlyInternetGatewayOperationSerializer()
            deserializer = CreateEgressOnlyInternetGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEgressOnlyInternetGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Launches an EC2 Fleet.
     * You can create a single EC2 Fleet that includes multiple launch specifications that vary by
     * instance type, AMI, Availability Zone, or subnet.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">Launching an EC2 Fleet in the Amazon EC2 User Guide.
     */
    override suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse {
        val op = SdkHttpOperation.build<CreateFleetRequest, CreateFleetResponse> {
            serializer = CreateFleetOperationSerializer()
            deserializer = CreateFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface,
     * subnet, or VPC.
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events
     * consisting of fields that describe the traffic flow. For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records
     * in the Amazon Virtual Private Cloud User Guide.
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network
     * interface has a unique log stream in the log group. When publishing to Amazon S3, flow log records for all
     * of the monitored network interfaces are published to a single log file object that is stored in the specified
     * bucket.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow Logs in the Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createFlowLogs(input: CreateFlowLogsRequest): CreateFlowLogsResponse {
        val op = SdkHttpOperation.build<CreateFlowLogsRequest, CreateFlowLogsResponse> {
            serializer = CreateFlowLogsOperationSerializer()
            deserializer = CreateFlowLogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFlowLogs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * The create operation is asynchronous. To verify that the AFI is ready for use,
     * check the output logs.
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA.
     * You can securely deploy an AFI on multiple FPGA-accelerated instances.
     * For more information, see the <a href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit.
     */
    override suspend fun createFpgaImage(input: CreateFpgaImageRequest): CreateFpgaImageResponse {
        val op = SdkHttpOperation.build<CreateFpgaImageRequest, CreateFpgaImageResponse> {
            serializer = CreateFpgaImageOperationSerializer()
            deserializer = CreateFpgaImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFpgaImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance
     * that is either running or stopped.
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device volume, the
     * new AMI contains block device mapping information for those volumes. When you launch an instance from this new AMI,
     * the instance automatically launches with those additional volumes.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating Amazon EBS-Backed Linux AMIs
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun createImage(input: CreateImageRequest): CreateImageResponse {
        val op = SdkHttpOperation.build<CreateImageRequest, CreateImageResponse> {
            serializer = CreateImageOperationSerializer()
            deserializer = CreateImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can
     * run.
     * You can define either a set of time ranges or a cron expression when creating the event
     * window, but not both. All event window times are in UTC.
     * You can create up to 200 event windows per Amazon Web Services Region.
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags)
     * are not yet associated with it. To ensure that the event window can be used, you must
     * associate one or more targets with it by using the AssociateInstanceEventWindow API.
     * Event windows are applicable only for scheduled events that stop, reboot, or
     * terminate instances.
     * Event windows are not applicable for:
     * Expedited scheduled events and network maintenance events.
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    override suspend fun createInstanceEventWindow(input: CreateInstanceEventWindowRequest): CreateInstanceEventWindowResponse {
        val op = SdkHttpOperation.build<CreateInstanceEventWindowRequest, CreateInstanceEventWindowResponse> {
            serializer = CreateInstanceEventWindowOperationSerializer()
            deserializer = CreateInstanceEventWindowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInstanceEventWindow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * For information about the supported operating systems, image formats, and known limitations
     * for the types of instances you can export, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using VM Import/Export
     * in the VM Import/Export User Guide.
     */
    override suspend fun createInstanceExportTask(input: CreateInstanceExportTaskRequest): CreateInstanceExportTaskResponse {
        val op = SdkHttpOperation.build<CreateInstanceExportTaskRequest, CreateInstanceExportTaskResponse> {
            serializer = CreateInstanceExportTaskOperationSerializer()
            deserializer = CreateInstanceExportTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInstanceExportTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an internet gateway for use with a VPC. After creating the internet gateway,
     * you attach it to a VPC using AttachInternetGateway.
     * For more information about your VPC and internet gateway, see the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createInternetGateway(input: CreateInternetGatewayRequest): CreateInternetGatewayResponse {
        val op = SdkHttpOperation.build<CreateInternetGatewayRequest, CreateInternetGatewayResponse> {
            serializer = CreateInternetGatewayOperationSerializer()
            deserializer = CreateInternetGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInternetGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an IPAM. Amazon VCP IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
     * For more information, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM in the Amazon VPC IPAM User Guide.
     */
    override suspend fun createIpam(input: CreateIpamRequest): CreateIpamResponse {
        val op = SdkHttpOperation.build<CreateIpamRequest, CreateIpamResponse> {
            serializer = CreateIpamOperationSerializer()
            deserializer = CreateIpamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIpam"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs. For example, if you have separate routing and security needs for development and production applications, you can create a pool for each.
     * For more information, see <a href="/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool in the Amazon VPC IPAM User Guide.
     */
    override suspend fun createIpamPool(input: CreateIpamPoolRequest): CreateIpamPoolResponse {
        val op = SdkHttpOperation.build<CreateIpamPoolRequest, CreateIpamPoolResponse> {
            serializer = CreateIpamPoolOperationSerializer()
            deserializer = CreateIpamPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIpamPool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict.
     * For more information, see <a href="/vpc/latest/ipam/add-scope-ipam.html">Add a scope in the Amazon VPC IPAM User Guide.
     */
    override suspend fun createIpamScope(input: CreateIpamScopeRequest): CreateIpamScopeResponse {
        val op = SdkHttpOperation.build<CreateIpamScopeRequest, CreateIpamScopeResponse> {
            serializer = CreateIpamScopeOperationSerializer()
            deserializer = CreateIpamScopeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIpamScope"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public
     * key and displays the private key for you to save to a file. The private key is returned
     * as an unencrypted PEM encoded PKCS#1 private key. If a key with the specified name
     * already exists, Amazon EC2 returns an error.
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it.
     * If you prefer, you can create your own key pair using a third-party tool and upload it
     * to any Region using ImportKeyPair.
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun createKeyPair(input: CreateKeyPairRequest): CreateKeyPairResponse {
        val op = SdkHttpOperation.build<CreateKeyPairRequest, CreateKeyPairResponse> {
            serializer = CreateKeyPairOperationSerializer()
            deserializer = CreateKeyPairOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateKeyPair"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a launch template. A launch template contains the parameters to launch an
     * instance. When you launch an instance using RunInstances, you can
     * specify a launch template instead of providing the launch parameters in the request. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a
     * launch template in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun createLaunchTemplate(input: CreateLaunchTemplateRequest): CreateLaunchTemplateResponse {
        val op = SdkHttpOperation.build<CreateLaunchTemplateRequest, CreateLaunchTemplateResponse> {
            serializer = CreateLaunchTemplateOperationSerializer()
            deserializer = CreateLaunchTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLaunchTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new version for a launch template. You can specify an existing version of
     * launch template from which to base the new version.
     * Launch template versions are numbered in the order in which they are created. You
     * cannot specify, change, or replace the numbering of launch template versions.
     * For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions">Managing launch template versionsin the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun createLaunchTemplateVersion(input: CreateLaunchTemplateVersionRequest): CreateLaunchTemplateVersionResponse {
        val op = SdkHttpOperation.build<CreateLaunchTemplateVersionRequest, CreateLaunchTemplateVersionResponse> {
            serializer = CreateLaunchTemplateVersionOperationSerializer()
            deserializer = CreateLaunchTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLaunchTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a static route for the specified local gateway route table.
     */
    override suspend fun createLocalGatewayRoute(input: CreateLocalGatewayRouteRequest): CreateLocalGatewayRouteResponse {
        val op = SdkHttpOperation.build<CreateLocalGatewayRouteRequest, CreateLocalGatewayRouteResponse> {
            serializer = CreateLocalGatewayRouteOperationSerializer()
            deserializer = CreateLocalGatewayRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocalGatewayRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified VPC with the specified local gateway route table.
     */
    override suspend fun createLocalGatewayRouteTableVpcAssociation(input: CreateLocalGatewayRouteTableVpcAssociationRequest): CreateLocalGatewayRouteTableVpcAssociationResponse {
        val op = SdkHttpOperation.build<CreateLocalGatewayRouteTableVpcAssociationRequest, CreateLocalGatewayRouteTableVpcAssociationResponse> {
            serializer = CreateLocalGatewayRouteTableVpcAssociationOperationSerializer()
            deserializer = CreateLocalGatewayRouteTableVpcAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLocalGatewayRouteTableVpcAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a managed prefix list. You can specify one or more entries for the prefix list.
     * Each entry consists of a CIDR block and an optional description.
     */
    override suspend fun createManagedPrefixList(input: CreateManagedPrefixListRequest): CreateManagedPrefixListResponse {
        val op = SdkHttpOperation.build<CreateManagedPrefixListRequest, CreateManagedPrefixListResponse> {
            serializer = CreateManagedPrefixListOperationSerializer()
            deserializer = CreateManagedPrefixListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateManagedPrefixList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a NAT gateway in the specified subnet. This action creates a network interface
     * in the specified subnet with a private IP address from the IP address range of the
     * subnet. You can create either a public NAT gateway or a private NAT gateway.
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed
     * to the NAT gateway, so that instances in a private subnet can connect to the internet.
     * With a private NAT gateway, private communication is routed across VPCs and on-premises
     * networks through a transit gateway or virtual private gateway. Common use cases include
     * running large workloads behind a small pool of allowlisted IPv4 addresses, preserving
     * private IPv4 addresses, and communicating between overlapping networks.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT gateways in the Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createNatGateway(input: CreateNatGatewayRequest): CreateNatGatewayResponse {
        val op = SdkHttpOperation.build<CreateNatGatewayRequest, CreateNatGatewayResponse> {
            serializer = CreateNatGatewayOperationSerializer()
            deserializer = CreateNatGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNatGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security groups) for the instances in your VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createNetworkAcl(input: CreateNetworkAclRequest): CreateNetworkAclResponse {
        val op = SdkHttpOperation.build<CreateNetworkAclRequest, CreateNetworkAclResponse> {
            serializer = CreateNetworkAclOperationSerializer()
            deserializer = CreateNetworkAclOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNetworkAcl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules
     * and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated
     * with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of
     * ingress rules and a separate set of egress rules.
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them one right after the
     * other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing ones without having to renumber the rules.
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old one.
     * For more information about network ACLs, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createNetworkAclEntry(input: CreateNetworkAclEntryRequest): CreateNetworkAclEntryResponse {
        val op = SdkHttpOperation.build<CreateNetworkAclEntryRequest, CreateNetworkAclEntryResponse> {
            serializer = CreateNetworkAclEntryOperationSerializer()
            deserializer = CreateNetworkAclEntryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNetworkAclEntry"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Network Access Scope.
     * Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams
     * to verify that their networks on Amazon Web Services conform to their network security and governance
     * objectives. For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web Services Network Access Analyzer Guide.
     */
    override suspend fun createNetworkInsightsAccessScope(input: CreateNetworkInsightsAccessScopeRequest): CreateNetworkInsightsAccessScopeResponse {
        val op = SdkHttpOperation.build<CreateNetworkInsightsAccessScopeRequest, CreateNetworkInsightsAccessScopeResponse> {
            serializer = CreateNetworkInsightsAccessScopeOperationSerializer()
            deserializer = CreateNetworkInsightsAccessScopeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNetworkInsightsAccessScope"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a path to analyze for reachability.
     * Reachability Analyzer enables you to analyze and debug network reachability between
     * two resources in your virtual private cloud (VPC). For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/reachability/">What is Reachability Analyzer.
     */
    override suspend fun createNetworkInsightsPath(input: CreateNetworkInsightsPathRequest): CreateNetworkInsightsPathResponse {
        val op = SdkHttpOperation.build<CreateNetworkInsightsPathRequest, CreateNetworkInsightsPathResponse> {
            serializer = CreateNetworkInsightsPathOperationSerializer()
            deserializer = CreateNetworkInsightsPathOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNetworkInsightsPath"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a network interface in the specified subnet.
     * For more information about network interfaces, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces
     * in the Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createNetworkInterface(input: CreateNetworkInterfaceRequest): CreateNetworkInterfaceResponse {
        val op = SdkHttpOperation.build<CreateNetworkInterfaceRequest, CreateNetworkInterfaceResponse> {
            serializer = CreateNetworkInterfaceOperationSerializer()
            deserializer = CreateNetworkInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNetworkInterface"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to
     * an instance in their account.
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     */
    override suspend fun createNetworkInterfacePermission(input: CreateNetworkInterfacePermissionRequest): CreateNetworkInterfacePermissionResponse {
        val op = SdkHttpOperation.build<CreateNetworkInterfacePermissionRequest, CreateNetworkInterfacePermissionResponse> {
            serializer = CreateNetworkInterfacePermissionOperationSerializer()
            deserializer = CreateNetworkInterfacePermissionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNetworkInterfacePermission"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a placement group in which to launch instances. The strategy of the placement
     * group determines how the instances are organized within the group.
     * A cluster placement group is a logical grouping of instances within a
     * single Availability Zone that benefit from low network latency, high network throughput.
     * A spread placement group places instances on distinct hardware. A
     * partition placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with
     * instances in another partition.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups in the
     * Amazon EC2 User Guide.
     */
    override suspend fun createPlacementGroup(input: CreatePlacementGroupRequest): CreatePlacementGroupResponse {
        val op = SdkHttpOperation.build<CreatePlacementGroupRequest, CreatePlacementGroupResponse> {
            serializer = CreatePlacementGroupOperationSerializer()
            deserializer = CreatePlacementGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePlacementGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only. To monitor the status of pool creation, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html">DescribePublicIpv4Pools.
     */
    override suspend fun createPublicIpv4Pool(input: CreatePublicIpv4PoolRequest): CreatePublicIpv4PoolResponse {
        val op = SdkHttpOperation.build<CreatePublicIpv4PoolRequest, CreatePublicIpv4PoolResponse> {
            serializer = CreatePublicIpv4PoolOperationSerializer()
            deserializer = CreatePublicIpv4PoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePublicIpv4Pool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a root volume replacement task for an Amazon EC2 instance. The root volume
     * can either be restored to its initial launch state, or it can be restored using a
     * specific snapshot.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root">Replace a root volume in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun createReplaceRootVolumeTask(input: CreateReplaceRootVolumeTaskRequest): CreateReplaceRootVolumeTaskResponse {
        val op = SdkHttpOperation.build<CreateReplaceRootVolumeTaskRequest, CreateReplaceRootVolumeTaskResponse> {
            serializer = CreateReplaceRootVolumeTaskOperationSerializer()
            deserializer = CreateReplaceRootVolumeTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateReplaceRootVolumeTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance
     * Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your
     * Standard Reserved Instances, you can use the DescribeReservedInstances operation.
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace.
     * Convertible Reserved Instances cannot be sold.
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance
     * Marketplace listing of some or all of your Standard Reserved Instances, and specify the upfront price
     * to receive for them. Your Standard Reserved Instance listings then become available for purchase. To
     * view the details of your Standard Reserved Instance listing, you can use the
     * DescribeReservedInstancesListings operation.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace in the
     * Amazon EC2 User Guide.
     */
    override suspend fun createReservedInstancesListing(input: CreateReservedInstancesListingRequest): CreateReservedInstancesListingResponse {
        val op = SdkHttpOperation.build<CreateReservedInstancesListingRequest, CreateReservedInstancesListingResponse> {
            serializer = CreateReservedInstancesListingOperationSerializer()
            deserializer = CreateReservedInstancesListingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateReservedInstancesListing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html">CreateStoreImageTask.
     * To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3 in the
     * Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun createRestoreImageTask(input: CreateRestoreImageTaskRequest): CreateRestoreImageTaskResponse {
        val op = SdkHttpOperation.build<CreateRestoreImageTaskRequest, CreateRestoreImageTaskResponse> {
            serializer = CreateRestoreImageTaskOperationSerializer()
            deserializer = CreateRestoreImageTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRestoreImageTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a route in a route table within a VPC.
     * You must specify one of the following targets: internet gateway or virtual private
     * gateway, NAT instance, NAT gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway.
     * When determining how to route traffic, we use the route with the most specific match.
     * For example, traffic is destined for the IPv4 address 192.0.2.3, and the
     * route table includes the following two IPv4 routes:
     * 192.0.2.0/24 (goes to some target A)
     * 192.0.2.0/28 (goes to some target B)
     * Both routes apply to the traffic destined for 192.0.2.3. However, the second route
     * in the list covers a smaller number of IP addresses and is therefore more specific,
     * so we use that route to determine where to target the traffic.
     * For more information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createRoute(input: CreateRouteRequest): CreateRouteResponse {
        val op = SdkHttpOperation.build<CreateRouteRequest, CreateRouteResponse> {
            serializer = CreateRouteOperationSerializer()
            deserializer = CreateRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createRouteTable(input: CreateRouteTableRequest): CreateRouteTableResponse {
        val op = SdkHttpOperation.build<CreateRouteTableRequest, CreateRouteTableResponse> {
            serializer = CreateRouteTableOperationSerializer()
            deserializer = CreateRouteTableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRouteTable"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a security group.
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 security groups in
     * the Amazon Elastic Compute Cloud User Guide and
     * <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your VPC in the
     * Amazon Virtual Private Cloud User Guide.
     * When you create a security group, you specify a friendly name of your choice. You can have a security group for use in EC2-Classic with the same name as a security group for use in a VPC. However, you can't have two security groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name.
     * You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you don't specify a security group when you launch an instance, the instance is launched into the appropriate default security group. A default security group includes a default rule that grants instances unrestricted network access to each other.
     * You can add or remove rules from your security groups using
     * AuthorizeSecurityGroupIngress,
     * AuthorizeSecurityGroupEgress,
     * RevokeSecurityGroupIngress, and
     * RevokeSecurityGroupEgress.
     * For more information about VPC security group limits, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits.
     */
    override suspend fun createSecurityGroup(input: CreateSecurityGroupRequest): CreateSecurityGroupResponse {
        val op = SdkHttpOperation.build<CreateSecurityGroupRequest, CreateSecurityGroupResponse> {
            serializer = CreateSecurityGroupOperationSerializer()
            deserializer = CreateSecurityGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSecurityGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for
     * backups, to make copies of EBS volumes, and to save data before shutting down an
     * instance.
     * You can create snapshots of volumes in a Region and volumes on an Outpost. If you
     * create a snapshot of a volume in a Region, the snapshot must be stored in the same
     * Region as the volume. If you create a snapshot of a volume on an Outpost, the snapshot
     * can be stored on the same Outpost as the volume, or in the Region for that Outpost.
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the
     * source volume are propagated to the snapshot.
     * You can take a snapshot of an attached volume that is in use. However, snapshots only
     * capture data that has been written to your Amazon EBS volume at the time the snapshot command is
     * issued; this might exclude any data that has been cached by any applications or the operating
     * system. If you can pause any file systems on the volume long enough to take a snapshot, your
     * snapshot should be complete. However, if you cannot pause all file writes to the volume, you
     * should unmount the volume from within the instance, issue the snapshot command, and then
     * remount the volume to ensure a consistent and complete snapshot. You may remount and use your
     * volume while the snapshot status is pending.
     * To create a snapshot for Amazon EBS volumes that serve as root devices, you should stop the
     * instance before taking the snapshot.
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that
     * are created from encrypted snapshots are also automatically encrypted. Your encrypted volumes
     * and any associated snapshots always remain protected.
     * You can tag your snapshots during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2
     * resources in the Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon Elastic Block Store and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse {
        val op = SdkHttpOperation.build<CreateSnapshotRequest, CreateSnapshotResponse> {
            serializer = CreateSnapshotOperationSerializer()
            deserializer = CreateSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3.
     * Volumes are chosen by specifying an instance. Any attached volumes will produce one snapshot
     * each that is crash-consistent across the instance. Boot volumes can be excluded by changing the
     * parameters.
     * You can create multi-volume snapshots of instances in a Region and instances on an
     * Outpost. If you create snapshots from an instance in a Region, the snapshots must be stored
     * in the same Region as the instance. If you create snapshots from an instance on an Outpost,
     * the snapshots can be stored on the same Outpost as the instance, or in the Region for that
     * Outpost.
     */
    override suspend fun createSnapshots(input: CreateSnapshotsRequest): CreateSnapshotsResponse {
        val op = SdkHttpOperation.build<CreateSnapshotsRequest, CreateSnapshotsResponse> {
            serializer = CreateSnapshotsOperationSerializer()
            deserializer = CreateSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs.
     * You can create one data feed per Amazon Web Services account. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed
     * in the Amazon EC2 User Guide for Linux Instances.
     */
    override suspend fun createSpotDatafeedSubscription(input: CreateSpotDatafeedSubscriptionRequest): CreateSpotDatafeedSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateSpotDatafeedSubscriptionRequest, CreateSpotDatafeedSubscriptionResponse> {
            serializer = CreateSpotDatafeedSubscriptionOperationSerializer()
            deserializer = CreateSpotDatafeedSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSpotDatafeedSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3 in the
     * Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun createStoreImageTask(input: CreateStoreImageTaskRequest): CreateStoreImageTaskResponse {
        val op = SdkHttpOperation.build<CreateStoreImageTaskRequest, CreateStoreImageTaskResponse> {
            serializer = CreateStoreImageTaskOperationSerializer()
            deserializer = CreateStoreImageTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStoreImageTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a subnet in a specified VPC.
     * You must specify an IPv4 CIDR block for the subnet. After you create a subnet, you
     * can't change its CIDR block. The allowed block size is between a /16 netmask (65,536 IP
     * addresses) and /28 netmask (16 IP addresses). The CIDR block must not overlap with the
     * CIDR block of an existing subnet in the VPC.
     * If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an
     * IPv6 CIDR block that uses a /64 prefix length.
     * Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR
     * block. They're not available for use.
     * If you add more than one subnet to a VPC, they're set up in a star topology with a
     * logical router in the middle.
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's
     * therefore possible to have a subnet with no running instances (they're all stopped), but
     * no remaining IP addresses available.
     * For more information about subnets, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and subnets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createSubnet(input: CreateSubnetRequest): CreateSubnetResponse {
        val op = SdkHttpOperation.build<CreateSubnetRequest, CreateSubnetResponse> {
            serializer = CreateSubnetOperationSerializer()
            deserializer = CreateSubnetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSubnet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a subnet CIDR reservation. For information about subnet CIDR reservations, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations in the Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createSubnetCidrReservation(input: CreateSubnetCidrReservationRequest): CreateSubnetCidrReservationResponse {
        val op = SdkHttpOperation.build<CreateSubnetCidrReservationRequest, CreateSubnetCidrReservationResponse> {
            serializer = CreateSubnetCidrReservationOperationSerializer()
            deserializer = CreateSubnetCidrReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSubnetCidrReservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or
     * resources. When you specify an existing tag key, the value is overwritten with
     * the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and
     * optional value. Tag keys must be unique per resource.
     * For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources in the
     * Amazon Elastic Compute Cloud User Guide. For more information about
     * creating IAM policies that control users' access to resources based on tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * Resource-Level Permissions for Amazon EC2 API Actions in the Amazon
     * Elastic Compute Cloud User Guide.
     */
    override suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse {
        val op = SdkHttpOperation.build<CreateTagsRequest, CreateTagsResponse> {
            serializer = CreateTagsOperationSerializer()
            deserializer = CreateTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Traffic Mirror filter.
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * By default, no traffic is mirrored. To mirror traffic, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm">CreateTrafficMirrorFilterRule to add Traffic Mirror rules to the filter. The rules you
     * add define what traffic gets mirrored. You can also use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html">ModifyTrafficMirrorFilterNetworkServices to mirror supported network services.
     */
    override suspend fun createTrafficMirrorFilter(input: CreateTrafficMirrorFilterRequest): CreateTrafficMirrorFilterResponse {
        val op = SdkHttpOperation.build<CreateTrafficMirrorFilterRequest, CreateTrafficMirrorFilterResponse> {
            serializer = CreateTrafficMirrorFilterOperationSerializer()
            deserializer = CreateTrafficMirrorFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTrafficMirrorFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Traffic Mirror filter rule.
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * You need the Traffic Mirror filter ID when you create the rule.
     */
    override suspend fun createTrafficMirrorFilterRule(input: CreateTrafficMirrorFilterRuleRequest): CreateTrafficMirrorFilterRuleResponse {
        val op = SdkHttpOperation.build<CreateTrafficMirrorFilterRuleRequest, CreateTrafficMirrorFilterRuleResponse> {
            serializer = CreateTrafficMirrorFilterRuleOperationSerializer()
            deserializer = CreateTrafficMirrorFilterRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTrafficMirrorFilterRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Traffic Mirror session.
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create a filter, and then assign it
     * to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a different VPC connected via VPC peering or a transit gateway.
     * By default, no traffic is mirrored. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm">CreateTrafficMirrorFilter to
     * create filter rules that specify the traffic to mirror.
     */
    override suspend fun createTrafficMirrorSession(input: CreateTrafficMirrorSessionRequest): CreateTrafficMirrorSessionResponse {
        val op = SdkHttpOperation.build<CreateTrafficMirrorSessionRequest, CreateTrafficMirrorSessionResponse> {
            serializer = CreateTrafficMirrorSessionOperationSerializer()
            deserializer = CreateTrafficMirrorSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTrafficMirrorSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a target for your Traffic Mirror session.
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and
     * the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in
     * different VPCs connected via VPC peering or a transit gateway.
     * A Traffic Mirror target can be a network interface, or a Network Load Balancer.
     * To use the target in a Traffic Mirror session, use  <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm">CreateTrafficMirrorSession.
     */
    override suspend fun createTrafficMirrorTarget(input: CreateTrafficMirrorTargetRequest): CreateTrafficMirrorTargetResponse {
        val op = SdkHttpOperation.build<CreateTrafficMirrorTargetRequest, CreateTrafficMirrorTargetResponse> {
            serializer = CreateTrafficMirrorTargetOperationSerializer()
            deserializer = CreateTrafficMirrorTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTrafficMirrorTarget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a transit gateway.
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks.
     * After the transit gateway enters the available state, you can attach your VPCs and VPN
     * connections to the transit gateway.
     * To attach your VPCs, use CreateTransitGatewayVpcAttachment.
     * To attach a VPN connection, use CreateCustomerGateway to create a customer
     * gateway and specify the ID of the customer gateway and the ID of the transit gateway in a call to
     * CreateVpnConnection.
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default association route table
     * and the default propagation route table. You can use CreateTransitGatewayRouteTable to create
     * additional transit gateway route tables. If you disable automatic route propagation, we do not create a default transit gateway route table.
     * You can use EnableTransitGatewayRouteTablePropagation to propagate routes from a resource
     * attachment to a transit gateway route table. If you disable automatic associations, you can use AssociateTransitGatewayRouteTable to associate a resource attachment with a transit gateway route table.
     */
    override suspend fun createTransitGateway(input: CreateTransitGatewayRequest): CreateTransitGatewayResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayRequest, CreateTransitGatewayResponse> {
            serializer = CreateTransitGatewayOperationSerializer()
            deserializer = CreateTransitGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying transport mechanism.
     */
    override suspend fun createTransitGatewayConnect(input: CreateTransitGatewayConnectRequest): CreateTransitGatewayConnectResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayConnectRequest, CreateTransitGatewayConnectResponse> {
            serializer = CreateTransitGatewayConnectOperationSerializer()
            deserializer = CreateTransitGatewayConnectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGatewayConnect"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Connect peer for a specified transit gateway Connect attachment between a
     * transit gateway and an appliance.
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers in the Transit Gateways Guide.
     */
    override suspend fun createTransitGatewayConnectPeer(input: CreateTransitGatewayConnectPeerRequest): CreateTransitGatewayConnectPeerResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayConnectPeerRequest, CreateTransitGatewayConnectPeerResponse> {
            serializer = CreateTransitGatewayConnectPeerOperationSerializer()
            deserializer = CreateTransitGatewayConnectPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGatewayConnectPeer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a multicast domain using the specified transit gateway.
     * The transit gateway  must be in the available state before you create a domain. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html">DescribeTransitGateways to see the state of transit gateway.
     */
    override suspend fun createTransitGatewayMulticastDomain(input: CreateTransitGatewayMulticastDomainRequest): CreateTransitGatewayMulticastDomainResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayMulticastDomainRequest, CreateTransitGatewayMulticastDomainResponse> {
            serializer = CreateTransitGatewayMulticastDomainOperationSerializer()
            deserializer = CreateTransitGatewayMulticastDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGatewayMulticastDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests a transit gateway peering attachment between the specified transit gateway
     * (requester) and a peer transit gateway (accepter). The transit gateways must be in
     * different Regions. The peer transit gateway can be in your account or a different
     * Amazon Web Services account.
     * After you create the peering attachment, the owner of the accepter transit gateway
     * must accept the attachment request.
     */
    override suspend fun createTransitGatewayPeeringAttachment(input: CreateTransitGatewayPeeringAttachmentRequest): CreateTransitGatewayPeeringAttachmentResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayPeeringAttachmentRequest, CreateTransitGatewayPeeringAttachmentResponse> {
            serializer = CreateTransitGatewayPeeringAttachmentOperationSerializer()
            deserializer = CreateTransitGatewayPeeringAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGatewayPeeringAttachment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     */
    override suspend fun createTransitGatewayPrefixListReference(input: CreateTransitGatewayPrefixListReferenceRequest): CreateTransitGatewayPrefixListReferenceResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayPrefixListReferenceRequest, CreateTransitGatewayPrefixListReferenceResponse> {
            serializer = CreateTransitGatewayPrefixListReferenceOperationSerializer()
            deserializer = CreateTransitGatewayPrefixListReferenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGatewayPrefixListReference"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a static route for the specified transit gateway route table.
     */
    override suspend fun createTransitGatewayRoute(input: CreateTransitGatewayRouteRequest): CreateTransitGatewayRouteResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayRouteRequest, CreateTransitGatewayRouteResponse> {
            serializer = CreateTransitGatewayRouteOperationSerializer()
            deserializer = CreateTransitGatewayRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGatewayRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a route table for the specified transit gateway.
     */
    override suspend fun createTransitGatewayRouteTable(input: CreateTransitGatewayRouteTableRequest): CreateTransitGatewayRouteTableResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayRouteTableRequest, CreateTransitGatewayRouteTableResponse> {
            serializer = CreateTransitGatewayRouteTableOperationSerializer()
            deserializer = CreateTransitGatewayRouteTableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGatewayRouteTable"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches the specified VPC to the specified transit gateway.
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached,
     * the new VPC CIDR range is not propagated to the default propagation route table.
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using CreateRoute.
     */
    override suspend fun createTransitGatewayVpcAttachment(input: CreateTransitGatewayVpcAttachmentRequest): CreateTransitGatewayVpcAttachmentResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayVpcAttachmentRequest, CreateTransitGatewayVpcAttachmentResponse> {
            serializer = CreateTransitGatewayVpcAttachmentOperationSerializer()
            deserializer = CreateTransitGatewayVpcAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTransitGatewayVpcAttachment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * You can create a new empty volume or restore a volume from an EBS snapshot.
     * Any Amazon Web Services Marketplace product codes from the snapshot are propagated to the volume.
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that
     * support Amazon EBS encryption. Volumes that are created from encrypted snapshots are also automatically
     * encrypted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     * You can tag your volumes during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2
     * resources in the Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html">Create an Amazon EBS volume in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun createVolume(input: CreateVolumeRequest): CreateVolumeResponse {
        val op = SdkHttpOperation.build<CreateVolumeRequest, CreateVolumeResponse> {
            serializer = CreateVolumeOperationSerializer()
            deserializer = CreateVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create
     * uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16 netmask (65,536 IPv4
     * addresses). For more information about how large to make your VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and
     * subnets in the Amazon Virtual Private Cloud User Guide.
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided
     * IPv6 CIDR block from Amazon's pool of IPv6 addresses, or an IPv6 CIDR block from an IPv6 address
     * pool that you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP).
     * By default, each instance you launch in the VPC has the default DHCP options, which
     * include only a default DNS server that we provide (AmazonProvidedDNS). For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets in the Amazon Virtual Private Cloud User Guide.
     * You can specify the instance tenancy value for the VPC when you create it. You can't change
     * this value for the VPC after you create it. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun createVpc(input: CreateVpcRequest): CreateVpcResponse {
        val op = SdkHttpOperation.build<CreateVpcRequest, CreateVpcResponse> {
            serializer = CreateVpcOperationSerializer()
            deserializer = CreateVpcOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVpc"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a VPC endpoint for a specified service. An endpoint enables you to create a
     * private connection between your VPC and the service. The service may be provided by Amazon Web Services,
     * an Amazon Web Services Marketplace Partner, or another Amazon Web Services account. For more information,
     * see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html">VPC Endpoints in the
     * Amazon Virtual Private Cloud User Guide.
     * A gateway endpoint serves as a target for a route in your route table for
     * traffic destined for the Amazon Web Service. You can specify an endpoint policy to attach
     * to the endpoint, which will control access to the service from your VPC. You can also
     * specify the VPC route tables that use the endpoint.
     * An interface endpoint is a network interface in your subnet that
     * serves as an endpoint for communicating with the specified service. You can specify the
     * subnets in which to create an endpoint, and the security groups to associate with the
     * endpoint network interface.
     * A GatewayLoadBalancer endpoint is a network interface in your subnet that serves an endpoint for communicating with a Gateway Load Balancer that you've configured as a VPC endpoint service.
     * Use DescribeVpcEndpointServices to get a list of supported
     * services.
     */
    override suspend fun createVpcEndpoint(input: CreateVpcEndpointRequest): CreateVpcEndpointResponse {
        val op = SdkHttpOperation.build<CreateVpcEndpointRequest, CreateVpcEndpointResponse> {
            serializer = CreateVpcEndpointOperationSerializer()
            deserializer = CreateVpcEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVpcEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint
     * service. A connection notification notifies you of specific endpoint events. You must
     * create an SNS topic to receive notifications. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Create a Topic in
     * the Amazon Simple Notification Service Developer Guide.
     * You can create a connection notification for interface endpoints only.
     */
    override suspend fun createVpcEndpointConnectionNotification(input: CreateVpcEndpointConnectionNotificationRequest): CreateVpcEndpointConnectionNotificationResponse {
        val op = SdkHttpOperation.build<CreateVpcEndpointConnectionNotificationRequest, CreateVpcEndpointConnectionNotificationResponse> {
            serializer = CreateVpcEndpointConnectionNotificationOperationSerializer()
            deserializer = CreateVpcEndpointConnectionNotificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVpcEndpointConnectionNotification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a VPC endpoint service configuration to which service consumers (Amazon Web Services accounts,
     * IAM users, and IAM roles) can connect.
     * To create an endpoint service configuration, you must first create one of the
     * following for your service:
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/introduction.html">Network Load Balancer. Service consumers connect to your service using an
     * interface endpoint.
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/introduction.html">Gateway Load Balancer. Service consumers connect to your service using a
     * Gateway Load Balancer endpoint.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">VPC Endpoint Services in the
     * Amazon Virtual Private Cloud User Guide.
     * If you set the private DNS name, you must prove that you own the private DNS domain
     * name. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">VPC Endpoint Service
     * Private DNS Name Verification in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun createVpcEndpointServiceConfiguration(input: CreateVpcEndpointServiceConfigurationRequest): CreateVpcEndpointServiceConfigurationResponse {
        val op = SdkHttpOperation.build<CreateVpcEndpointServiceConfigurationRequest, CreateVpcEndpointServiceConfigurationResponse> {
            serializer = CreateVpcEndpointServiceConfigurationOperationSerializer()
            deserializer = CreateVpcEndpointServiceConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVpcEndpointServiceConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and
     * an accepter VPC with which to create the connection. The accepter VPC can belong to
     * another Amazon Web Services account and can be in a different Region to the requester VPC.
     * The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * Limitations and rules apply to a VPC peering connection. For more information, see
     * the <a href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations">limitations section in the VPC Peering Guide.
     * The owner of the accepter VPC must accept the peering request to activate the peering
     * connection. The VPC peering connection request expires after 7 days, after which it
     * cannot be accepted or rejected.
     * If you create a VPC peering connection request between VPCs with overlapping CIDR
     * blocks, the VPC peering connection has a status of failed.
     */
    override suspend fun createVpcPeeringConnection(input: CreateVpcPeeringConnectionRequest): CreateVpcPeeringConnectionResponse {
        val op = SdkHttpOperation.build<CreateVpcPeeringConnectionRequest, CreateVpcPeeringConnectionResponse> {
            serializer = CreateVpcPeeringConnectionOperationSerializer()
            deserializer = CreateVpcPeeringConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVpcPeeringConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a VPN connection between an existing virtual private gateway or transit
     * gateway and a customer gateway. The supported connection type is
     * ipsec.1.
     * The response includes information that you need to give to your network administrator
     * to configure your customer gateway.
     * We strongly recommend that you use HTTPS when calling this operation because the
     * response contains sensitive cryptographic information for configuring your customer
     * gateway device.
     * If you decide to shut down your VPN connection for any reason and later create a new
     * VPN connection, you must reconfigure your customer gateway with the new information
     * returned from this call.
     * This is an idempotent operation. If you perform the operation more than once, Amazon
     * EC2 doesn't return an error.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    override suspend fun createVpnConnection(input: CreateVpnConnectionRequest): CreateVpnConnectionResponse {
        val op = SdkHttpOperation.build<CreateVpnConnectionRequest, CreateVpnConnectionResponse> {
            serializer = CreateVpnConnectionOperationSerializer()
            deserializer = CreateVpnConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVpnConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a static route associated with a VPN connection between an existing virtual
     * private gateway and a VPN customer gateway. The static route allows traffic to be routed
     * from the virtual private gateway to the VPN customer gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    override suspend fun createVpnConnectionRoute(input: CreateVpnConnectionRouteRequest): CreateVpnConnectionRouteResponse {
        val op = SdkHttpOperation.build<CreateVpnConnectionRouteRequest, CreateVpnConnectionRouteResponse> {
            serializer = CreateVpnConnectionRouteOperationSerializer()
            deserializer = CreateVpnConnectionRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVpnConnectionRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the
     * VPC side of your VPN connection. You can create a virtual private gateway before
     * creating the VPC itself.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    override suspend fun createVpnGateway(input: CreateVpnGatewayRequest): CreateVpnGatewayResponse {
        val op = SdkHttpOperation.build<CreateVpnGatewayRequest, CreateVpnGatewayResponse> {
            serializer = CreateVpnGatewayOperationSerializer()
            deserializer = CreateVpnGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVpnGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a carrier gateway.
     * If you do not delete the route that contains the carrier gateway as the
     * Target, the route is a blackhole route. For information about how to delete a route, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute.
     */
    override suspend fun deleteCarrierGateway(input: DeleteCarrierGatewayRequest): DeleteCarrierGatewayResponse {
        val op = SdkHttpOperation.build<DeleteCarrierGatewayRequest, DeleteCarrierGatewayResponse> {
            serializer = DeleteCarrierGatewayOperationSerializer()
            deserializer = DeleteCarrierGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCarrierGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you
     * can delete a Client VPN endpoint.
     */
    override suspend fun deleteClientVpnEndpoint(input: DeleteClientVpnEndpointRequest): DeleteClientVpnEndpointResponse {
        val op = SdkHttpOperation.build<DeleteClientVpnEndpointRequest, DeleteClientVpnEndpointResponse> {
            serializer = DeleteClientVpnEndpointOperationSerializer()
            deserializer = DeleteClientVpnEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteClientVpnEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using
     * the CreateClientVpnRoute action. You cannot delete routes that were
     * automatically added when associating a subnet. To remove routes that have been automatically added,
     * disassociate the target subnet from the Client VPN endpoint.
     */
    override suspend fun deleteClientVpnRoute(input: DeleteClientVpnRouteRequest): DeleteClientVpnRouteResponse {
        val op = SdkHttpOperation.build<DeleteClientVpnRouteRequest, DeleteClientVpnRouteResponse> {
            serializer = DeleteClientVpnRouteOperationSerializer()
            deserializer = DeleteClientVpnRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteClientVpnRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified customer gateway. You must delete the VPN connection before you
     * can delete the customer gateway.
     */
    override suspend fun deleteCustomerGateway(input: DeleteCustomerGatewayRequest): DeleteCustomerGatewayResponse {
        val op = SdkHttpOperation.build<DeleteCustomerGatewayRequest, DeleteCustomerGatewayResponse> {
            serializer = DeleteCustomerGatewayOperationSerializer()
            deserializer = DeleteCustomerGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomerGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of options with the VPC.
     */
    override suspend fun deleteDhcpOptions(input: DeleteDhcpOptionsRequest): DeleteDhcpOptionsResponse {
        val op = SdkHttpOperation.build<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse> {
            serializer = DeleteDhcpOptionsOperationSerializer()
            deserializer = DeleteDhcpOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDhcpOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an egress-only internet gateway.
     */
    override suspend fun deleteEgressOnlyInternetGateway(input: DeleteEgressOnlyInternetGatewayRequest): DeleteEgressOnlyInternetGatewayResponse {
        val op = SdkHttpOperation.build<DeleteEgressOnlyInternetGatewayRequest, DeleteEgressOnlyInternetGatewayResponse> {
            serializer = DeleteEgressOnlyInternetGatewayOperationSerializer()
            deserializer = DeleteEgressOnlyInternetGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEgressOnlyInternetGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified EC2 Fleet.
     * After you delete an EC2 Fleet, it launches no new instances.
     * You must specify whether a deleted EC2 Fleet should also terminate its instances. If you
     * choose to terminate the instances, the EC2 Fleet enters the deleted_terminating
     * state. Otherwise, the EC2 Fleet enters the deleted_running state, and the instances
     * continue to run until they are interrupted or you terminate them manually.
     * For instant fleets, EC2 Fleet must terminate the instances when the fleet is
     * deleted. A deleted instant fleet with running instances is not
     * supported.
     * <p class="title">
     * Restrictions
     * You can delete up to 25 instant fleets in a single request. If you exceed this
     * number, no instant fleets are deleted and an error is returned. There is no
     * restriction on the number of fleets of type maintain or request that can be deleted
     * in a single request.
     * Up to 1000 instances can be terminated in a single request to delete
     * instant fleets.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Deleting an EC2
     * Fleet in the Amazon EC2 User Guide.
     */
    override suspend fun deleteFleets(input: DeleteFleetsRequest): DeleteFleetsResponse {
        val op = SdkHttpOperation.build<DeleteFleetsRequest, DeleteFleetsResponse> {
            serializer = DeleteFleetsOperationSerializer()
            deserializer = DeleteFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes one or more flow logs.
     */
    override suspend fun deleteFlowLogs(input: DeleteFlowLogsRequest): DeleteFlowLogsResponse {
        val op = SdkHttpOperation.build<DeleteFlowLogsRequest, DeleteFlowLogsResponse> {
            serializer = DeleteFlowLogsOperationSerializer()
            deserializer = DeleteFlowLogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFlowLogs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Amazon FPGA Image (AFI).
     */
    override suspend fun deleteFpgaImage(input: DeleteFpgaImageRequest): DeleteFpgaImageResponse {
        val op = SdkHttpOperation.build<DeleteFpgaImageRequest, DeleteFpgaImageResponse> {
            serializer = DeleteFpgaImageOperationSerializer()
            deserializer = DeleteFpgaImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFpgaImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified event window.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    override suspend fun deleteInstanceEventWindow(input: DeleteInstanceEventWindowRequest): DeleteInstanceEventWindowResponse {
        val op = SdkHttpOperation.build<DeleteInstanceEventWindowRequest, DeleteInstanceEventWindowResponse> {
            serializer = DeleteInstanceEventWindowOperationSerializer()
            deserializer = DeleteInstanceEventWindowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInstanceEventWindow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified internet gateway. You must detach the internet gateway from the
     * VPC before you can delete it.
     */
    override suspend fun deleteInternetGateway(input: DeleteInternetGatewayRequest): DeleteInternetGatewayResponse {
        val op = SdkHttpOperation.build<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse> {
            serializer = DeleteInternetGatewayOperationSerializer()
            deserializer = DeleteInternetGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInternetGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical data for CIDRs.
     * You cannot delete an IPAM if there are CIDRs provisioned to pools or if there are allocations in the pools within the IPAM. To deprovision pool
     * CIDRs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html">DeprovisionIpamPoolCidr. To release allocations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">ReleaseIpamPoolAllocation.
     * For more information, see <a href="/vpc/latest/ipam/delete-ipam.html">Delete an IPAM in the Amazon VPC IPAM User Guide.
     */
    override suspend fun deleteIpam(input: DeleteIpamRequest): DeleteIpamResponse {
        val op = SdkHttpOperation.build<DeleteIpamRequest, DeleteIpamResponse> {
            serializer = DeleteIpamOperationSerializer()
            deserializer = DeleteIpamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteIpam"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an IPAM pool.
     * You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release
     * allocations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">ReleaseIpamPoolAllocation. To deprovision pool
     * CIDRs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html">DeprovisionIpamPoolCidr.
     * For more information, see <a href="/vpc/latest/ipam/delete-pool-ipam.html">Delete a pool in the Amazon VPC IPAM User Guide.
     */
    override suspend fun deleteIpamPool(input: DeleteIpamPoolRequest): DeleteIpamPoolResponse {
        val op = SdkHttpOperation.build<DeleteIpamPoolRequest, DeleteIpamPoolResponse> {
            serializer = DeleteIpamPoolOperationSerializer()
            deserializer = DeleteIpamPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteIpamPool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete the scope for an IPAM. You cannot delete the default scopes.
     * For more information, see <a href="/vpc/latest/ipam/delete-scope-ipam.html">Delete a scope in the Amazon VPC IPAM User Guide.
     */
    override suspend fun deleteIpamScope(input: DeleteIpamScopeRequest): DeleteIpamScopeResponse {
        val op = SdkHttpOperation.build<DeleteIpamScopeRequest, DeleteIpamScopeResponse> {
            serializer = DeleteIpamScopeOperationSerializer()
            deserializer = DeleteIpamScopeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteIpamScope"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     */
    override suspend fun deleteKeyPair(input: DeleteKeyPairRequest): DeleteKeyPairResponse {
        val op = SdkHttpOperation.build<DeleteKeyPairRequest, DeleteKeyPairResponse> {
            serializer = DeleteKeyPairOperationSerializer()
            deserializer = DeleteKeyPairOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteKeyPair"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     */
    override suspend fun deleteLaunchTemplate(input: DeleteLaunchTemplateRequest): DeleteLaunchTemplateResponse {
        val op = SdkHttpOperation.build<DeleteLaunchTemplateRequest, DeleteLaunchTemplateResponse> {
            serializer = DeleteLaunchTemplateOperationSerializer()
            deserializer = DeleteLaunchTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLaunchTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes one or more versions of a launch template. You cannot delete the default
     * version of a launch template; you must first assign a different version as the default.
     * If the default version is the only version for the launch template, you must delete the
     * entire launch template using DeleteLaunchTemplate.
     */
    override suspend fun deleteLaunchTemplateVersions(input: DeleteLaunchTemplateVersionsRequest): DeleteLaunchTemplateVersionsResponse {
        val op = SdkHttpOperation.build<DeleteLaunchTemplateVersionsRequest, DeleteLaunchTemplateVersionsResponse> {
            serializer = DeleteLaunchTemplateVersionsOperationSerializer()
            deserializer = DeleteLaunchTemplateVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLaunchTemplateVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified route from the specified local gateway route table.
     */
    override suspend fun deleteLocalGatewayRoute(input: DeleteLocalGatewayRouteRequest): DeleteLocalGatewayRouteResponse {
        val op = SdkHttpOperation.build<DeleteLocalGatewayRouteRequest, DeleteLocalGatewayRouteResponse> {
            serializer = DeleteLocalGatewayRouteOperationSerializer()
            deserializer = DeleteLocalGatewayRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLocalGatewayRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified association between a VPC and local gateway route table.
     */
    override suspend fun deleteLocalGatewayRouteTableVpcAssociation(input: DeleteLocalGatewayRouteTableVpcAssociationRequest): DeleteLocalGatewayRouteTableVpcAssociationResponse {
        val op = SdkHttpOperation.build<DeleteLocalGatewayRouteTableVpcAssociationRequest, DeleteLocalGatewayRouteTableVpcAssociationResponse> {
            serializer = DeleteLocalGatewayRouteTableVpcAssociationOperationSerializer()
            deserializer = DeleteLocalGatewayRouteTableVpcAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLocalGatewayRouteTableVpcAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your resources.
     */
    override suspend fun deleteManagedPrefixList(input: DeleteManagedPrefixListRequest): DeleteManagedPrefixListResponse {
        val op = SdkHttpOperation.build<DeleteManagedPrefixListRequest, DeleteManagedPrefixListResponse> {
            serializer = DeleteManagedPrefixListOperationSerializer()
            deserializer = DeleteManagedPrefixListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteManagedPrefixList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address,
     * but does not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway
     * routes in your route tables.
     */
    override suspend fun deleteNatGateway(input: DeleteNatGatewayRequest): DeleteNatGatewayResponse {
        val op = SdkHttpOperation.build<DeleteNatGatewayRequest, DeleteNatGatewayResponse> {
            serializer = DeleteNatGatewayOperationSerializer()
            deserializer = DeleteNatGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNatGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete the default network ACL.
     */
    override suspend fun deleteNetworkAcl(input: DeleteNetworkAclRequest): DeleteNetworkAclResponse {
        val op = SdkHttpOperation.build<DeleteNetworkAclRequest, DeleteNetworkAclResponse> {
            serializer = DeleteNetworkAclOperationSerializer()
            deserializer = DeleteNetworkAclOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNetworkAcl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     */
    override suspend fun deleteNetworkAclEntry(input: DeleteNetworkAclEntryRequest): DeleteNetworkAclEntryResponse {
        val op = SdkHttpOperation.build<DeleteNetworkAclEntryRequest, DeleteNetworkAclEntryResponse> {
            serializer = DeleteNetworkAclEntryOperationSerializer()
            deserializer = DeleteNetworkAclEntryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNetworkAclEntry"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Network Access Scope.
     */
    override suspend fun deleteNetworkInsightsAccessScope(input: DeleteNetworkInsightsAccessScopeRequest): DeleteNetworkInsightsAccessScopeResponse {
        val op = SdkHttpOperation.build<DeleteNetworkInsightsAccessScopeRequest, DeleteNetworkInsightsAccessScopeResponse> {
            serializer = DeleteNetworkInsightsAccessScopeOperationSerializer()
            deserializer = DeleteNetworkInsightsAccessScopeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNetworkInsightsAccessScope"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Network Access Scope analysis.
     */
    override suspend fun deleteNetworkInsightsAccessScopeAnalysis(input: DeleteNetworkInsightsAccessScopeAnalysisRequest): DeleteNetworkInsightsAccessScopeAnalysisResponse {
        val op = SdkHttpOperation.build<DeleteNetworkInsightsAccessScopeAnalysisRequest, DeleteNetworkInsightsAccessScopeAnalysisResponse> {
            serializer = DeleteNetworkInsightsAccessScopeAnalysisOperationSerializer()
            deserializer = DeleteNetworkInsightsAccessScopeAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNetworkInsightsAccessScopeAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified network insights analysis.
     */
    override suspend fun deleteNetworkInsightsAnalysis(input: DeleteNetworkInsightsAnalysisRequest): DeleteNetworkInsightsAnalysisResponse {
        val op = SdkHttpOperation.build<DeleteNetworkInsightsAnalysisRequest, DeleteNetworkInsightsAnalysisResponse> {
            serializer = DeleteNetworkInsightsAnalysisOperationSerializer()
            deserializer = DeleteNetworkInsightsAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNetworkInsightsAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified path.
     */
    override suspend fun deleteNetworkInsightsPath(input: DeleteNetworkInsightsPathRequest): DeleteNetworkInsightsPathResponse {
        val op = SdkHttpOperation.build<DeleteNetworkInsightsPathRequest, DeleteNetworkInsightsPathResponse> {
            serializer = DeleteNetworkInsightsPathOperationSerializer()
            deserializer = DeleteNetworkInsightsPathOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNetworkInsightsPath"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     */
    override suspend fun deleteNetworkInterface(input: DeleteNetworkInterfaceRequest): DeleteNetworkInterfaceResponse {
        val op = SdkHttpOperation.build<DeleteNetworkInterfaceRequest, DeleteNetworkInterfaceResponse> {
            serializer = DeleteNetworkInterfaceOperationSerializer()
            deserializer = DeleteNetworkInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNetworkInterface"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a permission for a network interface. By default, you cannot delete the
     * permission if the account for which you're removing the permission has attached the
     * network interface to an instance. However, you can force delete the permission,
     * regardless of any attachment.
     */
    override suspend fun deleteNetworkInterfacePermission(input: DeleteNetworkInterfacePermissionRequest): DeleteNetworkInterfacePermissionResponse {
        val op = SdkHttpOperation.build<DeleteNetworkInterfacePermissionRequest, DeleteNetworkInterfacePermissionResponse> {
            serializer = DeleteNetworkInterfacePermissionOperationSerializer()
            deserializer = DeleteNetworkInterfacePermissionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNetworkInterfacePermission"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified placement group. You must terminate all instances in the
     * placement group before you can delete the placement group. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups in the Amazon EC2 User Guide.
     */
    override suspend fun deletePlacementGroup(input: DeletePlacementGroupRequest): DeletePlacementGroupResponse {
        val op = SdkHttpOperation.build<DeletePlacementGroupRequest, DeletePlacementGroupResponse> {
            serializer = DeletePlacementGroupOperationSerializer()
            deserializer = DeletePlacementGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePlacementGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only.
     */
    override suspend fun deletePublicIpv4Pool(input: DeletePublicIpv4PoolRequest): DeletePublicIpv4PoolResponse {
        val op = SdkHttpOperation.build<DeletePublicIpv4PoolRequest, DeletePublicIpv4PoolResponse> {
            serializer = DeletePublicIpv4PoolOperationSerializer()
            deserializer = DeletePublicIpv4PoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePublicIpv4Pool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the queued purchases for the specified Reserved Instances.
     */
    override suspend fun deleteQueuedReservedInstances(input: DeleteQueuedReservedInstancesRequest): DeleteQueuedReservedInstancesResponse {
        val op = SdkHttpOperation.build<DeleteQueuedReservedInstancesRequest, DeleteQueuedReservedInstancesResponse> {
            serializer = DeleteQueuedReservedInstancesOperationSerializer()
            deserializer = DeleteQueuedReservedInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteQueuedReservedInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified route from the specified route table.
     */
    override suspend fun deleteRoute(input: DeleteRouteRequest): DeleteRouteResponse {
        val op = SdkHttpOperation.build<DeleteRouteRequest, DeleteRouteResponse> {
            serializer = DeleteRouteOperationSerializer()
            deserializer = DeleteRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete it. You can't delete the main route table.
     */
    override suspend fun deleteRouteTable(input: DeleteRouteTableRequest): DeleteRouteTableResponse {
        val op = SdkHttpOperation.build<DeleteRouteTableRequest, DeleteRouteTableResponse> {
            serializer = DeleteRouteTableOperationSerializer()
            deserializer = DeleteRouteTableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRouteTable"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a security group.
     * If you attempt to delete a security group that is associated with an instance, or is
     * referenced by another security group, the operation fails with
     * InvalidGroup.InUse in EC2-Classic or
     * DependencyViolation in EC2-VPC.
     */
    override suspend fun deleteSecurityGroup(input: DeleteSecurityGroupRequest): DeleteSecurityGroupResponse {
        val op = SdkHttpOperation.build<DeleteSecurityGroupRequest, DeleteSecurityGroupResponse> {
            serializer = DeleteSecurityGroupOperationSerializer()
            deserializer = DeleteSecurityGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSecurityGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified snapshot.
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the
     * blocks on the device that have changed since your last snapshot are saved in the new snapshot.
     * When you delete a snapshot, only the data not needed for any other snapshot is removed. So
     * regardless of which prior snapshots have been deleted, all active snapshots will have access
     * to all the information needed to restore the volume.
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI.
     * You must first de-register the AMI before you can delete the snapshot.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html">Delete an Amazon EBS snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteSnapshotRequest, DeleteSnapshotResponse> {
            serializer = DeleteSnapshotOperationSerializer()
            deserializer = DeleteSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the data feed for Spot Instances.
     */
    override suspend fun deleteSpotDatafeedSubscription(input: DeleteSpotDatafeedSubscriptionRequest): DeleteSpotDatafeedSubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteSpotDatafeedSubscriptionRequest, DeleteSpotDatafeedSubscriptionResponse> {
            serializer = DeleteSpotDatafeedSubscriptionOperationSerializer()
            deserializer = DeleteSpotDatafeedSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSpotDatafeedSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the subnet.
     */
    override suspend fun deleteSubnet(input: DeleteSubnetRequest): DeleteSubnetResponse {
        val op = SdkHttpOperation.build<DeleteSubnetRequest, DeleteSubnetResponse> {
            serializer = DeleteSubnetOperationSerializer()
            deserializer = DeleteSubnetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSubnet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a subnet CIDR reservation.
     */
    override suspend fun deleteSubnetCidrReservation(input: DeleteSubnetCidrReservationRequest): DeleteSubnetCidrReservationResponse {
        val op = SdkHttpOperation.build<DeleteSubnetCidrReservationRequest, DeleteSubnetCidrReservationResponse> {
            serializer = DeleteSubnetCidrReservationOperationSerializer()
            deserializer = DeleteSubnetCidrReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSubnetCidrReservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified set of tags from the specified set of resources.
     * To list the current tags, use DescribeTags. For more information about tags, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse {
        val op = SdkHttpOperation.build<DeleteTagsRequest, DeleteTagsResponse> {
            serializer = DeleteTagsOperationSerializer()
            deserializer = DeleteTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Traffic Mirror filter.
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     */
    override suspend fun deleteTrafficMirrorFilter(input: DeleteTrafficMirrorFilterRequest): DeleteTrafficMirrorFilterResponse {
        val op = SdkHttpOperation.build<DeleteTrafficMirrorFilterRequest, DeleteTrafficMirrorFilterResponse> {
            serializer = DeleteTrafficMirrorFilterOperationSerializer()
            deserializer = DeleteTrafficMirrorFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTrafficMirrorFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Traffic Mirror rule.
     */
    override suspend fun deleteTrafficMirrorFilterRule(input: DeleteTrafficMirrorFilterRuleRequest): DeleteTrafficMirrorFilterRuleResponse {
        val op = SdkHttpOperation.build<DeleteTrafficMirrorFilterRuleRequest, DeleteTrafficMirrorFilterRuleResponse> {
            serializer = DeleteTrafficMirrorFilterRuleOperationSerializer()
            deserializer = DeleteTrafficMirrorFilterRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTrafficMirrorFilterRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Traffic Mirror session.
     */
    override suspend fun deleteTrafficMirrorSession(input: DeleteTrafficMirrorSessionRequest): DeleteTrafficMirrorSessionResponse {
        val op = SdkHttpOperation.build<DeleteTrafficMirrorSessionRequest, DeleteTrafficMirrorSessionResponse> {
            serializer = DeleteTrafficMirrorSessionOperationSerializer()
            deserializer = DeleteTrafficMirrorSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTrafficMirrorSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Traffic Mirror target.
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     */
    override suspend fun deleteTrafficMirrorTarget(input: DeleteTrafficMirrorTargetRequest): DeleteTrafficMirrorTargetResponse {
        val op = SdkHttpOperation.build<DeleteTrafficMirrorTargetRequest, DeleteTrafficMirrorTargetResponse> {
            serializer = DeleteTrafficMirrorTargetOperationSerializer()
            deserializer = DeleteTrafficMirrorTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTrafficMirrorTarget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified transit gateway.
     */
    override suspend fun deleteTransitGateway(input: DeleteTransitGatewayRequest): DeleteTransitGatewayResponse {
        val op = SdkHttpOperation.build<DeleteTransitGatewayRequest, DeleteTransitGatewayResponse> {
            serializer = DeleteTransitGatewayOperationSerializer()
            deserializer = DeleteTransitGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTransitGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Connect attachment. You must first delete any Connect peers for
     * the attachment.
     */
    override suspend fun deleteTransitGatewayConnect(input: DeleteTransitGatewayConnectRequest): DeleteTransitGatewayConnectResponse {
        val op = SdkHttpOperation.build<DeleteTransitGatewayConnectRequest, DeleteTransitGatewayConnectResponse> {
            serializer = DeleteTransitGatewayConnectOperationSerializer()
            deserializer = DeleteTransitGatewayConnectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTransitGatewayConnect"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Connect peer.
     */
    override suspend fun deleteTransitGatewayConnectPeer(input: DeleteTransitGatewayConnectPeerRequest): DeleteTransitGatewayConnectPeerResponse {
        val op = SdkHttpOperation.build<DeleteTransitGatewayConnectPeerRequest, DeleteTransitGatewayConnectPeerResponse> {
            serializer = DeleteTransitGatewayConnectPeerOperationSerializer()
            deserializer = DeleteTransitGatewayConnectPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTransitGatewayConnectPeer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified transit gateway multicast domain.
     */
    override suspend fun deleteTransitGatewayMulticastDomain(input: DeleteTransitGatewayMulticastDomainRequest): DeleteTransitGatewayMulticastDomainResponse {
        val op = SdkHttpOperation.build<DeleteTransitGatewayMulticastDomainRequest, DeleteTransitGatewayMulticastDomainResponse> {
            serializer = DeleteTransitGatewayMulticastDomainOperationSerializer()
            deserializer = DeleteTransitGatewayMulticastDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTransitGatewayMulticastDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a transit gateway peering attachment.
     */
    override suspend fun deleteTransitGatewayPeeringAttachment(input: DeleteTransitGatewayPeeringAttachmentRequest): DeleteTransitGatewayPeeringAttachmentResponse {
        val op = SdkHttpOperation.build<DeleteTransitGatewayPeeringAttachmentRequest, DeleteTransitGatewayPeeringAttachmentResponse> {
            serializer = DeleteTransitGatewayPeeringAttachmentOperationSerializer()
            deserializer = DeleteTransitGatewayPeeringAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTransitGatewayPeeringAttachment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     */
    override suspend fun deleteTransitGatewayPrefixListReference(input: DeleteTransitGatewayPrefixListReferenceRequest): DeleteTransitGatewayPrefixListReferenceResponse {
        val op = SdkHttpOperation.build<DeleteTransitGatewayPrefixListReferenceRequest, DeleteTransitGatewayPrefixListReferenceResponse> {
            serializer = DeleteTransitGatewayPrefixListReferenceOperationSerializer()
            deserializer = DeleteTransitGatewayPrefixListReferenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTransitGatewayPrefixListReference"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified route from the specified transit gateway route table.
     */
    override suspend fun deleteTransitGatewayRoute(input: DeleteTransitGatewayRouteRequest): DeleteTransitGatewayRouteResponse {
        val op = SdkHttpOperation.build<DeleteTransitGatewayRouteRequest, DeleteTransitGatewayRouteResponse> {
            serializer = DeleteTransitGatewayRouteOperationSerializer()
            deserializer = DeleteTransitGatewayRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTransitGatewayRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified transit gateway route table. You must disassociate the route table from any
     * transit gateway route tables before you can delete it.
     */
    override suspend fun deleteTransitGatewayRouteTable(input: DeleteTransitGatewayRouteTableRequest): DeleteTransitGatewayRouteTableResponse {
        val op = SdkHttpOperation.build<DeleteTransitGatewayRouteTableRequest, DeleteTransitGatewayRouteTableResponse> {
            serializer = DeleteTransitGatewayRouteTableOperationSerializer()
            deserializer = DeleteTransitGatewayRouteTableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTransitGatewayRouteTable"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified VPC attachment.
     */
    override suspend fun deleteTransitGatewayVpcAttachment(input: DeleteTransitGatewayVpcAttachmentRequest): DeleteTransitGatewayVpcAttachmentResponse {
        val op = SdkHttpOperation.build<DeleteTransitGatewayVpcAttachmentRequest, DeleteTransitGatewayVpcAttachmentResponse> {
            serializer = DeleteTransitGatewayVpcAttachmentOperationSerializer()
            deserializer = DeleteTransitGatewayVpcAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTransitGatewayVpcAttachment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified EBS volume. The volume must be in the available state
     * (not attached to an instance).
     * The volume can remain in the deleting state for several minutes.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html">Delete an Amazon EBS volume in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun deleteVolume(input: DeleteVolumeRequest): DeleteVolumeResponse {
        val op = SdkHttpOperation.build<DeleteVolumeRequest, DeleteVolumeResponse> {
            serializer = DeleteVolumeOperationSerializer()
            deserializer = DeleteVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on.
     */
    override suspend fun deleteVpc(input: DeleteVpcRequest): DeleteVpcResponse {
        val op = SdkHttpOperation.build<DeleteVpcRequest, DeleteVpcResponse> {
            serializer = DeleteVpcOperationSerializer()
            deserializer = DeleteVpcOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVpc"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes one or more VPC endpoint connection notifications.
     */
    override suspend fun deleteVpcEndpointConnectionNotifications(input: DeleteVpcEndpointConnectionNotificationsRequest): DeleteVpcEndpointConnectionNotificationsResponse {
        val op = SdkHttpOperation.build<DeleteVpcEndpointConnectionNotificationsRequest, DeleteVpcEndpointConnectionNotificationsResponse> {
            serializer = DeleteVpcEndpointConnectionNotificationsOperationSerializer()
            deserializer = DeleteVpcEndpointConnectionNotificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVpcEndpointConnectionNotifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes one or more VPC endpoint service configurations in your account. Before you
     * delete the endpoint service configuration, you must reject any Available or
     * PendingAcceptance interface endpoint connections that are attached to
     * the service.
     */
    override suspend fun deleteVpcEndpointServiceConfigurations(input: DeleteVpcEndpointServiceConfigurationsRequest): DeleteVpcEndpointServiceConfigurationsResponse {
        val op = SdkHttpOperation.build<DeleteVpcEndpointServiceConfigurationsRequest, DeleteVpcEndpointServiceConfigurationsResponse> {
            serializer = DeleteVpcEndpointServiceConfigurationsOperationSerializer()
            deserializer = DeleteVpcEndpointServiceConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVpcEndpointServiceConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes one or more specified VPC endpoints. You can delete any of the following types of VPC endpoints.
     * Gateway endpoint,
     * Gateway Load Balancer endpoint,
     * Interface endpoint
     * The following rules apply when you delete a VPC endpoint:
     * When you delete a gateway endpoint, we delete the endpoint routes in the route tables that are associated with the endpoint.
     * When you delete a Gateway Load Balancer endpoint, we delete the endpoint network interfaces.
     * You can only delete Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.
     * When you delete an interface endpoint, we delete the  endpoint network interfaces.
     */
    override suspend fun deleteVpcEndpoints(input: DeleteVpcEndpointsRequest): DeleteVpcEndpointsResponse {
        val op = SdkHttpOperation.build<DeleteVpcEndpointsRequest, DeleteVpcEndpointsResponse> {
            serializer = DeleteVpcEndpointsOperationSerializer()
            deserializer = DeleteVpcEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVpcEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner
     * of the accepter VPC can delete the VPC peering connection if it's in the
     * active state. The owner of the requester VPC can delete a VPC peering
     * connection in the pending-acceptance state. You cannot delete a VPC peering
     * connection that's in the failed state.
     */
    override suspend fun deleteVpcPeeringConnection(input: DeleteVpcPeeringConnectionRequest): DeleteVpcPeeringConnectionResponse {
        val op = SdkHttpOperation.build<DeleteVpcPeeringConnectionRequest, DeleteVpcPeeringConnectionResponse> {
            serializer = DeleteVpcPeeringConnectionOperationSerializer()
            deserializer = DeleteVpcPeeringConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVpcPeeringConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified VPN connection.
     * If you're deleting the VPC and its associated components, we recommend that you detach
     * the virtual private gateway from the VPC and delete the VPC before deleting the VPN
     * connection. If you believe that the tunnel credentials for your VPN connection have been
     * compromised, you can delete the VPN connection and create a new one that has new keys,
     * without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration
     * information returned with the new VPN connection ID.
     * For certificate-based authentication, delete all Certificate Manager (ACM) private
     * certificates used for the Amazon Web Services-side tunnel endpoints for the VPN
     * connection before deleting the VPN connection.
     */
    override suspend fun deleteVpnConnection(input: DeleteVpnConnectionRequest): DeleteVpnConnectionResponse {
        val op = SdkHttpOperation.build<DeleteVpnConnectionRequest, DeleteVpnConnectionResponse> {
            serializer = DeleteVpnConnectionOperationSerializer()
            deserializer = DeleteVpnConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVpnConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified static route associated with a VPN connection between an
     * existing virtual private gateway and a VPN customer gateway. The static route allows
     * traffic to be routed from the virtual private gateway to the VPN customer
     * gateway.
     */
    override suspend fun deleteVpnConnectionRoute(input: DeleteVpnConnectionRouteRequest): DeleteVpnConnectionRouteResponse {
        val op = SdkHttpOperation.build<DeleteVpnConnectionRouteRequest, DeleteVpnConnectionRouteResponse> {
            serializer = DeleteVpnConnectionRouteOperationSerializer()
            deserializer = DeleteVpnConnectionRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVpnConnectionRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified virtual private gateway. You must first detach the virtual
     * private gateway from the VPC. Note that you don't need to delete the virtual private
     * gateway if you plan to delete and recreate the VPN connection between your VPC and your
     * network.
     */
    override suspend fun deleteVpnGateway(input: DeleteVpnGatewayRequest): DeleteVpnGatewayResponse {
        val op = SdkHttpOperation.build<DeleteVpnGatewayRequest, DeleteVpnGatewayResponse> {
            serializer = DeleteVpnGatewayOperationSerializer()
            deserializer = DeleteVpnGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVpnGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Releases the specified address range that you provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * Before you can release an address range, you must stop advertising it using WithdrawByoipCidr and you must not have any IP addresses allocated from its
     * address range.
     */
    override suspend fun deprovisionByoipCidr(input: DeprovisionByoipCidrRequest): DeprovisionByoipCidrResponse {
        val op = SdkHttpOperation.build<DeprovisionByoipCidrRequest, DeprovisionByoipCidrResponse> {
            serializer = DeprovisionByoipCidrOperationSerializer()
            deserializer = DeprovisionByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeprovisionByoipCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool, the CIDR is recycled back into the source pool. For more information, see <a href="/vpc/latest/ipam/depro-pool-cidr-ipam.html">Deprovision pool CIDRs in the Amazon VPC IPAM User Guide.
     */
    override suspend fun deprovisionIpamPoolCidr(input: DeprovisionIpamPoolCidrRequest): DeprovisionIpamPoolCidrResponse {
        val op = SdkHttpOperation.build<DeprovisionIpamPoolCidrRequest, DeprovisionIpamPoolCidrResponse> {
            serializer = DeprovisionIpamPoolCidrOperationSerializer()
            deserializer = DeprovisionIpamPoolCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeprovisionIpamPoolCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deprovision a CIDR from a public IPv4 pool.
     */
    override suspend fun deprovisionPublicIpv4PoolCidr(input: DeprovisionPublicIpv4PoolCidrRequest): DeprovisionPublicIpv4PoolCidrResponse {
        val op = SdkHttpOperation.build<DeprovisionPublicIpv4PoolCidrRequest, DeprovisionPublicIpv4PoolCidrResponse> {
            serializer = DeprovisionPublicIpv4PoolCidrOperationSerializer()
            deserializer = DeprovisionPublicIpv4PoolCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeprovisionPublicIpv4PoolCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch
     * new instances; however, it doesn't affect any instances that you've already launched
     * from the AMI. You'll continue to incur usage costs for those instances until you
     * terminate them.
     * When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was
     * created for the root volume of the instance during the AMI creation process. When you
     * deregister an instance store-backed AMI, it doesn't affect the files that you uploaded
     * to Amazon S3 when you created the AMI.
     */
    override suspend fun deregisterImage(input: DeregisterImageRequest): DeregisterImageResponse {
        val op = SdkHttpOperation.build<DeregisterImageRequest, DeregisterImageResponse> {
            serializer = DeregisterImageOperationSerializer()
            deserializer = DeregisterImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * c
     * Deregisters tag keys to prevent tags that have the specified tag keys from being included
     * in scheduled event notifications for resources in the Region.
     */
    override suspend fun deregisterInstanceEventNotificationAttributes(input: DeregisterInstanceEventNotificationAttributesRequest): DeregisterInstanceEventNotificationAttributesResponse {
        val op = SdkHttpOperation.build<DeregisterInstanceEventNotificationAttributesRequest, DeregisterInstanceEventNotificationAttributesResponse> {
            serializer = DeregisterInstanceEventNotificationAttributesOperationSerializer()
            deserializer = DeregisterInstanceEventNotificationAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterInstanceEventNotificationAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters the specified members (network interfaces) from the  transit gateway multicast group.
     */
    override suspend fun deregisterTransitGatewayMulticastGroupMembers(input: DeregisterTransitGatewayMulticastGroupMembersRequest): DeregisterTransitGatewayMulticastGroupMembersResponse {
        val op = SdkHttpOperation.build<DeregisterTransitGatewayMulticastGroupMembersRequest, DeregisterTransitGatewayMulticastGroupMembersResponse> {
            serializer = DeregisterTransitGatewayMulticastGroupMembersOperationSerializer()
            deserializer = DeregisterTransitGatewayMulticastGroupMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterTransitGatewayMulticastGroupMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters the specified sources (network interfaces) from the  transit gateway multicast group.
     */
    override suspend fun deregisterTransitGatewayMulticastGroupSources(input: DeregisterTransitGatewayMulticastGroupSourcesRequest): DeregisterTransitGatewayMulticastGroupSourcesResponse {
        val op = SdkHttpOperation.build<DeregisterTransitGatewayMulticastGroupSourcesRequest, DeregisterTransitGatewayMulticastGroupSourcesResponse> {
            serializer = DeregisterTransitGatewayMulticastGroupSourcesOperationSerializer()
            deserializer = DeregisterTransitGatewayMulticastGroupSourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterTransitGatewayMulticastGroupSources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes attributes of your Amazon Web Services account. The following are the supported account attributes:
     * supported-platforms: Indicates whether your account can launch instances
     * into EC2-Classic and EC2-VPC, or only into EC2-VPC.
     * default-vpc: The ID of the default VPC for your account, or
     * none.
     * max-instances: This attribute is no longer supported. The returned
     * value does not reflect your actual vCPU limit for running On-Demand Instances.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits">On-Demand Instance Limits in the
     * Amazon Elastic Compute Cloud User Guide.
     * vpc-max-security-groups-per-interface: The maximum number of security groups
     * that you can assign to a network interface.
     * max-elastic-ips: The maximum number of Elastic IP addresses that you can
     * allocate for use with EC2-Classic.
     * vpc-max-elastic-ips: The maximum number of Elastic IP addresses that you can
     * allocate for use with EC2-VPC.
     */
    override suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse {
        val op = SdkHttpOperation.build<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse> {
            serializer = DescribeAccountAttributesOperationSerializer()
            deserializer = DescribeAccountAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeAddresses(input: DescribeAddressesRequest): DescribeAddressesResponse {
        val op = SdkHttpOperation.build<DescribeAddressesRequest, DescribeAddressesResponse> {
            serializer = DescribeAddressesOperationSerializer()
            deserializer = DescribeAddressesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAddresses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications.
     */
    override suspend fun describeAddressesAttribute(input: DescribeAddressesAttributeRequest): DescribeAddressesAttributeResponse {
        val op = SdkHttpOperation.build<DescribeAddressesAttributeRequest, DescribeAddressesAttributeResponse> {
            serializer = DescribeAddressesAttributeOperationSerializer()
            deserializer = DescribeAddressesAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAddressesAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the longer ID format settings for all resource types in a specific
     * Region. This request is useful for performing a quick audit to determine whether a
     * specific Region is fully opted in for longer IDs (17-character IDs).
     * This request only returns information about resource types that support longer IDs.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc |
     * vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     */
    override suspend fun describeAggregateIdFormat(input: DescribeAggregateIdFormatRequest): DescribeAggregateIdFormatResponse {
        val op = SdkHttpOperation.build<DescribeAggregateIdFormatRequest, DescribeAggregateIdFormatResponse> {
            serializer = DescribeAggregateIdFormatOperationSerializer()
            deserializer = DescribeAggregateIdFormatOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAggregateIdFormat"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to
     * you. If there is an event impacting a zone, you can use this request to view the state and any
     * provided messages for that zone.
     * For more information about Availability Zones, Local Zones, and Wavelength Zones, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and zones
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeAvailabilityZones(input: DescribeAvailabilityZonesRequest): DescribeAvailabilityZonesResponse {
        val op = SdkHttpOperation.build<DescribeAvailabilityZonesRequest, DescribeAvailabilityZonesResponse> {
            serializer = DescribeAvailabilityZonesOperationSerializer()
            deserializer = DescribeAvailabilityZonesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAvailabilityZones"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified bundle tasks or all of your bundle tasks.
     * Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can still register an AMI from it. Just use RegisterImage with the Amazon S3 bucket name and image manifest name you provided to the bundle task.
     */
    override suspend fun describeBundleTasks(input: DescribeBundleTasksRequest): DescribeBundleTasksResponse {
        val op = SdkHttpOperation.build<DescribeBundleTasksRequest, DescribeBundleTasksResponse> {
            serializer = DescribeBundleTasksOperationSerializer()
            deserializer = DescribeBundleTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBundleTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the IP address ranges that were specified in calls to ProvisionByoipCidr.
     * To describe the address pools that were created when you provisioned the address
     * ranges, use DescribePublicIpv4Pools or DescribeIpv6Pools.
     */
    override suspend fun describeByoipCidrs(input: DescribeByoipCidrsRequest): DescribeByoipCidrsResponse {
        val op = SdkHttpOperation.build<DescribeByoipCidrsRequest, DescribeByoipCidrsResponse> {
            serializer = DescribeByoipCidrsOperationSerializer()
            deserializer = DescribeByoipCidrsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeByoipCidrs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Capacity Reservation Fleets.
     */
    override suspend fun describeCapacityReservationFleets(input: DescribeCapacityReservationFleetsRequest): DescribeCapacityReservationFleetsResponse {
        val op = SdkHttpOperation.build<DescribeCapacityReservationFleetsRequest, DescribeCapacityReservationFleetsResponse> {
            serializer = DescribeCapacityReservationFleetsOperationSerializer()
            deserializer = DescribeCapacityReservationFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCapacityReservationFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     */
    override suspend fun describeCapacityReservations(input: DescribeCapacityReservationsRequest): DescribeCapacityReservationsResponse {
        val op = SdkHttpOperation.build<DescribeCapacityReservationsRequest, DescribeCapacityReservationsResponse> {
            serializer = DescribeCapacityReservationsOperationSerializer()
            deserializer = DescribeCapacityReservationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCapacityReservations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your carrier gateways.
     */
    override suspend fun describeCarrierGateways(input: DescribeCarrierGatewaysRequest): DescribeCarrierGatewaysResponse {
        val op = SdkHttpOperation.build<DescribeCarrierGatewaysRequest, DescribeCarrierGatewaysResponse> {
            serializer = DescribeCarrierGatewaysOperationSerializer()
            deserializer = DescribeCarrierGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCarrierGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your linked EC2-Classic instances. This request only returns
     * information about EC2-Classic instances linked to a VPC through ClassicLink. You cannot
     * use this request to return information about other instances.
     */
    override suspend fun describeClassicLinkInstances(input: DescribeClassicLinkInstancesRequest): DescribeClassicLinkInstancesResponse {
        val op = SdkHttpOperation.build<DescribeClassicLinkInstancesRequest, DescribeClassicLinkInstancesResponse> {
            serializer = DescribeClassicLinkInstancesOperationSerializer()
            deserializer = DescribeClassicLinkInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClassicLinkInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the authorization rules for a specified Client VPN endpoint.
     */
    override suspend fun describeClientVpnAuthorizationRules(input: DescribeClientVpnAuthorizationRulesRequest): DescribeClientVpnAuthorizationRulesResponse {
        val op = SdkHttpOperation.build<DescribeClientVpnAuthorizationRulesRequest, DescribeClientVpnAuthorizationRulesResponse> {
            serializer = DescribeClientVpnAuthorizationRulesOperationSerializer()
            deserializer = DescribeClientVpnAuthorizationRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClientVpnAuthorizationRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes active client connections and connections that have been terminated within the last 60
     * minutes for the specified Client VPN endpoint.
     */
    override suspend fun describeClientVpnConnections(input: DescribeClientVpnConnectionsRequest): DescribeClientVpnConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeClientVpnConnectionsRequest, DescribeClientVpnConnectionsResponse> {
            serializer = DescribeClientVpnConnectionsOperationSerializer()
            deserializer = DescribeClientVpnConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClientVpnConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Client VPN endpoints in the account.
     */
    override suspend fun describeClientVpnEndpoints(input: DescribeClientVpnEndpointsRequest): DescribeClientVpnEndpointsResponse {
        val op = SdkHttpOperation.build<DescribeClientVpnEndpointsRequest, DescribeClientVpnEndpointsResponse> {
            serializer = DescribeClientVpnEndpointsOperationSerializer()
            deserializer = DescribeClientVpnEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClientVpnEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the routes for the specified Client VPN endpoint.
     */
    override suspend fun describeClientVpnRoutes(input: DescribeClientVpnRoutesRequest): DescribeClientVpnRoutesResponse {
        val op = SdkHttpOperation.build<DescribeClientVpnRoutesRequest, DescribeClientVpnRoutesResponse> {
            serializer = DescribeClientVpnRoutesOperationSerializer()
            deserializer = DescribeClientVpnRoutesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClientVpnRoutes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the target networks associated with the specified Client VPN endpoint.
     */
    override suspend fun describeClientVpnTargetNetworks(input: DescribeClientVpnTargetNetworksRequest): DescribeClientVpnTargetNetworksResponse {
        val op = SdkHttpOperation.build<DescribeClientVpnTargetNetworksRequest, DescribeClientVpnTargetNetworksResponse> {
            serializer = DescribeClientVpnTargetNetworksOperationSerializer()
            deserializer = DescribeClientVpnTargetNetworksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClientVpnTargetNetworks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified customer-owned address pools or all of your customer-owned address pools.
     */
    override suspend fun describeCoipPools(input: DescribeCoipPoolsRequest): DescribeCoipPoolsResponse {
        val op = SdkHttpOperation.build<DescribeCoipPoolsRequest, DescribeCoipPoolsResponse> {
            serializer = DescribeCoipPoolsOperationSerializer()
            deserializer = DescribeCoipPoolsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCoipPools"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified conversion tasks or all your conversion tasks. For more information, see the
     * <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/">VM Import/Export User Guide.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    override suspend fun describeConversionTasks(input: DescribeConversionTasksRequest): DescribeConversionTasksResponse {
        val op = SdkHttpOperation.build<DescribeConversionTasksRequest, DescribeConversionTasksResponse> {
            serializer = DescribeConversionTasksOperationSerializer()
            deserializer = DescribeConversionTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConversionTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your VPN customer gateways.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    override suspend fun describeCustomerGateways(input: DescribeCustomerGatewaysRequest): DescribeCustomerGatewaysResponse {
        val op = SdkHttpOperation.build<DescribeCustomerGatewaysRequest, DescribeCustomerGatewaysResponse> {
            serializer = DescribeCustomerGatewaysOperationSerializer()
            deserializer = DescribeCustomerGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomerGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your DHCP options sets.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun describeDhcpOptions(input: DescribeDhcpOptionsRequest): DescribeDhcpOptionsResponse {
        val op = SdkHttpOperation.build<DescribeDhcpOptionsRequest, DescribeDhcpOptionsResponse> {
            serializer = DescribeDhcpOptionsOperationSerializer()
            deserializer = DescribeDhcpOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDhcpOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your egress-only internet gateways.
     */
    override suspend fun describeEgressOnlyInternetGateways(input: DescribeEgressOnlyInternetGatewaysRequest): DescribeEgressOnlyInternetGatewaysResponse {
        val op = SdkHttpOperation.build<DescribeEgressOnlyInternetGatewaysRequest, DescribeEgressOnlyInternetGatewaysResponse> {
            serializer = DescribeEgressOnlyInternetGatewaysOperationSerializer()
            deserializer = DescribeEgressOnlyInternetGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEgressOnlyInternetGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the Elastic Graphics accelerator associated with your instances. For more information
     * about Elastic Graphics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon Elastic Graphics.
     */
    override suspend fun describeElasticGpus(input: DescribeElasticGpusRequest): DescribeElasticGpusResponse {
        val op = SdkHttpOperation.build<DescribeElasticGpusRequest, DescribeElasticGpusResponse> {
            serializer = DescribeElasticGpusOperationSerializer()
            deserializer = DescribeElasticGpusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeElasticGpus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified export image tasks or all of your export image tasks.
     */
    override suspend fun describeExportImageTasks(input: DescribeExportImageTasksRequest): DescribeExportImageTasksResponse {
        val op = SdkHttpOperation.build<DescribeExportImageTasksRequest, DescribeExportImageTasksResponse> {
            serializer = DescribeExportImageTasksOperationSerializer()
            deserializer = DescribeExportImageTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeExportImageTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified export instance tasks or all of your export instance tasks.
     */
    override suspend fun describeExportTasks(input: DescribeExportTasksRequest): DescribeExportTasksResponse {
        val op = SdkHttpOperation.build<DescribeExportTasksRequest, DescribeExportTasksResponse> {
            serializer = DescribeExportTasksOperationSerializer()
            deserializer = DescribeExportTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeExportTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe details for Windows AMIs that are configured for faster launching.
     */
    override suspend fun describeFastLaunchImages(input: DescribeFastLaunchImagesRequest): DescribeFastLaunchImagesResponse {
        val op = SdkHttpOperation.build<DescribeFastLaunchImagesRequest, DescribeFastLaunchImagesResponse> {
            serializer = DescribeFastLaunchImagesOperationSerializer()
            deserializer = DescribeFastLaunchImagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFastLaunchImages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the state of fast snapshot restores for your snapshots.
     */
    override suspend fun describeFastSnapshotRestores(input: DescribeFastSnapshotRestoresRequest): DescribeFastSnapshotRestoresResponse {
        val op = SdkHttpOperation.build<DescribeFastSnapshotRestoresRequest, DescribeFastSnapshotRestoresResponse> {
            serializer = DescribeFastSnapshotRestoresOperationSerializer()
            deserializer = DescribeFastSnapshotRestoresOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFastSnapshotRestores"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the events for the specified EC2 Fleet during the specified time.
     * EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures
     * that you can query by the last evaluated time and not miss a recorded event. EC2 Fleet events
     * are available for 48 hours.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon EventBridge in the
     * Amazon EC2 User Guide.
     */
    override suspend fun describeFleetHistory(input: DescribeFleetHistoryRequest): DescribeFleetHistoryResponse {
        val op = SdkHttpOperation.build<DescribeFleetHistoryRequest, DescribeFleetHistoryResponse> {
            serializer = DescribeFleetHistoryOperationSerializer()
            deserializer = DescribeFleetHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFleetHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the running instances for the specified EC2 Fleet.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet">Monitoring your EC2 Fleet in the Amazon EC2 User Guide.
     */
    override suspend fun describeFleetInstances(input: DescribeFleetInstancesRequest): DescribeFleetInstancesResponse {
        val op = SdkHttpOperation.build<DescribeFleetInstancesRequest, DescribeFleetInstancesResponse> {
            serializer = DescribeFleetInstancesOperationSerializer()
            deserializer = DescribeFleetInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFleetInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified EC2 Fleets or all of your EC2 Fleets.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet">Monitoring your EC2 Fleet in the Amazon EC2 User Guide.
     */
    override suspend fun describeFleets(input: DescribeFleetsRequest): DescribeFleetsResponse {
        val op = SdkHttpOperation.build<DescribeFleetsRequest, DescribeFleetsResponse> {
            serializer = DescribeFleetsOperationSerializer()
            deserializer = DescribeFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more flow logs. To view the information in your flow logs (the log
     * streams for the network interfaces), you must use the CloudWatch Logs console or the CloudWatch Logs
     * API.
     */
    override suspend fun describeFlowLogs(input: DescribeFlowLogsRequest): DescribeFlowLogsResponse {
        val op = SdkHttpOperation.build<DescribeFlowLogsRequest, DescribeFlowLogsResponse> {
            serializer = DescribeFlowLogsOperationSerializer()
            deserializer = DescribeFlowLogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFlowLogs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified attribute of the specified Amazon FPGA Image (AFI).
     */
    override suspend fun describeFpgaImageAttribute(input: DescribeFpgaImageAttributeRequest): DescribeFpgaImageAttributeResponse {
        val op = SdkHttpOperation.build<DescribeFpgaImageAttributeRequest, DescribeFpgaImageAttributeResponse> {
            serializer = DescribeFpgaImageAttributeOperationSerializer()
            deserializer = DescribeFpgaImageAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFpgaImageAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs,
     * private AFIs that you own, and AFIs owned by other Amazon Web Services accounts for which you have load
     * permissions.
     */
    override suspend fun describeFpgaImages(input: DescribeFpgaImagesRequest): DescribeFpgaImagesResponse {
        val op = SdkHttpOperation.build<DescribeFpgaImagesRequest, DescribeFpgaImagesResponse> {
            serializer = DescribeFpgaImagesOperationSerializer()
            deserializer = DescribeFpgaImagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFpgaImages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the Dedicated Host reservations that are available to purchase.
     * The results describe all of the Dedicated Host reservation offerings, including
     * offerings that might not match the instance family and Region of your Dedicated Hosts.
     * When purchasing an offering, ensure that the instance family and Region of the offering
     * matches that of the Dedicated Hosts with which it is to be associated. For more
     * information about supported instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts
     * in the Amazon EC2 User Guide.
     */
    override suspend fun describeHostReservationOfferings(input: DescribeHostReservationOfferingsRequest): DescribeHostReservationOfferingsResponse {
        val op = SdkHttpOperation.build<DescribeHostReservationOfferingsRequest, DescribeHostReservationOfferingsResponse> {
            serializer = DescribeHostReservationOfferingsOperationSerializer()
            deserializer = DescribeHostReservationOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHostReservationOfferings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes reservations that are associated with Dedicated Hosts in your
     * account.
     */
    override suspend fun describeHostReservations(input: DescribeHostReservationsRequest): DescribeHostReservationsResponse {
        val op = SdkHttpOperation.build<DescribeHostReservationsRequest, DescribeHostReservationsResponse> {
            serializer = DescribeHostReservationsOperationSerializer()
            deserializer = DescribeHostReservationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHostReservations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified Dedicated Hosts or all your Dedicated Hosts.
     * The results describe only the Dedicated Hosts in the Region you're currently using.
     * All listed instances consume capacity on your Dedicated Host. Dedicated Hosts that have
     * recently been released are listed with the state released.
     */
    override suspend fun describeHosts(input: DescribeHostsRequest): DescribeHostsResponse {
        val op = SdkHttpOperation.build<DescribeHostsRequest, DescribeHostsResponse> {
            serializer = DescribeHostsOperationSerializer()
            deserializer = DescribeHostsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHosts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes your IAM instance profile associations.
     */
    override suspend fun describeIamInstanceProfileAssociations(input: DescribeIamInstanceProfileAssociationsRequest): DescribeIamInstanceProfileAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeIamInstanceProfileAssociationsRequest, DescribeIamInstanceProfileAssociationsResponse> {
            serializer = DescribeIamInstanceProfileAssociationsOperationSerializer()
            deserializer = DescribeIamInstanceProfileAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIamInstanceProfileAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource types are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc
     * | vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     * These settings apply to the IAM user who makes the request; they do not apply to the entire
     * Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user, unless
     * they explicitly override the settings by running the ModifyIdFormat command. Resources
     * created with longer IDs are visible to all IAM users, regardless of these settings and
     * provided that they have permission to use the relevant Describe command for the
     * resource type.
     */
    override suspend fun describeIdFormat(input: DescribeIdFormatRequest): DescribeIdFormatResponse {
        val op = SdkHttpOperation.build<DescribeIdFormatRequest, DescribeIdFormatResponse> {
            serializer = DescribeIdFormatOperationSerializer()
            deserializer = DescribeIdFormatOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIdFormat"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the ID format settings for resources for the specified IAM user, IAM role, or root
     * user. For example, you can view the resource types that are enabled for longer IDs. This request only
     * returns information about resource types whose ID formats can be modified; it does not return
     * information about other resource types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs in the Amazon Elastic Compute Cloud User Guide.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc
     * | vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     * These settings apply to the principal specified in the request. They do not apply to the
     * principal that makes the request.
     */
    override suspend fun describeIdentityIdFormat(input: DescribeIdentityIdFormatRequest): DescribeIdentityIdFormatResponse {
        val op = SdkHttpOperation.build<DescribeIdentityIdFormatRequest, DescribeIdentityIdFormatResponse> {
            serializer = DescribeIdentityIdFormatOperationSerializer()
            deserializer = DescribeIdentityIdFormatOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIdentityIdFormat"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.
     */
    override suspend fun describeImageAttribute(input: DescribeImageAttributeRequest): DescribeImageAttributeResponse {
        val op = SdkHttpOperation.build<DescribeImageAttributeRequest, DescribeImageAttributeResponse> {
            serializer = DescribeImageAttributeOperationSerializer()
            deserializer = DescribeImageAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImageAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you.
     * The images available to you include public images, private images that you own, and private images owned by other
     * Amazon Web Services accounts for which you have explicit launch permissions.
     * Recently deregistered images appear in the returned results for a short interval and then
     * return empty results. After all instances that reference a deregistered AMI are terminated,
     * specifying the ID of the image will eventually return an error indicating that the AMI ID
     * cannot be found.
     */
    override suspend fun describeImages(input: DescribeImagesRequest): DescribeImagesResponse {
        val op = SdkHttpOperation.build<DescribeImagesRequest, DescribeImagesResponse> {
            serializer = DescribeImagesOperationSerializer()
            deserializer = DescribeImagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Displays details about an import virtual machine or import snapshot tasks that are already created.
     */
    override suspend fun describeImportImageTasks(input: DescribeImportImageTasksRequest): DescribeImportImageTasksResponse {
        val op = SdkHttpOperation.build<DescribeImportImageTasksRequest, DescribeImportImageTasksResponse> {
            serializer = DescribeImportImageTasksOperationSerializer()
            deserializer = DescribeImportImageTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImportImageTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes your import snapshot tasks.
     */
    override suspend fun describeImportSnapshotTasks(input: DescribeImportSnapshotTasksRequest): DescribeImportSnapshotTasksResponse {
        val op = SdkHttpOperation.build<DescribeImportSnapshotTasksRequest, DescribeImportSnapshotTasksResponse> {
            serializer = DescribeImportSnapshotTasksOperationSerializer()
            deserializer = DescribeImportSnapshotTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImportSnapshotTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified attribute of the specified instance. You can specify only one
     * attribute at a time. Valid attribute values are: instanceType |
     * kernel | ramdisk | userData |
     * disableApiTermination | instanceInitiatedShutdownBehavior
     * | rootDeviceName | blockDeviceMapping |
     * productCodes | sourceDestCheck | groupSet |
     * ebsOptimized | sriovNetSupport
     */
    override suspend fun describeInstanceAttribute(input: DescribeInstanceAttributeRequest): DescribeInstanceAttributeResponse {
        val op = SdkHttpOperation.build<DescribeInstanceAttributeRequest, DescribeInstanceAttributeResponse> {
            serializer = DescribeInstanceAttributeOperationSerializer()
            deserializer = DescribeInstanceAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstanceAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the credit option for CPU usage of the specified burstable performance
     * instances. The credit options are standard and
     * unlimited.
     * If you do not specify an instance ID, Amazon EC2 returns burstable performance
     * instances with the unlimited credit option, as well as instances that were
     * previously configured as T2, T3, and T3a with the unlimited credit option.
     * For example, if you resize a T2 instance, while it is configured as
     * unlimited, to an M4 instance, Amazon EC2 returns the M4
     * instance.
     * If you specify one or more instance IDs, Amazon EC2 returns the credit option
     * (standard or unlimited) of those instances. If you specify
     * an instance ID that is not valid, such as an instance that is not a burstable
     * performance instance, an error is returned.
     * Recently terminated instances might appear in the returned results. This interval is
     * usually less than one hour.
     * If an Availability Zone is experiencing a service disruption and you specify instance
     * IDs in the affected zone, or do not specify any instance IDs at all, the call fails. If
     * you specify only instance IDs in an unaffected zone, the call works normally.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    override suspend fun describeInstanceCreditSpecifications(input: DescribeInstanceCreditSpecificationsRequest): DescribeInstanceCreditSpecificationsResponse {
        val op = SdkHttpOperation.build<DescribeInstanceCreditSpecificationsRequest, DescribeInstanceCreditSpecificationsResponse> {
            serializer = DescribeInstanceCreditSpecificationsOperationSerializer()
            deserializer = DescribeInstanceCreditSpecificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstanceCreditSpecifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the tag keys that are registered to appear in scheduled event notifications for
     * resources in the current Region.
     */
    override suspend fun describeInstanceEventNotificationAttributes(input: DescribeInstanceEventNotificationAttributesRequest): DescribeInstanceEventNotificationAttributesResponse {
        val op = SdkHttpOperation.build<DescribeInstanceEventNotificationAttributesRequest, DescribeInstanceEventNotificationAttributesResponse> {
            serializer = DescribeInstanceEventNotificationAttributesOperationSerializer()
            deserializer = DescribeInstanceEventNotificationAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstanceEventNotificationAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified event windows or all event windows.
     * If you specify event window IDs, the output includes information for only the specified
     * event windows. If you specify filters, the output includes information for only those event
     * windows that meet the filter criteria. If you do not specify event windows IDs or filters,
     * the output includes information for all event windows, which can affect performance. We
     * recommend that you use pagination to ensure that the operation returns quickly and
     * successfully.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    override suspend fun describeInstanceEventWindows(input: DescribeInstanceEventWindowsRequest): DescribeInstanceEventWindowsResponse {
        val op = SdkHttpOperation.build<DescribeInstanceEventWindowsRequest, DescribeInstanceEventWindowsResponse> {
            serializer = DescribeInstanceEventWindowsOperationSerializer()
            deserializer = DescribeInstanceEventWindowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstanceEventWindows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status of the specified instances or all of your instances. By default,
     * only running instances are described, unless you specifically indicate to return the
     * status of all instances.
     * Instance status includes the following components:
     * Status checks - Amazon EC2 performs status
     * checks on running EC2 instances to identify hardware and software issues. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status checks for your instances and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshoot
     * instances with failed status checks in the Amazon EC2 User
     * Guide.
     * Scheduled events - Amazon EC2 can schedule
     * events (such as reboot, stop, or terminate) for your instances related to
     * hardware issues, software updates, or system maintenance. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled events for your instances in the Amazon EC2 User Guide.
     * Instance state - You can manage your instances
     * from the moment you launch them through their termination. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance
     * lifecycle in the Amazon EC2 User Guide.
     */
    override suspend fun describeInstanceStatus(input: DescribeInstanceStatusRequest): DescribeInstanceStatusResponse {
        val op = SdkHttpOperation.build<DescribeInstanceStatusRequest, DescribeInstanceStatusResponse> {
            serializer = DescribeInstanceStatusOperationSerializer()
            deserializer = DescribeInstanceStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstanceStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all instance types offered. The results can be filtered by location (Region or Availability
     * Zone). If no location is specified, the instance types offered in the current Region are returned.
     */
    override suspend fun describeInstanceTypeOfferings(input: DescribeInstanceTypeOfferingsRequest): DescribeInstanceTypeOfferingsResponse {
        val op = SdkHttpOperation.build<DescribeInstanceTypeOfferingsRequest, DescribeInstanceTypeOfferingsResponse> {
            serializer = DescribeInstanceTypeOfferingsOperationSerializer()
            deserializer = DescribeInstanceTypeOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstanceTypeOfferings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the details of the instance types that are offered in a location. The results can be filtered by the
     * attributes of the instance types.
     */
    override suspend fun describeInstanceTypes(input: DescribeInstanceTypesRequest): DescribeInstanceTypesResponse {
        val op = SdkHttpOperation.build<DescribeInstanceTypesRequest, DescribeInstanceTypesResponse> {
            serializer = DescribeInstanceTypesOperationSerializer()
            deserializer = DescribeInstanceTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstanceTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified instances or all instances.
     * If you specify instance IDs, the output includes information for only the specified instances.
     * If you specify filters, the output includes information for only those instances that meet the filter criteria.
     * If you do not specify instance IDs or filters, the output includes information for all instances,
     * which can affect performance. We recommend that you use pagination to ensure that the operation
     * returns quickly and successfully.
     * If you specify an instance ID that is not valid, an error is returned. If you
     * specify an instance that you do not own, it is not included in the output.
     * Recently terminated instances might appear in the returned results. This interval is
     * usually less than one hour.
     * If you describe instances in the rare case where an Availability Zone is experiencing
     * a service disruption and you specify instance IDs that are in the affected zone, or do
     * not specify any instance IDs at all, the call fails. If you describe instances and
     * specify only instance IDs that are in an unaffected zone, the call works
     * normally.
     */
    override suspend fun describeInstances(input: DescribeInstancesRequest): DescribeInstancesResponse {
        val op = SdkHttpOperation.build<DescribeInstancesRequest, DescribeInstancesResponse> {
            serializer = DescribeInstancesOperationSerializer()
            deserializer = DescribeInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your internet gateways.
     */
    override suspend fun describeInternetGateways(input: DescribeInternetGatewaysRequest): DescribeInternetGatewaysResponse {
        val op = SdkHttpOperation.build<DescribeInternetGatewaysRequest, DescribeInternetGatewaysResponse> {
            serializer = DescribeInternetGatewaysOperationSerializer()
            deserializer = DescribeInternetGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInternetGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get information about your IPAM pools.
     */
    override suspend fun describeIpamPools(input: DescribeIpamPoolsRequest): DescribeIpamPoolsResponse {
        val op = SdkHttpOperation.build<DescribeIpamPoolsRequest, DescribeIpamPoolsResponse> {
            serializer = DescribeIpamPoolsOperationSerializer()
            deserializer = DescribeIpamPoolsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIpamPools"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get information about your IPAM scopes.
     */
    override suspend fun describeIpamScopes(input: DescribeIpamScopesRequest): DescribeIpamScopesResponse {
        val op = SdkHttpOperation.build<DescribeIpamScopesRequest, DescribeIpamScopesResponse> {
            serializer = DescribeIpamScopesOperationSerializer()
            deserializer = DescribeIpamScopesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIpamScopes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get information about your IPAM pools.
     * For more information, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM? in the Amazon VPC IPAM User Guide.
     */
    override suspend fun describeIpams(input: DescribeIpamsRequest): DescribeIpamsResponse {
        val op = SdkHttpOperation.build<DescribeIpamsRequest, DescribeIpamsResponse> {
            serializer = DescribeIpamsOperationSerializer()
            deserializer = DescribeIpamsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIpams"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes your IPv6 address pools.
     */
    override suspend fun describeIpv6Pools(input: DescribeIpv6PoolsRequest): DescribeIpv6PoolsResponse {
        val op = SdkHttpOperation.build<DescribeIpv6PoolsRequest, DescribeIpv6PoolsResponse> {
            serializer = DescribeIpv6PoolsOperationSerializer()
            deserializer = DescribeIpv6PoolsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIpv6Pools"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified key pairs or all of your key pairs.
     * For more information about key pairs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeKeyPairs(input: DescribeKeyPairsRequest): DescribeKeyPairsResponse {
        val op = SdkHttpOperation.build<DescribeKeyPairsRequest, DescribeKeyPairsResponse> {
            serializer = DescribeKeyPairsOperationSerializer()
            deserializer = DescribeKeyPairsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeKeyPairs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more versions of a specified launch template. You can describe all
     * versions, individual versions, or a range of versions. You can also describe all the
     * latest versions or all the default versions of all the launch templates in your
     * account.
     */
    override suspend fun describeLaunchTemplateVersions(input: DescribeLaunchTemplateVersionsRequest): DescribeLaunchTemplateVersionsResponse {
        val op = SdkHttpOperation.build<DescribeLaunchTemplateVersionsRequest, DescribeLaunchTemplateVersionsResponse> {
            serializer = DescribeLaunchTemplateVersionsOperationSerializer()
            deserializer = DescribeLaunchTemplateVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLaunchTemplateVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more launch templates.
     */
    override suspend fun describeLaunchTemplates(input: DescribeLaunchTemplatesRequest): DescribeLaunchTemplatesResponse {
        val op = SdkHttpOperation.build<DescribeLaunchTemplatesRequest, DescribeLaunchTemplatesResponse> {
            serializer = DescribeLaunchTemplatesOperationSerializer()
            deserializer = DescribeLaunchTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLaunchTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the associations between virtual interface groups and local gateway route tables.
     */
    override suspend fun describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(input: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest): DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest, DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> {
            serializer = DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOperationSerializer()
            deserializer = DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified associations between VPCs and local gateway route tables.
     */
    override suspend fun describeLocalGatewayRouteTableVpcAssociations(input: DescribeLocalGatewayRouteTableVpcAssociationsRequest): DescribeLocalGatewayRouteTableVpcAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeLocalGatewayRouteTableVpcAssociationsRequest, DescribeLocalGatewayRouteTableVpcAssociationsResponse> {
            serializer = DescribeLocalGatewayRouteTableVpcAssociationsOperationSerializer()
            deserializer = DescribeLocalGatewayRouteTableVpcAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocalGatewayRouteTableVpcAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more local gateway route tables. By default, all local gateway route tables are described.
     * Alternatively, you can filter the results.
     */
    override suspend fun describeLocalGatewayRouteTables(input: DescribeLocalGatewayRouteTablesRequest): DescribeLocalGatewayRouteTablesResponse {
        val op = SdkHttpOperation.build<DescribeLocalGatewayRouteTablesRequest, DescribeLocalGatewayRouteTablesResponse> {
            serializer = DescribeLocalGatewayRouteTablesOperationSerializer()
            deserializer = DescribeLocalGatewayRouteTablesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocalGatewayRouteTables"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified local gateway virtual interface groups.
     */
    override suspend fun describeLocalGatewayVirtualInterfaceGroups(input: DescribeLocalGatewayVirtualInterfaceGroupsRequest): DescribeLocalGatewayVirtualInterfaceGroupsResponse {
        val op = SdkHttpOperation.build<DescribeLocalGatewayVirtualInterfaceGroupsRequest, DescribeLocalGatewayVirtualInterfaceGroupsResponse> {
            serializer = DescribeLocalGatewayVirtualInterfaceGroupsOperationSerializer()
            deserializer = DescribeLocalGatewayVirtualInterfaceGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocalGatewayVirtualInterfaceGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified local gateway virtual interfaces.
     */
    override suspend fun describeLocalGatewayVirtualInterfaces(input: DescribeLocalGatewayVirtualInterfacesRequest): DescribeLocalGatewayVirtualInterfacesResponse {
        val op = SdkHttpOperation.build<DescribeLocalGatewayVirtualInterfacesRequest, DescribeLocalGatewayVirtualInterfacesResponse> {
            serializer = DescribeLocalGatewayVirtualInterfacesOperationSerializer()
            deserializer = DescribeLocalGatewayVirtualInterfacesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocalGatewayVirtualInterfaces"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more local gateways. By default, all local gateways are described.
     * Alternatively, you can filter the results.
     */
    override suspend fun describeLocalGateways(input: DescribeLocalGatewaysRequest): DescribeLocalGatewaysResponse {
        val op = SdkHttpOperation.build<DescribeLocalGatewaysRequest, DescribeLocalGatewaysResponse> {
            serializer = DescribeLocalGatewaysOperationSerializer()
            deserializer = DescribeLocalGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLocalGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes your managed prefix lists and any Amazon Web Services-managed prefix lists.
     * To view the entries for your prefix list, use GetManagedPrefixListEntries.
     */
    override suspend fun describeManagedPrefixLists(input: DescribeManagedPrefixListsRequest): DescribeManagedPrefixListsResponse {
        val op = SdkHttpOperation.build<DescribeManagedPrefixListsRequest, DescribeManagedPrefixListsResponse> {
            serializer = DescribeManagedPrefixListsOperationSerializer()
            deserializer = DescribeManagedPrefixListsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeManagedPrefixLists"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your account.
     */
    override suspend fun describeMovingAddresses(input: DescribeMovingAddressesRequest): DescribeMovingAddressesResponse {
        val op = SdkHttpOperation.build<DescribeMovingAddressesRequest, DescribeMovingAddressesResponse> {
            serializer = DescribeMovingAddressesOperationSerializer()
            deserializer = DescribeMovingAddressesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMovingAddresses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your NAT gateways.
     */
    override suspend fun describeNatGateways(input: DescribeNatGatewaysRequest): DescribeNatGatewaysResponse {
        val op = SdkHttpOperation.build<DescribeNatGatewaysRequest, DescribeNatGatewaysResponse> {
            serializer = DescribeNatGatewaysOperationSerializer()
            deserializer = DescribeNatGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNatGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your network ACLs.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun describeNetworkAcls(input: DescribeNetworkAclsRequest): DescribeNetworkAclsResponse {
        val op = SdkHttpOperation.build<DescribeNetworkAclsRequest, DescribeNetworkAclsResponse> {
            serializer = DescribeNetworkAclsOperationSerializer()
            deserializer = DescribeNetworkAclsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNetworkAcls"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified Network Access Scope analyses.
     */
    override suspend fun describeNetworkInsightsAccessScopeAnalyses(input: DescribeNetworkInsightsAccessScopeAnalysesRequest): DescribeNetworkInsightsAccessScopeAnalysesResponse {
        val op = SdkHttpOperation.build<DescribeNetworkInsightsAccessScopeAnalysesRequest, DescribeNetworkInsightsAccessScopeAnalysesResponse> {
            serializer = DescribeNetworkInsightsAccessScopeAnalysesOperationSerializer()
            deserializer = DescribeNetworkInsightsAccessScopeAnalysesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNetworkInsightsAccessScopeAnalyses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified Network Access Scopes.
     */
    override suspend fun describeNetworkInsightsAccessScopes(input: DescribeNetworkInsightsAccessScopesRequest): DescribeNetworkInsightsAccessScopesResponse {
        val op = SdkHttpOperation.build<DescribeNetworkInsightsAccessScopesRequest, DescribeNetworkInsightsAccessScopesResponse> {
            serializer = DescribeNetworkInsightsAccessScopesOperationSerializer()
            deserializer = DescribeNetworkInsightsAccessScopesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNetworkInsightsAccessScopes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your network insights analyses.
     */
    override suspend fun describeNetworkInsightsAnalyses(input: DescribeNetworkInsightsAnalysesRequest): DescribeNetworkInsightsAnalysesResponse {
        val op = SdkHttpOperation.build<DescribeNetworkInsightsAnalysesRequest, DescribeNetworkInsightsAnalysesResponse> {
            serializer = DescribeNetworkInsightsAnalysesOperationSerializer()
            deserializer = DescribeNetworkInsightsAnalysesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNetworkInsightsAnalyses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your paths.
     */
    override suspend fun describeNetworkInsightsPaths(input: DescribeNetworkInsightsPathsRequest): DescribeNetworkInsightsPathsResponse {
        val op = SdkHttpOperation.build<DescribeNetworkInsightsPathsRequest, DescribeNetworkInsightsPathsResponse> {
            serializer = DescribeNetworkInsightsPathsOperationSerializer()
            deserializer = DescribeNetworkInsightsPathsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNetworkInsightsPaths"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a network interface attribute. You can specify only one attribute at a time.
     */
    override suspend fun describeNetworkInterfaceAttribute(input: DescribeNetworkInterfaceAttributeRequest): DescribeNetworkInterfaceAttributeResponse {
        val op = SdkHttpOperation.build<DescribeNetworkInterfaceAttributeRequest, DescribeNetworkInterfaceAttributeResponse> {
            serializer = DescribeNetworkInterfaceAttributeOperationSerializer()
            deserializer = DescribeNetworkInterfaceAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNetworkInterfaceAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the permissions for your network interfaces.
     */
    override suspend fun describeNetworkInterfacePermissions(input: DescribeNetworkInterfacePermissionsRequest): DescribeNetworkInterfacePermissionsResponse {
        val op = SdkHttpOperation.build<DescribeNetworkInterfacePermissionsRequest, DescribeNetworkInterfacePermissionsResponse> {
            serializer = DescribeNetworkInterfacePermissionsOperationSerializer()
            deserializer = DescribeNetworkInterfacePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNetworkInterfacePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your network interfaces.
     */
    override suspend fun describeNetworkInterfaces(input: DescribeNetworkInterfacesRequest): DescribeNetworkInterfacesResponse {
        val op = SdkHttpOperation.build<DescribeNetworkInterfacesRequest, DescribeNetworkInterfacesResponse> {
            serializer = DescribeNetworkInterfacesOperationSerializer()
            deserializer = DescribeNetworkInterfacesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNetworkInterfaces"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified placement groups or all of your placement groups. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups in the
     * Amazon EC2 User Guide.
     */
    override suspend fun describePlacementGroups(input: DescribePlacementGroupsRequest): DescribePlacementGroupsResponse {
        val op = SdkHttpOperation.build<DescribePlacementGroupsRequest, DescribePlacementGroupsResponse> {
            serializer = DescribePlacementGroupsOperationSerializer()
            deserializer = DescribePlacementGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePlacementGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes available Amazon Web Services services in a prefix list format, which includes the prefix list
     * name and prefix list ID of the service and the IP address range for the service.
     * We recommend that you use DescribeManagedPrefixLists instead.
     */
    override suspend fun describePrefixLists(input: DescribePrefixListsRequest): DescribePrefixListsResponse {
        val op = SdkHttpOperation.build<DescribePrefixListsRequest, DescribePrefixListsResponse> {
            serializer = DescribePrefixListsOperationSerializer()
            deserializer = DescribePrefixListsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePrefixLists"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the ID format settings for the root user and all IAM roles and IAM users
     * that have explicitly specified a longer ID (17-character ID) preference.
     * By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they
     * explicitly override the settings. This request is useful for identifying those IAM users and IAM roles
     * that have overridden the default ID settings.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc
     * | vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     */
    override suspend fun describePrincipalIdFormat(input: DescribePrincipalIdFormatRequest): DescribePrincipalIdFormatResponse {
        val op = SdkHttpOperation.build<DescribePrincipalIdFormatRequest, DescribePrincipalIdFormatResponse> {
            serializer = DescribePrincipalIdFormatOperationSerializer()
            deserializer = DescribePrincipalIdFormatOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePrincipalIdFormat"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified IPv4 address pools.
     */
    override suspend fun describePublicIpv4Pools(input: DescribePublicIpv4PoolsRequest): DescribePublicIpv4PoolsResponse {
        val op = SdkHttpOperation.build<DescribePublicIpv4PoolsRequest, DescribePublicIpv4PoolsResponse> {
            serializer = DescribePublicIpv4PoolsOperationSerializer()
            deserializer = DescribePublicIpv4PoolsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePublicIpv4Pools"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the Regions that are enabled for your account, or all Regions.
     * For a list of the Regions supported by Amazon EC2, see <a href="https://docs.aws.amazon.com/general/latest/gr/ec2-service.html">
     * Amazon Elastic Compute Cloud endpoints and quotas.
     * For information about enabling and disabling Regions for your account, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon Web Services Regions in the Amazon Web Services General Reference.
     */
    override suspend fun describeRegions(input: DescribeRegionsRequest): DescribeRegionsResponse {
        val op = SdkHttpOperation.build<DescribeRegionsRequest, DescribeRegionsResponse> {
            serializer = DescribeRegionsOperationSerializer()
            deserializer = DescribeRegionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRegions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a root volume replacement task. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root">Replace a root volume in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeReplaceRootVolumeTasks(input: DescribeReplaceRootVolumeTasksRequest): DescribeReplaceRootVolumeTasksResponse {
        val op = SdkHttpOperation.build<DescribeReplaceRootVolumeTasksRequest, DescribeReplaceRootVolumeTasksResponse> {
            serializer = DescribeReplaceRootVolumeTasksOperationSerializer()
            deserializer = DescribeReplaceRootVolumeTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReplaceRootVolumeTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of the Reserved Instances that you purchased.
     * For more information about Reserved Instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved
     * Instances in the Amazon EC2 User Guide.
     */
    override suspend fun describeReservedInstances(input: DescribeReservedInstancesRequest): DescribeReservedInstancesResponse {
        val op = SdkHttpOperation.build<DescribeReservedInstancesRequest, DescribeReservedInstancesResponse> {
            serializer = DescribeReservedInstancesOperationSerializer()
            deserializer = DescribeReservedInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes your account's Reserved Instance listings in the Reserved Instance Marketplace.
     * The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.
     * As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available for purchase.
     * As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what you're searching for with what's available. The Marketplace first sells the lowest priced Reserved Instances to you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged based on the total price of all of the listings that you purchase.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    override suspend fun describeReservedInstancesListings(input: DescribeReservedInstancesListingsRequest): DescribeReservedInstancesListingsResponse {
        val op = SdkHttpOperation.build<DescribeReservedInstancesListingsRequest, DescribeReservedInstancesListingsResponse> {
            serializer = DescribeReservedInstancesListingsOperationSerializer()
            deserializer = DescribeReservedInstancesListingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedInstancesListings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all your Reserved Instances modification requests is returned. If a modification ID is specified, only information about the specific modification is returned.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances in the Amazon EC2 User Guide.
     */
    override suspend fun describeReservedInstancesModifications(input: DescribeReservedInstancesModificationsRequest): DescribeReservedInstancesModificationsResponse {
        val op = SdkHttpOperation.build<DescribeReservedInstancesModificationsRequest, DescribeReservedInstancesModificationsResponse> {
            serializer = DescribeReservedInstancesModificationsOperationSerializer()
            deserializer = DescribeReservedInstancesModificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedInstancesModifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the right to launch instances for a period of time. During that time period, you do not receive insufficient capacity errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.
     * If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    override suspend fun describeReservedInstancesOfferings(input: DescribeReservedInstancesOfferingsRequest): DescribeReservedInstancesOfferingsResponse {
        val op = SdkHttpOperation.build<DescribeReservedInstancesOfferingsRequest, DescribeReservedInstancesOfferingsResponse> {
            serializer = DescribeReservedInstancesOfferingsOperationSerializer()
            deserializer = DescribeReservedInstancesOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedInstancesOfferings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your route tables.
     * Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any route table, it is implicitly associated with the main route table. This command does not return the subnet ID for implicit associations.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun describeRouteTables(input: DescribeRouteTablesRequest): DescribeRouteTablesResponse {
        val op = SdkHttpOperation.build<DescribeRouteTablesRequest, DescribeRouteTablesResponse> {
            serializer = DescribeRouteTablesOperationSerializer()
            deserializer = DescribeRouteTablesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRouteTables"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Finds available schedules that meet the specified criteria.
     * You can search for an available schedule no more than 3 months in advance. You must meet the minimum required duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.
     * After you find a schedule that meets your needs, call PurchaseScheduledInstances
     * to purchase Scheduled Instances with that schedule.
     */
    override suspend fun describeScheduledInstanceAvailability(input: DescribeScheduledInstanceAvailabilityRequest): DescribeScheduledInstanceAvailabilityResponse {
        val op = SdkHttpOperation.build<DescribeScheduledInstanceAvailabilityRequest, DescribeScheduledInstanceAvailabilityResponse> {
            serializer = DescribeScheduledInstanceAvailabilityOperationSerializer()
            deserializer = DescribeScheduledInstanceAvailabilityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeScheduledInstanceAvailability"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified Scheduled Instances or all your Scheduled Instances.
     */
    override suspend fun describeScheduledInstances(input: DescribeScheduledInstancesRequest): DescribeScheduledInstancesResponse {
        val op = SdkHttpOperation.build<DescribeScheduledInstancesRequest, DescribeScheduledInstancesResponse> {
            serializer = DescribeScheduledInstancesOperationSerializer()
            deserializer = DescribeScheduledInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeScheduledInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * &#91;VPC only&#93; Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you've specified in this request.
     */
    override suspend fun describeSecurityGroupReferences(input: DescribeSecurityGroupReferencesRequest): DescribeSecurityGroupReferencesResponse {
        val op = SdkHttpOperation.build<DescribeSecurityGroupReferencesRequest, DescribeSecurityGroupReferencesResponse> {
            serializer = DescribeSecurityGroupReferencesOperationSerializer()
            deserializer = DescribeSecurityGroupReferencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSecurityGroupReferences"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your security group rules.
     */
    override suspend fun describeSecurityGroupRules(input: DescribeSecurityGroupRulesRequest): DescribeSecurityGroupRulesResponse {
        val op = SdkHttpOperation.build<DescribeSecurityGroupRulesRequest, DescribeSecurityGroupRulesResponse> {
            serializer = DescribeSecurityGroupRulesOperationSerializer()
            deserializer = DescribeSecurityGroupRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSecurityGroupRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified security groups or all of your security groups.
     * A security group is for use with instances either in the EC2-Classic platform
     * or in a specific VPC. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 security groups in
     * the Amazon Elastic Compute Cloud User Guide and
     * <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your VPC in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun describeSecurityGroups(input: DescribeSecurityGroupsRequest): DescribeSecurityGroupsResponse {
        val op = SdkHttpOperation.build<DescribeSecurityGroupsRequest, DescribeSecurityGroupsResponse> {
            serializer = DescribeSecurityGroupsOperationSerializer()
            deserializer = DescribeSecurityGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSecurityGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified attribute of the specified snapshot. You can specify only one
     * attribute at a time.
     * For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeSnapshotAttribute(input: DescribeSnapshotAttributeRequest): DescribeSnapshotAttributeResponse {
        val op = SdkHttpOperation.build<DescribeSnapshotAttributeRequest, DescribeSnapshotAttributeResponse> {
            serializer = DescribeSnapshotAttributeOperationSerializer()
            deserializer = DescribeSnapshotAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSnapshotAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the storage tier status of one or more Amazon EBS snapshots.
     */
    override suspend fun describeSnapshotTierStatus(input: DescribeSnapshotTierStatusRequest): DescribeSnapshotTierStatusResponse {
        val op = SdkHttpOperation.build<DescribeSnapshotTierStatusRequest, DescribeSnapshotTierStatusResponse> {
            serializer = DescribeSnapshotTierStatusOperationSerializer()
            deserializer = DescribeSnapshotTierStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSnapshotTierStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified EBS snapshots available to you or all of the EBS snapshots
     * available to you.
     * The snapshots available to you include public snapshots, private snapshots that you own,
     * and private snapshots owned by other Amazon Web Services accounts for which you have explicit create volume
     * permissions.
     * The create volume permissions fall into the following categories:
     * public: The owner of the snapshot granted create volume
     * permissions for the snapshot to the all group. All Amazon Web Services accounts have create
     * volume permissions for these snapshots.
     * explicit: The owner of the snapshot granted create volume
     * permissions to a specific Amazon Web Services account.
     * implicit: An Amazon Web Services account has implicit create volume permissions
     * for all snapshots it owns.
     * The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot
     * owners, or Amazon Web Services accounts with create volume permissions. If no options are specified,
     * Amazon EC2 returns all snapshots for which you have create volume permissions.
     * If you specify one or more snapshot IDs, only snapshots that have the specified IDs are
     * returned. If you specify an invalid snapshot ID, an error is returned. If you specify a
     * snapshot ID for which you do not have access, it is not included in the returned
     * results.
     * If you specify one or more snapshot owners using the OwnerIds option, only
     * snapshots from the specified owners and for which you have access are returned. The results
     * can include the Amazon Web Services account IDs of the specified owners, amazon for snapshots
     * owned by Amazon, or self for snapshots that you own.
     * If you specify a list of restorable users, only snapshots with create snapshot permissions
     * for those users are returned. You can specify Amazon Web Services account IDs (if you own the snapshots),
     * self for snapshots for which you own or have explicit permissions, or
     * all for public snapshots.
     * If you are describing a long list of snapshots, we recommend that you paginate the output to make the
     * list more manageable. The MaxResults parameter sets the maximum number of results
     * returned in a single page. If the list of results exceeds your MaxResults value,
     * then that number of results is returned along with a NextToken value that can be
     * passed to a subsequent DescribeSnapshots request to retrieve the remaining
     * results.
     * To get the state of fast snapshot restores for a snapshot, use DescribeFastSnapshotRestores.
     * For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeSnapshots(input: DescribeSnapshotsRequest): DescribeSnapshotsResponse {
        val op = SdkHttpOperation.build<DescribeSnapshotsRequest, DescribeSnapshotsResponse> {
            serializer = DescribeSnapshotsOperationSerializer()
            deserializer = DescribeSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the data feed for Spot Instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot
     * Instance data feed in the Amazon EC2 User Guide for Linux Instances.
     */
    override suspend fun describeSpotDatafeedSubscription(input: DescribeSpotDatafeedSubscriptionRequest): DescribeSpotDatafeedSubscriptionResponse {
        val op = SdkHttpOperation.build<DescribeSpotDatafeedSubscriptionRequest, DescribeSpotDatafeedSubscriptionResponse> {
            serializer = DescribeSpotDatafeedSubscriptionOperationSerializer()
            deserializer = DescribeSpotDatafeedSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSpotDatafeedSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the running instances for the specified Spot Fleet.
     */
    override suspend fun describeSpotFleetInstances(input: DescribeSpotFleetInstancesRequest): DescribeSpotFleetInstancesResponse {
        val op = SdkHttpOperation.build<DescribeSpotFleetInstancesRequest, DescribeSpotFleetInstancesResponse> {
            serializer = DescribeSpotFleetInstancesOperationSerializer()
            deserializer = DescribeSpotFleetInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSpotFleetInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the events for the specified Spot Fleet request during the specified
     * time.
     * Spot Fleet events are delayed by up to 30 seconds before they can be described. This
     * ensures that you can query by the last evaluated time and not miss a recorded event.
     * Spot Fleet events are available for 48 hours.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon
     * EventBridge in the Amazon EC2 User Guide for Linux Instances.
     */
    override suspend fun describeSpotFleetRequestHistory(input: DescribeSpotFleetRequestHistoryRequest): DescribeSpotFleetRequestHistoryResponse {
        val op = SdkHttpOperation.build<DescribeSpotFleetRequestHistoryRequest, DescribeSpotFleetRequestHistoryResponse> {
            serializer = DescribeSpotFleetRequestHistoryOperationSerializer()
            deserializer = DescribeSpotFleetRequestHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSpotFleetRequestHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes your Spot Fleet requests.
     * Spot Fleet requests are deleted 48 hours after they are canceled and their instances
     * are terminated.
     */
    override suspend fun describeSpotFleetRequests(input: DescribeSpotFleetRequestsRequest): DescribeSpotFleetRequestsResponse {
        val op = SdkHttpOperation.build<DescribeSpotFleetRequestsRequest, DescribeSpotFleetRequestsResponse> {
            serializer = DescribeSpotFleetRequestsOperationSerializer()
            deserializer = DescribeSpotFleetRequestsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSpotFleetRequests"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified Spot Instance requests.
     * You can use DescribeSpotInstanceRequests to find a running Spot Instance by
     * examining the response. If the status of the Spot Instance is fulfilled, the
     * instance ID appears in the response and contains the identifier of the instance.
     * Alternatively, you can use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances">DescribeInstances
     * with a filter to look for instances where the instance lifecycle is
     * spot.
     * We recommend that you set MaxResults to a value between 5 and 1000 to
     * limit the number of results returned. This paginates the output, which makes the list
     * more manageable and returns the results faster. If the list of results exceeds your
     * MaxResults value, then that number of results is returned along with a
     * NextToken value that can be passed to a subsequent
     * DescribeSpotInstanceRequests request to retrieve the remaining
     * results.
     * Spot Instance requests are deleted four hours after they are canceled and their instances are
     * terminated.
     */
    override suspend fun describeSpotInstanceRequests(input: DescribeSpotInstanceRequestsRequest): DescribeSpotInstanceRequestsResponse {
        val op = SdkHttpOperation.build<DescribeSpotInstanceRequestsRequest, DescribeSpotInstanceRequestsResponse> {
            serializer = DescribeSpotInstanceRequestsOperationSerializer()
            deserializer = DescribeSpotInstanceRequestsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSpotInstanceRequests"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the Spot price history. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html">Spot Instance pricing history in the
     * Amazon EC2 User Guide for Linux Instances.
     * When you specify a start and end time, the operation returns the prices of the
     * instance types within that time range. It also returns the last price change before the
     * start time, which is the effective price as of the start time.
     */
    override suspend fun describeSpotPriceHistory(input: DescribeSpotPriceHistoryRequest): DescribeSpotPriceHistoryResponse {
        val op = SdkHttpOperation.build<DescribeSpotPriceHistoryRequest, DescribeSpotPriceHistoryResponse> {
            serializer = DescribeSpotPriceHistoryOperationSerializer()
            deserializer = DescribeSpotPriceHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSpotPriceHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * &#91;VPC only&#93; Describes the stale security group rules for security groups in a specified VPC.
     * Rules are stale when they reference a deleted security group in the same VPC or in a peer VPC,
     * or if they reference a security group in a peer VPC for which the VPC peering connection has
     * been deleted.
     */
    override suspend fun describeStaleSecurityGroups(input: DescribeStaleSecurityGroupsRequest): DescribeStaleSecurityGroupsResponse {
        val op = SdkHttpOperation.build<DescribeStaleSecurityGroupsRequest, DescribeStaleSecurityGroupsResponse> {
            serializer = DescribeStaleSecurityGroupsOperationSerializer()
            deserializer = DescribeStaleSecurityGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStaleSecurityGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the progress of the AMI store tasks. You can describe the store tasks for
     * specified AMIs. If you don't specify the AMIs, you get a paginated list of store tasks from
     * the last 31 days.
     * For each AMI task, the response indicates if the task is InProgress,
     * Completed, or Failed. For tasks InProgress, the
     * response shows the estimated progress as a percentage.
     * Tasks are listed in reverse chronological order. Currently, only tasks from the past 31
     * days can be viewed.
     * To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3 in the
     * Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeStoreImageTasks(input: DescribeStoreImageTasksRequest): DescribeStoreImageTasksResponse {
        val op = SdkHttpOperation.build<DescribeStoreImageTasksRequest, DescribeStoreImageTasksResponse> {
            serializer = DescribeStoreImageTasksOperationSerializer()
            deserializer = DescribeStoreImageTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStoreImageTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your subnets.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and subnets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun describeSubnets(input: DescribeSubnetsRequest): DescribeSubnetsResponse {
        val op = SdkHttpOperation.build<DescribeSubnetsRequest, DescribeSubnetsResponse> {
            serializer = DescribeSubnetsOperationSerializer()
            deserializer = DescribeSubnetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSubnets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified tags for your EC2 resources.
     * For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse {
        val op = SdkHttpOperation.build<DescribeTagsRequest, DescribeTagsResponse> {
            serializer = DescribeTagsOperationSerializer()
            deserializer = DescribeTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Traffic Mirror filters.
     */
    override suspend fun describeTrafficMirrorFilters(input: DescribeTrafficMirrorFiltersRequest): DescribeTrafficMirrorFiltersResponse {
        val op = SdkHttpOperation.build<DescribeTrafficMirrorFiltersRequest, DescribeTrafficMirrorFiltersResponse> {
            serializer = DescribeTrafficMirrorFiltersOperationSerializer()
            deserializer = DescribeTrafficMirrorFiltersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrafficMirrorFilters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.
     */
    override suspend fun describeTrafficMirrorSessions(input: DescribeTrafficMirrorSessionsRequest): DescribeTrafficMirrorSessionsResponse {
        val op = SdkHttpOperation.build<DescribeTrafficMirrorSessionsRequest, DescribeTrafficMirrorSessionsResponse> {
            serializer = DescribeTrafficMirrorSessionsOperationSerializer()
            deserializer = DescribeTrafficMirrorSessionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrafficMirrorSessions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Information about one or more Traffic Mirror targets.
     */
    override suspend fun describeTrafficMirrorTargets(input: DescribeTrafficMirrorTargetsRequest): DescribeTrafficMirrorTargetsResponse {
        val op = SdkHttpOperation.build<DescribeTrafficMirrorTargetsRequest, DescribeTrafficMirrorTargetsResponse> {
            serializer = DescribeTrafficMirrorTargetsOperationSerializer()
            deserializer = DescribeTrafficMirrorTargetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrafficMirrorTargets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more attachments between resources and transit gateways. By default, all attachments are described.
     * Alternatively, you can filter the results by attachment ID, attachment state, resource ID, or resource owner.
     */
    override suspend fun describeTransitGatewayAttachments(input: DescribeTransitGatewayAttachmentsRequest): DescribeTransitGatewayAttachmentsResponse {
        val op = SdkHttpOperation.build<DescribeTransitGatewayAttachmentsRequest, DescribeTransitGatewayAttachmentsResponse> {
            serializer = DescribeTransitGatewayAttachmentsOperationSerializer()
            deserializer = DescribeTransitGatewayAttachmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTransitGatewayAttachments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Connect peers.
     */
    override suspend fun describeTransitGatewayConnectPeers(input: DescribeTransitGatewayConnectPeersRequest): DescribeTransitGatewayConnectPeersResponse {
        val op = SdkHttpOperation.build<DescribeTransitGatewayConnectPeersRequest, DescribeTransitGatewayConnectPeersResponse> {
            serializer = DescribeTransitGatewayConnectPeersOperationSerializer()
            deserializer = DescribeTransitGatewayConnectPeersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTransitGatewayConnectPeers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Connect attachments.
     */
    override suspend fun describeTransitGatewayConnects(input: DescribeTransitGatewayConnectsRequest): DescribeTransitGatewayConnectsResponse {
        val op = SdkHttpOperation.build<DescribeTransitGatewayConnectsRequest, DescribeTransitGatewayConnectsResponse> {
            serializer = DescribeTransitGatewayConnectsOperationSerializer()
            deserializer = DescribeTransitGatewayConnectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTransitGatewayConnects"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more transit gateway multicast domains.
     */
    override suspend fun describeTransitGatewayMulticastDomains(input: DescribeTransitGatewayMulticastDomainsRequest): DescribeTransitGatewayMulticastDomainsResponse {
        val op = SdkHttpOperation.build<DescribeTransitGatewayMulticastDomainsRequest, DescribeTransitGatewayMulticastDomainsResponse> {
            serializer = DescribeTransitGatewayMulticastDomainsOperationSerializer()
            deserializer = DescribeTransitGatewayMulticastDomainsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTransitGatewayMulticastDomains"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes your transit gateway peering attachments.
     */
    override suspend fun describeTransitGatewayPeeringAttachments(input: DescribeTransitGatewayPeeringAttachmentsRequest): DescribeTransitGatewayPeeringAttachmentsResponse {
        val op = SdkHttpOperation.build<DescribeTransitGatewayPeeringAttachmentsRequest, DescribeTransitGatewayPeeringAttachmentsResponse> {
            serializer = DescribeTransitGatewayPeeringAttachmentsOperationSerializer()
            deserializer = DescribeTransitGatewayPeeringAttachmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTransitGatewayPeeringAttachments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more transit gateway route tables. By default, all transit gateway route tables are described.
     * Alternatively, you can filter the results.
     */
    override suspend fun describeTransitGatewayRouteTables(input: DescribeTransitGatewayRouteTablesRequest): DescribeTransitGatewayRouteTablesResponse {
        val op = SdkHttpOperation.build<DescribeTransitGatewayRouteTablesRequest, DescribeTransitGatewayRouteTablesResponse> {
            serializer = DescribeTransitGatewayRouteTablesOperationSerializer()
            deserializer = DescribeTransitGatewayRouteTablesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTransitGatewayRouteTables"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more VPC attachments. By default, all VPC attachments are described.
     * Alternatively, you can filter the results.
     */
    override suspend fun describeTransitGatewayVpcAttachments(input: DescribeTransitGatewayVpcAttachmentsRequest): DescribeTransitGatewayVpcAttachmentsResponse {
        val op = SdkHttpOperation.build<DescribeTransitGatewayVpcAttachmentsRequest, DescribeTransitGatewayVpcAttachmentsResponse> {
            serializer = DescribeTransitGatewayVpcAttachmentsOperationSerializer()
            deserializer = DescribeTransitGatewayVpcAttachmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTransitGatewayVpcAttachments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can
     * filter the results.
     */
    override suspend fun describeTransitGateways(input: DescribeTransitGatewaysRequest): DescribeTransitGatewaysResponse {
        val op = SdkHttpOperation.build<DescribeTransitGatewaysRequest, DescribeTransitGatewaysResponse> {
            serializer = DescribeTransitGatewaysOperationSerializer()
            deserializer = DescribeTransitGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTransitGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This API action is currently in limited preview only.
     * If you are interested in using this feature, contact your account manager.
     * Describes one or more network interface trunk associations.
     */
    override suspend fun describeTrunkInterfaceAssociations(input: DescribeTrunkInterfaceAssociationsRequest): DescribeTrunkInterfaceAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeTrunkInterfaceAssociationsRequest, DescribeTrunkInterfaceAssociationsResponse> {
            serializer = DescribeTrunkInterfaceAssociationsOperationSerializer()
            deserializer = DescribeTrunkInterfaceAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrunkInterfaceAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified attribute of the specified volume. You can specify only one
     * attribute at a time.
     * For more information about EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeVolumeAttribute(input: DescribeVolumeAttributeRequest): DescribeVolumeAttributeResponse {
        val op = SdkHttpOperation.build<DescribeVolumeAttributeRequest, DescribeVolumeAttributeResponse> {
            serializer = DescribeVolumeAttributeOperationSerializer()
            deserializer = DescribeVolumeAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVolumeAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status of the specified volumes. Volume status provides the result of the
     * checks performed on your volumes to determine events that can impair the performance of your
     * volumes. The performance of a volume can be affected if an issue occurs on the volume's
     * underlying host. If the volume's underlying host experiences a power outage or system issue,
     * after the system is restored, there could be data inconsistencies on the volume. Volume events
     * notify you if this occurs. Volume actions notify you if any action needs to be taken in
     * response to the event.
     * The DescribeVolumeStatus operation provides the following information about
     * the specified volumes:
     * Status: Reflects the current status of the volume. The possible
     * values are ok, impaired , warning, or
     * insufficient-data. If all checks pass, the overall status of the volume is
     * ok. If the check fails, the overall status is impaired. If the
     * status is insufficient-data, then the checks might still be taking place on your
     * volume at the time. We recommend that you retry the request. For more information about volume
     * status, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html">Monitor the status of your volumes in the
     * Amazon Elastic Compute Cloud User Guide.
     * Events: Reflect the cause of a volume status and might require you to
     * take action. For example, if your volume returns an impaired status, then the
     * volume event might be potential-data-inconsistency. This means that your volume
     * has been affected by an issue with the underlying host, has all I/O operations disabled, and
     * might have inconsistent data.
     * Actions: Reflect the actions you might have to take in response to an
     * event. For example, if the status of the volume is impaired and the volume event
     * shows potential-data-inconsistency, then the action shows
     * enable-volume-io. This means that you may want to enable the I/O operations for
     * the volume by calling the EnableVolumeIO action and then check the volume
     * for data consistency.
     * Volume status is based on the volume status checks, and does not reflect the volume state.
     * Therefore, volume status does not indicate volumes in the error state (for
     * example, when a volume is incapable of accepting I/O.)
     */
    override suspend fun describeVolumeStatus(input: DescribeVolumeStatusRequest): DescribeVolumeStatusResponse {
        val op = SdkHttpOperation.build<DescribeVolumeStatusRequest, DescribeVolumeStatusResponse> {
            serializer = DescribeVolumeStatusOperationSerializer()
            deserializer = DescribeVolumeStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVolumeStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified EBS volumes or all of your EBS volumes.
     * If you are describing a long list of volumes, we recommend that you paginate the output to make the list
     * more manageable. The MaxResults parameter sets the maximum number of results
     * returned in a single page. If the list of results exceeds your MaxResults value,
     * then that number of results is returned along with a NextToken value that can be
     * passed to a subsequent DescribeVolumes request to retrieve the remaining
     * results.
     * For more information about EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeVolumes(input: DescribeVolumesRequest): DescribeVolumesResponse {
        val op = SdkHttpOperation.build<DescribeVolumesRequest, DescribeVolumesResponse> {
            serializer = DescribeVolumesOperationSerializer()
            deserializer = DescribeVolumesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVolumes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the most recent volume modification request for the specified EBS volumes.
     * If a volume has never been modified, some information in the output will be null.
     * If a volume has been modified more than once, the output includes only the most
     * recent modification request.
     * You can also use CloudWatch Events to check the status of a modification to an EBS
     * volume. For information about CloudWatch Events, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon CloudWatch Events User Guide. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-modifications.html">Monitor the progress of volume modifications in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeVolumesModifications(input: DescribeVolumesModificationsRequest): DescribeVolumesModificationsResponse {
        val op = SdkHttpOperation.build<DescribeVolumesModificationsRequest, DescribeVolumesModificationsResponse> {
            serializer = DescribeVolumesModificationsOperationSerializer()
            deserializer = DescribeVolumesModificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVolumesModifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.
     */
    override suspend fun describeVpcAttribute(input: DescribeVpcAttributeRequest): DescribeVpcAttributeResponse {
        val op = SdkHttpOperation.build<DescribeVpcAttributeRequest, DescribeVpcAttributeResponse> {
            serializer = DescribeVpcAttributeOperationSerializer()
            deserializer = DescribeVpcAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the ClassicLink status of one or more VPCs.
     */
    override suspend fun describeVpcClassicLink(input: DescribeVpcClassicLinkRequest): DescribeVpcClassicLinkResponse {
        val op = SdkHttpOperation.build<DescribeVpcClassicLinkRequest, DescribeVpcClassicLinkResponse> {
            serializer = DescribeVpcClassicLinkOperationSerializer()
            deserializer = DescribeVpcClassicLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcClassicLink"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS
     * hostname of a linked EC2-Classic instance resolves to its private IP address when
     * addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname
     * of an instance in a VPC resolves to its private IP address when addressed from a linked
     * EC2-Classic instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun describeVpcClassicLinkDnsSupport(input: DescribeVpcClassicLinkDnsSupportRequest): DescribeVpcClassicLinkDnsSupportResponse {
        val op = SdkHttpOperation.build<DescribeVpcClassicLinkDnsSupportRequest, DescribeVpcClassicLinkDnsSupportResponse> {
            serializer = DescribeVpcClassicLinkDnsSupportOperationSerializer()
            deserializer = DescribeVpcClassicLinkDnsSupportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcClassicLinkDnsSupport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the connection notifications for VPC endpoints and VPC endpoint
     * services.
     */
    override suspend fun describeVpcEndpointConnectionNotifications(input: DescribeVpcEndpointConnectionNotificationsRequest): DescribeVpcEndpointConnectionNotificationsResponse {
        val op = SdkHttpOperation.build<DescribeVpcEndpointConnectionNotificationsRequest, DescribeVpcEndpointConnectionNotificationsResponse> {
            serializer = DescribeVpcEndpointConnectionNotificationsOperationSerializer()
            deserializer = DescribeVpcEndpointConnectionNotificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcEndpointConnectionNotifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the VPC endpoint connections to your VPC endpoint services, including any
     * endpoints that are pending your acceptance.
     */
    override suspend fun describeVpcEndpointConnections(input: DescribeVpcEndpointConnectionsRequest): DescribeVpcEndpointConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeVpcEndpointConnectionsRequest, DescribeVpcEndpointConnectionsResponse> {
            serializer = DescribeVpcEndpointConnectionsOperationSerializer()
            deserializer = DescribeVpcEndpointConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcEndpointConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the VPC endpoint service configurations in your account (your services).
     */
    override suspend fun describeVpcEndpointServiceConfigurations(input: DescribeVpcEndpointServiceConfigurationsRequest): DescribeVpcEndpointServiceConfigurationsResponse {
        val op = SdkHttpOperation.build<DescribeVpcEndpointServiceConfigurationsRequest, DescribeVpcEndpointServiceConfigurationsResponse> {
            serializer = DescribeVpcEndpointServiceConfigurationsOperationSerializer()
            deserializer = DescribeVpcEndpointServiceConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcEndpointServiceConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the principals (service consumers) that are permitted to discover your VPC
     * endpoint service.
     */
    override suspend fun describeVpcEndpointServicePermissions(input: DescribeVpcEndpointServicePermissionsRequest): DescribeVpcEndpointServicePermissionsResponse {
        val op = SdkHttpOperation.build<DescribeVpcEndpointServicePermissionsRequest, DescribeVpcEndpointServicePermissionsResponse> {
            serializer = DescribeVpcEndpointServicePermissionsOperationSerializer()
            deserializer = DescribeVpcEndpointServicePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcEndpointServicePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes available services to which you can create a VPC endpoint.
     * When the service provider and the consumer have different accounts in multiple
     * Availability Zones, and the consumer views the VPC endpoint service information, the
     * response only includes the common Availability Zones. For example, when the service
     * provider account uses us-east-1a and us-east-1c and the
     * consumer uses us-east-1a and us-east-1b, the response includes
     * the VPC endpoint services in the common Availability Zone,
     * us-east-1a.
     */
    override suspend fun describeVpcEndpointServices(input: DescribeVpcEndpointServicesRequest): DescribeVpcEndpointServicesResponse {
        val op = SdkHttpOperation.build<DescribeVpcEndpointServicesRequest, DescribeVpcEndpointServicesResponse> {
            serializer = DescribeVpcEndpointServicesOperationSerializer()
            deserializer = DescribeVpcEndpointServicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcEndpointServices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your VPC endpoints.
     */
    override suspend fun describeVpcEndpoints(input: DescribeVpcEndpointsRequest): DescribeVpcEndpointsResponse {
        val op = SdkHttpOperation.build<DescribeVpcEndpointsRequest, DescribeVpcEndpointsResponse> {
            serializer = DescribeVpcEndpointsOperationSerializer()
            deserializer = DescribeVpcEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your VPC peering connections.
     */
    override suspend fun describeVpcPeeringConnections(input: DescribeVpcPeeringConnectionsRequest): DescribeVpcPeeringConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeVpcPeeringConnectionsRequest, DescribeVpcPeeringConnectionsResponse> {
            serializer = DescribeVpcPeeringConnectionsOperationSerializer()
            deserializer = DescribeVpcPeeringConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcPeeringConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your VPCs.
     */
    override suspend fun describeVpcs(input: DescribeVpcsRequest): DescribeVpcsResponse {
        val op = SdkHttpOperation.build<DescribeVpcsRequest, DescribeVpcsResponse> {
            serializer = DescribeVpcsOperationSerializer()
            deserializer = DescribeVpcsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpcs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your VPN connections.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    override suspend fun describeVpnConnections(input: DescribeVpnConnectionsRequest): DescribeVpnConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeVpnConnectionsRequest, DescribeVpnConnectionsResponse> {
            serializer = DescribeVpnConnectionsOperationSerializer()
            deserializer = DescribeVpnConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpnConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your virtual private gateways.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    override suspend fun describeVpnGateways(input: DescribeVpnGatewaysRequest): DescribeVpnGatewaysResponse {
        val op = SdkHttpOperation.build<DescribeVpnGatewaysRequest, DescribeVpnGatewaysResponse> {
            serializer = DescribeVpnGatewaysOperationSerializer()
            deserializer = DescribeVpnGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVpnGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it's stopped.
     */
    override suspend fun detachClassicLinkVpc(input: DetachClassicLinkVpcRequest): DetachClassicLinkVpcResponse {
        val op = SdkHttpOperation.build<DetachClassicLinkVpcRequest, DetachClassicLinkVpcResponse> {
            serializer = DetachClassicLinkVpcOperationSerializer()
            deserializer = DetachClassicLinkVpcOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachClassicLinkVpc"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches an internet gateway from a VPC, disabling connectivity between the internet
     * and the VPC. The VPC must not contain any running instances with Elastic IP addresses or
     * public IPv4 addresses.
     */
    override suspend fun detachInternetGateway(input: DetachInternetGatewayRequest): DetachInternetGatewayResponse {
        val op = SdkHttpOperation.build<DetachInternetGatewayRequest, DetachInternetGatewayResponse> {
            serializer = DetachInternetGatewayOperationSerializer()
            deserializer = DetachInternetGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachInternetGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a network interface from an instance.
     */
    override suspend fun detachNetworkInterface(input: DetachNetworkInterfaceRequest): DetachNetworkInterfaceResponse {
        val op = SdkHttpOperation.build<DetachNetworkInterfaceRequest, DetachNetworkInterfaceResponse> {
            serializer = DetachNetworkInterfaceOperationSerializer()
            deserializer = DetachNetworkInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachNetworkInterface"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches an EBS volume from an instance. Make sure to unmount any file systems on the
     * device within your operating system before detaching the volume. Failure to do so can result
     * in the volume becoming stuck in the busy state while detaching. If this happens,
     * detachment can be delayed indefinitely until you unmount the volume, force detachment, reboot
     * the instance, or all three. If an EBS volume is the root device of an instance, it can't be
     * detached while the instance is running. To detach the root volume, stop the instance
     * first.
     * When a volume with an Amazon Web Services Marketplace product code is detached from an instance, the
     * product code is no longer associated with the instance.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html">Detach an Amazon EBS volume in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun detachVolume(input: DetachVolumeRequest): DetachVolumeResponse {
        val op = SdkHttpOperation.build<DetachVolumeRequest, DetachVolumeResponse> {
            serializer = DetachVolumeOperationSerializer()
            deserializer = DetachVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a virtual private gateway from a VPC. You do this if you're planning to turn
     * off the VPC and not use it anymore. You can confirm a virtual private gateway has been
     * completely detached from a VPC by describing the virtual private gateway (any
     * attachments to the virtual private gateway are also described).
     * You must wait for the attachment's state to switch to detached before you
     * can delete the VPC or attach a different VPC to the virtual private gateway.
     */
    override suspend fun detachVpnGateway(input: DetachVpnGatewayRequest): DetachVpnGatewayResponse {
        val op = SdkHttpOperation.build<DetachVpnGatewayRequest, DetachVpnGatewayResponse> {
            serializer = DetachVpnGatewayOperationSerializer()
            deserializer = DetachVpnGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachVpnGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables EBS encryption by default for your account in the current Region.
     * After you disable encryption by default, you can still create encrypted volumes by
     * enabling encryption when you create each volume.
     * Disabling encryption by default does not change the encryption status of your
     * existing volumes.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun disableEbsEncryptionByDefault(input: DisableEbsEncryptionByDefaultRequest): DisableEbsEncryptionByDefaultResponse {
        val op = SdkHttpOperation.build<DisableEbsEncryptionByDefaultRequest, DisableEbsEncryptionByDefaultResponse> {
            serializer = DisableEbsEncryptionByDefaultOperationSerializer()
            deserializer = DisableEbsEncryptionByDefaultOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableEbsEncryptionByDefault"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Discontinue faster launching for a Windows AMI, and clean up existing pre-provisioned snapshots.
     * When you disable faster launching, the AMI uses the standard launch process for each
     * instance. All pre-provisioned snapshots must be removed before you can enable faster launching again.
     */
    override suspend fun disableFastLaunch(input: DisableFastLaunchRequest): DisableFastLaunchResponse {
        val op = SdkHttpOperation.build<DisableFastLaunchRequest, DisableFastLaunchResponse> {
            serializer = DisableFastLaunchOperationSerializer()
            deserializer = DisableFastLaunchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableFastLaunch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables fast snapshot restores for the specified snapshots in the specified Availability Zones.
     */
    override suspend fun disableFastSnapshotRestores(input: DisableFastSnapshotRestoresRequest): DisableFastSnapshotRestoresResponse {
        val op = SdkHttpOperation.build<DisableFastSnapshotRestoresRequest, DisableFastSnapshotRestoresResponse> {
            serializer = DisableFastSnapshotRestoresOperationSerializer()
            deserializer = DisableFastSnapshotRestoresOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableFastSnapshotRestores"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the deprecation of the specified AMI.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deprecate.html">Deprecate an AMI in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun disableImageDeprecation(input: DisableImageDeprecationRequest): DisableImageDeprecationResponse {
        val op = SdkHttpOperation.build<DisableImageDeprecationRequest, DisableImageDeprecationResponse> {
            serializer = DisableImageDeprecationOperationSerializer()
            deserializer = DisableImageDeprecationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableImageDeprecation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disable the IPAM account. For more information, see <a href="/vpc/latest/ipam/enable-integ-ipam.html">Enable integration with Organizations in the Amazon VPC IPAM User Guide.
     */
    override suspend fun disableIpamOrganizationAdminAccount(input: DisableIpamOrganizationAdminAccountRequest): DisableIpamOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<DisableIpamOrganizationAdminAccountRequest, DisableIpamOrganizationAdminAccountResponse> {
            serializer = DisableIpamOrganizationAdminAccountOperationSerializer()
            deserializer = DisableIpamOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableIpamOrganizationAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables access to the EC2 serial console of all instances for your account. By default,
     * access to the EC2 serial console is disabled for your account. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console in the Amazon EC2
     * User Guide.
     */
    override suspend fun disableSerialConsoleAccess(input: DisableSerialConsoleAccessRequest): DisableSerialConsoleAccessResponse {
        val op = SdkHttpOperation.build<DisableSerialConsoleAccessRequest, DisableSerialConsoleAccessResponse> {
            serializer = DisableSerialConsoleAccessOperationSerializer()
            deserializer = DisableSerialConsoleAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableSerialConsoleAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the specified resource attachment from propagating routes to the specified
     * propagation route table.
     */
    override suspend fun disableTransitGatewayRouteTablePropagation(input: DisableTransitGatewayRouteTablePropagationRequest): DisableTransitGatewayRouteTablePropagationResponse {
        val op = SdkHttpOperation.build<DisableTransitGatewayRouteTablePropagationRequest, DisableTransitGatewayRouteTablePropagationResponse> {
            serializer = DisableTransitGatewayRouteTablePropagationOperationSerializer()
            deserializer = DisableTransitGatewayRouteTablePropagationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableTransitGatewayRouteTablePropagation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables a virtual private gateway (VGW) from propagating routes to a specified route
     * table of a VPC.
     */
    override suspend fun disableVgwRoutePropagation(input: DisableVgwRoutePropagationRequest): DisableVgwRoutePropagationResponse {
        val op = SdkHttpOperation.build<DisableVgwRoutePropagationRequest, DisableVgwRoutePropagationResponse> {
            serializer = DisableVgwRoutePropagationOperationSerializer()
            deserializer = DisableVgwRoutePropagationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableVgwRoutePropagation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to it.
     */
    override suspend fun disableVpcClassicLink(input: DisableVpcClassicLinkRequest): DisableVpcClassicLinkResponse {
        val op = SdkHttpOperation.build<DisableVpcClassicLinkRequest, DisableVpcClassicLinkResponse> {
            serializer = DisableVpcClassicLinkOperationSerializer()
            deserializer = DisableVpcClassicLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableVpcClassicLink"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve to
     * public IP addresses when addressed between a linked EC2-Classic instance and instances
     * in the VPC to which it's linked. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the
     * Amazon Elastic Compute Cloud User Guide.
     * You must specify a VPC ID in the request.
     */
    override suspend fun disableVpcClassicLinkDnsSupport(input: DisableVpcClassicLinkDnsSupportRequest): DisableVpcClassicLinkDnsSupportResponse {
        val op = SdkHttpOperation.build<DisableVpcClassicLinkDnsSupportRequest, DisableVpcClassicLinkDnsSupportResponse> {
            serializer = DisableVpcClassicLinkDnsSupportOperationSerializer()
            deserializer = DisableVpcClassicLinkDnsSupportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableVpcClassicLinkDnsSupport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an Elastic IP address from the instance or network interface it's associated with.
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     * Addresses in the Amazon Elastic Compute Cloud User Guide.
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     */
    override suspend fun disassociateAddress(input: DisassociateAddressRequest): DisassociateAddressResponse {
        val op = SdkHttpOperation.build<DisassociateAddressRequest, DisassociateAddressResponse> {
            serializer = DisassociateAddressOperationSerializer()
            deserializer = DisassociateAddressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateAddress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a target network from the specified Client VPN endpoint. When you disassociate the
     * last target network from a Client VPN, the following happens:
     * The route that was automatically added for the VPC is deleted
     * All active client connections are terminated
     * New client connections are disallowed
     * The Client VPN endpoint's status changes to pending-associate
     */
    override suspend fun disassociateClientVpnTargetNetwork(input: DisassociateClientVpnTargetNetworkRequest): DisassociateClientVpnTargetNetworkResponse {
        val op = SdkHttpOperation.build<DisassociateClientVpnTargetNetworkRequest, DisassociateClientVpnTargetNetworkResponse> {
            serializer = DisassociateClientVpnTargetNetworkOperationSerializer()
            deserializer = DisassociateClientVpnTargetNetworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateClientVpnTargetNetwork"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an IAM role from an Certificate Manager (ACM) certificate. Disassociating an IAM role
     * from an ACM certificate removes the Amazon S3 object that contains the certificate, certificate chain, and
     * encrypted private key from the Amazon S3 bucket. It also revokes the IAM role's permission to use the
     * KMS key used to encrypt the private key. This effectively revokes the role's permission
     * to use the certificate.
     */
    override suspend fun disassociateEnclaveCertificateIamRole(input: DisassociateEnclaveCertificateIamRoleRequest): DisassociateEnclaveCertificateIamRoleResponse {
        val op = SdkHttpOperation.build<DisassociateEnclaveCertificateIamRoleRequest, DisassociateEnclaveCertificateIamRoleResponse> {
            serializer = DisassociateEnclaveCertificateIamRoleOperationSerializer()
            deserializer = DisassociateEnclaveCertificateIamRoleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateEnclaveCertificateIamRole"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an IAM instance profile from a running or stopped instance.
     * Use DescribeIamInstanceProfileAssociations to get the association
     * ID.
     */
    override suspend fun disassociateIamInstanceProfile(input: DisassociateIamInstanceProfileRequest): DisassociateIamInstanceProfileResponse {
        val op = SdkHttpOperation.build<DisassociateIamInstanceProfileRequest, DisassociateIamInstanceProfileResponse> {
            serializer = DisassociateIamInstanceProfileOperationSerializer()
            deserializer = DisassociateIamInstanceProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateIamInstanceProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates one or more targets from an event window.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    override suspend fun disassociateInstanceEventWindow(input: DisassociateInstanceEventWindowRequest): DisassociateInstanceEventWindowResponse {
        val op = SdkHttpOperation.build<DisassociateInstanceEventWindowRequest, DisassociateInstanceEventWindowResponse> {
            serializer = DisassociateInstanceEventWindowOperationSerializer()
            deserializer = DisassociateInstanceEventWindowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateInstanceEventWindow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a subnet or gateway from a route table.
     * After you perform this action, the subnet no longer uses the routes in the route table.
     * Instead, it uses the routes in the VPC's main route table. For more information
     * about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables in the Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun disassociateRouteTable(input: DisassociateRouteTableRequest): DisassociateRouteTableResponse {
        val op = SdkHttpOperation.build<DisassociateRouteTableRequest, DisassociateRouteTableResponse> {
            serializer = DisassociateRouteTableOperationSerializer()
            deserializer = DisassociateRouteTableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateRouteTable"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a CIDR block from a subnet. Currently, you can disassociate an IPv6 CIDR block only. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it.
     */
    override suspend fun disassociateSubnetCidrBlock(input: DisassociateSubnetCidrBlockRequest): DisassociateSubnetCidrBlockResponse {
        val op = SdkHttpOperation.build<DisassociateSubnetCidrBlockRequest, DisassociateSubnetCidrBlockResponse> {
            serializer = DisassociateSubnetCidrBlockOperationSerializer()
            deserializer = DisassociateSubnetCidrBlockOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateSubnetCidrBlock"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified subnets from the transit gateway multicast domain.
     */
    override suspend fun disassociateTransitGatewayMulticastDomain(input: DisassociateTransitGatewayMulticastDomainRequest): DisassociateTransitGatewayMulticastDomainResponse {
        val op = SdkHttpOperation.build<DisassociateTransitGatewayMulticastDomainRequest, DisassociateTransitGatewayMulticastDomainResponse> {
            serializer = DisassociateTransitGatewayMulticastDomainOperationSerializer()
            deserializer = DisassociateTransitGatewayMulticastDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateTransitGatewayMulticastDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a resource attachment from a transit gateway route table.
     */
    override suspend fun disassociateTransitGatewayRouteTable(input: DisassociateTransitGatewayRouteTableRequest): DisassociateTransitGatewayRouteTableResponse {
        val op = SdkHttpOperation.build<DisassociateTransitGatewayRouteTableRequest, DisassociateTransitGatewayRouteTableResponse> {
            serializer = DisassociateTransitGatewayRouteTableOperationSerializer()
            deserializer = DisassociateTransitGatewayRouteTableOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateTransitGatewayRouteTable"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This API action is currently in limited preview only.
     * If you are interested in using this feature, contact your account manager.
     * Removes an association between a branch network interface with a trunk network interface.
     */
    override suspend fun disassociateTrunkInterface(input: DisassociateTrunkInterfaceRequest): DisassociateTrunkInterfaceResponse {
        val op = SdkHttpOperation.build<DisassociateTrunkInterfaceRequest, DisassociateTrunkInterfaceResponse> {
            serializer = DisassociateTrunkInterfaceOperationSerializer()
            deserializer = DisassociateTrunkInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateTrunkInterface"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a CIDR block from a VPC. To disassociate the CIDR block, you must
     * specify its association ID. You can get the association ID by using
     * DescribeVpcs. You must detach or delete all gateways and resources that
     * are associated with the CIDR block before you can disassociate it.
     * You cannot disassociate the CIDR block with which you originally created the VPC (the
     * primary CIDR block).
     */
    override suspend fun disassociateVpcCidrBlock(input: DisassociateVpcCidrBlockRequest): DisassociateVpcCidrBlockResponse {
        val op = SdkHttpOperation.build<DisassociateVpcCidrBlockRequest, DisassociateVpcCidrBlockResponse> {
            serializer = DisassociateVpcCidrBlockOperationSerializer()
            deserializer = DisassociateVpcCidrBlockOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateVpcCidrBlock"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables EBS encryption by default for your account in the current Region.
     * After you enable encryption by default, the EBS volumes that you create are
     * always encrypted, either using the default KMS key or the KMS key that you specified
     * when you created each volume. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the
     * Amazon Elastic Compute Cloud User Guide.
     * You can specify the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId
     * or ResetEbsDefaultKmsKeyId.
     * Enabling encryption by default has no effect on the encryption status of your
     * existing volumes.
     * After you enable encryption by default, you can no longer launch instances
     * using instance types that do not support encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported
     * instance types.
     */
    override suspend fun enableEbsEncryptionByDefault(input: EnableEbsEncryptionByDefaultRequest): EnableEbsEncryptionByDefaultResponse {
        val op = SdkHttpOperation.build<EnableEbsEncryptionByDefaultRequest, EnableEbsEncryptionByDefaultResponse> {
            serializer = EnableEbsEncryptionByDefaultOperationSerializer()
            deserializer = EnableEbsEncryptionByDefaultOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableEbsEncryptionByDefault"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * When you enable faster launching for a Windows AMI, images are pre-provisioned,
     * using snapshots to launch instances up to 65% faster. To create the optimized Windows
     * image, Amazon EC2 launches an instance and runs through Sysprep steps, rebooting as required.
     * Then it creates a set of reserved snapshots that are used for subsequent launches. The
     * reserved snapshots are automatically replenished as they are used, depending on your
     * settings for launch frequency.
     */
    override suspend fun enableFastLaunch(input: EnableFastLaunchRequest): EnableFastLaunchResponse {
        val op = SdkHttpOperation.build<EnableFastLaunchRequest, EnableFastLaunchResponse> {
            serializer = EnableFastLaunchOperationSerializer()
            deserializer = EnableFastLaunchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableFastLaunch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables fast snapshot restores for the specified snapshots in the specified Availability Zones.
     * You get the full benefit of fast snapshot restores after they enter the enabled state.
     * To get the current state of fast snapshot restores, use DescribeFastSnapshotRestores.
     * To disable fast snapshot restores, use DisableFastSnapshotRestores.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-fast-snapshot-restore.html">Amazon EBS fast snapshot
     * restore in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun enableFastSnapshotRestores(input: EnableFastSnapshotRestoresRequest): EnableFastSnapshotRestoresResponse {
        val op = SdkHttpOperation.build<EnableFastSnapshotRestoresRequest, EnableFastSnapshotRestoresResponse> {
            serializer = EnableFastSnapshotRestoresOperationSerializer()
            deserializer = EnableFastSnapshotRestoresOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableFastSnapshotRestores"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables deprecation of the specified AMI at the specified date and time.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deprecate.html">Deprecate an AMI in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun enableImageDeprecation(input: EnableImageDeprecationRequest): EnableImageDeprecationResponse {
        val op = SdkHttpOperation.build<EnableImageDeprecationRequest, EnableImageDeprecationResponse> {
            serializer = EnableImageDeprecationOperationSerializer()
            deserializer = EnableImageDeprecationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableImageDeprecation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enable an Organizations member account as the IPAM admin account. You cannot select the Organizations management account as the IPAM admin account. For more information, see <a href="/vpc/latest/ipam/enable-integ-ipam.html">Enable integration with Organizations in the Amazon VPC IPAM User Guide.
     */
    override suspend fun enableIpamOrganizationAdminAccount(input: EnableIpamOrganizationAdminAccountRequest): EnableIpamOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<EnableIpamOrganizationAdminAccountRequest, EnableIpamOrganizationAdminAccountResponse> {
            serializer = EnableIpamOrganizationAdminAccountOperationSerializer()
            deserializer = EnableIpamOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableIpamOrganizationAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables access to the EC2 serial console of all instances for your account. By default,
     * access to the EC2 serial console is disabled for your account. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console
     * in the Amazon EC2 User Guide.
     */
    override suspend fun enableSerialConsoleAccess(input: EnableSerialConsoleAccessRequest): EnableSerialConsoleAccessResponse {
        val op = SdkHttpOperation.build<EnableSerialConsoleAccessRequest, EnableSerialConsoleAccessResponse> {
            serializer = EnableSerialConsoleAccessOperationSerializer()
            deserializer = EnableSerialConsoleAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableSerialConsoleAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables the specified attachment to propagate routes to the specified
     * propagation route table.
     */
    override suspend fun enableTransitGatewayRouteTablePropagation(input: EnableTransitGatewayRouteTablePropagationRequest): EnableTransitGatewayRouteTablePropagationResponse {
        val op = SdkHttpOperation.build<EnableTransitGatewayRouteTablePropagationRequest, EnableTransitGatewayRouteTablePropagationResponse> {
            serializer = EnableTransitGatewayRouteTablePropagationOperationSerializer()
            deserializer = EnableTransitGatewayRouteTablePropagationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableTransitGatewayRouteTablePropagation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables a virtual private gateway (VGW) to propagate routes to the specified route
     * table of a VPC.
     */
    override suspend fun enableVgwRoutePropagation(input: EnableVgwRoutePropagationRequest): EnableVgwRoutePropagationResponse {
        val op = SdkHttpOperation.build<EnableVgwRoutePropagationRequest, EnableVgwRoutePropagationResponse> {
            serializer = EnableVgwRoutePropagationOperationSerializer()
            deserializer = EnableVgwRoutePropagationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableVgwRoutePropagation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables I/O operations for a volume that had I/O operations disabled because the data on
     * the volume was potentially inconsistent.
     */
    override suspend fun enableVolumeIo(input: EnableVolumeIoRequest): EnableVolumeIoResponse {
        val op = SdkHttpOperation.build<EnableVolumeIoRequest, EnableVolumeIoResponse> {
            serializer = EnableVolumeIOOperationSerializer()
            deserializer = EnableVolumeIOOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableVolumeIO"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your
     * ClassicLink-enabled VPC to allow communication over private IP addresses. You cannot
     * enable your VPC for ClassicLink if any of your VPC route tables have existing routes for
     * address ranges within the 10.0.0.0/8 IP address range, excluding local
     * routes for VPCs in the 10.0.0.0/16 and 10.1.0.0/16 IP address
     * ranges. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun enableVpcClassicLink(input: EnableVpcClassicLinkRequest): EnableVpcClassicLinkResponse {
        val op = SdkHttpOperation.build<EnableVpcClassicLinkRequest, EnableVpcClassicLinkResponse> {
            serializer = EnableVpcClassicLinkOperationSerializer()
            deserializer = EnableVpcClassicLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableVpcClassicLink"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled, the DNS
     * hostname of a linked EC2-Classic instance resolves to its private IP address when
     * addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname
     * of an instance in a VPC resolves to its private IP address when addressed from a linked
     * EC2-Classic instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the
     * Amazon Elastic Compute Cloud User Guide.
     * You must specify a VPC ID in the request.
     */
    override suspend fun enableVpcClassicLinkDnsSupport(input: EnableVpcClassicLinkDnsSupportRequest): EnableVpcClassicLinkDnsSupportResponse {
        val op = SdkHttpOperation.build<EnableVpcClassicLinkDnsSupportRequest, EnableVpcClassicLinkDnsSupportResponse> {
            serializer = EnableVpcClassicLinkDnsSupportOperationSerializer()
            deserializer = EnableVpcClassicLinkDnsSupportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableVpcClassicLinkDnsSupport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Downloads the client certificate revocation list for the specified Client VPN endpoint.
     */
    override suspend fun exportClientVpnClientCertificateRevocationList(input: ExportClientVpnClientCertificateRevocationListRequest): ExportClientVpnClientCertificateRevocationListResponse {
        val op = SdkHttpOperation.build<ExportClientVpnClientCertificateRevocationListRequest, ExportClientVpnClientCertificateRevocationListResponse> {
            serializer = ExportClientVpnClientCertificateRevocationListOperationSerializer()
            deserializer = ExportClientVpnClientCertificateRevocationListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportClientVpnClientCertificateRevocationList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Downloads the contents of the Client VPN endpoint configuration file for the specified Client VPN endpoint. The Client VPN endpoint configuration
     * file includes the Client VPN endpoint and certificate information clients need to establish a connection
     * with the Client VPN endpoint.
     */
    override suspend fun exportClientVpnClientConfiguration(input: ExportClientVpnClientConfigurationRequest): ExportClientVpnClientConfigurationResponse {
        val op = SdkHttpOperation.build<ExportClientVpnClientConfigurationRequest, ExportClientVpnClientConfigurationResponse> {
            serializer = ExportClientVpnClientConfigurationOperationSerializer()
            deserializer = ExportClientVpnClientConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportClientVpnClientConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Exports an Amazon Machine Image (AMI) to a VM file. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport_image.html">Exporting a VM
     * directly from an Amazon Machine Image (AMI) in the
     * VM Import/Export User Guide.
     */
    override suspend fun exportImage(input: ExportImageRequest): ExportImageResponse {
        val op = SdkHttpOperation.build<ExportImageRequest, ExportImageResponse> {
            serializer = ExportImageOperationSerializer()
            deserializer = ExportImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Exports routes from the specified transit gateway route table to the specified S3 bucket.
     * By default, all routes are exported. Alternatively, you can filter by CIDR range.
     * The routes are saved to the specified bucket in a JSON file. For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-route-tables.html#tgw-export-route-tables">Export Route Tables
     * to Amazon S3 in Transit Gateways.
     */
    override suspend fun exportTransitGatewayRoutes(input: ExportTransitGatewayRoutesRequest): ExportTransitGatewayRoutesResponse {
        val op = SdkHttpOperation.build<ExportTransitGatewayRoutesRequest, ExportTransitGatewayRoutesResponse> {
            serializer = ExportTransitGatewayRoutesOperationSerializer()
            deserializer = ExportTransitGatewayRoutesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportTransitGatewayRoutes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the IAM roles that are associated with the specified ACM (ACM) certificate.
     * It also returns the name of the Amazon S3 bucket and the Amazon S3 object key where the certificate,
     * certificate chain, and encrypted private key bundle are stored, and the ARN of the KMS key
     * that's used to encrypt the private key.
     */
    override suspend fun getAssociatedEnclaveCertificateIamRoles(input: GetAssociatedEnclaveCertificateIamRolesRequest): GetAssociatedEnclaveCertificateIamRolesResponse {
        val op = SdkHttpOperation.build<GetAssociatedEnclaveCertificateIamRolesRequest, GetAssociatedEnclaveCertificateIamRolesResponse> {
            serializer = GetAssociatedEnclaveCertificateIamRolesOperationSerializer()
            deserializer = GetAssociatedEnclaveCertificateIamRolesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssociatedEnclaveCertificateIamRoles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the IPv6 CIDR block associations for a specified IPv6 address pool.
     */
    override suspend fun getAssociatedIpv6PoolCidrs(input: GetAssociatedIpv6PoolCidrsRequest): GetAssociatedIpv6PoolCidrsResponse {
        val op = SdkHttpOperation.build<GetAssociatedIpv6PoolCidrsRequest, GetAssociatedIpv6PoolCidrsResponse> {
            serializer = GetAssociatedIpv6PoolCidrsOperationSerializer()
            deserializer = GetAssociatedIpv6PoolCidrsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssociatedIpv6PoolCidrs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets usage information about a Capacity Reservation. If the Capacity Reservation is shared, it shows usage information for the Capacity Reservation owner
     * and each Amazon Web Services account that is currently using the shared capacity. If the Capacity Reservation is not shared, it shows only
     * the Capacity Reservation owner's usage.
     */
    override suspend fun getCapacityReservationUsage(input: GetCapacityReservationUsageRequest): GetCapacityReservationUsageResponse {
        val op = SdkHttpOperation.build<GetCapacityReservationUsageRequest, GetCapacityReservationUsageResponse> {
            serializer = GetCapacityReservationUsageOperationSerializer()
            deserializer = GetCapacityReservationUsageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCapacityReservationUsage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the allocations from the specified customer-owned address pool.
     */
    override suspend fun getCoipPoolUsage(input: GetCoipPoolUsageRequest): GetCoipPoolUsageResponse {
        val op = SdkHttpOperation.build<GetCoipPoolUsageRequest, GetCoipPoolUsageResponse> {
            serializer = GetCoipPoolUsageOperationSerializer()
            deserializer = GetCoipPoolUsageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCoipPoolUsage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the console output for the specified instance. For Linux instances, the instance
     * console output displays the exact console output that would normally be displayed on a
     * physical monitor attached to a computer. For Windows instances, the instance console
     * output includes the last three system event log errors.
     * By default, the console output returns buffered information that was posted shortly
     * after an instance transition state (start, stop, reboot, or terminate). This information
     * is available for at least one hour after the most recent post. Only the most recent 64
     * KB of console output is available.
     * You can optionally retrieve the latest serial console output at any time during the
     * instance lifecycle. This option is supported on instance types that use the Nitro
     * hypervisor.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html#instance-console-console-output">Instance
     * console output in the Amazon EC2 User Guide.
     */
    override suspend fun getConsoleOutput(input: GetConsoleOutputRequest): GetConsoleOutputResponse {
        val op = SdkHttpOperation.build<GetConsoleOutputRequest, GetConsoleOutputResponse> {
            serializer = GetConsoleOutputOperationSerializer()
            deserializer = GetConsoleOutputOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConsoleOutput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a JPG-format screenshot of a running instance to help with
     * troubleshooting.
     * The returned content is Base64-encoded.
     */
    override suspend fun getConsoleScreenshot(input: GetConsoleScreenshotRequest): GetConsoleScreenshotResponse {
        val op = SdkHttpOperation.build<GetConsoleScreenshotRequest, GetConsoleScreenshotResponse> {
            serializer = GetConsoleScreenshotOperationSerializer()
            deserializer = GetConsoleScreenshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConsoleScreenshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the default credit option for CPU usage of a burstable performance instance family.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    override suspend fun getDefaultCreditSpecification(input: GetDefaultCreditSpecificationRequest): GetDefaultCreditSpecificationResponse {
        val op = SdkHttpOperation.build<GetDefaultCreditSpecificationRequest, GetDefaultCreditSpecificationResponse> {
            serializer = GetDefaultCreditSpecificationOperationSerializer()
            deserializer = GetDefaultCreditSpecificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDefaultCreditSpecification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the default KMS key for EBS encryption by default for your account in this Region.
     * You can change the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId or
     * ResetEbsDefaultKmsKeyId.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun getEbsDefaultKmsKeyId(input: GetEbsDefaultKmsKeyIdRequest): GetEbsDefaultKmsKeyIdResponse {
        val op = SdkHttpOperation.build<GetEbsDefaultKmsKeyIdRequest, GetEbsDefaultKmsKeyIdResponse> {
            serializer = GetEbsDefaultKmsKeyIdOperationSerializer()
            deserializer = GetEbsDefaultKmsKeyIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEbsDefaultKmsKeyId"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes whether EBS encryption by default is enabled for your account in the current
     * Region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun getEbsEncryptionByDefault(input: GetEbsEncryptionByDefaultRequest): GetEbsEncryptionByDefaultResponse {
        val op = SdkHttpOperation.build<GetEbsEncryptionByDefaultRequest, GetEbsEncryptionByDefaultResponse> {
            serializer = GetEbsEncryptionByDefaultOperationSerializer()
            deserializer = GetEbsEncryptionByDefaultOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEbsEncryptionByDefault"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Generates a CloudFormation template that streamlines and automates the integration of VPC flow logs
     * with Amazon Athena. This make it easier for you to query and gain insights from VPC flow logs data.
     * Based on the information that you provide, we configure resources in the template to do the following:
     * Create a table in Athena that maps fields to a custom log format
     * Create a Lambda function that updates the table with new partitions on a daily, weekly, or
     * monthly basis
     * Create a table partitioned between two timestamps in the past
     * Create a set of named queries in Athena that you can use to get started quickly
     */
    override suspend fun getFlowLogsIntegrationTemplate(input: GetFlowLogsIntegrationTemplateRequest): GetFlowLogsIntegrationTemplateResponse {
        val op = SdkHttpOperation.build<GetFlowLogsIntegrationTemplateRequest, GetFlowLogsIntegrationTemplateResponse> {
            serializer = GetFlowLogsIntegrationTemplateOperationSerializer()
            deserializer = GetFlowLogsIntegrationTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFlowLogsIntegrationTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the resource groups to which a Capacity Reservation has been added.
     */
    override suspend fun getGroupsForCapacityReservation(input: GetGroupsForCapacityReservationRequest): GetGroupsForCapacityReservationResponse {
        val op = SdkHttpOperation.build<GetGroupsForCapacityReservationRequest, GetGroupsForCapacityReservationResponse> {
            serializer = GetGroupsForCapacityReservationOperationSerializer()
            deserializer = GetGroupsForCapacityReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGroupsForCapacityReservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Preview a reservation purchase with configurations that match those of your
     * Dedicated Host. You must have active Dedicated Hosts in your account before you purchase
     * a reservation.
     * This is a preview of the PurchaseHostReservation action and does
     * not result in the offering being purchased.
     */
    override suspend fun getHostReservationPurchasePreview(input: GetHostReservationPurchasePreviewRequest): GetHostReservationPurchasePreviewResponse {
        val op = SdkHttpOperation.build<GetHostReservationPurchasePreviewRequest, GetHostReservationPurchasePreviewResponse> {
            serializer = GetHostReservationPurchasePreviewOperationSerializer()
            deserializer = GetHostReservationPurchasePreviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetHostReservationPurchasePreview"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of instance types with the specified instance attributes. You can
     * use the response to preview the instance types without launching instances. Note
     * that the response does not consider capacity.
     * When you specify multiple parameters, you get instance types that satisfy all of the
     * specified parameters. If you specify multiple values for a parameter, you get instance
     * types that satisfy any of the specified values.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html#spotfleet-get-instance-types-from-instance-requirements">Preview instance types with specified attributes, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for EC2 Fleet, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for Spot Fleet, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot
     * placement score in the Amazon EC2 User Guide, and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an
     * Auto Scaling group using attribute-based instance type selection in the
     * Amazon EC2 Auto Scaling User Guide.
     */
    override suspend fun getInstanceTypesFromInstanceRequirements(input: GetInstanceTypesFromInstanceRequirementsRequest): GetInstanceTypesFromInstanceRequirementsResponse {
        val op = SdkHttpOperation.build<GetInstanceTypesFromInstanceRequirementsRequest, GetInstanceTypesFromInstanceRequirementsResponse> {
            serializer = GetInstanceTypesFromInstanceRequirementsOperationSerializer()
            deserializer = GetInstanceTypesFromInstanceRequirementsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstanceTypesFromInstanceRequirements"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve historical information about a CIDR within an IPAM scope. For more information, see <a href="/vpc/latest/ipam/view-history-cidr-ipam.html">View the history of IP addresses in the Amazon VPC IPAM User Guide.
     */
    override suspend fun getIpamAddressHistory(input: GetIpamAddressHistoryRequest): GetIpamAddressHistoryResponse {
        val op = SdkHttpOperation.build<GetIpamAddressHistoryRequest, GetIpamAddressHistoryResponse> {
            serializer = GetIpamAddressHistoryOperationSerializer()
            deserializer = GetIpamAddressHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIpamAddressHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a list of all the CIDR allocations in an IPAM pool.
     */
    override suspend fun getIpamPoolAllocations(input: GetIpamPoolAllocationsRequest): GetIpamPoolAllocationsResponse {
        val op = SdkHttpOperation.build<GetIpamPoolAllocationsRequest, GetIpamPoolAllocationsResponse> {
            serializer = GetIpamPoolAllocationsOperationSerializer()
            deserializer = GetIpamPoolAllocationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIpamPoolAllocations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the CIDRs provisioned to an IPAM pool.
     */
    override suspend fun getIpamPoolCidrs(input: GetIpamPoolCidrsRequest): GetIpamPoolCidrsResponse {
        val op = SdkHttpOperation.build<GetIpamPoolCidrsRequest, GetIpamPoolCidrsResponse> {
            serializer = GetIpamPoolCidrsOperationSerializer()
            deserializer = GetIpamPoolCidrsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIpamPoolCidrs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get information about the resources in a scope.
     */
    override suspend fun getIpamResourceCidrs(input: GetIpamResourceCidrsRequest): GetIpamResourceCidrsResponse {
        val op = SdkHttpOperation.build<GetIpamResourceCidrsRequest, GetIpamResourceCidrsResponse> {
            serializer = GetIpamResourceCidrsOperationSerializer()
            deserializer = GetIpamResourceCidrsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIpamResourceCidrs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the configuration data of the specified instance. You can use this data
     * to create a launch template.
     * This action calls on other describe actions to get instance information. Depending on your instance configuration, you may need to allow the following
     * actions in your IAM policy: DescribeSpotInstanceRequests, DescribeInstanceCreditSpecifications, DescribeVolumes, DescribeInstanceAttribute, and DescribeElasticGpus. Or, you can allow
     * describe* depending on your instance requirements.
     */
    override suspend fun getLaunchTemplateData(input: GetLaunchTemplateDataRequest): GetLaunchTemplateDataResponse {
        val op = SdkHttpOperation.build<GetLaunchTemplateDataRequest, GetLaunchTemplateDataResponse> {
            serializer = GetLaunchTemplateDataOperationSerializer()
            deserializer = GetLaunchTemplateDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLaunchTemplateData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the resources that are associated with the specified managed prefix list.
     */
    override suspend fun getManagedPrefixListAssociations(input: GetManagedPrefixListAssociationsRequest): GetManagedPrefixListAssociationsResponse {
        val op = SdkHttpOperation.build<GetManagedPrefixListAssociationsRequest, GetManagedPrefixListAssociationsResponse> {
            serializer = GetManagedPrefixListAssociationsOperationSerializer()
            deserializer = GetManagedPrefixListAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetManagedPrefixListAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the entries for a specified managed prefix list.
     */
    override suspend fun getManagedPrefixListEntries(input: GetManagedPrefixListEntriesRequest): GetManagedPrefixListEntriesResponse {
        val op = SdkHttpOperation.build<GetManagedPrefixListEntriesRequest, GetManagedPrefixListEntriesResponse> {
            serializer = GetManagedPrefixListEntriesOperationSerializer()
            deserializer = GetManagedPrefixListEntriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetManagedPrefixListEntries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the findings for the specified Network Access Scope analysis.
     */
    override suspend fun getNetworkInsightsAccessScopeAnalysisFindings(input: GetNetworkInsightsAccessScopeAnalysisFindingsRequest): GetNetworkInsightsAccessScopeAnalysisFindingsResponse {
        val op = SdkHttpOperation.build<GetNetworkInsightsAccessScopeAnalysisFindingsRequest, GetNetworkInsightsAccessScopeAnalysisFindingsResponse> {
            serializer = GetNetworkInsightsAccessScopeAnalysisFindingsOperationSerializer()
            deserializer = GetNetworkInsightsAccessScopeAnalysisFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetworkInsightsAccessScopeAnalysisFindings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the content for the specified Network Access Scope.
     */
    override suspend fun getNetworkInsightsAccessScopeContent(input: GetNetworkInsightsAccessScopeContentRequest): GetNetworkInsightsAccessScopeContentResponse {
        val op = SdkHttpOperation.build<GetNetworkInsightsAccessScopeContentRequest, GetNetworkInsightsAccessScopeContentResponse> {
            serializer = GetNetworkInsightsAccessScopeContentOperationSerializer()
            deserializer = GetNetworkInsightsAccessScopeContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetworkInsightsAccessScopeContent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the encrypted administrator password for a running Windows instance.
     * The Windows password is generated at boot by the EC2Config service or
     * EC2Launch scripts (Windows Server 2016 and later). This usually only
     * happens the first time an instance is launched. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/UsingConfig_WinAMI.html">EC2Config and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2launch.html">EC2Launch in the
     * Amazon EC2 User Guide.
     * For the EC2Config service, the password is not generated for rebundled
     * AMIs unless Ec2SetPassword is enabled before bundling.
     * The password is encrypted using the key pair that you specified when you launched the
     * instance. You must provide the corresponding key pair file.
     * When you launch an instance, password generation and encryption may take a few
     * minutes. If you try to retrieve the password before it's available, the output returns
     * an empty string. We recommend that you wait up to 15 minutes after launching an instance
     * before trying to retrieve the generated password.
     */
    override suspend fun getPasswordData(input: GetPasswordDataRequest): GetPasswordDataResponse {
        val op = SdkHttpOperation.build<GetPasswordDataRequest, GetPasswordDataResponse> {
            serializer = GetPasswordDataOperationSerializer()
            deserializer = GetPasswordDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPasswordData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a quote and exchange information for exchanging one or more specified
     * Convertible Reserved Instances for a new Convertible Reserved Instance. If the exchange
     * cannot be performed, the reason is returned in the response. Use AcceptReservedInstancesExchangeQuote to perform the exchange.
     */
    override suspend fun getReservedInstancesExchangeQuote(input: GetReservedInstancesExchangeQuoteRequest): GetReservedInstancesExchangeQuoteResponse {
        val op = SdkHttpOperation.build<GetReservedInstancesExchangeQuoteRequest, GetReservedInstancesExchangeQuoteResponse> {
            serializer = GetReservedInstancesExchangeQuoteOperationSerializer()
            deserializer = GetReservedInstancesExchangeQuoteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetReservedInstancesExchangeQuote"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the access status of your account to the EC2 serial console of all instances. By
     * default, access to the EC2 serial console is disabled for your account. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console in the Amazon EC2
     * User Guide.
     */
    override suspend fun getSerialConsoleAccessStatus(input: GetSerialConsoleAccessStatusRequest): GetSerialConsoleAccessStatusResponse {
        val op = SdkHttpOperation.build<GetSerialConsoleAccessStatusRequest, GetSerialConsoleAccessStatusResponse> {
            serializer = GetSerialConsoleAccessStatusOperationSerializer()
            deserializer = GetSerialConsoleAccessStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSerialConsoleAccessStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Calculates the Spot placement score for a Region or Availability Zone based on the
     * specified target capacity and compute requirements.
     * You can specify your compute requirements either by using
     * InstanceRequirementsWithMetadata and letting Amazon EC2 choose the optimal
     * instance types to fulfill your Spot request, or you can specify the instance types by using
     * InstanceTypes.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score in
     * the Amazon EC2 User Guide.
     */
    override suspend fun getSpotPlacementScores(input: GetSpotPlacementScoresRequest): GetSpotPlacementScoresResponse {
        val op = SdkHttpOperation.build<GetSpotPlacementScoresRequest, GetSpotPlacementScoresResponse> {
            serializer = GetSpotPlacementScoresOperationSerializer()
            deserializer = GetSpotPlacementScoresOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSpotPlacementScores"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the subnet CIDR reservations.
     */
    override suspend fun getSubnetCidrReservations(input: GetSubnetCidrReservationsRequest): GetSubnetCidrReservationsResponse {
        val op = SdkHttpOperation.build<GetSubnetCidrReservationsRequest, GetSubnetCidrReservationsResponse> {
            serializer = GetSubnetCidrReservationsOperationSerializer()
            deserializer = GetSubnetCidrReservationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSubnetCidrReservations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the route tables to which the specified resource attachment propagates routes.
     */
    override suspend fun getTransitGatewayAttachmentPropagations(input: GetTransitGatewayAttachmentPropagationsRequest): GetTransitGatewayAttachmentPropagationsResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayAttachmentPropagationsRequest, GetTransitGatewayAttachmentPropagationsResponse> {
            serializer = GetTransitGatewayAttachmentPropagationsOperationSerializer()
            deserializer = GetTransitGatewayAttachmentPropagationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTransitGatewayAttachmentPropagations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the associations for the transit gateway multicast domain.
     */
    override suspend fun getTransitGatewayMulticastDomainAssociations(input: GetTransitGatewayMulticastDomainAssociationsRequest): GetTransitGatewayMulticastDomainAssociationsResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayMulticastDomainAssociationsRequest, GetTransitGatewayMulticastDomainAssociationsResponse> {
            serializer = GetTransitGatewayMulticastDomainAssociationsOperationSerializer()
            deserializer = GetTransitGatewayMulticastDomainAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTransitGatewayMulticastDomainAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the prefix list references in a specified transit gateway route table.
     */
    override suspend fun getTransitGatewayPrefixListReferences(input: GetTransitGatewayPrefixListReferencesRequest): GetTransitGatewayPrefixListReferencesResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayPrefixListReferencesRequest, GetTransitGatewayPrefixListReferencesResponse> {
            serializer = GetTransitGatewayPrefixListReferencesOperationSerializer()
            deserializer = GetTransitGatewayPrefixListReferencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTransitGatewayPrefixListReferences"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the associations for the specified transit gateway route table.
     */
    override suspend fun getTransitGatewayRouteTableAssociations(input: GetTransitGatewayRouteTableAssociationsRequest): GetTransitGatewayRouteTableAssociationsResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayRouteTableAssociationsRequest, GetTransitGatewayRouteTableAssociationsResponse> {
            serializer = GetTransitGatewayRouteTableAssociationsOperationSerializer()
            deserializer = GetTransitGatewayRouteTableAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTransitGatewayRouteTableAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the route table propagations for the specified transit gateway route table.
     */
    override suspend fun getTransitGatewayRouteTablePropagations(input: GetTransitGatewayRouteTablePropagationsRequest): GetTransitGatewayRouteTablePropagationsResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayRouteTablePropagationsRequest, GetTransitGatewayRouteTablePropagationsResponse> {
            serializer = GetTransitGatewayRouteTablePropagationsOperationSerializer()
            deserializer = GetTransitGatewayRouteTablePropagationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTransitGatewayRouteTablePropagations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Download an Amazon Web Services-provided sample configuration file to be used with the customer
     * gateway device specified for your Site-to-Site VPN connection.
     */
    override suspend fun getVpnConnectionDeviceSampleConfiguration(input: GetVpnConnectionDeviceSampleConfigurationRequest): GetVpnConnectionDeviceSampleConfigurationResponse {
        val op = SdkHttpOperation.build<GetVpnConnectionDeviceSampleConfigurationRequest, GetVpnConnectionDeviceSampleConfigurationResponse> {
            serializer = GetVpnConnectionDeviceSampleConfigurationOperationSerializer()
            deserializer = GetVpnConnectionDeviceSampleConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVpnConnectionDeviceSampleConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Obtain a list of customer gateway devices for which sample configuration
     * files can be provided. The request has no additional parameters. You can also see the
     * list of device types with sample configuration files available under <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/your-cgw.html">Your customer gateway
     * device in the Amazon Web Services Site-to-Site VPN User Guide.
     */
    override suspend fun getVpnConnectionDeviceTypes(input: GetVpnConnectionDeviceTypesRequest): GetVpnConnectionDeviceTypesResponse {
        val op = SdkHttpOperation.build<GetVpnConnectionDeviceTypesRequest, GetVpnConnectionDeviceTypesResponse> {
            serializer = GetVpnConnectionDeviceTypesOperationSerializer()
            deserializer = GetVpnConnectionDeviceTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVpnConnectionDeviceTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Uploads a client certificate revocation list to the specified Client VPN endpoint. Uploading a client certificate revocation list overwrites the existing client certificate revocation list.
     * Uploading a client certificate revocation list resets existing client connections.
     */
    override suspend fun importClientVpnClientCertificateRevocationList(input: ImportClientVpnClientCertificateRevocationListRequest): ImportClientVpnClientCertificateRevocationListResponse {
        val op = SdkHttpOperation.build<ImportClientVpnClientCertificateRevocationListRequest, ImportClientVpnClientCertificateRevocationListResponse> {
            serializer = ImportClientVpnClientCertificateRevocationListOperationSerializer()
            deserializer = ImportClientVpnClientCertificateRevocationListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportClientVpnClientCertificateRevocationList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI).
     * For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html">Importing a
     * VM as an image using VM Import/Export in the VM Import/Export User Guide.
     */
    override suspend fun importImage(input: ImportImageRequest): ImportImageResponse {
        val op = SdkHttpOperation.build<ImportImageRequest, ImportImageResponse> {
            serializer = ImportImageOperationSerializer()
            deserializer = ImportImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an import instance task using metadata from the specified disk image.
     * This API action supports only single-volume VMs. To import multi-volume VMs, use ImportImage
     * instead.
     * This API action is not supported by the Command Line Interface (CLI). For
     * information about using the Amazon EC2 CLI, which is deprecated, see
     * <a href="https://awsdocs.s3.amazonaws.com/EC2/ec2-clt.pdf#UsingVirtualMachinesinAmazonEC2">Importing a VM to Amazon EC2 in the Amazon EC2 CLI Reference PDF file.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    override suspend fun importInstance(input: ImportInstanceRequest): ImportInstanceResponse {
        val op = SdkHttpOperation.build<ImportInstanceRequest, ImportInstanceResponse> {
            serializer = ImportInstanceOperationSerializer()
            deserializer = ImportInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Imports the public key from an RSA or ED25519 key pair that you created with a third-party tool.
     * Compare this with CreateKeyPair, in which Amazon Web Services creates the key pair and gives the keys to you
     * (Amazon Web Services keeps a copy of the public key). With ImportKeyPair, you create the key pair and give Amazon Web Services just the public key.
     * The private key is never transferred between you and Amazon Web Services.
     * For more information about key pairs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun importKeyPair(input: ImportKeyPairRequest): ImportKeyPairResponse {
        val op = SdkHttpOperation.build<ImportKeyPairRequest, ImportKeyPairResponse> {
            serializer = ImportKeyPairOperationSerializer()
            deserializer = ImportKeyPairOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportKeyPair"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Imports a disk into an EBS snapshot.
     * For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-import-snapshot.html">Importing a disk as a snapshot using VM Import/Export in the
     * VM Import/Export User Guide.
     */
    override suspend fun importSnapshot(input: ImportSnapshotRequest): ImportSnapshotResponse {
        val op = SdkHttpOperation.build<ImportSnapshotRequest, ImportSnapshotResponse> {
            serializer = ImportSnapshotOperationSerializer()
            deserializer = ImportSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an import volume task using metadata from the specified disk image.
     * This API action supports only single-volume VMs. To import multi-volume VMs, use
     * ImportImage instead. To import a disk to a snapshot, use
     * ImportSnapshot instead.
     * This API action is not supported by the Command Line Interface (CLI). For
     * information about using the Amazon EC2 CLI, which is deprecated, see <a href="https://awsdocs.s3.amazonaws.com/EC2/ec2-clt.pdf#importing-your-volumes-into-amazon-ebs">Importing Disks to Amazon EBS in the Amazon EC2 CLI Reference PDF file.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    override suspend fun importVolume(input: ImportVolumeRequest): ImportVolumeResponse {
        val op = SdkHttpOperation.build<ImportVolumeRequest, ImportVolumeResponse> {
            serializer = ImportVolumeOperationSerializer()
            deserializer = ImportVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists one or more snapshots that are currently in the Recycle Bin.
     */
    override suspend fun listSnapshotsInRecycleBin(input: ListSnapshotsInRecycleBinRequest): ListSnapshotsInRecycleBinResponse {
        val op = SdkHttpOperation.build<ListSnapshotsInRecycleBinRequest, ListSnapshotsInRecycleBinResponse> {
            serializer = ListSnapshotsInRecycleBinOperationSerializer()
            deserializer = ListSnapshotsInRecycleBinOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSnapshotsInRecycleBin"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an attribute of the specified Elastic IP address. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications.
     */
    override suspend fun modifyAddressAttribute(input: ModifyAddressAttributeRequest): ModifyAddressAttributeResponse {
        val op = SdkHttpOperation.build<ModifyAddressAttributeRequest, ModifyAddressAttributeResponse> {
            serializer = ModifyAddressAttributeOperationSerializer()
            deserializer = ModifyAddressAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyAddressAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the opt-in status of the Local Zone and Wavelength Zone group for your
     * account.
     * Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">
     * DescribeAvailabilityZones to view the value for GroupName.
     */
    override suspend fun modifyAvailabilityZoneGroup(input: ModifyAvailabilityZoneGroupRequest): ModifyAvailabilityZoneGroupResponse {
        val op = SdkHttpOperation.build<ModifyAvailabilityZoneGroupRequest, ModifyAvailabilityZoneGroupResponse> {
            serializer = ModifyAvailabilityZoneGroupOperationSerializer()
            deserializer = ModifyAvailabilityZoneGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyAvailabilityZoneGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a Capacity Reservation's capacity and the conditions under which it is to be released. You
     * cannot change a Capacity Reservation's instance type, EBS optimization, instance store settings,
     * platform, Availability Zone, or instance eligibility. If you need to modify any of these
     * attributes, we recommend that you cancel the Capacity Reservation, and then create a new one with
     * the required attributes.
     */
    override suspend fun modifyCapacityReservation(input: ModifyCapacityReservationRequest): ModifyCapacityReservationResponse {
        val op = SdkHttpOperation.build<ModifyCapacityReservationRequest, ModifyCapacityReservationResponse> {
            serializer = ModifyCapacityReservationOperationSerializer()
            deserializer = ModifyCapacityReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyCapacityReservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a Capacity Reservation Fleet.
     * When you modify the total target capacity of a Capacity Reservation Fleet, the Fleet automatically
     * creates new Capacity Reservations, or modifies or cancels existing Capacity Reservations in the Fleet
     * to meet the new total target capacity. When you modify the end date for the Fleet, the end dates for
     * all of the individual Capacity Reservations in the Fleet are updated accordingly.
     */
    override suspend fun modifyCapacityReservationFleet(input: ModifyCapacityReservationFleetRequest): ModifyCapacityReservationFleetResponse {
        val op = SdkHttpOperation.build<ModifyCapacityReservationFleetRequest, ModifyCapacityReservationFleetResponse> {
            serializer = ModifyCapacityReservationFleetOperationSerializer()
            deserializer = ModifyCapacityReservationFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyCapacityReservationFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified Client VPN endpoint. Modifying the DNS server resets existing client connections.
     */
    override suspend fun modifyClientVpnEndpoint(input: ModifyClientVpnEndpointRequest): ModifyClientVpnEndpointResponse {
        val op = SdkHttpOperation.build<ModifyClientVpnEndpointRequest, ModifyClientVpnEndpointResponse> {
            serializer = ModifyClientVpnEndpointOperationSerializer()
            deserializer = ModifyClientVpnEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyClientVpnEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the default credit option for CPU usage of burstable performance instances.
     * The default credit option is set at the account level per Amazon Web Services Region, and is specified
     * per instance family. All new burstable performance instances in the account launch using
     * the default credit option.
     * ModifyDefaultCreditSpecification is an asynchronous operation, which works at an Amazon Web Services Region
     * level and modifies the credit option for each Availability Zone. All zones in a
     * Region are updated within five minutes. But if instances are launched during this
     * operation, they might not get the new credit option until the zone is updated. To verify
     * whether the update has occurred, you can call GetDefaultCreditSpecification and check
     * DefaultCreditSpecification for updates.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    override suspend fun modifyDefaultCreditSpecification(input: ModifyDefaultCreditSpecificationRequest): ModifyDefaultCreditSpecificationResponse {
        val op = SdkHttpOperation.build<ModifyDefaultCreditSpecificationRequest, ModifyDefaultCreditSpecificationResponse> {
            serializer = ModifyDefaultCreditSpecificationOperationSerializer()
            deserializer = ModifyDefaultCreditSpecificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyDefaultCreditSpecification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the default KMS key for EBS encryption by default for your account in this Region.
     * Amazon Web Services creates a unique Amazon Web Services managed KMS key in each Region for use with encryption by default. If
     * you change the default KMS key to a symmetric customer managed KMS key, it is used instead of the Amazon Web Services
     * managed KMS key. To reset the default KMS key to the Amazon Web Services managed KMS key for EBS, use ResetEbsDefaultKmsKeyId. Amazon EBS does not support asymmetric KMS keys.
     * If you delete or disable the customer managed KMS key that you specified for use with
     * encryption by default, your instances will fail to launch.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun modifyEbsDefaultKmsKeyId(input: ModifyEbsDefaultKmsKeyIdRequest): ModifyEbsDefaultKmsKeyIdResponse {
        val op = SdkHttpOperation.build<ModifyEbsDefaultKmsKeyIdRequest, ModifyEbsDefaultKmsKeyIdResponse> {
            serializer = ModifyEbsDefaultKmsKeyIdOperationSerializer()
            deserializer = ModifyEbsDefaultKmsKeyIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyEbsDefaultKmsKeyId"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified EC2 Fleet.
     * You can only modify an EC2 Fleet request of type maintain.
     * While the EC2 Fleet is being modified, it is in the modifying state.
     * To scale up your EC2 Fleet, increase its target capacity. The EC2 Fleet launches the additional
     * Spot Instances according to the allocation strategy for the EC2 Fleet request. If the allocation
     * strategy is lowest-price, the EC2 Fleet launches instances using the Spot Instance
     * pool with the lowest price. If the allocation strategy is diversified, the
     * EC2 Fleet distributes the instances across the Spot Instance pools. If the allocation strategy
     * is capacity-optimized, EC2 Fleet launches instances from Spot Instance pools with optimal
     * capacity for the number of instances that are launching.
     * To scale down your EC2 Fleet, decrease its target capacity. First, the EC2 Fleet cancels any open
     * requests that exceed the new target capacity. You can request that the EC2 Fleet terminate Spot
     * Instances until the size of the fleet no longer exceeds the new target capacity. If the
     * allocation strategy is lowest-price, the EC2 Fleet terminates the instances with
     * the highest price per unit. If the allocation strategy is capacity-optimized,
     * the EC2 Fleet terminates the instances in the Spot Instance pools that have the least available
     * Spot Instance capacity. If the allocation strategy is diversified, the EC2 Fleet terminates
     * instances across the Spot Instance pools. Alternatively, you can request that the EC2 Fleet keep
     * the fleet at its current size, but not replace any Spot Instances that are interrupted or
     * that you terminate manually.
     * If you are finished with your EC2 Fleet for now, but will use it again later, you can set the
     * target capacity to 0.
     */
    override suspend fun modifyFleet(input: ModifyFleetRequest): ModifyFleetResponse {
        val op = SdkHttpOperation.build<ModifyFleetRequest, ModifyFleetResponse> {
            serializer = ModifyFleetOperationSerializer()
            deserializer = ModifyFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified attribute of the specified Amazon FPGA Image (AFI).
     */
    override suspend fun modifyFpgaImageAttribute(input: ModifyFpgaImageAttributeRequest): ModifyFpgaImageAttributeResponse {
        val op = SdkHttpOperation.build<ModifyFpgaImageAttributeRequest, ModifyFpgaImageAttributeResponse> {
            serializer = ModifyFpgaImageAttributeOperationSerializer()
            deserializer = ModifyFpgaImageAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyFpgaImageAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled,
     * any instances that you launch with a tenancy of host but without a specific host
     * ID are placed onto any available Dedicated Host in your account that has auto-placement enabled.
     * When auto-placement is disabled, you need to provide a host ID to have the instance launch onto
     * a specific host. If no host ID is provided, the instance is launched onto a suitable host with
     * auto-placement enabled.
     * You can also use this API action to modify a Dedicated Host to support either multiple
     * instance types in an instance family, or to support a specific instance type only.
     */
    override suspend fun modifyHosts(input: ModifyHostsRequest): ModifyHostsResponse {
        val op = SdkHttpOperation.build<ModifyHostsRequest, ModifyHostsResponse> {
            serializer = ModifyHostsOperationSerializer()
            deserializer = ModifyHostsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyHosts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the ID format for the specified resource on a per-Region basis. You can
     * specify that resources should receive longer IDs (17-character IDs) when they are
     * created.
     * This request can only be used to modify longer ID settings for resource types that
     * are within the opt-in period. Resources currently in their opt-in period include:
     * bundle | conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | internet-gateway | network-acl
     * | network-acl-association | network-interface |
     * network-interface-attachment | prefix-list |
     * route-table | route-table-association |
     * security-group | subnet |
     * subnet-cidr-block-association | vpc |
     * vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
     * This setting applies to the IAM user who makes the request; it does not apply to the
     * entire Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user. If
     * you're using this action as the root user, then these settings apply to the entire account,
     * unless an IAM user explicitly overrides these settings for themselves. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs
     * in the Amazon Elastic Compute Cloud User Guide.
     * Resources created with longer IDs are visible to all IAM roles and users, regardless
     * of these settings and provided that they have permission to use the relevant
     * Describe command for the resource type.
     */
    override suspend fun modifyIdFormat(input: ModifyIdFormatRequest): ModifyIdFormatResponse {
        val op = SdkHttpOperation.build<ModifyIdFormatRequest, ModifyIdFormatResponse> {
            serializer = ModifyIdFormatOperationSerializer()
            deserializer = ModifyIdFormatOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyIdFormat"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the ID format of a resource for a specified IAM user, IAM role, or the root
     * user for an account; or all IAM users, IAM roles, and the root user for an account. You can
     * specify that resources should receive longer IDs (17-character IDs) when they are created.
     * This request can only be used to modify longer ID settings for resource types that are
     * within the opt-in period. Resources currently in their opt-in period include:
     * bundle | conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | internet-gateway | network-acl
     * | network-acl-association | network-interface |
     * network-interface-attachment | prefix-list |
     * route-table | route-table-association |
     * security-group | subnet |
     * subnet-cidr-block-association | vpc |
     * vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs in the
     * Amazon Elastic Compute Cloud User Guide.
     * This setting applies to the principal specified in the request; it does not apply to the
     * principal that makes the request.
     * Resources created with longer IDs are visible to all IAM roles and users, regardless of these
     * settings and provided that they have permission to use the relevant Describe
     * command for the resource type.
     */
    override suspend fun modifyIdentityIdFormat(input: ModifyIdentityIdFormatRequest): ModifyIdentityIdFormatResponse {
        val op = SdkHttpOperation.build<ModifyIdentityIdFormatRequest, ModifyIdentityIdFormatResponse> {
            serializer = ModifyIdentityIdFormatOperationSerializer()
            deserializer = ModifyIdentityIdFormatOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyIdentityIdFormat"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time.
     * You can use the Attribute parameter to specify the attribute or one of the following parameters:
     * Description or LaunchPermission.
     * Images with an Amazon Web Services Marketplace product code cannot be made public.
     * To enable the SriovNetSupport enhanced networking attribute of an image, enable SriovNetSupport on an instance
     * and create an AMI from the instance.
     */
    override suspend fun modifyImageAttribute(input: ModifyImageAttributeRequest): ModifyImageAttributeResponse {
        val op = SdkHttpOperation.build<ModifyImageAttributeRequest, ModifyImageAttributeResponse> {
            serializer = ModifyImageAttributeOperationSerializer()
            deserializer = ModifyImageAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyImageAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified attribute of the specified instance. You can specify only one
     * attribute at a time.
     * Note: Using this action to change the security groups
     * associated with an elastic network interface (ENI) attached to an instance in a VPC can
     * result in an error if the instance has more than one ENI. To change the security groups
     * associated with an ENI attached to an instance that has multiple ENIs, we recommend that
     * you use the ModifyNetworkInterfaceAttribute action.
     * To modify some attributes, the instance must be stopped. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html">Modify a stopped instance in the Amazon EC2 User Guide.
     */
    override suspend fun modifyInstanceAttribute(input: ModifyInstanceAttributeRequest): ModifyInstanceAttributeResponse {
        val op = SdkHttpOperation.build<ModifyInstanceAttributeRequest, ModifyInstanceAttributeResponse> {
            serializer = ModifyInstanceAttributeOperationSerializer()
            deserializer = ModifyInstanceAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyInstanceAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the Capacity Reservation settings for a stopped instance. Use this action to configure an
     * instance to target a specific Capacity Reservation, run in any open Capacity Reservation with matching
     * attributes, or run On-Demand Instance capacity.
     */
    override suspend fun modifyInstanceCapacityReservationAttributes(input: ModifyInstanceCapacityReservationAttributesRequest): ModifyInstanceCapacityReservationAttributesResponse {
        val op = SdkHttpOperation.build<ModifyInstanceCapacityReservationAttributesRequest, ModifyInstanceCapacityReservationAttributesResponse> {
            serializer = ModifyInstanceCapacityReservationAttributesOperationSerializer()
            deserializer = ModifyInstanceCapacityReservationAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyInstanceCapacityReservationAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the credit option for CPU usage on a running or stopped burstable performance
     * instance. The credit options are standard and
     * unlimited.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    override suspend fun modifyInstanceCreditSpecification(input: ModifyInstanceCreditSpecificationRequest): ModifyInstanceCreditSpecificationResponse {
        val op = SdkHttpOperation.build<ModifyInstanceCreditSpecificationRequest, ModifyInstanceCreditSpecificationResponse> {
            serializer = ModifyInstanceCreditSpecificationOperationSerializer()
            deserializer = ModifyInstanceCreditSpecificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyInstanceCreditSpecification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the start time for a scheduled Amazon EC2 instance event.
     */
    override suspend fun modifyInstanceEventStartTime(input: ModifyInstanceEventStartTimeRequest): ModifyInstanceEventStartTimeResponse {
        val op = SdkHttpOperation.build<ModifyInstanceEventStartTimeRequest, ModifyInstanceEventStartTimeResponse> {
            serializer = ModifyInstanceEventStartTimeOperationSerializer()
            deserializer = ModifyInstanceEventStartTimeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyInstanceEventStartTime"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified event window.
     * You can define either a set of time ranges or a cron expression when modifying the event
     * window, but not both.
     * To modify the targets associated with the event window, use the AssociateInstanceEventWindow and DisassociateInstanceEventWindow API.
     * If Amazon Web Services has already scheduled an event, modifying an event window won't change the time
     * of the scheduled event.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    override suspend fun modifyInstanceEventWindow(input: ModifyInstanceEventWindowRequest): ModifyInstanceEventWindowResponse {
        val op = SdkHttpOperation.build<ModifyInstanceEventWindowRequest, ModifyInstanceEventWindowResponse> {
            serializer = ModifyInstanceEventWindowOperationSerializer()
            deserializer = ModifyInstanceEventWindowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyInstanceEventWindow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modify the instance metadata parameters on a running or stopped instance. When you
     * modify the parameters on a stopped instance, they are applied when the instance is
     * started. When you modify the parameters on a running instance, the API responds with a
     * state of “pending”. After the parameter modifications are successfully applied to the
     * instance, the state of the modifications changes from “pending” to “applied” in
     * subsequent describe-instances API calls. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data
     * in the Amazon EC2 User Guide.
     */
    override suspend fun modifyInstanceMetadataOptions(input: ModifyInstanceMetadataOptionsRequest): ModifyInstanceMetadataOptionsResponse {
        val op = SdkHttpOperation.build<ModifyInstanceMetadataOptionsRequest, ModifyInstanceMetadataOptionsResponse> {
            serializer = ModifyInstanceMetadataOptionsOperationSerializer()
            deserializer = ModifyInstanceMetadataOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyInstanceMetadataOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the placement attributes for a specified instance. You can do the
     * following:
     * Modify the affinity between an instance and a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated
     * Host. When affinity is set to host and the instance is
     * not associated with a specific Dedicated Host, the next time the instance is
     * launched, it is automatically associated with the host on which it lands. If the
     * instance is restarted or rebooted, this relationship persists.
     * Change the Dedicated Host with which an instance is associated.
     * Change the instance tenancy of an instance.
     * Move an instance to or from a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">placement
     * group.
     * At least one attribute for affinity, host ID, tenancy, or placement group name must
     * be specified in the request. Affinity and tenancy can be modified in the same
     * request.
     * To modify the host ID, tenancy, placement group, or partition for an instance, the
     * instance must be in the stopped state.
     */
    override suspend fun modifyInstancePlacement(input: ModifyInstancePlacementRequest): ModifyInstancePlacementResponse {
        val op = SdkHttpOperation.build<ModifyInstancePlacementRequest, ModifyInstancePlacementResponse> {
            serializer = ModifyInstancePlacementOperationSerializer()
            deserializer = ModifyInstancePlacementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyInstancePlacement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modify the configurations of an IPAM.
     */
    override suspend fun modifyIpam(input: ModifyIpamRequest): ModifyIpamResponse {
        val op = SdkHttpOperation.build<ModifyIpamRequest, ModifyIpamResponse> {
            serializer = ModifyIpamOperationSerializer()
            deserializer = ModifyIpamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyIpam"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modify the configurations of an IPAM pool.
     * For more information, see <a href="/vpc/latest/ipam/mod-pool-ipam.html">Modify a pool in the Amazon VPC IPAM User Guide.
     */
    override suspend fun modifyIpamPool(input: ModifyIpamPoolRequest): ModifyIpamPoolResponse {
        val op = SdkHttpOperation.build<ModifyIpamPoolRequest, ModifyIpamPoolResponse> {
            serializer = ModifyIpamPoolOperationSerializer()
            deserializer = ModifyIpamPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyIpamPool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modify a resource CIDR. You can use this action to transfer resource CIDRs between scopes and ignore resource CIDRs that you do not want to manage. If set to false, the resource will not be tracked for overlap, it cannot be auto-imported into a pool, and it will be removed from any pool it has an allocation in.
     * For more information, see <a href="/vpc/latest/ipam/move-resource-ipam.html">Move resource CIDRs between scopes and <a href="/vpc/latest/ipam/change-monitoring-state-ipam.html">Change the monitoring state of resource CIDRs in the Amazon VPC IPAM User Guide.
     */
    override suspend fun modifyIpamResourceCidr(input: ModifyIpamResourceCidrRequest): ModifyIpamResourceCidrResponse {
        val op = SdkHttpOperation.build<ModifyIpamResourceCidrRequest, ModifyIpamResourceCidrResponse> {
            serializer = ModifyIpamResourceCidrOperationSerializer()
            deserializer = ModifyIpamResourceCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyIpamResourceCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modify an IPAM scope.
     */
    override suspend fun modifyIpamScope(input: ModifyIpamScopeRequest): ModifyIpamScopeResponse {
        val op = SdkHttpOperation.build<ModifyIpamScopeRequest, ModifyIpamScopeResponse> {
            serializer = ModifyIpamScopeOperationSerializer()
            deserializer = ModifyIpamScopeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyIpamScope"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a launch template. You can specify which version of the launch template to
     * set as the default version. When launching an instance, the default version applies when
     * a launch template version is not specified.
     */
    override suspend fun modifyLaunchTemplate(input: ModifyLaunchTemplateRequest): ModifyLaunchTemplateResponse {
        val op = SdkHttpOperation.build<ModifyLaunchTemplateRequest, ModifyLaunchTemplateResponse> {
            serializer = ModifyLaunchTemplateOperationSerializer()
            deserializer = ModifyLaunchTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyLaunchTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified managed prefix list.
     * Adding or removing entries in a prefix list creates a new version of the prefix list.
     * Changing the name of the prefix list does not affect the version.
     * If you specify a current version number that does not match the true current version
     * number, the request fails.
     */
    override suspend fun modifyManagedPrefixList(input: ModifyManagedPrefixListRequest): ModifyManagedPrefixListResponse {
        val op = SdkHttpOperation.build<ModifyManagedPrefixListRequest, ModifyManagedPrefixListResponse> {
            serializer = ModifyManagedPrefixListOperationSerializer()
            deserializer = ModifyManagedPrefixListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyManagedPrefixList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified network interface attribute. You can specify only one
     * attribute at a time. You can use this action to attach and detach security groups from
     * an existing EC2 instance.
     */
    override suspend fun modifyNetworkInterfaceAttribute(input: ModifyNetworkInterfaceAttributeRequest): ModifyNetworkInterfaceAttributeResponse {
        val op = SdkHttpOperation.build<ModifyNetworkInterfaceAttributeRequest, ModifyNetworkInterfaceAttributeResponse> {
            serializer = ModifyNetworkInterfaceAttributeOperationSerializer()
            deserializer = ModifyNetworkInterfaceAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyNetworkInterfaceAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the options for instance hostnames for the specified instance.
     */
    override suspend fun modifyPrivateDnsNameOptions(input: ModifyPrivateDnsNameOptionsRequest): ModifyPrivateDnsNameOptionsResponse {
        val op = SdkHttpOperation.build<ModifyPrivateDnsNameOptionsRequest, ModifyPrivateDnsNameOptionsResponse> {
            serializer = ModifyPrivateDnsNameOptionsOperationSerializer()
            deserializer = ModifyPrivateDnsNameOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyPrivateDnsNameOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the Availability Zone, instance count, instance type, or network platform
     * (EC2-Classic or EC2-VPC) of your Reserved Instances. The Reserved Instances to be
     * modified must be identical, except for Availability Zone, network platform, and instance
     * type.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved
     * Instances in the Amazon EC2 User Guide.
     */
    override suspend fun modifyReservedInstances(input: ModifyReservedInstancesRequest): ModifyReservedInstancesResponse {
        val op = SdkHttpOperation.build<ModifyReservedInstancesRequest, ModifyReservedInstancesResponse> {
            serializer = ModifyReservedInstancesOperationSerializer()
            deserializer = ModifyReservedInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyReservedInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the rules of a security group.
     */
    override suspend fun modifySecurityGroupRules(input: ModifySecurityGroupRulesRequest): ModifySecurityGroupRulesResponse {
        val op = SdkHttpOperation.build<ModifySecurityGroupRulesRequest, ModifySecurityGroupRulesResponse> {
            serializer = ModifySecurityGroupRulesOperationSerializer()
            deserializer = ModifySecurityGroupRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifySecurityGroupRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or removes permission settings for the specified snapshot. You may add or remove
     * specified Amazon Web Services account IDs from a snapshot's list of create volume permissions, but you cannot
     * do both in a single operation. If you need to both add and remove account IDs for a snapshot,
     * you must use multiple operations. You can make up to 500 modifications to a snapshot in a single operation.
     * Encrypted snapshots and snapshots with Amazon Web Services Marketplace product codes cannot be made
     * public. Snapshots encrypted with your default KMS key cannot be shared with other accounts.
     * For more information about modifying snapshot permissions, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Share a snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun modifySnapshotAttribute(input: ModifySnapshotAttributeRequest): ModifySnapshotAttributeResponse {
        val op = SdkHttpOperation.build<ModifySnapshotAttributeRequest, ModifySnapshotAttributeResponse> {
            serializer = ModifySnapshotAttributeOperationSerializer()
            deserializer = ModifySnapshotAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifySnapshotAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Archives an Amazon EBS snapshot. When you archive a snapshot, it is converted to a full
     * snapshot that includes all of the blocks of data that were written to the volume at the
     * time the snapshot was created, and moved from the standard tier to the archive
     * tier. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-archive.html">Archive Amazon EBS snapshots
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun modifySnapshotTier(input: ModifySnapshotTierRequest): ModifySnapshotTierResponse {
        val op = SdkHttpOperation.build<ModifySnapshotTierRequest, ModifySnapshotTierResponse> {
            serializer = ModifySnapshotTierOperationSerializer()
            deserializer = ModifySnapshotTierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifySnapshotTier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified Spot Fleet request.
     * You can only modify a Spot Fleet request of type maintain.
     * While the Spot Fleet request is being modified, it is in the modifying
     * state.
     * To scale up your Spot Fleet, increase its target capacity. The Spot Fleet launches the
     * additional Spot Instances according to the allocation strategy for the Spot Fleet
     * request. If the allocation strategy is lowestPrice, the Spot Fleet launches
     * instances using the Spot Instance pool with the lowest price. If the allocation strategy
     * is diversified, the Spot Fleet distributes the instances across the Spot
     * Instance pools. If the allocation strategy is capacityOptimized, Spot Fleet
     * launches instances from Spot Instance pools with optimal capacity for the number of instances
     * that are launching.
     * To scale down your Spot Fleet, decrease its target capacity. First, the Spot Fleet
     * cancels any open requests that exceed the new target capacity. You can request that the
     * Spot Fleet terminate Spot Instances until the size of the fleet no longer exceeds the
     * new target capacity. If the allocation strategy is lowestPrice, the Spot
     * Fleet terminates the instances with the highest price per unit. If the allocation
     * strategy is capacityOptimized, the Spot Fleet terminates the instances in
     * the Spot Instance pools that have the least available Spot Instance capacity. If the allocation
     * strategy is diversified, the Spot Fleet terminates instances across the
     * Spot Instance pools. Alternatively, you can request that the Spot Fleet keep the fleet
     * at its current size, but not replace any Spot Instances that are interrupted or that you
     * terminate manually.
     * If you are finished with your Spot Fleet for now, but will use it again later, you can
     * set the target capacity to 0.
     */
    override suspend fun modifySpotFleetRequest(input: ModifySpotFleetRequestRequest): ModifySpotFleetRequestResponse {
        val op = SdkHttpOperation.build<ModifySpotFleetRequestRequest, ModifySpotFleetRequestResponse> {
            serializer = ModifySpotFleetRequestOperationSerializer()
            deserializer = ModifySpotFleetRequestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifySpotFleetRequest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a subnet attribute. You can only modify one attribute at a time.
     * Use this action to modify subnets on Amazon Web Services Outposts.
     * To modify a subnet on an Outpost rack, set both
     * MapCustomerOwnedIpOnLaunch and
     * CustomerOwnedIpv4Pool. These two parameters act as a single
     * attribute.
     * To modify a subnet on an Outpost server, set either
     * EnableLniAtDeviceIndex or
     * DisableLniAtDeviceIndex.
     * For more information about Amazon Web Services Outposts, see the following:
     * <a href="https://docs.aws.amazon.com/outposts/latest/userguide/how-servers-work.html">Outpost servers
     * <a href="https://docs.aws.amazon.com/outposts/latest/userguide/how-racks-work.html">Outpost racks
     */
    override suspend fun modifySubnetAttribute(input: ModifySubnetAttributeRequest): ModifySubnetAttributeResponse {
        val op = SdkHttpOperation.build<ModifySubnetAttributeRequest, ModifySubnetAttributeResponse> {
            serializer = ModifySubnetAttributeOperationSerializer()
            deserializer = ModifySubnetAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifySubnetAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows or restricts mirroring network services.
     * By default, Amazon DNS network services are not eligible for Traffic Mirror. Use AddNetworkServices to add network services to a Traffic Mirror filter. When a network service is added to the Traffic Mirror filter, all traffic related to that network service will be mirrored.
     * When you no longer want to mirror network services, use RemoveNetworkServices to remove the network services from the Traffic Mirror filter.
     */
    override suspend fun modifyTrafficMirrorFilterNetworkServices(input: ModifyTrafficMirrorFilterNetworkServicesRequest): ModifyTrafficMirrorFilterNetworkServicesResponse {
        val op = SdkHttpOperation.build<ModifyTrafficMirrorFilterNetworkServicesRequest, ModifyTrafficMirrorFilterNetworkServicesResponse> {
            serializer = ModifyTrafficMirrorFilterNetworkServicesOperationSerializer()
            deserializer = ModifyTrafficMirrorFilterNetworkServicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyTrafficMirrorFilterNetworkServices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified Traffic Mirror rule.
     * DestinationCidrBlock and SourceCidrBlock must both be an IPv4
     * range or an IPv6 range.
     */
    override suspend fun modifyTrafficMirrorFilterRule(input: ModifyTrafficMirrorFilterRuleRequest): ModifyTrafficMirrorFilterRuleResponse {
        val op = SdkHttpOperation.build<ModifyTrafficMirrorFilterRuleRequest, ModifyTrafficMirrorFilterRuleResponse> {
            serializer = ModifyTrafficMirrorFilterRuleOperationSerializer()
            deserializer = ModifyTrafficMirrorFilterRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyTrafficMirrorFilterRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a Traffic Mirror session.
     */
    override suspend fun modifyTrafficMirrorSession(input: ModifyTrafficMirrorSessionRequest): ModifyTrafficMirrorSessionResponse {
        val op = SdkHttpOperation.build<ModifyTrafficMirrorSessionRequest, ModifyTrafficMirrorSessionResponse> {
            serializer = ModifyTrafficMirrorSessionOperationSerializer()
            deserializer = ModifyTrafficMirrorSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyTrafficMirrorSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified transit gateway. When you modify a transit gateway, the modified options are applied to new transit gateway attachments only. Your existing transit gateway attachments are not modified.
     */
    override suspend fun modifyTransitGateway(input: ModifyTransitGatewayRequest): ModifyTransitGatewayResponse {
        val op = SdkHttpOperation.build<ModifyTransitGatewayRequest, ModifyTransitGatewayResponse> {
            serializer = ModifyTransitGatewayOperationSerializer()
            deserializer = ModifyTransitGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyTransitGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a reference (route) to a prefix list in a specified transit gateway route table.
     */
    override suspend fun modifyTransitGatewayPrefixListReference(input: ModifyTransitGatewayPrefixListReferenceRequest): ModifyTransitGatewayPrefixListReferenceResponse {
        val op = SdkHttpOperation.build<ModifyTransitGatewayPrefixListReferenceRequest, ModifyTransitGatewayPrefixListReferenceResponse> {
            serializer = ModifyTransitGatewayPrefixListReferenceOperationSerializer()
            deserializer = ModifyTransitGatewayPrefixListReferenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyTransitGatewayPrefixListReference"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified VPC attachment.
     */
    override suspend fun modifyTransitGatewayVpcAttachment(input: ModifyTransitGatewayVpcAttachmentRequest): ModifyTransitGatewayVpcAttachmentResponse {
        val op = SdkHttpOperation.build<ModifyTransitGatewayVpcAttachmentRequest, ModifyTransitGatewayVpcAttachmentResponse> {
            serializer = ModifyTransitGatewayVpcAttachmentOperationSerializer()
            deserializer = ModifyTransitGatewayVpcAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyTransitGatewayVpcAttachment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * You can modify several parameters of an existing EBS volume, including volume size, volume
     * type, and IOPS capacity. If your EBS volume is attached to a current-generation EC2 instance
     * type, you might be able to apply these changes without stopping the instance or detaching the
     * volume from it. For more information about modifying EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modify-volume.html">Amazon EBS Elastic Volumes (Linux instances)
     * or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-modify-volume.html">Amazon EBS Elastic Volumes (Windows instances).
     * When you complete a resize operation on your volume, you need to extend the volume's
     * file-system size to take advantage of the new storage capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#recognize-expanded-volume-linux">Extend a Linux file system or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html#recognize-expanded-volume-windows">Extend a Windows file system.
     * You can use CloudWatch Events to check the status of a modification to an EBS volume. For
     * information about CloudWatch Events, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon CloudWatch Events User Guide. You can also track the status of a
     * modification using DescribeVolumesModifications. For information
     * about tracking status changes using either method, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-modifications.html">Monitor the progress of volume modifications.
     * With previous-generation instance types, resizing an EBS volume might require detaching and
     * reattaching the volume or stopping and restarting the instance.
     * If you reach the maximum volume modification rate per volume limit, you must wait
     * at least six hours before applying further modifications to the affected EBS volume.
     */
    override suspend fun modifyVolume(input: ModifyVolumeRequest): ModifyVolumeResponse {
        val op = SdkHttpOperation.build<ModifyVolumeRequest, ModifyVolumeResponse> {
            serializer = ModifyVolumeOperationSerializer()
            deserializer = ModifyVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a volume attribute.
     * By default, all I/O operations for the volume are suspended when the data on the volume is
     * determined to be potentially inconsistent, to prevent undetectable, latent data corruption.
     * The I/O access to the volume can be resumed by first enabling I/O access and then checking the
     * data consistency on your volume.
     * You can change the default behavior to resume I/O operations. We recommend that you change
     * this only for boot volumes or for volumes that are stateless or disposable.
     */
    override suspend fun modifyVolumeAttribute(input: ModifyVolumeAttributeRequest): ModifyVolumeAttributeResponse {
        val op = SdkHttpOperation.build<ModifyVolumeAttributeRequest, ModifyVolumeAttributeResponse> {
            serializer = ModifyVolumeAttributeOperationSerializer()
            deserializer = ModifyVolumeAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVolumeAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified attribute of the specified VPC.
     */
    override suspend fun modifyVpcAttribute(input: ModifyVpcAttributeRequest): ModifyVpcAttributeResponse {
        val op = SdkHttpOperation.build<ModifyVpcAttributeRequest, ModifyVpcAttributeResponse> {
            serializer = ModifyVpcAttributeOperationSerializer()
            deserializer = ModifyVpcAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpcAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies attributes of a specified VPC endpoint. The attributes that you can modify
     * depend on the type of VPC endpoint (interface, gateway, or Gateway Load Balancer). For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html">VPC
     * Endpoints in the Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun modifyVpcEndpoint(input: ModifyVpcEndpointRequest): ModifyVpcEndpointResponse {
        val op = SdkHttpOperation.build<ModifyVpcEndpointRequest, ModifyVpcEndpointResponse> {
            serializer = ModifyVpcEndpointOperationSerializer()
            deserializer = ModifyVpcEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpcEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a connection notification for VPC endpoint or VPC endpoint service. You
     * can change the SNS topic for the notification, or the events for which to be notified.
     */
    override suspend fun modifyVpcEndpointConnectionNotification(input: ModifyVpcEndpointConnectionNotificationRequest): ModifyVpcEndpointConnectionNotificationResponse {
        val op = SdkHttpOperation.build<ModifyVpcEndpointConnectionNotificationRequest, ModifyVpcEndpointConnectionNotificationResponse> {
            serializer = ModifyVpcEndpointConnectionNotificationOperationSerializer()
            deserializer = ModifyVpcEndpointConnectionNotificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpcEndpointConnectionNotification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the attributes of your VPC endpoint service configuration. You can change the
     * Network Load Balancers or Gateway Load Balancers for your service, and you can specify whether acceptance is
     * required for requests to connect to your endpoint service through an interface VPC
     * endpoint.
     * If you set or modify the private DNS name, you must prove that you own the private DNS
     * domain name. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">VPC Endpoint Service
     * Private DNS Name Verification in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun modifyVpcEndpointServiceConfiguration(input: ModifyVpcEndpointServiceConfigurationRequest): ModifyVpcEndpointServiceConfigurationResponse {
        val op = SdkHttpOperation.build<ModifyVpcEndpointServiceConfigurationRequest, ModifyVpcEndpointServiceConfigurationResponse> {
            serializer = ModifyVpcEndpointServiceConfigurationOperationSerializer()
            deserializer = ModifyVpcEndpointServiceConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpcEndpointServiceConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the payer responsibility for your VPC endpoint service.
     */
    override suspend fun modifyVpcEndpointServicePayerResponsibility(input: ModifyVpcEndpointServicePayerResponsibilityRequest): ModifyVpcEndpointServicePayerResponsibilityResponse {
        val op = SdkHttpOperation.build<ModifyVpcEndpointServicePayerResponsibilityRequest, ModifyVpcEndpointServicePayerResponsibilityResponse> {
            serializer = ModifyVpcEndpointServicePayerResponsibilityOperationSerializer()
            deserializer = ModifyVpcEndpointServicePayerResponsibilityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpcEndpointServicePayerResponsibility"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the permissions for your <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">VPC endpoint service. You can add or remove permissions for service consumers (IAM users,
     * IAM roles, and Amazon Web Services accounts) to connect to your endpoint service.
     * If you grant permissions to all principals, the service is public. Any users who know the name of a
     * public service can send a request to attach an endpoint. If the service does not require manual approval,
     * attachments are automatically approved.
     */
    override suspend fun modifyVpcEndpointServicePermissions(input: ModifyVpcEndpointServicePermissionsRequest): ModifyVpcEndpointServicePermissionsResponse {
        val op = SdkHttpOperation.build<ModifyVpcEndpointServicePermissionsRequest, ModifyVpcEndpointServicePermissionsResponse> {
            serializer = ModifyVpcEndpointServicePermissionsOperationSerializer()
            deserializer = ModifyVpcEndpointServicePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpcEndpointServicePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the VPC peering connection options on one side of a VPC peering connection. You can do the following:
     * Enable/disable communication over the peering connection between an EC2-Classic instance that's linked to your VPC (using ClassicLink) and instances in the peer VPC.
     * Enable/disable communication over the peering connection between instances in your VPC and an EC2-Classic instance that's linked to the peer VPC.
     * Enable/disable the ability to resolve public DNS hostnames to private IP
     * addresses when queried from instances in the peer VPC.
     * If the peered VPCs are in the same Amazon Web Services account, you can enable DNS resolution
     * for queries from the local VPC. This ensures that queries from the local VPC resolve to private IP
     * addresses in the peer VPC. This option is not available if the peered VPCs are in different
     * different Amazon Web Services accounts or different Regions. For peered VPCs in different
     * Amazon Web Services accounts, each Amazon Web Services account owner must initiate a separate request
     * to modify the peering connection options. For inter-region peering connections, you must use the
     * Region for the requester VPC to modify the requester VPC peering options and the Region for the
     * accepter VPC to modify the accepter VPC peering options. To verify which VPCs are the accepter and
     * the requester for a VPC peering connection, use the DescribeVpcPeeringConnections command.
     */
    override suspend fun modifyVpcPeeringConnectionOptions(input: ModifyVpcPeeringConnectionOptionsRequest): ModifyVpcPeeringConnectionOptionsResponse {
        val op = SdkHttpOperation.build<ModifyVpcPeeringConnectionOptionsRequest, ModifyVpcPeeringConnectionOptionsResponse> {
            serializer = ModifyVpcPeeringConnectionOptionsOperationSerializer()
            deserializer = ModifyVpcPeeringConnectionOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpcPeeringConnectionOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the instance tenancy attribute of the specified VPC. You can change the
     * instance tenancy attribute of a VPC to default only. You cannot change the
     * instance tenancy attribute to dedicated.
     * After you modify the tenancy of the VPC, any new instances that you launch into the
     * VPC have a tenancy of default, unless you specify otherwise during launch.
     * The tenancy of any existing instances in the VPC is not affected.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun modifyVpcTenancy(input: ModifyVpcTenancyRequest): ModifyVpcTenancyResponse {
        val op = SdkHttpOperation.build<ModifyVpcTenancyRequest, ModifyVpcTenancyResponse> {
            serializer = ModifyVpcTenancyOperationSerializer()
            deserializer = ModifyVpcTenancyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpcTenancy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the customer gateway or the target gateway of an Amazon Web Services Site-to-Site VPN connection. To
     * modify the target gateway, the following migration options are available:
     * An existing virtual private gateway to a new virtual private gateway
     * An existing virtual private gateway to a transit gateway
     * An existing transit gateway to a new transit gateway
     * An existing transit gateway to a virtual private gateway
     * Before you perform the migration to the new gateway, you must configure the new
     * gateway. Use CreateVpnGateway to create a virtual private gateway, or
     * CreateTransitGateway to create a transit gateway.
     * This step is required when you migrate from a virtual private gateway with static
     * routes to a transit gateway.
     * You must delete the static routes before you migrate to the new gateway.
     * Keep a copy of the static route before you delete it. You will need to add back these
     * routes to the transit gateway after the VPN connection migration is complete.
     * After you migrate to the new gateway, you might need to modify your VPC route table.
     * Use CreateRoute and DeleteRoute to make the changes
     * described in <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/modify-vpn-target.html#step-update-routing">Update VPC route
     * tables in the Amazon Web Services Site-to-Site VPN User Guide.
     * When the new gateway is a transit gateway, modify the transit gateway route table to
     * allow traffic between the VPC and the Amazon Web Services Site-to-Site VPN connection.
     * Use CreateTransitGatewayRoute to add the routes.
     * If you deleted VPN static routes, you must add the static routes to the transit
     * gateway route table.
     * After you perform this operation, the VPN endpoint's IP addresses on the Amazon Web Services side and the tunnel options remain intact. Your Amazon Web Services Site-to-Site VPN connection will
     * be temporarily unavailable for a brief period while we provision the new
     * endpoints.
     */
    override suspend fun modifyVpnConnection(input: ModifyVpnConnectionRequest): ModifyVpnConnectionResponse {
        val op = SdkHttpOperation.build<ModifyVpnConnectionRequest, ModifyVpnConnectionResponse> {
            serializer = ModifyVpnConnectionOperationSerializer()
            deserializer = ModifyVpnConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpnConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the connection options for your Site-to-Site VPN connection.
     * When you modify the VPN connection options, the VPN endpoint IP addresses on the
     * Amazon Web Services side do not change, and the tunnel options do not change. Your
     * VPN connection will be temporarily unavailable for a brief period while the VPN
     * connection is updated.
     */
    override suspend fun modifyVpnConnectionOptions(input: ModifyVpnConnectionOptionsRequest): ModifyVpnConnectionOptionsResponse {
        val op = SdkHttpOperation.build<ModifyVpnConnectionOptionsRequest, ModifyVpnConnectionOptionsResponse> {
            serializer = ModifyVpnConnectionOptionsOperationSerializer()
            deserializer = ModifyVpnConnectionOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpnConnectionOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the VPN tunnel endpoint certificate.
     */
    override suspend fun modifyVpnTunnelCertificate(input: ModifyVpnTunnelCertificateRequest): ModifyVpnTunnelCertificateResponse {
        val op = SdkHttpOperation.build<ModifyVpnTunnelCertificateRequest, ModifyVpnTunnelCertificateResponse> {
            serializer = ModifyVpnTunnelCertificateOperationSerializer()
            deserializer = ModifyVpnTunnelCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpnTunnelCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the options for a VPN tunnel in an Amazon Web Services Site-to-Site VPN connection. You can modify
     * multiple options for a tunnel in a single request, but you can only modify one tunnel at
     * a time. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPNTunnels.html">Site-to-Site VPN tunnel options for your Site-to-Site VPN
     * connection in the Amazon Web Services Site-to-Site VPN User Guide.
     */
    override suspend fun modifyVpnTunnelOptions(input: ModifyVpnTunnelOptionsRequest): ModifyVpnTunnelOptionsResponse {
        val op = SdkHttpOperation.build<ModifyVpnTunnelOptionsRequest, ModifyVpnTunnelOptionsResponse> {
            serializer = ModifyVpnTunnelOptionsOperationSerializer()
            deserializer = ModifyVpnTunnelOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyVpnTunnelOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables detailed monitoring for a running instance. Otherwise, basic monitoring is
     * enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitor your instances using
     * CloudWatch in the Amazon EC2 User Guide.
     * To disable detailed monitoring, see .
     */
    override suspend fun monitorInstances(input: MonitorInstancesRequest): MonitorInstancesResponse {
        val op = SdkHttpOperation.build<MonitorInstancesRequest, MonitorInstancesResponse> {
            serializer = MonitorInstancesOperationSerializer()
            deserializer = MonitorInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MonitorInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform. The
     * Elastic IP address must be allocated to your account for more than 24 hours, and it must not
     * be associated with an instance. After the Elastic IP address is moved, it is no longer
     * available for use in the EC2-Classic platform, unless you move it back using the
     * RestoreAddressToClassic request. You cannot move an Elastic IP address that was
     * originally allocated for use in the EC2-VPC platform to the EC2-Classic platform.
     */
    override suspend fun moveAddressToVpc(input: MoveAddressToVpcRequest): MoveAddressToVpcResponse {
        val op = SdkHttpOperation.build<MoveAddressToVpcRequest, MoveAddressToVpcResponse> {
            serializer = MoveAddressToVpcOperationSerializer()
            deserializer = MoveAddressToVpcOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MoveAddressToVpc"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Move an BYOIP IPv4 CIDR to IPAM from a public IPv4 pool.
     */
    override suspend fun moveByoipCidrToIpam(input: MoveByoipCidrToIpamRequest): MoveByoipCidrToIpamResponse {
        val op = SdkHttpOperation.build<MoveByoipCidrToIpamRequest, MoveByoipCidrToIpamResponse> {
            serializer = MoveByoipCidrToIpamOperationSerializer()
            deserializer = MoveByoipCidrToIpamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MoveByoipCidrToIpam"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provisions an IPv4 or IPv6 address range for use with your Amazon Web Services resources through bring your own IP
     * addresses (BYOIP) and creates a corresponding address pool. After the address range is
     * provisioned, it is ready to be advertised using AdvertiseByoipCidr.
     * Amazon Web Services verifies that you own the address range and are authorized to advertise it.
     * You must ensure that the address range is registered to you and that you created an
     * RPKI ROA to authorize Amazon ASNs 16509 and 14618 to advertise the address range.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring your own IP addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide.
     * Provisioning an address range is an asynchronous operation, so the call returns immediately,
     * but the address range is not ready to use until its status changes from pending-provision
     * to provisioned. To monitor the status of an address range, use DescribeByoipCidrs.
     * To allocate an Elastic IP address from your IPv4 address pool, use AllocateAddress
     * with either the specific address from the address pool or the ID of the address pool.
     */
    override suspend fun provisionByoipCidr(input: ProvisionByoipCidrRequest): ProvisionByoipCidrResponse {
        val op = SdkHttpOperation.build<ProvisionByoipCidrRequest, ProvisionByoipCidrResponse> {
            serializer = ProvisionByoipCidrOperationSerializer()
            deserializer = ProvisionByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ProvisionByoipCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provision a CIDR to an IPAM pool. You can use thsi action to provision new CIDRs to a top-level pool or to transfer a CIDR from a top-level pool to a pool within it.
     * For more information, see <a href="/vpc/latest/ipam/prov-cidr-ipam.html">Provision CIDRs to pools in the Amazon VPC IPAM User Guide.
     */
    override suspend fun provisionIpamPoolCidr(input: ProvisionIpamPoolCidrRequest): ProvisionIpamPoolCidrResponse {
        val op = SdkHttpOperation.build<ProvisionIpamPoolCidrRequest, ProvisionIpamPoolCidrResponse> {
            serializer = ProvisionIpamPoolCidrOperationSerializer()
            deserializer = ProvisionIpamPoolCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ProvisionIpamPoolCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provision a CIDR to a public IPv4 pool.
     * For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM? in the Amazon VPC IPAM User Guide.
     */
    override suspend fun provisionPublicIpv4PoolCidr(input: ProvisionPublicIpv4PoolCidrRequest): ProvisionPublicIpv4PoolCidrResponse {
        val op = SdkHttpOperation.build<ProvisionPublicIpv4PoolCidrRequest, ProvisionPublicIpv4PoolCidrResponse> {
            serializer = ProvisionPublicIpv4PoolCidrOperationSerializer()
            deserializer = ProvisionPublicIpv4PoolCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ProvisionPublicIpv4PoolCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Purchase a reservation with configurations that match those of your Dedicated Host.
     * You must have active Dedicated Hosts in your account before you purchase a reservation.
     * This action results in the specified reservation being purchased and charged to your
     * account.
     */
    override suspend fun purchaseHostReservation(input: PurchaseHostReservationRequest): PurchaseHostReservationResponse {
        val op = SdkHttpOperation.build<PurchaseHostReservationRequest, PurchaseHostReservationResponse> {
            serializer = PurchaseHostReservationOperationSerializer()
            deserializer = PurchaseHostReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PurchaseHostReservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay a lower
     * hourly rate compared to On-Demand instance pricing.
     * Use DescribeReservedInstancesOfferings to get a list of Reserved Instance offerings
     * that match your specifications. After you've purchased a Reserved Instance, you can check for your
     * new Reserved Instance with DescribeReservedInstances.
     * To queue a purchase for a future date and time, specify a purchase time. If you do not specify a
     * purchase time, the default is the current time.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved Instances and
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    override suspend fun purchaseReservedInstancesOffering(input: PurchaseReservedInstancesOfferingRequest): PurchaseReservedInstancesOfferingResponse {
        val op = SdkHttpOperation.build<PurchaseReservedInstancesOfferingRequest, PurchaseReservedInstancesOfferingResponse> {
            serializer = PurchaseReservedInstancesOfferingOperationSerializer()
            deserializer = PurchaseReservedInstancesOfferingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PurchaseReservedInstancesOffering"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Purchases the Scheduled Instances with the specified schedule.
     * Scheduled Instances enable you to purchase Amazon EC2 compute capacity by the hour for a one-year term.
     * Before you can purchase a Scheduled Instance, you must call DescribeScheduledInstanceAvailability
     * to check for available schedules and obtain a purchase token. After you purchase a Scheduled Instance,
     * you must call RunScheduledInstances during each scheduled time period.
     * After you purchase a Scheduled Instance, you can't cancel, modify, or resell your purchase.
     */
    override suspend fun purchaseScheduledInstances(input: PurchaseScheduledInstancesRequest): PurchaseScheduledInstancesResponse {
        val op = SdkHttpOperation.build<PurchaseScheduledInstancesRequest, PurchaseScheduledInstancesResponse> {
            serializer = PurchaseScheduledInstancesOperationSerializer()
            deserializer = PurchaseScheduledInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PurchaseScheduledInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests a reboot of the specified instances. This operation is asynchronous; it only
     * queues a request to reboot the specified instances. The operation succeeds if the
     * instances are valid and belong to you. Requests to reboot terminated instances are
     * ignored.
     * If an instance does not cleanly shut down within a few minutes, Amazon EC2 performs a
     * hard reboot.
     * For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html">Troubleshoot an unreachable
     * instance in the Amazon EC2 User Guide.
     */
    override suspend fun rebootInstances(input: RebootInstancesRequest): RebootInstancesResponse {
        val op = SdkHttpOperation.build<RebootInstancesRequest, RebootInstancesResponse> {
            serializer = RebootInstancesOperationSerializer()
            deserializer = RebootInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers an AMI. When you're creating an AMI, this is the final step you must complete
     * before you can launch an instance from the AMI. For more information about creating AMIs, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami.html">Creating your
     * own AMIs in the Amazon Elastic Compute Cloud User Guide.
     * For Amazon EBS-backed instances, CreateImage creates and registers
     * the AMI in a single request, so you don't have to register the AMI yourself.
     * If needed, you can deregister an AMI at any time. Any modifications you make to an AMI backed by an instance store volume invalidates its registration.
     * If you make changes to an image, deregister the previous image and register the new image.
     * Register a snapshot of a root device volume
     * You can use RegisterImage to create an Amazon EBS-backed Linux AMI from
     * a snapshot of a root device volume. You specify the snapshot using a block device mapping.
     * You can't set the encryption state of the volume using the block device mapping. If the
     * snapshot is encrypted, or encryption by default is enabled, the root volume of an instance
     * launched from the AMI is encrypted.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html#creating-launching-ami-from-snapshot">Create a Linux AMI from a snapshot and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html">Use encryption with Amazon EBS-backed AMIs
     * in the Amazon Elastic Compute Cloud User Guide.
     * Amazon Web Services Marketplace product codes
     * If any snapshots have Amazon Web Services Marketplace product codes, they are copied to the new
     * AMI.
     * Windows and some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE
     * Linux Enterprise Server (SLES), use the Amazon EC2 billing product code associated with an AMI to
     * verify the subscription status for package updates. To create a new AMI for operating systems
     * that require a billing product code, instead of registering the AMI, do the following to
     * preserve the billing product code association:
     * <ol>
     * Launch an instance from an existing AMI with that billing product code.
     * Customize the instance.
     * Create an AMI from the instance using CreateImage.
     * </ol>
     * If you purchase a Reserved Instance to apply to an On-Demand Instance that was launched
     * from an AMI with a billing product code, make sure that the Reserved Instance has the matching
     * billing product code. If you purchase a Reserved Instance without the matching billing product
     * code, the Reserved Instance will not be applied to the On-Demand Instance. For information
     * about how to obtain the platform details and billing information of an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understanding AMI
     * billing in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun registerImage(input: RegisterImageRequest): RegisterImageResponse {
        val op = SdkHttpOperation.build<RegisterImageRequest, RegisterImageResponse> {
            serializer = RegisterImageOperationSerializer()
            deserializer = RegisterImageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterImage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers a set of tag keys to include in scheduled event notifications for your resources.
     * To remove tags, use .
     */
    override suspend fun registerInstanceEventNotificationAttributes(input: RegisterInstanceEventNotificationAttributesRequest): RegisterInstanceEventNotificationAttributesResponse {
        val op = SdkHttpOperation.build<RegisterInstanceEventNotificationAttributesRequest, RegisterInstanceEventNotificationAttributesResponse> {
            serializer = RegisterInstanceEventNotificationAttributesOperationSerializer()
            deserializer = RegisterInstanceEventNotificationAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterInstanceEventNotificationAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers members (network interfaces) with the  transit gateway multicast group. A member is a network interface associated
     * with a supported EC2 instance that receives multicast traffic. For information about
     * supported instances, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/transit-gateway-limits.html#multicast-limits">Multicast
     * Consideration in Amazon VPC Transit Gateways.
     * After you add the members, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html">SearchTransitGatewayMulticastGroups to verify that the members were added
     * to the  transit gateway multicast group.
     */
    override suspend fun registerTransitGatewayMulticastGroupMembers(input: RegisterTransitGatewayMulticastGroupMembersRequest): RegisterTransitGatewayMulticastGroupMembersResponse {
        val op = SdkHttpOperation.build<RegisterTransitGatewayMulticastGroupMembersRequest, RegisterTransitGatewayMulticastGroupMembersResponse> {
            serializer = RegisterTransitGatewayMulticastGroupMembersOperationSerializer()
            deserializer = RegisterTransitGatewayMulticastGroupMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterTransitGatewayMulticastGroupMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers sources (network interfaces) with the specified  transit gateway multicast group.
     * A multicast source is a network interface attached to a supported instance that sends
     * multicast traffic. For information about supported instances, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/transit-gateway-limits.html#multicast-limits">Multicast
     * Considerations in Amazon VPC Transit Gateways.
     * After you add the source, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html">SearchTransitGatewayMulticastGroups to verify that the source was added to the multicast
     * group.
     */
    override suspend fun registerTransitGatewayMulticastGroupSources(input: RegisterTransitGatewayMulticastGroupSourcesRequest): RegisterTransitGatewayMulticastGroupSourcesResponse {
        val op = SdkHttpOperation.build<RegisterTransitGatewayMulticastGroupSourcesRequest, RegisterTransitGatewayMulticastGroupSourcesResponse> {
            serializer = RegisterTransitGatewayMulticastGroupSourcesOperationSerializer()
            deserializer = RegisterTransitGatewayMulticastGroupSourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterTransitGatewayMulticastGroupSources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rejects a request to associate cross-account subnets with a transit gateway multicast domain.
     */
    override suspend fun rejectTransitGatewayMulticastDomainAssociations(input: RejectTransitGatewayMulticastDomainAssociationsRequest): RejectTransitGatewayMulticastDomainAssociationsResponse {
        val op = SdkHttpOperation.build<RejectTransitGatewayMulticastDomainAssociationsRequest, RejectTransitGatewayMulticastDomainAssociationsResponse> {
            serializer = RejectTransitGatewayMulticastDomainAssociationsOperationSerializer()
            deserializer = RejectTransitGatewayMulticastDomainAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectTransitGatewayMulticastDomainAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rejects a transit gateway peering attachment request.
     */
    override suspend fun rejectTransitGatewayPeeringAttachment(input: RejectTransitGatewayPeeringAttachmentRequest): RejectTransitGatewayPeeringAttachmentResponse {
        val op = SdkHttpOperation.build<RejectTransitGatewayPeeringAttachmentRequest, RejectTransitGatewayPeeringAttachmentResponse> {
            serializer = RejectTransitGatewayPeeringAttachmentOperationSerializer()
            deserializer = RejectTransitGatewayPeeringAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectTransitGatewayPeeringAttachment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rejects a request to attach a VPC to a transit gateway.
     * The VPC attachment must be in the pendingAcceptance state.
     * Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests.
     * Use AcceptTransitGatewayVpcAttachment to accept a VPC attachment request.
     */
    override suspend fun rejectTransitGatewayVpcAttachment(input: RejectTransitGatewayVpcAttachmentRequest): RejectTransitGatewayVpcAttachmentResponse {
        val op = SdkHttpOperation.build<RejectTransitGatewayVpcAttachmentRequest, RejectTransitGatewayVpcAttachmentResponse> {
            serializer = RejectTransitGatewayVpcAttachmentOperationSerializer()
            deserializer = RejectTransitGatewayVpcAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectTransitGatewayVpcAttachment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rejects one or more VPC endpoint connection requests to your VPC endpoint
     * service.
     */
    override suspend fun rejectVpcEndpointConnections(input: RejectVpcEndpointConnectionsRequest): RejectVpcEndpointConnectionsResponse {
        val op = SdkHttpOperation.build<RejectVpcEndpointConnectionsRequest, RejectVpcEndpointConnectionsResponse> {
            serializer = RejectVpcEndpointConnectionsOperationSerializer()
            deserializer = RejectVpcEndpointConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectVpcEndpointConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rejects a VPC peering connection request. The VPC peering connection must be in the
     * pending-acceptance state. Use the DescribeVpcPeeringConnections request
     * to view your outstanding VPC peering connection requests. To delete an active VPC peering
     * connection, or to delete a VPC peering connection request that you initiated, use	DeleteVpcPeeringConnection.
     */
    override suspend fun rejectVpcPeeringConnection(input: RejectVpcPeeringConnectionRequest): RejectVpcPeeringConnectionResponse {
        val op = SdkHttpOperation.build<RejectVpcPeeringConnectionRequest, RejectVpcPeeringConnectionResponse> {
            serializer = RejectVpcPeeringConnectionOperationSerializer()
            deserializer = RejectVpcPeeringConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectVpcPeeringConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Releases the specified Elastic IP address.
     * &#91;EC2-Classic, default VPC&#93; Releasing an Elastic IP address automatically disassociates it
     * from any instance that it's associated with. To disassociate an Elastic IP address without
     * releasing it, use DisassociateAddress.
     * &#91;Nondefault VPC&#93; You must use DisassociateAddress to disassociate the Elastic IP address
     * before you can release it. Otherwise, Amazon EC2 returns an error (InvalidIPAddress.InUse).
     * After releasing an Elastic IP address, it is released to the IP address pool.
     * Be sure to update your DNS records and any servers or devices that communicate with the address.
     * If you attempt to release an Elastic IP address that you already released, you'll get an
     * AuthFailure error if the address is already allocated to another Amazon Web Services account.
     * &#91;EC2-VPC&#93; After you release an Elastic IP address for use in a VPC, you might be able to recover it.
     * For more information, see AllocateAddress.
     */
    override suspend fun releaseAddress(input: ReleaseAddressRequest): ReleaseAddressResponse {
        val op = SdkHttpOperation.build<ReleaseAddressRequest, ReleaseAddressResponse> {
            serializer = ReleaseAddressOperationSerializer()
            deserializer = ReleaseAddressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReleaseAddress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * When you no longer want to use an On-Demand Dedicated Host it can be released.
     * On-Demand billing is stopped and the host goes into released state. The
     * host ID of Dedicated Hosts that have been released can no longer be specified in another
     * request, for example, to modify the host. You must stop or terminate all instances on a
     * host before it can be released.
     * When Dedicated Hosts are released, it may take some time for them to stop counting
     * toward your limit and you may receive capacity errors when trying to allocate new
     * Dedicated Hosts. Wait a few minutes and then try again.
     * Released hosts still appear in a DescribeHosts response.
     */
    override suspend fun releaseHosts(input: ReleaseHostsRequest): ReleaseHostsResponse {
        val op = SdkHttpOperation.build<ReleaseHostsRequest, ReleaseHostsResponse> {
            serializer = ReleaseHostsOperationSerializer()
            deserializer = ReleaseHostsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReleaseHosts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Release an allocation within an IPAM pool. You can only use this action to release manual allocations. To remove an allocation for a resource without deleting the resource, set its monitored state to false using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIpamResourceCidr.html">ModifyIpamResourceCidr. For more information, see <a href="/vpc/latest/ipam/release-pool-alloc-ipam.html">Release an allocation in the Amazon VPC IPAM User Guide.
     */
    override suspend fun releaseIpamPoolAllocation(input: ReleaseIpamPoolAllocationRequest): ReleaseIpamPoolAllocationResponse {
        val op = SdkHttpOperation.build<ReleaseIpamPoolAllocationRequest, ReleaseIpamPoolAllocationResponse> {
            serializer = ReleaseIpamPoolAllocationOperationSerializer()
            deserializer = ReleaseIpamPoolAllocationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReleaseIpamPoolAllocation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Replaces an IAM instance profile for the specified running instance. You can use
     * this action to change the IAM instance profile that's associated with an instance
     * without having to disassociate the existing IAM instance profile first.
     * Use DescribeIamInstanceProfileAssociations to get the association
     * ID.
     */
    override suspend fun replaceIamInstanceProfileAssociation(input: ReplaceIamInstanceProfileAssociationRequest): ReplaceIamInstanceProfileAssociationResponse {
        val op = SdkHttpOperation.build<ReplaceIamInstanceProfileAssociationRequest, ReplaceIamInstanceProfileAssociationResponse> {
            serializer = ReplaceIamInstanceProfileAssociationOperationSerializer()
            deserializer = ReplaceIamInstanceProfileAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReplaceIamInstanceProfileAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes which network ACL a subnet is associated with. By default when you create a
     * subnet, it's automatically associated with the default network ACL. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network
     * ACLs in the Amazon Virtual Private Cloud User Guide.
     * This is an idempotent operation.
     */
    override suspend fun replaceNetworkAclAssociation(input: ReplaceNetworkAclAssociationRequest): ReplaceNetworkAclAssociationResponse {
        val op = SdkHttpOperation.build<ReplaceNetworkAclAssociationRequest, ReplaceNetworkAclAssociationResponse> {
            serializer = ReplaceNetworkAclAssociationOperationSerializer()
            deserializer = ReplaceNetworkAclAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReplaceNetworkAclAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Replaces an entry (rule) in a network ACL. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun replaceNetworkAclEntry(input: ReplaceNetworkAclEntryRequest): ReplaceNetworkAclEntryResponse {
        val op = SdkHttpOperation.build<ReplaceNetworkAclEntryRequest, ReplaceNetworkAclEntryResponse> {
            serializer = ReplaceNetworkAclEntryOperationSerializer()
            deserializer = ReplaceNetworkAclEntryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReplaceNetworkAclEntry"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Replaces an existing route within a route table in a VPC. You must provide only one of
     * the following: internet gateway, virtual private gateway, NAT instance, NAT gateway, VPC
     * peering connection, network interface, egress-only internet gateway, or transit
     * gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    override suspend fun replaceRoute(input: ReplaceRouteRequest): ReplaceRouteResponse {
        val op = SdkHttpOperation.build<ReplaceRouteRequest, ReplaceRouteResponse> {
            serializer = ReplaceRouteOperationSerializer()
            deserializer = ReplaceRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReplaceRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the route table associated with a given subnet, internet gateway, or virtual private gateway in a VPC. After the operation
     * completes, the subnet or gateway uses the routes in the new route table. For more
     * information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables in the Amazon Virtual Private Cloud User Guide.
     * You can also use this operation to change which table is the main route table in the VPC. Specify the main route table's association ID and the route table ID of the new main route table.
     */
    override suspend fun replaceRouteTableAssociation(input: ReplaceRouteTableAssociationRequest): ReplaceRouteTableAssociationResponse {
        val op = SdkHttpOperation.build<ReplaceRouteTableAssociationRequest, ReplaceRouteTableAssociationResponse> {
            serializer = ReplaceRouteTableAssociationOperationSerializer()
            deserializer = ReplaceRouteTableAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReplaceRouteTableAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the specified route in the specified transit gateway route table.
     */
    override suspend fun replaceTransitGatewayRoute(input: ReplaceTransitGatewayRouteRequest): ReplaceTransitGatewayRouteResponse {
        val op = SdkHttpOperation.build<ReplaceTransitGatewayRouteRequest, ReplaceTransitGatewayRouteResponse> {
            serializer = ReplaceTransitGatewayRouteOperationSerializer()
            deserializer = ReplaceTransitGatewayRouteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReplaceTransitGatewayRoute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Submits feedback about the status of an instance. The instance must be in the
     * running state. If your experience with the instance differs from the
     * instance status returned by DescribeInstanceStatus, use ReportInstanceStatus to report your experience with the instance. Amazon
     * EC2 collects this information to improve the accuracy of status checks.
     * Use of this action does not change the value returned by DescribeInstanceStatus.
     */
    override suspend fun reportInstanceStatus(input: ReportInstanceStatusRequest): ReportInstanceStatusResponse {
        val op = SdkHttpOperation.build<ReportInstanceStatusRequest, ReportInstanceStatusResponse> {
            serializer = ReportInstanceStatusOperationSerializer()
            deserializer = ReportInstanceStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReportInstanceStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Spot Fleet request.
     * The Spot Fleet request specifies the total target capacity and the On-Demand target
     * capacity. Amazon EC2 calculates the difference between the total capacity and On-Demand
     * capacity, and launches the difference as Spot capacity.
     * You can submit a single request that includes multiple launch specifications that vary
     * by instance type, AMI, Availability Zone, or subnet.
     * By default, the Spot Fleet requests Spot Instances in the Spot Instance pool where the
     * price per unit is the lowest. Each launch specification can include its own instance
     * weighting that reflects the value of the instance type to your application
     * workload.
     * Alternatively, you can specify that the Spot Fleet distribute the target capacity
     * across the Spot pools included in its launch specifications. By ensuring that the Spot
     * Instances in your Spot Fleet are in different Spot pools, you can improve the
     * availability of your fleet.
     * You can specify tags for the Spot Fleet request and instances launched by the fleet.
     * You cannot tag other resource types in a Spot Fleet request because only the
     * spot-fleet-request and instance resource types are
     * supported.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html">Spot Fleet requests
     * in the Amazon EC2 User Guide for Linux Instances.
     */
    override suspend fun requestSpotFleet(input: RequestSpotFleetRequest): RequestSpotFleetResponse {
        val op = SdkHttpOperation.build<RequestSpotFleetRequest, RequestSpotFleetResponse> {
            serializer = RequestSpotFleetOperationSerializer()
            deserializer = RequestSpotFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RequestSpotFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Spot Instance request.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance requests in
     * the Amazon EC2 User Guide for Linux Instances.
     */
    override suspend fun requestSpotInstances(input: RequestSpotInstancesRequest): RequestSpotInstancesResponse {
        val op = SdkHttpOperation.build<RequestSpotInstancesRequest, RequestSpotInstancesResponse> {
            serializer = RequestSpotInstancesOperationSerializer()
            deserializer = RequestSpotInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RequestSpotInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets the attribute of the specified IP address. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications.
     */
    override suspend fun resetAddressAttribute(input: ResetAddressAttributeRequest): ResetAddressAttributeResponse {
        val op = SdkHttpOperation.build<ResetAddressAttributeRequest, ResetAddressAttributeResponse> {
            serializer = ResetAddressAttributeOperationSerializer()
            deserializer = ResetAddressAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetAddressAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets the default KMS key for EBS encryption for your account in this Region
     * to the Amazon Web Services managed KMS key for EBS.
     * After resetting the default KMS key to the Amazon Web Services managed KMS key, you can continue to encrypt by a
     * customer managed KMS key by specifying it when you create the volume. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun resetEbsDefaultKmsKeyId(input: ResetEbsDefaultKmsKeyIdRequest): ResetEbsDefaultKmsKeyIdResponse {
        val op = SdkHttpOperation.build<ResetEbsDefaultKmsKeyIdRequest, ResetEbsDefaultKmsKeyIdResponse> {
            serializer = ResetEbsDefaultKmsKeyIdOperationSerializer()
            deserializer = ResetEbsDefaultKmsKeyIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetEbsDefaultKmsKeyId"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets the specified attribute of the specified Amazon FPGA Image (AFI) to its default value.
     * You can only reset the load permission attribute.
     */
    override suspend fun resetFpgaImageAttribute(input: ResetFpgaImageAttributeRequest): ResetFpgaImageAttributeResponse {
        val op = SdkHttpOperation.build<ResetFpgaImageAttributeRequest, ResetFpgaImageAttributeResponse> {
            serializer = ResetFpgaImageAttributeOperationSerializer()
            deserializer = ResetFpgaImageAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetFpgaImageAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets an attribute of an AMI to its default value.
     */
    override suspend fun resetImageAttribute(input: ResetImageAttributeRequest): ResetImageAttributeResponse {
        val op = SdkHttpOperation.build<ResetImageAttributeRequest, ResetImageAttributeResponse> {
            serializer = ResetImageAttributeOperationSerializer()
            deserializer = ResetImageAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetImageAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets an attribute of an instance to its default value. To reset the
     * kernel or ramdisk, the instance must be in a stopped
     * state. To reset the sourceDestCheck, the instance can be either running or
     * stopped.
     * The sourceDestCheck attribute controls whether source/destination
     * checking is enabled. The default value is true, which means checking is
     * enabled. This value must be false for a NAT instance to perform NAT. For
     * more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances in the
     * Amazon VPC User Guide.
     */
    override suspend fun resetInstanceAttribute(input: ResetInstanceAttributeRequest): ResetInstanceAttributeResponse {
        val op = SdkHttpOperation.build<ResetInstanceAttributeRequest, ResetInstanceAttributeResponse> {
            serializer = ResetInstanceAttributeOperationSerializer()
            deserializer = ResetInstanceAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetInstanceAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets a network interface attribute. You can specify only one attribute at a time.
     */
    override suspend fun resetNetworkInterfaceAttribute(input: ResetNetworkInterfaceAttributeRequest): ResetNetworkInterfaceAttributeResponse {
        val op = SdkHttpOperation.build<ResetNetworkInterfaceAttributeRequest, ResetNetworkInterfaceAttributeResponse> {
            serializer = ResetNetworkInterfaceAttributeOperationSerializer()
            deserializer = ResetNetworkInterfaceAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetNetworkInterfaceAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets permission settings for the specified snapshot.
     * For more information about modifying snapshot permissions, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Share a snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun resetSnapshotAttribute(input: ResetSnapshotAttributeRequest): ResetSnapshotAttributeResponse {
        val op = SdkHttpOperation.build<ResetSnapshotAttributeRequest, ResetSnapshotAttributeResponse> {
            serializer = ResetSnapshotAttributeOperationSerializer()
            deserializer = ResetSnapshotAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetSnapshotAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Restores an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform. You cannot move an Elastic IP address that was originally allocated for use in EC2-VPC. The Elastic IP address must not be associated with an instance or network interface.
     */
    override suspend fun restoreAddressToClassic(input: RestoreAddressToClassicRequest): RestoreAddressToClassicResponse {
        val op = SdkHttpOperation.build<RestoreAddressToClassicRequest, RestoreAddressToClassicResponse> {
            serializer = RestoreAddressToClassicOperationSerializer()
            deserializer = RestoreAddressToClassicOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreAddressToClassic"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Restores the entries from a previous version of a managed prefix list to a new version of the prefix list.
     */
    override suspend fun restoreManagedPrefixListVersion(input: RestoreManagedPrefixListVersionRequest): RestoreManagedPrefixListVersionResponse {
        val op = SdkHttpOperation.build<RestoreManagedPrefixListVersionRequest, RestoreManagedPrefixListVersionResponse> {
            serializer = RestoreManagedPrefixListVersionOperationSerializer()
            deserializer = RestoreManagedPrefixListVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreManagedPrefixListVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Restores a snapshot from the Recycle Bin. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-snaps.html#recycle-bin-restore-snaps">Restore
     * snapshots from the Recycle Bin in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun restoreSnapshotFromRecycleBin(input: RestoreSnapshotFromRecycleBinRequest): RestoreSnapshotFromRecycleBinResponse {
        val op = SdkHttpOperation.build<RestoreSnapshotFromRecycleBinRequest, RestoreSnapshotFromRecycleBinResponse> {
            serializer = RestoreSnapshotFromRecycleBinOperationSerializer()
            deserializer = RestoreSnapshotFromRecycleBinOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreSnapshotFromRecycleBin"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Restores an archived Amazon EBS snapshot for use temporarily or permanently, or modifies the restore
     * period or restore type for a snapshot that was previously temporarily restored.
     * For more information see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/working-with-snapshot-archiving.html#restore-archived-snapshot">
     * Restore an archived snapshot and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/working-with-snapshot-archiving.html#modify-temp-restore-period">
     * modify the restore period or restore type for a temporarily restored snapshot in the Amazon Elastic Compute Cloud User Guide.
     */
    override suspend fun restoreSnapshotTier(input: RestoreSnapshotTierRequest): RestoreSnapshotTierResponse {
        val op = SdkHttpOperation.build<RestoreSnapshotTierRequest, RestoreSnapshotTierResponse> {
            serializer = RestoreSnapshotTierOperationSerializer()
            deserializer = RestoreSnapshotTierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreSnapshotTier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an ingress authorization rule from a Client VPN endpoint.
     */
    override suspend fun revokeClientVpnIngress(input: RevokeClientVpnIngressRequest): RevokeClientVpnIngressResponse {
        val op = SdkHttpOperation.build<RevokeClientVpnIngressRequest, RevokeClientVpnIngressResponse> {
            serializer = RevokeClientVpnIngressOperationSerializer()
            deserializer = RevokeClientVpnIngressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeClientVpnIngress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * &#91;VPC only&#93; Removes the specified outbound (egress) rules from a security group for EC2-VPC.
     * This action does not apply to security groups for use in EC2-Classic.
     * You can specify rules using either rule IDs or security group rule properties. If you use
     * rule properties, the values that you specify (for example, ports) must match the existing rule's
     * values exactly. Each rule has a protocol, from and to ports, and destination (CIDR range,
     * security group, or prefix list). For the TCP and UDP protocols, you must also specify the
     * destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type
     * and code. If the security group rule has a description, you do not need to specify the description
     * to revoke the rule.
     * &#91;Default VPC&#93; If the values you specify do not match the existing rule's values, no error is
     * returned, and the output describes the security group rules that were not revoked.
     * Amazon Web Services recommends that you describe the security group to verify that the rules were removed.
     * Rule changes are propagated to instances within the security group as quickly as possible. However,
     * a small delay might occur.
     */
    override suspend fun revokeSecurityGroupEgress(input: RevokeSecurityGroupEgressRequest): RevokeSecurityGroupEgressResponse {
        val op = SdkHttpOperation.build<RevokeSecurityGroupEgressRequest, RevokeSecurityGroupEgressResponse> {
            serializer = RevokeSecurityGroupEgressOperationSerializer()
            deserializer = RevokeSecurityGroupEgressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeSecurityGroupEgress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified inbound (ingress) rules from a security group.
     * You can specify rules using either rule IDs or security group rule properties. If you use
     * rule properties, the values that you specify (for example, ports) must match the existing rule's
     * values exactly. Each rule has a protocol, from and to ports, and source (CIDR range,
     * security group, or prefix list). For the TCP and UDP protocols, you must also specify the
     * destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type
     * and code. If the security group rule has a description, you do not need to specify the description
     * to revoke the rule.
     * &#91;EC2-Classic, default VPC&#93; If the values you specify do not match the existing rule's values, no error is
     * returned, and the output describes the security group rules that were not revoked.
     * Amazon Web Services recommends that you describe the security group to verify that the rules were removed.
     * Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.
     */
    override suspend fun revokeSecurityGroupIngress(input: RevokeSecurityGroupIngressRequest): RevokeSecurityGroupIngressResponse {
        val op = SdkHttpOperation.build<RevokeSecurityGroupIngressRequest, RevokeSecurityGroupIngressResponse> {
            serializer = RevokeSecurityGroupIngressOperationSerializer()
            deserializer = RevokeSecurityGroupIngressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeSecurityGroupIngress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Launches the specified number of instances using an AMI for which you have
     * permissions.
     * You can specify a number of options, or leave the default options. The following rules
     * apply:
     * &#91;EC2-VPC&#93; If you don't specify a subnet ID, we choose a default subnet from
     * your default VPC for you. If you don't have a default VPC, you must specify a
     * subnet ID in the request.
     * &#91;EC2-Classic&#93; If don't specify an Availability Zone, we choose one for
     * you.
     * Some instance types must be launched into a VPC. If you do not have a default
     * VPC, or if you do not specify a subnet ID, the request fails. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-vpc.html#vpc-only-instance-types">Instance types available only in a VPC.
     * &#91;EC2-VPC&#93; All instances have a network interface with a primary private IPv4
     * address. If you don't specify this address, we choose one from the IPv4 range of
     * your subnet.
     * Not all instance types support IPv6 addresses. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance
     * types.
     * If you don't specify a security group ID, we use the default security group.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Security
     * groups.
     * If any of the AMIs have a product code attached for which the user has not
     * subscribed, the request fails.
     * You can create a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">launch template,
     * which is a resource that contains the parameters to launch an instance. When you launch
     * an instance using RunInstances, you can specify the launch template
     * instead of specifying the launch parameters.
     * To ensure faster instance launches, break up large requests into smaller batches. For
     * example, create five separate launch requests for 100 instances each instead of one
     * launch request for 500 instances.
     * An instance is ready for you to use when it's in the running state. You
     * can check the state of your instance using DescribeInstances. You can
     * tag instances and EBS volumes during launch, after launch, or both. For more
     * information, see CreateTags and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2
     * resources.
     * Linux instances have access to the public key of the key pair at boot. You can use
     * this key to provide secure access to the instance. Amazon EC2 public images use this
     * feature to provide secure access without passwords. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key
     * pairs.
     * For troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_InstanceStraightToTerminated.html">What to do if
     * an instance immediately terminates, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesConnecting.html">Troubleshooting connecting to your instance.
     */
    override suspend fun runInstances(input: RunInstancesRequest): RunInstancesResponse {
        val op = SdkHttpOperation.build<RunInstancesRequest, RunInstancesResponse> {
            serializer = RunInstancesOperationSerializer()
            deserializer = RunInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RunInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Launches the specified Scheduled Instances.
     * Before you can launch a Scheduled Instance, you must purchase it and obtain an identifier using PurchaseScheduledInstances.
     * You must launch a Scheduled Instance during its scheduled time period. You can't stop or reboot a Scheduled Instance,
     * but you can terminate it as needed. If you terminate a Scheduled Instance before the current scheduled time period ends,
     * you can launch it again after a few minutes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-scheduled-instances.html">Scheduled Instances
     * in the Amazon EC2 User Guide.
     */
    override suspend fun runScheduledInstances(input: RunScheduledInstancesRequest): RunScheduledInstancesResponse {
        val op = SdkHttpOperation.build<RunScheduledInstancesRequest, RunScheduledInstancesResponse> {
            serializer = RunScheduledInstancesOperationSerializer()
            deserializer = RunScheduledInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RunScheduledInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for routes in the specified local gateway route table.
     */
    override suspend fun searchLocalGatewayRoutes(input: SearchLocalGatewayRoutesRequest): SearchLocalGatewayRoutesResponse {
        val op = SdkHttpOperation.build<SearchLocalGatewayRoutesRequest, SearchLocalGatewayRoutesResponse> {
            serializer = SearchLocalGatewayRoutesOperationSerializer()
            deserializer = SearchLocalGatewayRoutesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchLocalGatewayRoutes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches one or more  transit gateway multicast groups and returns the group membership information.
     */
    override suspend fun searchTransitGatewayMulticastGroups(input: SearchTransitGatewayMulticastGroupsRequest): SearchTransitGatewayMulticastGroupsResponse {
        val op = SdkHttpOperation.build<SearchTransitGatewayMulticastGroupsRequest, SearchTransitGatewayMulticastGroupsResponse> {
            serializer = SearchTransitGatewayMulticastGroupsOperationSerializer()
            deserializer = SearchTransitGatewayMulticastGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchTransitGatewayMulticastGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for routes in the specified transit gateway route table.
     */
    override suspend fun searchTransitGatewayRoutes(input: SearchTransitGatewayRoutesRequest): SearchTransitGatewayRoutesResponse {
        val op = SdkHttpOperation.build<SearchTransitGatewayRoutesRequest, SearchTransitGatewayRoutesResponse> {
            serializer = SearchTransitGatewayRoutesOperationSerializer()
            deserializer = SearchTransitGatewayRoutesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchTransitGatewayRoutes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends a diagnostic interrupt to the specified Amazon EC2 instance to trigger a
     * kernel panic (on Linux instances), or a
     * blue screen/stop error (on Windows
     * instances). For instances based on Intel and AMD processors, the interrupt is
     * received as a non-maskable interrupt (NMI).
     * In general, the operating system crashes and reboots when a kernel panic or stop
     * error is triggered. The operating system can also be configured to perform diagnostic
     * tasks, such as generating a memory dump file, loading a secondary kernel, or
     * obtaining a call trace.
     * Before sending a diagnostic interrupt to your instance, ensure that its operating
     * system is configured to perform the required diagnostic tasks.
     * For more information about configuring your operating system to generate a crash dump
     * when a kernel panic or stop error occurs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/diagnostic-interrupt.html">Send a diagnostic interrupt (for advanced users) (Linux instances) or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/diagnostic-interrupt.html">Send a diagnostic interrupt (for advanced users) (Windows instances).
     */
    override suspend fun sendDiagnosticInterrupt(input: SendDiagnosticInterruptRequest): SendDiagnosticInterruptResponse {
        val op = SdkHttpOperation.build<SendDiagnosticInterruptRequest, SendDiagnosticInterruptResponse> {
            serializer = SendDiagnosticInterruptOperationSerializer()
            deserializer = SendDiagnosticInterruptOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendDiagnosticInterrupt"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an Amazon EBS-backed instance that you've previously stopped.
     * Instances that use Amazon EBS volumes as their root devices can be quickly stopped and
     * started. When an instance is stopped, the compute resources are released and you are not
     * billed for instance usage. However, your root partition Amazon EBS volume remains and
     * continues to persist your data, and you are charged for Amazon EBS volume usage. You can
     * restart your instance at any time. Every time you start your instance, Amazon EC2
     * charges a one-minute minimum for instance usage, and thereafter charges per second for
     * instance usage.
     * Before stopping an instance, make sure it is in a state from which it can be
     * restarted. Stopping an instance does not preserve data stored in RAM.
     * Performing this operation on an instance that uses an instance store as its root
     * device returns an error.
     * If you attempt to start a T3 instance with host tenancy and the unlimted
     * CPU credit option, the request fails. The unlimited CPU credit option is not
     * supported on Dedicated Hosts. Before you start the instance, either change its CPU credit
     * option to standard, or change its tenancy to default or dedicated.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html">Stop and start your instance
     * in the Amazon EC2 User Guide.
     */
    override suspend fun startInstances(input: StartInstancesRequest): StartInstancesResponse {
        val op = SdkHttpOperation.build<StartInstancesRequest, StartInstancesResponse> {
            serializer = StartInstancesOperationSerializer()
            deserializer = StartInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts analyzing the specified Network Access Scope.
     */
    override suspend fun startNetworkInsightsAccessScopeAnalysis(input: StartNetworkInsightsAccessScopeAnalysisRequest): StartNetworkInsightsAccessScopeAnalysisResponse {
        val op = SdkHttpOperation.build<StartNetworkInsightsAccessScopeAnalysisRequest, StartNetworkInsightsAccessScopeAnalysisResponse> {
            serializer = StartNetworkInsightsAccessScopeAnalysisOperationSerializer()
            deserializer = StartNetworkInsightsAccessScopeAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartNetworkInsightsAccessScopeAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts analyzing the specified path. If the path is reachable, the
     * operation returns the shortest feasible path.
     */
    override suspend fun startNetworkInsightsAnalysis(input: StartNetworkInsightsAnalysisRequest): StartNetworkInsightsAnalysisResponse {
        val op = SdkHttpOperation.build<StartNetworkInsightsAnalysisRequest, StartNetworkInsightsAnalysisResponse> {
            serializer = StartNetworkInsightsAnalysisOperationSerializer()
            deserializer = StartNetworkInsightsAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartNetworkInsightsAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Initiates the verification process to prove that the service provider owns the private
     * DNS name domain for the endpoint service.
     * The service provider must successfully perform the verification before the consumer can use the name to access the service.
     * Before the service provider runs this command, they must add a record to the DNS server. For more information, see  <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html#add-dns-txt-record">Adding a TXT Record to Your Domain's DNS Server  in the Amazon VPC User Guide.
     */
    override suspend fun startVpcEndpointServicePrivateDnsVerification(input: StartVpcEndpointServicePrivateDnsVerificationRequest): StartVpcEndpointServicePrivateDnsVerificationResponse {
        val op = SdkHttpOperation.build<StartVpcEndpointServicePrivateDnsVerificationRequest, StartVpcEndpointServicePrivateDnsVerificationResponse> {
            serializer = StartVpcEndpointServicePrivateDnsVerificationOperationSerializer()
            deserializer = StartVpcEndpointServicePrivateDnsVerificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartVpcEndpointServicePrivateDnsVerification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops an Amazon EBS-backed instance.
     * You can use the Stop action to hibernate an instance if the instance is <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#enabling-hibernation">enabled for
     * hibernation and it meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation
     * prerequisites. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance in the
     * Amazon EC2 User Guide.
     * We don't charge usage for a stopped instance, or data transfer fees; however, your
     * root partition Amazon EBS volume remains and continues to persist your data, and you are
     * charged for Amazon EBS volume usage. Every time you start your instance, Amazon EC2
     * charges a one-minute minimum for instance usage, and thereafter charges per second for
     * instance usage.
     * You can't stop or hibernate instance store-backed instances. You can't use the Stop
     * action to hibernate Spot Instances, but you can specify that Amazon EC2 should hibernate
     * Spot Instances when they are interrupted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-interruptions.html#hibernate-spot-instances">Hibernating interrupted Spot Instances in the Amazon EC2 User Guide.
     * When you stop or hibernate an instance, we shut it down. You can restart your instance
     * at any time. Before stopping or hibernating an instance, make sure it is in a state from
     * which it can be restarted. Stopping an instance does not preserve data stored in RAM,
     * but hibernating an instance does preserve data stored in RAM. If an instance cannot
     * hibernate successfully, a normal shutdown occurs.
     * Stopping and hibernating an instance is different to rebooting or terminating it. For
     * example, when you stop or hibernate an instance, the root device and any other devices
     * attached to the instance persist. When you terminate an instance, the root device and
     * any other devices attached during the instance launch are automatically deleted. For
     * more information about the differences between rebooting, stopping, hibernating, and
     * terminating instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle
     * in the Amazon EC2 User Guide.
     * When you stop an instance, we attempt to shut it down forcibly after a short while. If
     * your instance appears stuck in the stopping state after a period of time, there may be
     * an issue with the underlying host computer. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html">Troubleshoot
     * stopping your instance in the Amazon EC2 User Guide.
     */
    override suspend fun stopInstances(input: StopInstancesRequest): StopInstancesResponse {
        val op = SdkHttpOperation.build<StopInstancesRequest, StopInstancesResponse> {
            serializer = StopInstancesOperationSerializer()
            deserializer = StopInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Terminates active Client VPN endpoint connections. This action can be used to terminate a specific client connection, or up to five connections established by a specific user.
     */
    override suspend fun terminateClientVpnConnections(input: TerminateClientVpnConnectionsRequest): TerminateClientVpnConnectionsResponse {
        val op = SdkHttpOperation.build<TerminateClientVpnConnectionsRequest, TerminateClientVpnConnectionsResponse> {
            serializer = TerminateClientVpnConnectionsOperationSerializer()
            deserializer = TerminateClientVpnConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TerminateClientVpnConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Shuts down the specified instances. This operation is idempotent; if you terminate an
     * instance more than once, each call succeeds.
     * If you specify multiple instances and the request fails (for example, because of a
     * single incorrect instance ID), none of the instances are terminated.
     * If you terminate multiple instances across multiple Availability Zones, and one or more
     * of the specified instances are enabled for termination protection, the request fails with
     * the following results:
     * The specified instances that are in the same Availability Zone as the protected
     * instance are not terminated.
     * The specified instances that are in different Availability Zones, where no other
     * specified instances are protected, are successfully terminated.
     * For example, say you have the following instances:
     * Instance A: us-east-1a; Not protected
     * Instance B: us-east-1a; Not protected
     * Instance C: us-east-1b; Protected
     * Instance D: us-east-1b; not protected
     * If you attempt to terminate all of these instances in the same request, the request reports
     * failure with the following results:
     * Instance A and Instance B are successfully terminated because none of the specified
     * instances in us-east-1a are enabled for termination protection.
     * Instance C and Instance D fail to terminate because at least one of the specified
     * instances in us-east-1b (Instance C) is enabled for termination protection.
     * Terminated instances remain visible after termination (for approximately one
     * hour).
     * By default, Amazon EC2 deletes all EBS volumes that were attached when the instance
     * launched. Volumes attached after instance launch continue running.
     * You can stop, start, and terminate EBS-backed instances. You can only terminate
     * instance store-backed instances. What happens to an instance differs if you stop it or
     * terminate it. For example, when you stop an instance, the root device and any other
     * devices attached to the instance persist. When you terminate an instance, any attached
     * EBS volumes with the DeleteOnTermination block device mapping parameter set
     * to true are automatically deleted. For more information about the
     * differences between stopping and terminating instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle
     * in the Amazon EC2 User Guide.
     * For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html">Troubleshooting terminating your instance in the Amazon EC2 User Guide.
     */
    override suspend fun terminateInstances(input: TerminateInstancesRequest): TerminateInstancesResponse {
        val op = SdkHttpOperation.build<TerminateInstancesRequest, TerminateInstancesResponse> {
            serializer = TerminateInstancesOperationSerializer()
            deserializer = TerminateInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TerminateInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Unassigns one or more IPv6 addresses IPv4 Prefix Delegation prefixes from a network interface.
     */
    override suspend fun unassignIpv6Addresses(input: UnassignIpv6AddressesRequest): UnassignIpv6AddressesResponse {
        val op = SdkHttpOperation.build<UnassignIpv6AddressesRequest, UnassignIpv6AddressesResponse> {
            serializer = UnassignIpv6AddressesOperationSerializer()
            deserializer = UnassignIpv6AddressesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UnassignIpv6Addresses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Unassigns one or more secondary private IP addresses, or IPv4 Prefix Delegation prefixes from a network interface.
     */
    override suspend fun unassignPrivateIpAddresses(input: UnassignPrivateIpAddressesRequest): UnassignPrivateIpAddressesResponse {
        val op = SdkHttpOperation.build<UnassignPrivateIpAddressesRequest, UnassignPrivateIpAddressesResponse> {
            serializer = UnassignPrivateIpAddressesOperationSerializer()
            deserializer = UnassignPrivateIpAddressesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UnassignPrivateIpAddresses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables detailed monitoring for a running instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring
     * your instances and volumes in the Amazon EC2 User Guide.
     */
    override suspend fun unmonitorInstances(input: UnmonitorInstancesRequest): UnmonitorInstancesResponse {
        val op = SdkHttpOperation.build<UnmonitorInstancesRequest, UnmonitorInstancesResponse> {
            serializer = UnmonitorInstancesOperationSerializer()
            deserializer = UnmonitorInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UnmonitorInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * &#91;VPC only&#93; Updates the description of an egress (outbound) security group rule. You
     * can replace an existing description, or add a description to a rule that did not have one
     * previously. You can remove a description for a security group rule by omitting the
     * description parameter in the request.
     */
    override suspend fun updateSecurityGroupRuleDescriptionsEgress(input: UpdateSecurityGroupRuleDescriptionsEgressRequest): UpdateSecurityGroupRuleDescriptionsEgressResponse {
        val op = SdkHttpOperation.build<UpdateSecurityGroupRuleDescriptionsEgressRequest, UpdateSecurityGroupRuleDescriptionsEgressResponse> {
            serializer = UpdateSecurityGroupRuleDescriptionsEgressOperationSerializer()
            deserializer = UpdateSecurityGroupRuleDescriptionsEgressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSecurityGroupRuleDescriptionsEgress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the description of an ingress (inbound) security group rule. You can replace an
     * existing description, or add a description to a rule that did not have one previously.
     * You can remove a description for a security group rule by omitting the description
     * parameter in the request.
     */
    override suspend fun updateSecurityGroupRuleDescriptionsIngress(input: UpdateSecurityGroupRuleDescriptionsIngressRequest): UpdateSecurityGroupRuleDescriptionsIngressResponse {
        val op = SdkHttpOperation.build<UpdateSecurityGroupRuleDescriptionsIngressRequest, UpdateSecurityGroupRuleDescriptionsIngressResponse> {
            serializer = UpdateSecurityGroupRuleDescriptionsIngressOperationSerializer()
            deserializer = UpdateSecurityGroupRuleDescriptionsIngressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSecurityGroupRuleDescriptionsIngress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops advertising an address range that is provisioned as an address pool.
     * You can perform this operation at most once every 10 seconds, even if you specify different
     * address ranges each time.
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services
     * because of BGP propagation delays.
     */
    override suspend fun withdrawByoipCidr(input: WithdrawByoipCidrRequest): WithdrawByoipCidrResponse {
        val op = SdkHttpOperation.build<WithdrawByoipCidrRequest, WithdrawByoipCidrResponse> {
            serializer = WithdrawByoipCidrOperationSerializer()
            deserializer = WithdrawByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "WithdrawByoipCidr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "ec2"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
