// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class AllocateAddressRequest private constructor(builder: Builder) {
    /**
     * &#91;EC2-VPC&#93; The Elastic IP address to recover or an IPv4 address from an address pool.
     */
    val address: kotlin.String? = builder.address
    /**
     * The ID of a customer-owned address pool. Use this parameter to let Amazon EC2
     * select an address from the address pool. Alternatively, specify a specific
     * address from the address pool.
     */
    val customerOwnedIpv4Pool: kotlin.String? = builder.customerOwnedIpv4Pool
    /**
     * Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.
     * Default: If the Region supports EC2-Classic, the default is standard. Otherwise, the default
     * is vpc.
     */
    val domain: aws.sdk.kotlin.services.ec2.model.DomainType? = builder.domain
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * A unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services
     * advertises IP addresses. Use this parameter to limit the IP address to this location. IP
     * addresses cannot move between network border groups.
     * Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones to view the network border groups.
     * You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 Classic,
     * you receive an InvalidParameterCombination error.
     */
    val networkBorderGroup: kotlin.String? = builder.networkBorderGroup
    /**
     * The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool.
     * To specify a specific address from the address pool, use the Address parameter instead.
     */
    val publicIpv4Pool: kotlin.String? = builder.publicIpv4Pool
    /**
     * The tags to assign to the Elastic IP address.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.AllocateAddressRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AllocateAddressRequest(")
        append("address=$address,")
        append("customerOwnedIpv4Pool=$customerOwnedIpv4Pool,")
        append("domain=$domain,")
        append("dryRun=$dryRun,")
        append("networkBorderGroup=$networkBorderGroup,")
        append("publicIpv4Pool=$publicIpv4Pool,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (customerOwnedIpv4Pool?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (networkBorderGroup?.hashCode() ?: 0)
        result = 31 * result + (publicIpv4Pool?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AllocateAddressRequest

        if (address != other.address) return false
        if (customerOwnedIpv4Pool != other.customerOwnedIpv4Pool) return false
        if (domain != other.domain) return false
        if (dryRun != other.dryRun) return false
        if (networkBorderGroup != other.networkBorderGroup) return false
        if (publicIpv4Pool != other.publicIpv4Pool) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.AllocateAddressRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * &#91;EC2-VPC&#93; The Elastic IP address to recover or an IPv4 address from an address pool.
         */
        var address: kotlin.String? = null
        /**
         * The ID of a customer-owned address pool. Use this parameter to let Amazon EC2
         * select an address from the address pool. Alternatively, specify a specific
         * address from the address pool.
         */
        var customerOwnedIpv4Pool: kotlin.String? = null
        /**
         * Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.
         * Default: If the Region supports EC2-Classic, the default is standard. Otherwise, the default
         * is vpc.
         */
        var domain: aws.sdk.kotlin.services.ec2.model.DomainType? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * A unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services
         * advertises IP addresses. Use this parameter to limit the IP address to this location. IP
         * addresses cannot move between network border groups.
         * Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones to view the network border groups.
         * You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 Classic,
         * you receive an InvalidParameterCombination error.
         */
        var networkBorderGroup: kotlin.String? = null
        /**
         * The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool.
         * To specify a specific address from the address pool, use the Address parameter instead.
         */
        var publicIpv4Pool: kotlin.String? = null
        /**
         * The tags to assign to the Elastic IP address.
         */
        var tagSpecifications: List<TagSpecification>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.AllocateAddressRequest) : this() {
            this.address = x.address
            this.customerOwnedIpv4Pool = x.customerOwnedIpv4Pool
            this.domain = x.domain
            this.dryRun = x.dryRun
            this.networkBorderGroup = x.networkBorderGroup
            this.publicIpv4Pool = x.publicIpv4Pool
            this.tagSpecifications = x.tagSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.AllocateAddressRequest = AllocateAddressRequest(this)
    }
}
