// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class AllocateHostsRequest private constructor(builder: Builder) {
    /**
     * Indicates whether the host accepts any untargeted instance launches that
     * match its instance type configuration, or if it only accepts Host tenancy
     * instance launches that specify its unique host ID. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding">
     * Understanding auto-placement and affinity in the Amazon EC2 User Guide.
     * Default: on
     */
    val autoPlacement: aws.sdk.kotlin.services.ec2.model.AutoPlacement? = builder.autoPlacement
    /**
     * The Availability Zone in which to allocate the Dedicated Host.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * Indicates whether to enable or disable host recovery for the Dedicated Host.
     * Host recovery is disabled by default. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">
     * Host recovery in the Amazon EC2 User Guide.
     * Default: off
     */
    val hostRecovery: aws.sdk.kotlin.services.ec2.model.HostRecovery? = builder.hostRecovery
    /**
     * Specifies the instance family to be supported by the Dedicated Hosts. If you specify
     * an instance family, the Dedicated Hosts support multiple instance types within that
     * instance family.
     * If you want the Dedicated Hosts to support a specific instance type only, omit this
     * parameter and specify InstanceType
     * instead. You cannot specify InstanceFamily and
     * InstanceType in the same request.
     */
    val instanceFamily: kotlin.String? = builder.instanceFamily
    /**
     * Specifies the instance type to be supported by the Dedicated Hosts. If you
     * specify an instance type, the Dedicated Hosts support instances of the
     * specified instance type only.
     * If you want the Dedicated Hosts to support multiple instance types in a specific
     * instance family, omit this parameter and specify InstanceFamily
     * instead. You cannot specify InstanceType and
     * InstanceFamily in the same request.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The number of Dedicated Hosts to allocate to your account with these parameters.
     */
    val quantity: kotlin.Int? = builder.quantity
    /**
     * The tags to apply to the Dedicated Host during creation.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.AllocateHostsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AllocateHostsRequest(")
        append("autoPlacement=$autoPlacement,")
        append("availabilityZone=$availabilityZone,")
        append("clientToken=$clientToken,")
        append("hostRecovery=$hostRecovery,")
        append("instanceFamily=$instanceFamily,")
        append("instanceType=$instanceType,")
        append("quantity=$quantity,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoPlacement?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (hostRecovery?.hashCode() ?: 0)
        result = 31 * result + (instanceFamily?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AllocateHostsRequest

        if (autoPlacement != other.autoPlacement) return false
        if (availabilityZone != other.availabilityZone) return false
        if (clientToken != other.clientToken) return false
        if (hostRecovery != other.hostRecovery) return false
        if (instanceFamily != other.instanceFamily) return false
        if (instanceType != other.instanceType) return false
        if (quantity != other.quantity) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.AllocateHostsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether the host accepts any untargeted instance launches that
         * match its instance type configuration, or if it only accepts Host tenancy
         * instance launches that specify its unique host ID. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding">
         * Understanding auto-placement and affinity in the Amazon EC2 User Guide.
         * Default: on
         */
        var autoPlacement: aws.sdk.kotlin.services.ec2.model.AutoPlacement? = null
        /**
         * The Availability Zone in which to allocate the Dedicated Host.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: kotlin.String? = null
        /**
         * Indicates whether to enable or disable host recovery for the Dedicated Host.
         * Host recovery is disabled by default. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">
         * Host recovery in the Amazon EC2 User Guide.
         * Default: off
         */
        var hostRecovery: aws.sdk.kotlin.services.ec2.model.HostRecovery? = null
        /**
         * Specifies the instance family to be supported by the Dedicated Hosts. If you specify
         * an instance family, the Dedicated Hosts support multiple instance types within that
         * instance family.
         * If you want the Dedicated Hosts to support a specific instance type only, omit this
         * parameter and specify InstanceType
         * instead. You cannot specify InstanceFamily and
         * InstanceType in the same request.
         */
        var instanceFamily: kotlin.String? = null
        /**
         * Specifies the instance type to be supported by the Dedicated Hosts. If you
         * specify an instance type, the Dedicated Hosts support instances of the
         * specified instance type only.
         * If you want the Dedicated Hosts to support multiple instance types in a specific
         * instance family, omit this parameter and specify InstanceFamily
         * instead. You cannot specify InstanceType and
         * InstanceFamily in the same request.
         */
        var instanceType: kotlin.String? = null
        /**
         * The number of Dedicated Hosts to allocate to your account with these parameters.
         */
        var quantity: kotlin.Int? = null
        /**
         * The tags to apply to the Dedicated Host during creation.
         */
        var tagSpecifications: List<TagSpecification>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.AllocateHostsRequest) : this() {
            this.autoPlacement = x.autoPlacement
            this.availabilityZone = x.availabilityZone
            this.clientToken = x.clientToken
            this.hostRecovery = x.hostRecovery
            this.instanceFamily = x.instanceFamily
            this.instanceType = x.instanceType
            this.quantity = x.quantity
            this.tagSpecifications = x.tagSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.AllocateHostsRequest = AllocateHostsRequest(this)
    }
}
