// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a client connection.
 */
class ClientVpnConnection private constructor(builder: Builder) {
    /**
     * The IP address of the client.
     */
    val clientIp: kotlin.String? = builder.clientIp
    /**
     * The ID of the Client VPN endpoint to which the client is connected.
     */
    val clientVpnEndpointId: kotlin.String? = builder.clientVpnEndpointId
    /**
     * The common name associated with the client. This is either the name of the client certificate,
     * or the Active Directory user name.
     */
    val commonName: kotlin.String? = builder.commonName
    /**
     * The date and time the client connection was terminated.
     */
    val connectionEndTime: kotlin.String? = builder.connectionEndTime
    /**
     * The date and time the client connection was established.
     */
    val connectionEstablishedTime: kotlin.String? = builder.connectionEstablishedTime
    /**
     * The ID of the client connection.
     */
    val connectionId: kotlin.String? = builder.connectionId
    /**
     * The number of bytes received by the client.
     */
    val egressBytes: kotlin.String? = builder.egressBytes
    /**
     * The number of packets received by the client.
     */
    val egressPackets: kotlin.String? = builder.egressPackets
    /**
     * The number of bytes sent by the client.
     */
    val ingressBytes: kotlin.String? = builder.ingressBytes
    /**
     * The number of packets sent by the client.
     */
    val ingressPackets: kotlin.String? = builder.ingressPackets
    /**
     * The statuses returned by the client connect handler for posture compliance, if applicable.
     */
    val postureComplianceStatuses: List<String>? = builder.postureComplianceStatuses
    /**
     * The current state of the client connection.
     */
    val status: aws.sdk.kotlin.services.ec2.model.ClientVpnConnectionStatus? = builder.status
    /**
     * The current date and time.
     */
    val timestamp: kotlin.String? = builder.timestamp
    /**
     * The username of the client who established the client connection. This information is only provided
     * if Active Directory client authentication is used.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ClientVpnConnection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClientVpnConnection(")
        append("clientIp=$clientIp,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("commonName=$commonName,")
        append("connectionEndTime=$connectionEndTime,")
        append("connectionEstablishedTime=$connectionEstablishedTime,")
        append("connectionId=$connectionId,")
        append("egressBytes=$egressBytes,")
        append("egressPackets=$egressPackets,")
        append("ingressBytes=$ingressBytes,")
        append("ingressPackets=$ingressPackets,")
        append("postureComplianceStatuses=$postureComplianceStatuses,")
        append("status=$status,")
        append("timestamp=$timestamp,")
        append("username=$username)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientIp?.hashCode() ?: 0
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (commonName?.hashCode() ?: 0)
        result = 31 * result + (connectionEndTime?.hashCode() ?: 0)
        result = 31 * result + (connectionEstablishedTime?.hashCode() ?: 0)
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (egressBytes?.hashCode() ?: 0)
        result = 31 * result + (egressPackets?.hashCode() ?: 0)
        result = 31 * result + (ingressBytes?.hashCode() ?: 0)
        result = 31 * result + (ingressPackets?.hashCode() ?: 0)
        result = 31 * result + (postureComplianceStatuses?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClientVpnConnection

        if (clientIp != other.clientIp) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (commonName != other.commonName) return false
        if (connectionEndTime != other.connectionEndTime) return false
        if (connectionEstablishedTime != other.connectionEstablishedTime) return false
        if (connectionId != other.connectionId) return false
        if (egressBytes != other.egressBytes) return false
        if (egressPackets != other.egressPackets) return false
        if (ingressBytes != other.ingressBytes) return false
        if (ingressPackets != other.ingressPackets) return false
        if (postureComplianceStatuses != other.postureComplianceStatuses) return false
        if (status != other.status) return false
        if (timestamp != other.timestamp) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ClientVpnConnection = Builder(this).apply(block).build()

    class Builder {
        /**
         * The IP address of the client.
         */
        var clientIp: kotlin.String? = null
        /**
         * The ID of the Client VPN endpoint to which the client is connected.
         */
        var clientVpnEndpointId: kotlin.String? = null
        /**
         * The common name associated with the client. This is either the name of the client certificate,
         * or the Active Directory user name.
         */
        var commonName: kotlin.String? = null
        /**
         * The date and time the client connection was terminated.
         */
        var connectionEndTime: kotlin.String? = null
        /**
         * The date and time the client connection was established.
         */
        var connectionEstablishedTime: kotlin.String? = null
        /**
         * The ID of the client connection.
         */
        var connectionId: kotlin.String? = null
        /**
         * The number of bytes received by the client.
         */
        var egressBytes: kotlin.String? = null
        /**
         * The number of packets received by the client.
         */
        var egressPackets: kotlin.String? = null
        /**
         * The number of bytes sent by the client.
         */
        var ingressBytes: kotlin.String? = null
        /**
         * The number of packets sent by the client.
         */
        var ingressPackets: kotlin.String? = null
        /**
         * The statuses returned by the client connect handler for posture compliance, if applicable.
         */
        var postureComplianceStatuses: List<String>? = null
        /**
         * The current state of the client connection.
         */
        var status: aws.sdk.kotlin.services.ec2.model.ClientVpnConnectionStatus? = null
        /**
         * The current date and time.
         */
        var timestamp: kotlin.String? = null
        /**
         * The username of the client who established the client connection. This information is only provided
         * if Active Directory client authentication is used.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ClientVpnConnection) : this() {
            this.clientIp = x.clientIp
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.commonName = x.commonName
            this.connectionEndTime = x.connectionEndTime
            this.connectionEstablishedTime = x.connectionEstablishedTime
            this.connectionId = x.connectionId
            this.egressBytes = x.egressBytes
            this.egressPackets = x.egressPackets
            this.ingressBytes = x.ingressBytes
            this.ingressPackets = x.ingressPackets
            this.postureComplianceStatuses = x.postureComplianceStatuses
            this.status = x.status
            this.timestamp = x.timestamp
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ClientVpnConnection = ClientVpnConnection(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientVpnConnectionStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.ec2.model.ClientVpnConnectionStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.ec2.model.ClientVpnConnectionStatus.invoke(block)
        }
    }
}
