// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateReplaceRootVolumeTaskRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     * If you do not specify a client token, a randomly generated token is used for the request
     * to ensure idempotency. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The ID of the instance for which to replace the root volume.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The ID of the snapshot from which to restore the replacement root volume. If you want to
     * restore the volume to the initial launch state, omit this parameter.
     */
    val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The tags to apply to the root volume replacement task.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateReplaceRootVolumeTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateReplaceRootVolumeTaskRequest(")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("instanceId=$instanceId,")
        append("snapshotId=$snapshotId,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateReplaceRootVolumeTaskRequest

        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (instanceId != other.instanceId) return false
        if (snapshotId != other.snapshotId) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateReplaceRootVolumeTaskRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * If you do not specify a client token, a randomly generated token is used for the request
         * to ensure idempotency. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency.
         */
        var clientToken: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The ID of the instance for which to replace the root volume.
         */
        var instanceId: kotlin.String? = null
        /**
         * The ID of the snapshot from which to restore the replacement root volume. If you want to
         * restore the volume to the initial launch state, omit this parameter.
         */
        var snapshotId: kotlin.String? = null
        /**
         * The tags to apply to the root volume replacement task.
         */
        var tagSpecifications: List<TagSpecification>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateReplaceRootVolumeTaskRequest) : this() {
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.instanceId = x.instanceId
            this.snapshotId = x.snapshotId
            this.tagSpecifications = x.tagSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateReplaceRootVolumeTaskRequest = CreateReplaceRootVolumeTaskRequest(this)
    }
}
