// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateSecurityGroupRequest private constructor(builder: Builder) {
    /**
     * A description for the security group. This is informational only.
     * Constraints: Up to 255 characters in length
     * Constraints for EC2-Classic: ASCII characters
     * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@&#91;&#93;+=&;{}!$*
     */
    val description: kotlin.String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The name of the security group.
     * Constraints: Up to 255 characters in length. Cannot start with
     * sg-.
     * Constraints for EC2-Classic: ASCII characters
     * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@&#91;&#93;+=&;{}!$*
     */
    val groupName: kotlin.String? = builder.groupName
    /**
     * The tags to assign to the security group.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * &#91;EC2-VPC&#93; The ID of the VPC. Required for EC2-VPC.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateSecurityGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSecurityGroupRequest(")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("groupName=$groupName,")
        append("tagSpecifications=$tagSpecifications,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSecurityGroupRequest

        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (groupName != other.groupName) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateSecurityGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A description for the security group. This is informational only.
         * Constraints: Up to 255 characters in length
         * Constraints for EC2-Classic: ASCII characters
         * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@&#91;&#93;+=&;{}!$*
         */
        var description: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The name of the security group.
         * Constraints: Up to 255 characters in length. Cannot start with
         * sg-.
         * Constraints for EC2-Classic: ASCII characters
         * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@&#91;&#93;+=&;{}!$*
         */
        var groupName: kotlin.String? = null
        /**
         * The tags to assign to the security group.
         */
        var tagSpecifications: List<TagSpecification>? = null
        /**
         * &#91;EC2-VPC&#93; The ID of the VPC. Required for EC2-VPC.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateSecurityGroupRequest) : this() {
            this.description = x.description
            this.dryRun = x.dryRun
            this.groupName = x.groupName
            this.tagSpecifications = x.tagSpecifications
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateSecurityGroupRequest = CreateSecurityGroupRequest(this)
    }
}
