// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateSubnetRequest private constructor(builder: Builder) {
    /**
     * The Availability Zone or Local Zone for the subnet.
     * Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we
     * do not necessarily select a different zone for each subnet.
     * To create a subnet in a Local Zone, set this value to the Local Zone ID, for example
     * us-west-2-lax-1a. For information about the Regions that support Local Zones,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions in the Amazon Elastic Compute Cloud User Guide.
     * To create a subnet in an Outpost, set this value to the Availability Zone for the
     * Outpost and specify the Outpost ARN.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The AZ ID or the Local Zone ID of the subnet.
     */
    val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The IPv4 network range for the subnet, in CIDR notation. For example, 10.0.0.0/24.
     * We modify the specified CIDR block to its canonical form; for example, if you specify
     * 100.68.0.18/18, we modify it to 100.68.0.0/18.
     * This parameter is not supported for an IPv6 only subnet.
     */
    val cidrBlock: kotlin.String? = builder.cidrBlock
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a
     * /64 prefix length.
     * This parameter is required for an IPv6 only subnet.
     */
    val ipv6CidrBlock: kotlin.String? = builder.ipv6CidrBlock
    /**
     * Indicates whether to create an IPv6 only subnet.
     */
    val ipv6Native: kotlin.Boolean? = builder.ipv6Native
    /**
     * The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also
     * specify the Availability Zone of the Outpost subnet.
     */
    val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The tags to assign to the subnet.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The ID of the VPC.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateSubnetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSubnetRequest(")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("cidrBlock=$cidrBlock,")
        append("dryRun=$dryRun,")
        append("ipv6CidrBlock=$ipv6CidrBlock,")
        append("ipv6Native=$ipv6Native,")
        append("outpostArn=$outpostArn,")
        append("tagSpecifications=$tagSpecifications,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (cidrBlock?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (ipv6Native?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSubnetRequest

        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (cidrBlock != other.cidrBlock) return false
        if (dryRun != other.dryRun) return false
        if (ipv6CidrBlock != other.ipv6CidrBlock) return false
        if (ipv6Native != other.ipv6Native) return false
        if (outpostArn != other.outpostArn) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateSubnetRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone or Local Zone for the subnet.
         * Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we
         * do not necessarily select a different zone for each subnet.
         * To create a subnet in a Local Zone, set this value to the Local Zone ID, for example
         * us-west-2-lax-1a. For information about the Regions that support Local Zones,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions in the Amazon Elastic Compute Cloud User Guide.
         * To create a subnet in an Outpost, set this value to the Availability Zone for the
         * Outpost and specify the Outpost ARN.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The AZ ID or the Local Zone ID of the subnet.
         */
        var availabilityZoneId: kotlin.String? = null
        /**
         * The IPv4 network range for the subnet, in CIDR notation. For example, 10.0.0.0/24.
         * We modify the specified CIDR block to its canonical form; for example, if you specify
         * 100.68.0.18/18, we modify it to 100.68.0.0/18.
         * This parameter is not supported for an IPv6 only subnet.
         */
        var cidrBlock: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a
         * /64 prefix length.
         * This parameter is required for an IPv6 only subnet.
         */
        var ipv6CidrBlock: kotlin.String? = null
        /**
         * Indicates whether to create an IPv6 only subnet.
         */
        var ipv6Native: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also
         * specify the Availability Zone of the Outpost subnet.
         */
        var outpostArn: kotlin.String? = null
        /**
         * The tags to assign to the subnet.
         */
        var tagSpecifications: List<TagSpecification>? = null
        /**
         * The ID of the VPC.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateSubnetRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.cidrBlock = x.cidrBlock
            this.dryRun = x.dryRun
            this.ipv6CidrBlock = x.ipv6CidrBlock
            this.ipv6Native = x.ipv6Native
            this.outpostArn = x.outpostArn
            this.tagSpecifications = x.tagSpecifications
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateSubnetRequest = CreateSubnetRequest(this)
    }
}
