// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateTrafficMirrorFilterRuleRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description of the Traffic Mirror rule.
     */
    val description: kotlin.String? = builder.description
    /**
     * The destination CIDR block to assign to the Traffic Mirror rule.
     */
    val destinationCidrBlock: kotlin.String? = builder.destinationCidrBlock
    /**
     * The destination port range.
     */
    val destinationPortRange: aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest? = builder.destinationPortRange
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The protocol, for example UDP, to assign to the Traffic Mirror rule.
     * For information about the protocol value, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers on the  Internet Assigned Numbers Authority (IANA) website.
     */
    val protocol: kotlin.Int? = builder.protocol
    /**
     * The action to take on the filtered traffic.
     */
    val ruleAction: aws.sdk.kotlin.services.ec2.model.TrafficMirrorRuleAction? = builder.ruleAction
    /**
     * The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
     * direction. The rules are processed in ascending order by rule number.
     */
    val ruleNumber: kotlin.Int? = builder.ruleNumber
    /**
     * The source CIDR block to assign to the Traffic Mirror rule.
     */
    val sourceCidrBlock: kotlin.String? = builder.sourceCidrBlock
    /**
     * The source port range.
     */
    val sourcePortRange: aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest? = builder.sourcePortRange
    /**
     * The type of traffic.
     */
    val trafficDirection: aws.sdk.kotlin.services.ec2.model.TrafficDirection? = builder.trafficDirection
    /**
     * The ID of the filter that this rule is associated with.
     */
    val trafficMirrorFilterId: kotlin.String? = builder.trafficMirrorFilterId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateTrafficMirrorFilterRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrafficMirrorFilterRuleRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("destinationCidrBlock=$destinationCidrBlock,")
        append("destinationPortRange=$destinationPortRange,")
        append("dryRun=$dryRun,")
        append("protocol=$protocol,")
        append("ruleAction=$ruleAction,")
        append("ruleNumber=$ruleNumber,")
        append("sourceCidrBlock=$sourceCidrBlock,")
        append("sourcePortRange=$sourcePortRange,")
        append("trafficDirection=$trafficDirection,")
        append("trafficMirrorFilterId=$trafficMirrorFilterId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (destinationPortRange?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (protocol ?: 0)
        result = 31 * result + (ruleAction?.hashCode() ?: 0)
        result = 31 * result + (ruleNumber ?: 0)
        result = 31 * result + (sourceCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (sourcePortRange?.hashCode() ?: 0)
        result = 31 * result + (trafficDirection?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorFilterId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTrafficMirrorFilterRuleRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (destinationCidrBlock != other.destinationCidrBlock) return false
        if (destinationPortRange != other.destinationPortRange) return false
        if (dryRun != other.dryRun) return false
        if (protocol != other.protocol) return false
        if (ruleAction != other.ruleAction) return false
        if (ruleNumber != other.ruleNumber) return false
        if (sourceCidrBlock != other.sourceCidrBlock) return false
        if (sourcePortRange != other.sourcePortRange) return false
        if (trafficDirection != other.trafficDirection) return false
        if (trafficMirrorFilterId != other.trafficMirrorFilterId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateTrafficMirrorFilterRuleRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        var clientToken: kotlin.String? = null
        /**
         * The description of the Traffic Mirror rule.
         */
        var description: kotlin.String? = null
        /**
         * The destination CIDR block to assign to the Traffic Mirror rule.
         */
        var destinationCidrBlock: kotlin.String? = null
        /**
         * The destination port range.
         */
        var destinationPortRange: aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The protocol, for example UDP, to assign to the Traffic Mirror rule.
         * For information about the protocol value, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers on the  Internet Assigned Numbers Authority (IANA) website.
         */
        var protocol: kotlin.Int? = null
        /**
         * The action to take on the filtered traffic.
         */
        var ruleAction: aws.sdk.kotlin.services.ec2.model.TrafficMirrorRuleAction? = null
        /**
         * The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
         * direction. The rules are processed in ascending order by rule number.
         */
        var ruleNumber: kotlin.Int? = null
        /**
         * The source CIDR block to assign to the Traffic Mirror rule.
         */
        var sourceCidrBlock: kotlin.String? = null
        /**
         * The source port range.
         */
        var sourcePortRange: aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest? = null
        /**
         * The type of traffic.
         */
        var trafficDirection: aws.sdk.kotlin.services.ec2.model.TrafficDirection? = null
        /**
         * The ID of the filter that this rule is associated with.
         */
        var trafficMirrorFilterId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateTrafficMirrorFilterRuleRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.destinationCidrBlock = x.destinationCidrBlock
            this.destinationPortRange = x.destinationPortRange
            this.dryRun = x.dryRun
            this.protocol = x.protocol
            this.ruleAction = x.ruleAction
            this.ruleNumber = x.ruleNumber
            this.sourceCidrBlock = x.sourceCidrBlock
            this.sourcePortRange = x.sourcePortRange
            this.trafficDirection = x.trafficDirection
            this.trafficMirrorFilterId = x.trafficMirrorFilterId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateTrafficMirrorFilterRuleRequest = CreateTrafficMirrorFilterRuleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest] inside the given [block]
         */
        fun destinationPortRange(block: aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest.Builder.() -> kotlin.Unit) {
            this.destinationPortRange = aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest] inside the given [block]
         */
        fun sourcePortRange(block: aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest.Builder.() -> kotlin.Unit) {
            this.sourcePortRange = aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest.invoke(block)
        }
    }
}
