// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a volume.
 */
class CreateVolumeResponse private constructor(builder: Builder) {
    /**
     * Information about the volume attachments.
     */
    val attachments: List<VolumeAttachment>? = builder.attachments
    /**
     * The Availability Zone for the volume.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The time stamp when volume creation was initiated.
     */
    val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * Indicates whether the volume is encrypted.
     */
    val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * Indicates whether the volume was created using fast snapshot restore.
     */
    val fastRestored: kotlin.Boolean? = builder.fastRestored
    /**
     * The number of I/O operations per second (IOPS). For gp3, io1, and io2 volumes, this represents
     * the number of IOPS that are provisioned for the volume. For gp2 volumes, this represents the baseline
     * performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the
     * volume encryption key for the volume.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Indicates whether Amazon EBS Multi-Attach is enabled.
     */
    val multiAttachEnabled: kotlin.Boolean? = builder.multiAttachEnabled
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The size of the volume, in GiBs.
     */
    val size: kotlin.Int? = builder.size
    /**
     * The snapshot from which the volume was created, if applicable.
     */
    val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The volume state.
     */
    val state: aws.sdk.kotlin.services.ec2.model.VolumeState? = builder.state
    /**
     * Any tags assigned to the volume.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The throughput that the volume supports, in MiB/s.
     */
    val throughput: kotlin.Int? = builder.throughput
    /**
     * The ID of the volume.
     */
    val volumeId: kotlin.String? = builder.volumeId
    /**
     * The volume type.
     */
    val volumeType: aws.sdk.kotlin.services.ec2.model.VolumeType? = builder.volumeType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateVolumeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVolumeResponse(")
        append("attachments=$attachments,")
        append("availabilityZone=$availabilityZone,")
        append("createTime=$createTime,")
        append("encrypted=$encrypted,")
        append("fastRestored=$fastRestored,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("multiAttachEnabled=$multiAttachEnabled,")
        append("outpostArn=$outpostArn,")
        append("size=$size,")
        append("snapshotId=$snapshotId,")
        append("state=$state,")
        append("tags=$tags,")
        append("throughput=$throughput,")
        append("volumeId=$volumeId,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachments?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (fastRestored?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (multiAttachEnabled?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (size ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVolumeResponse

        if (attachments != other.attachments) return false
        if (availabilityZone != other.availabilityZone) return false
        if (createTime != other.createTime) return false
        if (encrypted != other.encrypted) return false
        if (fastRestored != other.fastRestored) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (multiAttachEnabled != other.multiAttachEnabled) return false
        if (outpostArn != other.outpostArn) return false
        if (size != other.size) return false
        if (snapshotId != other.snapshotId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (throughput != other.throughput) return false
        if (volumeId != other.volumeId) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateVolumeResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the volume attachments.
         */
        var attachments: List<VolumeAttachment>? = null
        /**
         * The Availability Zone for the volume.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The time stamp when volume creation was initiated.
         */
        var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the volume is encrypted.
         */
        var encrypted: kotlin.Boolean? = null
        /**
         * Indicates whether the volume was created using fast snapshot restore.
         */
        var fastRestored: kotlin.Boolean? = null
        /**
         * The number of I/O operations per second (IOPS). For gp3, io1, and io2 volumes, this represents
         * the number of IOPS that are provisioned for the volume. For gp2 volumes, this represents the baseline
         * performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         */
        var iops: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the
         * volume encryption key for the volume.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * Indicates whether Amazon EBS Multi-Attach is enabled.
         */
        var multiAttachEnabled: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        var outpostArn: kotlin.String? = null
        /**
         * The size of the volume, in GiBs.
         */
        var size: kotlin.Int? = null
        /**
         * The snapshot from which the volume was created, if applicable.
         */
        var snapshotId: kotlin.String? = null
        /**
         * The volume state.
         */
        var state: aws.sdk.kotlin.services.ec2.model.VolumeState? = null
        /**
         * Any tags assigned to the volume.
         */
        var tags: List<Tag>? = null
        /**
         * The throughput that the volume supports, in MiB/s.
         */
        var throughput: kotlin.Int? = null
        /**
         * The ID of the volume.
         */
        var volumeId: kotlin.String? = null
        /**
         * The volume type.
         */
        var volumeType: aws.sdk.kotlin.services.ec2.model.VolumeType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateVolumeResponse) : this() {
            this.attachments = x.attachments
            this.availabilityZone = x.availabilityZone
            this.createTime = x.createTime
            this.encrypted = x.encrypted
            this.fastRestored = x.fastRestored
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.multiAttachEnabled = x.multiAttachEnabled
            this.outpostArn = x.outpostArn
            this.size = x.size
            this.snapshotId = x.snapshotId
            this.state = x.state
            this.tags = x.tags
            this.throughput = x.throughput
            this.volumeId = x.volumeId
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateVolumeResponse = CreateVolumeResponse(this)
    }
}
