// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DescribeReservedInstancesOfferings.
 */
class DescribeReservedInstancesOfferingsRequest private constructor(builder: Builder) {
    /**
     * The Availability Zone in which the Reserved Instance can be used.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters.
     * availability-zone - The Availability Zone where the Reserved Instance can be
     * used.
     * duration - The duration of the Reserved Instance (for example, one year or
     * three years), in seconds (31536000 | 94608000).
     * fixed-price - The purchase price of the Reserved Instance (for example,
     * 9800.0).
     * instance-type - The instance type that is covered by the
     * reservation.
     * marketplace - Set to true to show only Reserved Instance
     * Marketplace offerings. When this filter is not used, which is the default behavior, all
     * offerings from both Amazon Web Services and the Reserved Instance Marketplace are listed.
     * product-description - The Reserved Instance product platform description.
     * Instances that include (Amazon VPC) in the product platform description will
     * only be displayed to EC2-Classic account holders and are for use with Amazon VPC.
     * (Linux/UNIX | Linux/UNIX (Amazon VPC) | SUSE
     * Linux | SUSE Linux (Amazon VPC) | Red Hat Enterprise
     * Linux | Red Hat Enterprise Linux (Amazon VPC) | Red Hat
     * Enterprise Linux with HA (Amazon VPC) | Windows | Windows
     * (Amazon VPC) | Windows with SQL Server Standard | Windows with
     * SQL Server Standard (Amazon VPC) | Windows with SQL Server Web |
     * Windows with SQL Server Web (Amazon VPC) | Windows with SQL Server
     * Enterprise | Windows with SQL Server Enterprise (Amazon VPC))
     * reserved-instances-offering-id - The Reserved Instances offering
     * ID.
     * scope - The scope of the Reserved Instance (Availability Zone or
     * Region).
     * usage-price - The usage price of the Reserved Instance, per hour (for
     * example, 0.84).
     */
    val filters: List<Filter>? = builder.filters
    /**
     * Include Reserved Instance Marketplace offerings in the response.
     */
    val includeMarketplace: kotlin.Boolean? = builder.includeMarketplace
    /**
     * The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy
     * of dedicated is applied to instances that run in a VPC on single-tenant hardware
     * (i.e., Dedicated Instances).
     * Important: The host value cannot be used with this parameter. Use the default or dedicated values only.
     * Default: default
     */
    val instanceTenancy: aws.sdk.kotlin.services.ec2.model.Tenancy? = builder.instanceTenancy
    /**
     * The instance type that the reservation will cover (for example, m1.small). For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types in the
     * Amazon EC2 User Guide.
     */
    val instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = builder.instanceType
    /**
     * The maximum duration (in seconds) to filter when searching for offerings.
     * Default: 94608000 (3 years)
     */
    val maxDuration: kotlin.Long? = builder.maxDuration
    /**
     * The maximum number of instances to filter when searching for offerings.
     * Default: 20
     */
    val maxInstanceCount: kotlin.Int? = builder.maxInstanceCount
    /**
     * The maximum number of results to return for the request in a single page. The remaining
     * results of the initial request can be seen by sending another request with the returned
     * NextToken value. The maximum is 100.
     * Default: 100
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The minimum duration (in seconds) to filter when searching for offerings.
     * Default: 2592000 (1 month)
     */
    val minDuration: kotlin.Long? = builder.minDuration
    /**
     * The token to retrieve the next page of results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The offering class of the Reserved Instance. Can be standard or convertible.
     */
    val offeringClass: aws.sdk.kotlin.services.ec2.model.OfferingClassType? = builder.offeringClass
    /**
     * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API
     * version, you only have access to the Medium Utilization Reserved Instance
     * offering type.
     */
    val offeringType: aws.sdk.kotlin.services.ec2.model.OfferingTypeValues? = builder.offeringType
    /**
     * The Reserved Instance product platform description. Instances that include (Amazon
     * VPC) in the description are for use with Amazon VPC.
     */
    val productDescription: aws.sdk.kotlin.services.ec2.model.RiProductDescription? = builder.productDescription
    /**
     * One or more Reserved Instances offering IDs.
     */
    val reservedInstancesOfferingIds: List<String>? = builder.reservedInstancesOfferingIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeReservedInstancesOfferingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeReservedInstancesOfferingsRequest(")
        append("availabilityZone=$availabilityZone,")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("includeMarketplace=$includeMarketplace,")
        append("instanceTenancy=$instanceTenancy,")
        append("instanceType=$instanceType,")
        append("maxDuration=$maxDuration,")
        append("maxInstanceCount=$maxInstanceCount,")
        append("maxResults=$maxResults,")
        append("minDuration=$minDuration,")
        append("nextToken=$nextToken,")
        append("offeringClass=$offeringClass,")
        append("offeringType=$offeringType,")
        append("productDescription=$productDescription,")
        append("reservedInstancesOfferingIds=$reservedInstancesOfferingIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includeMarketplace?.hashCode() ?: 0)
        result = 31 * result + (instanceTenancy?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (maxDuration?.hashCode() ?: 0)
        result = 31 * result + (maxInstanceCount ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (minDuration?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (offeringClass?.hashCode() ?: 0)
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (productDescription?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesOfferingIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeReservedInstancesOfferingsRequest

        if (availabilityZone != other.availabilityZone) return false
        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (includeMarketplace != other.includeMarketplace) return false
        if (instanceTenancy != other.instanceTenancy) return false
        if (instanceType != other.instanceType) return false
        if (maxDuration != other.maxDuration) return false
        if (maxInstanceCount != other.maxInstanceCount) return false
        if (maxResults != other.maxResults) return false
        if (minDuration != other.minDuration) return false
        if (nextToken != other.nextToken) return false
        if (offeringClass != other.offeringClass) return false
        if (offeringType != other.offeringType) return false
        if (productDescription != other.productDescription) return false
        if (reservedInstancesOfferingIds != other.reservedInstancesOfferingIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeReservedInstancesOfferingsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone in which the Reserved Instance can be used.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters.
         * availability-zone - The Availability Zone where the Reserved Instance can be
         * used.
         * duration - The duration of the Reserved Instance (for example, one year or
         * three years), in seconds (31536000 | 94608000).
         * fixed-price - The purchase price of the Reserved Instance (for example,
         * 9800.0).
         * instance-type - The instance type that is covered by the
         * reservation.
         * marketplace - Set to true to show only Reserved Instance
         * Marketplace offerings. When this filter is not used, which is the default behavior, all
         * offerings from both Amazon Web Services and the Reserved Instance Marketplace are listed.
         * product-description - The Reserved Instance product platform description.
         * Instances that include (Amazon VPC) in the product platform description will
         * only be displayed to EC2-Classic account holders and are for use with Amazon VPC.
         * (Linux/UNIX | Linux/UNIX (Amazon VPC) | SUSE
         * Linux | SUSE Linux (Amazon VPC) | Red Hat Enterprise
         * Linux | Red Hat Enterprise Linux (Amazon VPC) | Red Hat
         * Enterprise Linux with HA (Amazon VPC) | Windows | Windows
         * (Amazon VPC) | Windows with SQL Server Standard | Windows with
         * SQL Server Standard (Amazon VPC) | Windows with SQL Server Web |
         * Windows with SQL Server Web (Amazon VPC) | Windows with SQL Server
         * Enterprise | Windows with SQL Server Enterprise (Amazon VPC))
         * reserved-instances-offering-id - The Reserved Instances offering
         * ID.
         * scope - The scope of the Reserved Instance (Availability Zone or
         * Region).
         * usage-price - The usage price of the Reserved Instance, per hour (for
         * example, 0.84).
         */
        var filters: List<Filter>? = null
        /**
         * Include Reserved Instance Marketplace offerings in the response.
         */
        var includeMarketplace: kotlin.Boolean? = null
        /**
         * The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy
         * of dedicated is applied to instances that run in a VPC on single-tenant hardware
         * (i.e., Dedicated Instances).
         * Important: The host value cannot be used with this parameter. Use the default or dedicated values only.
         * Default: default
         */
        var instanceTenancy: aws.sdk.kotlin.services.ec2.model.Tenancy? = null
        /**
         * The instance type that the reservation will cover (for example, m1.small). For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types in the
         * Amazon EC2 User Guide.
         */
        var instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = null
        /**
         * The maximum duration (in seconds) to filter when searching for offerings.
         * Default: 94608000 (3 years)
         */
        var maxDuration: kotlin.Long? = null
        /**
         * The maximum number of instances to filter when searching for offerings.
         * Default: 20
         */
        var maxInstanceCount: kotlin.Int? = null
        /**
         * The maximum number of results to return for the request in a single page. The remaining
         * results of the initial request can be seen by sending another request with the returned
         * NextToken value. The maximum is 100.
         * Default: 100
         */
        var maxResults: kotlin.Int? = null
        /**
         * The minimum duration (in seconds) to filter when searching for offerings.
         * Default: 2592000 (1 month)
         */
        var minDuration: kotlin.Long? = null
        /**
         * The token to retrieve the next page of results.
         */
        var nextToken: kotlin.String? = null
        /**
         * The offering class of the Reserved Instance. Can be standard or convertible.
         */
        var offeringClass: aws.sdk.kotlin.services.ec2.model.OfferingClassType? = null
        /**
         * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API
         * version, you only have access to the Medium Utilization Reserved Instance
         * offering type.
         */
        var offeringType: aws.sdk.kotlin.services.ec2.model.OfferingTypeValues? = null
        /**
         * The Reserved Instance product platform description. Instances that include (Amazon
         * VPC) in the description are for use with Amazon VPC.
         */
        var productDescription: aws.sdk.kotlin.services.ec2.model.RiProductDescription? = null
        /**
         * One or more Reserved Instances offering IDs.
         */
        var reservedInstancesOfferingIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeReservedInstancesOfferingsRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.includeMarketplace = x.includeMarketplace
            this.instanceTenancy = x.instanceTenancy
            this.instanceType = x.instanceType
            this.maxDuration = x.maxDuration
            this.maxInstanceCount = x.maxInstanceCount
            this.maxResults = x.maxResults
            this.minDuration = x.minDuration
            this.nextToken = x.nextToken
            this.offeringClass = x.offeringClass
            this.offeringType = x.offeringType
            this.productDescription = x.productDescription
            this.reservedInstancesOfferingIds = x.reservedInstancesOfferingIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeReservedInstancesOfferingsRequest = DescribeReservedInstancesOfferingsRequest(this)
    }
}
