// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class EnableFastLaunchRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is
     * DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The ID of the image for which you’re enabling faster launching.
     */
    val imageId: kotlin.String? = builder.imageId
    /**
     * The launch template to use when launching Windows instances from pre-provisioned
     * snapshots. Launch template parameters can include either the name or ID of the launch
     * template, but not both.
     */
    val launchTemplate: aws.sdk.kotlin.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest? = builder.launchTemplate
    /**
     * The maximum number of parallel instances to launch for creating resources.
     */
    val maxParallelLaunches: kotlin.Int? = builder.maxParallelLaunches
    /**
     * The type of resource to use for pre-provisioning the Windows AMI for faster launching.
     * Supported values include: snapshot, which is the default value.
     */
    val resourceType: kotlin.String? = builder.resourceType
    /**
     * Configuration settings for creating and managing the snapshots that are used for
     * pre-provisioning the Windows AMI for faster launching. The associated ResourceType
     * must be snapshot.
     */
    val snapshotConfiguration: aws.sdk.kotlin.services.ec2.model.FastLaunchSnapshotConfigurationRequest? = builder.snapshotConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.EnableFastLaunchRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnableFastLaunchRequest(")
        append("dryRun=$dryRun,")
        append("imageId=$imageId,")
        append("launchTemplate=$launchTemplate,")
        append("maxParallelLaunches=$maxParallelLaunches,")
        append("resourceType=$resourceType,")
        append("snapshotConfiguration=$snapshotConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (maxParallelLaunches ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (snapshotConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnableFastLaunchRequest

        if (dryRun != other.dryRun) return false
        if (imageId != other.imageId) return false
        if (launchTemplate != other.launchTemplate) return false
        if (maxParallelLaunches != other.maxParallelLaunches) return false
        if (resourceType != other.resourceType) return false
        if (snapshotConfiguration != other.snapshotConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.EnableFastLaunchRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is
         * DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The ID of the image for which you’re enabling faster launching.
         */
        var imageId: kotlin.String? = null
        /**
         * The launch template to use when launching Windows instances from pre-provisioned
         * snapshots. Launch template parameters can include either the name or ID of the launch
         * template, but not both.
         */
        var launchTemplate: aws.sdk.kotlin.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest? = null
        /**
         * The maximum number of parallel instances to launch for creating resources.
         */
        var maxParallelLaunches: kotlin.Int? = null
        /**
         * The type of resource to use for pre-provisioning the Windows AMI for faster launching.
         * Supported values include: snapshot, which is the default value.
         */
        var resourceType: kotlin.String? = null
        /**
         * Configuration settings for creating and managing the snapshots that are used for
         * pre-provisioning the Windows AMI for faster launching. The associated ResourceType
         * must be snapshot.
         */
        var snapshotConfiguration: aws.sdk.kotlin.services.ec2.model.FastLaunchSnapshotConfigurationRequest? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.EnableFastLaunchRequest) : this() {
            this.dryRun = x.dryRun
            this.imageId = x.imageId
            this.launchTemplate = x.launchTemplate
            this.maxParallelLaunches = x.maxParallelLaunches
            this.resourceType = x.resourceType
            this.snapshotConfiguration = x.snapshotConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.EnableFastLaunchRequest = EnableFastLaunchRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest] inside the given [block]
         */
        fun launchTemplate(block: aws.sdk.kotlin.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.FastLaunchSnapshotConfigurationRequest] inside the given [block]
         */
        fun snapshotConfiguration(block: aws.sdk.kotlin.services.ec2.model.FastLaunchSnapshotConfigurationRequest.Builder.() -> kotlin.Unit) {
            this.snapshotConfiguration = aws.sdk.kotlin.services.ec2.model.FastLaunchSnapshotConfigurationRequest.invoke(block)
        }
    }
}
