// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a flow log.
 */
class FlowLog private constructor(builder: Builder) {
    /**
     * The date and time the flow log was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Information about the error that occurred. Rate limited indicates that
     * CloudWatch Logs throttling has been applied for one or more network interfaces, or that you've
     * reached the limit on the number of log groups that you can create. Access
     * error indicates that the IAM role associated with the flow log does not have
     * sufficient permissions to publish to CloudWatch Logs. Unknown error indicates an
     * internal error.
     */
    val deliverLogsErrorMessage: kotlin.String? = builder.deliverLogsErrorMessage
    /**
     * The ARN of the IAM role that posts logs to CloudWatch Logs.
     */
    val deliverLogsPermissionArn: kotlin.String? = builder.deliverLogsPermissionArn
    /**
     * The status of the logs delivery (SUCCESS | FAILED).
     */
    val deliverLogsStatus: kotlin.String? = builder.deliverLogsStatus
    /**
     * The destination options.
     */
    val destinationOptions: aws.sdk.kotlin.services.ec2.model.DestinationOptionsResponse? = builder.destinationOptions
    /**
     * The flow log ID.
     */
    val flowLogId: kotlin.String? = builder.flowLogId
    /**
     * The status of the flow log (ACTIVE).
     */
    val flowLogStatus: kotlin.String? = builder.flowLogStatus
    /**
     * The destination to which the flow log data is published. Flow log data can be
     * published to an CloudWatch Logs log group or an Amazon S3 bucket. If the flow log publishes to CloudWatch Logs,
     * this element indicates the Amazon Resource Name (ARN) of the CloudWatch Logs log group to which
     * the data is published. If the flow log publishes to Amazon S3, this element indicates the ARN
     * of the Amazon S3 bucket to which the data is published.
     */
    val logDestination: kotlin.String? = builder.logDestination
    /**
     * The type of destination to which the flow log data is published. Flow log data can be
     * published to CloudWatch Logs or Amazon S3.
     */
    val logDestinationType: aws.sdk.kotlin.services.ec2.model.LogDestinationType? = builder.logDestinationType
    /**
     * The format of the flow log record.
     */
    val logFormat: kotlin.String? = builder.logFormat
    /**
     * The name of the flow log group.
     */
    val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow log record.
     * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
     * instance, the aggregation interval is always 60 seconds (1 minute) or less,
     * regardless of the specified value.
     * Valid Values: 60 | 600
     */
    val maxAggregationInterval: kotlin.Int? = builder.maxAggregationInterval
    /**
     * The ID of the resource on which the flow log was created.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * The tags for the flow log.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The type of traffic captured for the flow log.
     */
    val trafficType: aws.sdk.kotlin.services.ec2.model.TrafficType? = builder.trafficType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.FlowLog = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FlowLog(")
        append("creationTime=$creationTime,")
        append("deliverLogsErrorMessage=$deliverLogsErrorMessage,")
        append("deliverLogsPermissionArn=$deliverLogsPermissionArn,")
        append("deliverLogsStatus=$deliverLogsStatus,")
        append("destinationOptions=$destinationOptions,")
        append("flowLogId=$flowLogId,")
        append("flowLogStatus=$flowLogStatus,")
        append("logDestination=$logDestination,")
        append("logDestinationType=$logDestinationType,")
        append("logFormat=$logFormat,")
        append("logGroupName=$logGroupName,")
        append("maxAggregationInterval=$maxAggregationInterval,")
        append("resourceId=$resourceId,")
        append("tags=$tags,")
        append("trafficType=$trafficType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (deliverLogsErrorMessage?.hashCode() ?: 0)
        result = 31 * result + (deliverLogsPermissionArn?.hashCode() ?: 0)
        result = 31 * result + (deliverLogsStatus?.hashCode() ?: 0)
        result = 31 * result + (destinationOptions?.hashCode() ?: 0)
        result = 31 * result + (flowLogId?.hashCode() ?: 0)
        result = 31 * result + (flowLogStatus?.hashCode() ?: 0)
        result = 31 * result + (logDestination?.hashCode() ?: 0)
        result = 31 * result + (logDestinationType?.hashCode() ?: 0)
        result = 31 * result + (logFormat?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (maxAggregationInterval ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trafficType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FlowLog

        if (creationTime != other.creationTime) return false
        if (deliverLogsErrorMessage != other.deliverLogsErrorMessage) return false
        if (deliverLogsPermissionArn != other.deliverLogsPermissionArn) return false
        if (deliverLogsStatus != other.deliverLogsStatus) return false
        if (destinationOptions != other.destinationOptions) return false
        if (flowLogId != other.flowLogId) return false
        if (flowLogStatus != other.flowLogStatus) return false
        if (logDestination != other.logDestination) return false
        if (logDestinationType != other.logDestinationType) return false
        if (logFormat != other.logFormat) return false
        if (logGroupName != other.logGroupName) return false
        if (maxAggregationInterval != other.maxAggregationInterval) return false
        if (resourceId != other.resourceId) return false
        if (tags != other.tags) return false
        if (trafficType != other.trafficType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.FlowLog = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time the flow log was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the error that occurred. Rate limited indicates that
         * CloudWatch Logs throttling has been applied for one or more network interfaces, or that you've
         * reached the limit on the number of log groups that you can create. Access
         * error indicates that the IAM role associated with the flow log does not have
         * sufficient permissions to publish to CloudWatch Logs. Unknown error indicates an
         * internal error.
         */
        var deliverLogsErrorMessage: kotlin.String? = null
        /**
         * The ARN of the IAM role that posts logs to CloudWatch Logs.
         */
        var deliverLogsPermissionArn: kotlin.String? = null
        /**
         * The status of the logs delivery (SUCCESS | FAILED).
         */
        var deliverLogsStatus: kotlin.String? = null
        /**
         * The destination options.
         */
        var destinationOptions: aws.sdk.kotlin.services.ec2.model.DestinationOptionsResponse? = null
        /**
         * The flow log ID.
         */
        var flowLogId: kotlin.String? = null
        /**
         * The status of the flow log (ACTIVE).
         */
        var flowLogStatus: kotlin.String? = null
        /**
         * The destination to which the flow log data is published. Flow log data can be
         * published to an CloudWatch Logs log group or an Amazon S3 bucket. If the flow log publishes to CloudWatch Logs,
         * this element indicates the Amazon Resource Name (ARN) of the CloudWatch Logs log group to which
         * the data is published. If the flow log publishes to Amazon S3, this element indicates the ARN
         * of the Amazon S3 bucket to which the data is published.
         */
        var logDestination: kotlin.String? = null
        /**
         * The type of destination to which the flow log data is published. Flow log data can be
         * published to CloudWatch Logs or Amazon S3.
         */
        var logDestinationType: aws.sdk.kotlin.services.ec2.model.LogDestinationType? = null
        /**
         * The format of the flow log record.
         */
        var logFormat: kotlin.String? = null
        /**
         * The name of the flow log group.
         */
        var logGroupName: kotlin.String? = null
        /**
         * The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow log record.
         * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
         * instance, the aggregation interval is always 60 seconds (1 minute) or less,
         * regardless of the specified value.
         * Valid Values: 60 | 600
         */
        var maxAggregationInterval: kotlin.Int? = null
        /**
         * The ID of the resource on which the flow log was created.
         */
        var resourceId: kotlin.String? = null
        /**
         * The tags for the flow log.
         */
        var tags: List<Tag>? = null
        /**
         * The type of traffic captured for the flow log.
         */
        var trafficType: aws.sdk.kotlin.services.ec2.model.TrafficType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.FlowLog) : this() {
            this.creationTime = x.creationTime
            this.deliverLogsErrorMessage = x.deliverLogsErrorMessage
            this.deliverLogsPermissionArn = x.deliverLogsPermissionArn
            this.deliverLogsStatus = x.deliverLogsStatus
            this.destinationOptions = x.destinationOptions
            this.flowLogId = x.flowLogId
            this.flowLogStatus = x.flowLogStatus
            this.logDestination = x.logDestination
            this.logDestinationType = x.logDestinationType
            this.logFormat = x.logFormat
            this.logGroupName = x.logGroupName
            this.maxAggregationInterval = x.maxAggregationInterval
            this.resourceId = x.resourceId
            this.tags = x.tags
            this.trafficType = x.trafficType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.FlowLog = FlowLog(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DestinationOptionsResponse] inside the given [block]
         */
        fun destinationOptions(block: aws.sdk.kotlin.services.ec2.model.DestinationOptionsResponse.Builder.() -> kotlin.Unit) {
            this.destinationOptions = aws.sdk.kotlin.services.ec2.model.DestinationOptionsResponse.invoke(block)
        }
    }
}
