// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an event in the history of the Spot Fleet request.
 */
class HistoryRecord private constructor(builder: Builder) {
    /**
     * Information about the event.
     */
    val eventInformation: aws.sdk.kotlin.services.ec2.model.EventInformation? = builder.eventInformation
    /**
     * The event type.
     * error - An error with the Spot Fleet request.
     * fleetRequestChange - A change in the status or configuration of
     * the Spot Fleet request.
     * instanceChange - An instance was launched or terminated.
     * Information - An informational event.
     */
    val eventType: aws.sdk.kotlin.services.ec2.model.EventType? = builder.eventType
    /**
     * The date and time of the event, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     */
    val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.HistoryRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HistoryRecord(")
        append("eventInformation=$eventInformation,")
        append("eventType=$eventType,")
        append("timestamp=$timestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventInformation?.hashCode() ?: 0
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HistoryRecord

        if (eventInformation != other.eventInformation) return false
        if (eventType != other.eventType) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.HistoryRecord = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the event.
         */
        var eventInformation: aws.sdk.kotlin.services.ec2.model.EventInformation? = null
        /**
         * The event type.
         * error - An error with the Spot Fleet request.
         * fleetRequestChange - A change in the status or configuration of
         * the Spot Fleet request.
         * instanceChange - An instance was launched or terminated.
         * Information - An informational event.
         */
        var eventType: aws.sdk.kotlin.services.ec2.model.EventType? = null
        /**
         * The date and time of the event, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.HistoryRecord) : this() {
            this.eventInformation = x.eventInformation
            this.eventType = x.eventType
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.HistoryRecord = HistoryRecord(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EventInformation] inside the given [block]
         */
        fun eventInformation(block: aws.sdk.kotlin.services.ec2.model.EventInformation.Builder.() -> kotlin.Unit) {
            this.eventInformation = aws.sdk.kotlin.services.ec2.model.EventInformation.invoke(block)
        }
    }
}
