// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about the Dedicated Host Reservation and associated Dedicated
 * Hosts.
 */
class HostReservation private constructor(builder: Builder) {
    /**
     * The number of Dedicated Hosts the reservation is associated with.
     */
    val count: kotlin.Int? = builder.count
    /**
     * The currency in which the upfrontPrice and hourlyPrice
     * amounts are specified. At this time, the only supported currency is
     * USD.
     */
    val currencyCode: aws.sdk.kotlin.services.ec2.model.CurrencyCodeValues? = builder.currencyCode
    /**
     * The length of the reservation's term, specified in seconds. Can be 31536000
     * (1 year) | 94608000 (3 years).
     */
    val duration: kotlin.Int? = builder.duration
    /**
     * The date and time that the reservation ends.
     */
    val end: aws.smithy.kotlin.runtime.time.Instant? = builder.end
    /**
     * The IDs of the Dedicated Hosts associated with the reservation.
     */
    val hostIdSet: List<String>? = builder.hostIdSet
    /**
     * The ID of the reservation that specifies the associated Dedicated Hosts.
     */
    val hostReservationId: kotlin.String? = builder.hostReservationId
    /**
     * The hourly price of the reservation.
     */
    val hourlyPrice: kotlin.String? = builder.hourlyPrice
    /**
     * The instance family of the Dedicated Host Reservation. The instance family on the
     * Dedicated Host must be the same in order for it to benefit from the
     * reservation.
     */
    val instanceFamily: kotlin.String? = builder.instanceFamily
    /**
     * The ID of the reservation. This remains the same regardless of which Dedicated
     * Hosts are associated with it.
     */
    val offeringId: kotlin.String? = builder.offeringId
    /**
     * The payment option selected for this reservation.
     */
    val paymentOption: aws.sdk.kotlin.services.ec2.model.PaymentOption? = builder.paymentOption
    /**
     * The date and time that the reservation started.
     */
    val start: aws.smithy.kotlin.runtime.time.Instant? = builder.start
    /**
     * The state of the reservation.
     */
    val state: aws.sdk.kotlin.services.ec2.model.ReservationState? = builder.state
    /**
     * Any tags assigned to the Dedicated Host Reservation.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The upfront price of the reservation.
     */
    val upfrontPrice: kotlin.String? = builder.upfrontPrice

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.HostReservation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HostReservation(")
        append("count=$count,")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("end=$end,")
        append("hostIdSet=$hostIdSet,")
        append("hostReservationId=$hostReservationId,")
        append("hourlyPrice=$hourlyPrice,")
        append("instanceFamily=$instanceFamily,")
        append("offeringId=$offeringId,")
        append("paymentOption=$paymentOption,")
        append("start=$start,")
        append("state=$state,")
        append("tags=$tags,")
        append("upfrontPrice=$upfrontPrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = count ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (end?.hashCode() ?: 0)
        result = 31 * result + (hostIdSet?.hashCode() ?: 0)
        result = 31 * result + (hostReservationId?.hashCode() ?: 0)
        result = 31 * result + (hourlyPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceFamily?.hashCode() ?: 0)
        result = 31 * result + (offeringId?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (start?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (upfrontPrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HostReservation

        if (count != other.count) return false
        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (end != other.end) return false
        if (hostIdSet != other.hostIdSet) return false
        if (hostReservationId != other.hostReservationId) return false
        if (hourlyPrice != other.hourlyPrice) return false
        if (instanceFamily != other.instanceFamily) return false
        if (offeringId != other.offeringId) return false
        if (paymentOption != other.paymentOption) return false
        if (start != other.start) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (upfrontPrice != other.upfrontPrice) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.HostReservation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of Dedicated Hosts the reservation is associated with.
         */
        var count: kotlin.Int? = null
        /**
         * The currency in which the upfrontPrice and hourlyPrice
         * amounts are specified. At this time, the only supported currency is
         * USD.
         */
        var currencyCode: aws.sdk.kotlin.services.ec2.model.CurrencyCodeValues? = null
        /**
         * The length of the reservation's term, specified in seconds. Can be 31536000
         * (1 year) | 94608000 (3 years).
         */
        var duration: kotlin.Int? = null
        /**
         * The date and time that the reservation ends.
         */
        var end: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IDs of the Dedicated Hosts associated with the reservation.
         */
        var hostIdSet: List<String>? = null
        /**
         * The ID of the reservation that specifies the associated Dedicated Hosts.
         */
        var hostReservationId: kotlin.String? = null
        /**
         * The hourly price of the reservation.
         */
        var hourlyPrice: kotlin.String? = null
        /**
         * The instance family of the Dedicated Host Reservation. The instance family on the
         * Dedicated Host must be the same in order for it to benefit from the
         * reservation.
         */
        var instanceFamily: kotlin.String? = null
        /**
         * The ID of the reservation. This remains the same regardless of which Dedicated
         * Hosts are associated with it.
         */
        var offeringId: kotlin.String? = null
        /**
         * The payment option selected for this reservation.
         */
        var paymentOption: aws.sdk.kotlin.services.ec2.model.PaymentOption? = null
        /**
         * The date and time that the reservation started.
         */
        var start: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the reservation.
         */
        var state: aws.sdk.kotlin.services.ec2.model.ReservationState? = null
        /**
         * Any tags assigned to the Dedicated Host Reservation.
         */
        var tags: List<Tag>? = null
        /**
         * The upfront price of the reservation.
         */
        var upfrontPrice: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.HostReservation) : this() {
            this.count = x.count
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.end = x.end
            this.hostIdSet = x.hostIdSet
            this.hostReservationId = x.hostReservationId
            this.hourlyPrice = x.hourlyPrice
            this.instanceFamily = x.instanceFamily
            this.offeringId = x.offeringId
            this.paymentOption = x.paymentOption
            this.start = x.start
            this.state = x.state
            this.tags = x.tags
            this.upfrontPrice = x.upfrontPrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.HostReservation = HostReservation(this)
    }
}
