// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ImportImageRequest private constructor(builder: Builder) {
    /**
     * The architecture of the virtual machine.
     * Valid values: i386 | x86_64
     */
    val architecture: kotlin.String? = builder.architecture
    /**
     * The boot mode of the virtual machine.
     */
    val bootMode: aws.sdk.kotlin.services.ec2.model.BootModeValues? = builder.bootMode
    /**
     * The client-specific data.
     */
    val clientData: aws.sdk.kotlin.services.ec2.model.ClientData? = builder.clientData
    /**
     * The token to enable idempotency for VM import requests.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description string for the import image task.
     */
    val description: kotlin.String? = builder.description
    /**
     * Information about the disk containers.
     */
    val diskContainers: List<ImageDiskContainer>? = builder.diskContainers
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key for EBS is used
     * unless you specify a non-default KMS key using KmsKeyId. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The target hypervisor platform.
     * Valid values: xen
     */
    val hypervisor: kotlin.String? = builder.hypervisor
    /**
     * An identifier for the symmetric KMS key to use when creating the
     * encrypted AMI. This parameter is only required if you want to use a non-default KMS key; if this
     * parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is
     * specified, the Encrypted flag must also be set.
     * The KMS key identifier may be provided in any of the following formats:
     * Key ID
     * Key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the alias namespace, and then the key alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
     * ARN using key ID. The ID ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the key namespace, and then the key ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
     * ARN using key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the alias namespace, and then the key alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
     * Amazon Web Services parses KmsKeyId asynchronously, meaning that the action you call may appear to complete even
     * though you provided an invalid identifier. This action will eventually report failure.
     * The specified KMS key must exist in the Region that the AMI is being copied to.
     * Amazon EBS does not support asymmetric KMS keys.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The ARNs of the license configurations.
     */
    val licenseSpecifications: List<ImportImageLicenseConfigurationRequest>? = builder.licenseSpecifications
    /**
     * The license type to be used for the Amazon Machine Image (AMI) after importing.
     * By default, we detect the source-system operating system (OS) and apply the appropriate license. Specify
     * AWS to replace the source-system license with an Amazon Web Services license, if appropriate. Specify BYOL
     * to retain the source-system license, if appropriate.
     * To use BYOL, you must have existing licenses with rights to use these licenses in a third party
     * cloud, such as Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image">Prerequisites in the
     * VM Import/Export User Guide.
     */
    val licenseType: kotlin.String? = builder.licenseType
    /**
     * The operating system of the virtual machine.
     * Valid values: Windows | Linux
     */
    val platform: kotlin.String? = builder.platform
    /**
     * The name of the role to use when not using the default role, 'vmimport'.
     */
    val roleName: kotlin.String? = builder.roleName
    /**
     * The tags to apply to the import image task during creation.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The usage operation value. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#prerequisites">Licensing options in the VM Import/Export User Guide.
     */
    val usageOperation: kotlin.String? = builder.usageOperation

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ImportImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportImageRequest(")
        append("architecture=$architecture,")
        append("bootMode=$bootMode,")
        append("clientData=$clientData,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("diskContainers=$diskContainers,")
        append("dryRun=$dryRun,")
        append("encrypted=$encrypted,")
        append("hypervisor=$hypervisor,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseSpecifications=$licenseSpecifications,")
        append("licenseType=$licenseType,")
        append("platform=$platform,")
        append("roleName=$roleName,")
        append("tagSpecifications=$tagSpecifications,")
        append("usageOperation=$usageOperation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = architecture?.hashCode() ?: 0
        result = 31 * result + (bootMode?.hashCode() ?: 0)
        result = 31 * result + (clientData?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (diskContainers?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (hypervisor?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseSpecifications?.hashCode() ?: 0)
        result = 31 * result + (licenseType?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (usageOperation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportImageRequest

        if (architecture != other.architecture) return false
        if (bootMode != other.bootMode) return false
        if (clientData != other.clientData) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (diskContainers != other.diskContainers) return false
        if (dryRun != other.dryRun) return false
        if (encrypted != other.encrypted) return false
        if (hypervisor != other.hypervisor) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseSpecifications != other.licenseSpecifications) return false
        if (licenseType != other.licenseType) return false
        if (platform != other.platform) return false
        if (roleName != other.roleName) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (usageOperation != other.usageOperation) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ImportImageRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The architecture of the virtual machine.
         * Valid values: i386 | x86_64
         */
        var architecture: kotlin.String? = null
        /**
         * The boot mode of the virtual machine.
         */
        var bootMode: aws.sdk.kotlin.services.ec2.model.BootModeValues? = null
        /**
         * The client-specific data.
         */
        var clientData: aws.sdk.kotlin.services.ec2.model.ClientData? = null
        /**
         * The token to enable idempotency for VM import requests.
         */
        var clientToken: kotlin.String? = null
        /**
         * A description string for the import image task.
         */
        var description: kotlin.String? = null
        /**
         * Information about the disk containers.
         */
        var diskContainers: List<ImageDiskContainer>? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key for EBS is used
         * unless you specify a non-default KMS key using KmsKeyId. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var encrypted: kotlin.Boolean? = null
        /**
         * The target hypervisor platform.
         * Valid values: xen
         */
        var hypervisor: kotlin.String? = null
        /**
         * An identifier for the symmetric KMS key to use when creating the
         * encrypted AMI. This parameter is only required if you want to use a non-default KMS key; if this
         * parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is
         * specified, the Encrypted flag must also be set.
         * The KMS key identifier may be provided in any of the following formats:
         * Key ID
         * Key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the alias namespace, and then the key alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         * ARN using key ID. The ID ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the key namespace, and then the key ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
         * ARN using key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the alias namespace, and then the key alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         * Amazon Web Services parses KmsKeyId asynchronously, meaning that the action you call may appear to complete even
         * though you provided an invalid identifier. This action will eventually report failure.
         * The specified KMS key must exist in the Region that the AMI is being copied to.
         * Amazon EBS does not support asymmetric KMS keys.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The ARNs of the license configurations.
         */
        var licenseSpecifications: List<ImportImageLicenseConfigurationRequest>? = null
        /**
         * The license type to be used for the Amazon Machine Image (AMI) after importing.
         * By default, we detect the source-system operating system (OS) and apply the appropriate license. Specify
         * AWS to replace the source-system license with an Amazon Web Services license, if appropriate. Specify BYOL
         * to retain the source-system license, if appropriate.
         * To use BYOL, you must have existing licenses with rights to use these licenses in a third party
         * cloud, such as Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image">Prerequisites in the
         * VM Import/Export User Guide.
         */
        var licenseType: kotlin.String? = null
        /**
         * The operating system of the virtual machine.
         * Valid values: Windows | Linux
         */
        var platform: kotlin.String? = null
        /**
         * The name of the role to use when not using the default role, 'vmimport'.
         */
        var roleName: kotlin.String? = null
        /**
         * The tags to apply to the import image task during creation.
         */
        var tagSpecifications: List<TagSpecification>? = null
        /**
         * The usage operation value. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#prerequisites">Licensing options in the VM Import/Export User Guide.
         */
        var usageOperation: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ImportImageRequest) : this() {
            this.architecture = x.architecture
            this.bootMode = x.bootMode
            this.clientData = x.clientData
            this.clientToken = x.clientToken
            this.description = x.description
            this.diskContainers = x.diskContainers
            this.dryRun = x.dryRun
            this.encrypted = x.encrypted
            this.hypervisor = x.hypervisor
            this.kmsKeyId = x.kmsKeyId
            this.licenseSpecifications = x.licenseSpecifications
            this.licenseType = x.licenseType
            this.platform = x.platform
            this.roleName = x.roleName
            this.tagSpecifications = x.tagSpecifications
            this.usageOperation = x.usageOperation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ImportImageRequest = ImportImageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientData] inside the given [block]
         */
        fun clientData(block: aws.sdk.kotlin.services.ec2.model.ClientData.Builder.() -> kotlin.Unit) {
            this.clientData = aws.sdk.kotlin.services.ec2.model.ClientData.invoke(block)
        }
    }
}
