// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The CIDR for an IPAM resource.
 */
class IpamResourceCidr private constructor(builder: Builder) {
    /**
     * The compliance status of the IPAM resource. For more information on compliance statuses, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource in the Amazon VPC IPAM User Guide.
     */
    val complianceStatus: aws.sdk.kotlin.services.ec2.model.IpamComplianceStatus? = builder.complianceStatus
    /**
     * The IP address space in the IPAM pool that is allocated to this resource. To convert the decimal to a percentage, multiply the decimal by 100.
     */
    val ipUsage: kotlin.Double? = builder.ipUsage
    /**
     * The IPAM ID for an IPAM resource.
     */
    val ipamId: kotlin.String? = builder.ipamId
    /**
     * The pool ID for an IPAM resource.
     */
    val ipamPoolId: kotlin.String? = builder.ipamPoolId
    /**
     * The scope ID for an IPAM resource.
     */
    val ipamScopeId: kotlin.String? = builder.ipamScopeId
    /**
     * The management state of the resource. For more information about management states, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource in the Amazon VPC IPAM User Guide.
     */
    val managementState: aws.sdk.kotlin.services.ec2.model.IpamManagementState? = builder.managementState
    /**
     * The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps with another CIDR in the scope. For more information on overlap statuses, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource in the Amazon VPC IPAM User Guide.
     */
    val overlapStatus: aws.sdk.kotlin.services.ec2.model.IpamOverlapStatus? = builder.overlapStatus
    /**
     * The CIDR for an IPAM resource.
     */
    val resourceCidr: kotlin.String? = builder.resourceCidr
    /**
     * The ID of an IPAM resource.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * The name of an IPAM resource.
     */
    val resourceName: kotlin.String? = builder.resourceName
    /**
     * The Amazon Web Services account number of the owner of an IPAM resource.
     */
    val resourceOwnerId: kotlin.String? = builder.resourceOwnerId
    /**
     * The Amazon Web Services Region for an IPAM resource.
     */
    val resourceRegion: kotlin.String? = builder.resourceRegion
    /**
     * The tags for an IPAM resource.
     */
    val resourceTags: List<IpamResourceTag>? = builder.resourceTags
    /**
     * The type of IPAM resource.
     */
    val resourceType: aws.sdk.kotlin.services.ec2.model.IpamResourceType? = builder.resourceType
    /**
     * The ID of a VPC.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.IpamResourceCidr = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpamResourceCidr(")
        append("complianceStatus=$complianceStatus,")
        append("ipUsage=$ipUsage,")
        append("ipamId=$ipamId,")
        append("ipamPoolId=$ipamPoolId,")
        append("ipamScopeId=$ipamScopeId,")
        append("managementState=$managementState,")
        append("overlapStatus=$overlapStatus,")
        append("resourceCidr=$resourceCidr,")
        append("resourceId=$resourceId,")
        append("resourceName=$resourceName,")
        append("resourceOwnerId=$resourceOwnerId,")
        append("resourceRegion=$resourceRegion,")
        append("resourceTags=$resourceTags,")
        append("resourceType=$resourceType,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = complianceStatus?.hashCode() ?: 0
        result = 31 * result + (ipUsage?.hashCode() ?: 0)
        result = 31 * result + (ipamId?.hashCode() ?: 0)
        result = 31 * result + (ipamPoolId?.hashCode() ?: 0)
        result = 31 * result + (ipamScopeId?.hashCode() ?: 0)
        result = 31 * result + (managementState?.hashCode() ?: 0)
        result = 31 * result + (overlapStatus?.hashCode() ?: 0)
        result = 31 * result + (resourceCidr?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (resourceRegion?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpamResourceCidr

        if (complianceStatus != other.complianceStatus) return false
        if (ipUsage != other.ipUsage) return false
        if (ipamId != other.ipamId) return false
        if (ipamPoolId != other.ipamPoolId) return false
        if (ipamScopeId != other.ipamScopeId) return false
        if (managementState != other.managementState) return false
        if (overlapStatus != other.overlapStatus) return false
        if (resourceCidr != other.resourceCidr) return false
        if (resourceId != other.resourceId) return false
        if (resourceName != other.resourceName) return false
        if (resourceOwnerId != other.resourceOwnerId) return false
        if (resourceRegion != other.resourceRegion) return false
        if (resourceTags != other.resourceTags) return false
        if (resourceType != other.resourceType) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.IpamResourceCidr = Builder(this).apply(block).build()

    class Builder {
        /**
         * The compliance status of the IPAM resource. For more information on compliance statuses, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource in the Amazon VPC IPAM User Guide.
         */
        var complianceStatus: aws.sdk.kotlin.services.ec2.model.IpamComplianceStatus? = null
        /**
         * The IP address space in the IPAM pool that is allocated to this resource. To convert the decimal to a percentage, multiply the decimal by 100.
         */
        var ipUsage: kotlin.Double? = null
        /**
         * The IPAM ID for an IPAM resource.
         */
        var ipamId: kotlin.String? = null
        /**
         * The pool ID for an IPAM resource.
         */
        var ipamPoolId: kotlin.String? = null
        /**
         * The scope ID for an IPAM resource.
         */
        var ipamScopeId: kotlin.String? = null
        /**
         * The management state of the resource. For more information about management states, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource in the Amazon VPC IPAM User Guide.
         */
        var managementState: aws.sdk.kotlin.services.ec2.model.IpamManagementState? = null
        /**
         * The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps with another CIDR in the scope. For more information on overlap statuses, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource in the Amazon VPC IPAM User Guide.
         */
        var overlapStatus: aws.sdk.kotlin.services.ec2.model.IpamOverlapStatus? = null
        /**
         * The CIDR for an IPAM resource.
         */
        var resourceCidr: kotlin.String? = null
        /**
         * The ID of an IPAM resource.
         */
        var resourceId: kotlin.String? = null
        /**
         * The name of an IPAM resource.
         */
        var resourceName: kotlin.String? = null
        /**
         * The Amazon Web Services account number of the owner of an IPAM resource.
         */
        var resourceOwnerId: kotlin.String? = null
        /**
         * The Amazon Web Services Region for an IPAM resource.
         */
        var resourceRegion: kotlin.String? = null
        /**
         * The tags for an IPAM resource.
         */
        var resourceTags: List<IpamResourceTag>? = null
        /**
         * The type of IPAM resource.
         */
        var resourceType: aws.sdk.kotlin.services.ec2.model.IpamResourceType? = null
        /**
         * The ID of a VPC.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.IpamResourceCidr) : this() {
            this.complianceStatus = x.complianceStatus
            this.ipUsage = x.ipUsage
            this.ipamId = x.ipamId
            this.ipamPoolId = x.ipamPoolId
            this.ipamScopeId = x.ipamScopeId
            this.managementState = x.managementState
            this.overlapStatus = x.overlapStatus
            this.resourceCidr = x.resourceCidr
            this.resourceId = x.resourceId
            this.resourceName = x.resourceName
            this.resourceOwnerId = x.resourceOwnerId
            this.resourceRegion = x.resourceRegion
            this.resourceTags = x.resourceTags
            this.resourceType = x.resourceType
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.IpamResourceCidr = IpamResourceCidr(this)
    }
}
