// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a NAT gateway.
 */
class NatGateway private constructor(builder: Builder) {
    /**
     * Indicates whether the NAT gateway supports public or private connectivity.
     */
    val connectivityType: aws.sdk.kotlin.services.ec2.model.ConnectivityType? = builder.connectivityType
    /**
     * The date and time the NAT gateway was created.
     */
    val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The date and time the NAT gateway was deleted, if applicable.
     */
    val deleteTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deleteTime
    /**
     * If the NAT gateway could not be created, specifies the error code for the failure.
     * (InsufficientFreeAddressesInSubnet | Gateway.NotAttached |
     * InvalidAllocationID.NotFound | Resource.AlreadyAssociated |
     * InternalError | InvalidSubnetID.NotFound)
     */
    val failureCode: kotlin.String? = builder.failureCode
    /**
     * If the NAT gateway could not be created, specifies the error message for the failure, that corresponds to the error code.
     * For InsufficientFreeAddressesInSubnet: "Subnet has insufficient free addresses to create this NAT gateway"
     * For Gateway.NotAttached: "Network vpc-xxxxxxxx has no Internet gateway attached"
     * For InvalidAllocationID.NotFound: "Elastic IP address eipalloc-xxxxxxxx could not be associated with this NAT gateway"
     * For Resource.AlreadyAssociated: "Elastic IP address eipalloc-xxxxxxxx is already associated"
     * For InternalError: "Network interface eni-xxxxxxxx, created and used internally by this NAT gateway is in an invalid state. Please try again."
     * For InvalidSubnetID.NotFound: "The specified subnet subnet-xxxxxxxx does not exist or could not be found."
     */
    val failureMessage: kotlin.String? = builder.failureMessage
    /**
     * Information about the IP addresses and network interface associated with the NAT gateway.
     */
    val natGatewayAddresses: List<NatGatewayAddress>? = builder.natGatewayAddresses
    /**
     * The ID of the NAT gateway.
     */
    val natGatewayId: kotlin.String? = builder.natGatewayId
    /**
     * Reserved. If you need to sustain traffic greater than the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">documented limits, contact us through
     * the <a href="https://console.aws.amazon.com/support/home?">Support Center.
     */
    val provisionedBandwidth: aws.sdk.kotlin.services.ec2.model.ProvisionedBandwidth? = builder.provisionedBandwidth
    /**
     * The state of the NAT gateway.
     * pending: The NAT gateway is being created and is not ready to process
     * traffic.
     * failed: The NAT gateway could not be created. Check the
     * failureCode and failureMessage fields for the reason.
     * available: The NAT gateway is able to process traffic. This status remains
     * until you delete the NAT gateway, and does not indicate the health of the NAT gateway.
     * deleting: The NAT gateway is in the process of being terminated and may
     * still be processing traffic.
     * deleted: The NAT gateway has been terminated and is no longer processing
     * traffic.
     */
    val state: aws.sdk.kotlin.services.ec2.model.NatGatewayState? = builder.state
    /**
     * The ID of the subnet in which the NAT gateway is located.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * The tags for the NAT gateway.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC in which the NAT gateway is located.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.NatGateway = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NatGateway(")
        append("connectivityType=$connectivityType,")
        append("createTime=$createTime,")
        append("deleteTime=$deleteTime,")
        append("failureCode=$failureCode,")
        append("failureMessage=$failureMessage,")
        append("natGatewayAddresses=$natGatewayAddresses,")
        append("natGatewayId=$natGatewayId,")
        append("provisionedBandwidth=$provisionedBandwidth,")
        append("state=$state,")
        append("subnetId=$subnetId,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectivityType?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (deleteTime?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (natGatewayAddresses?.hashCode() ?: 0)
        result = 31 * result + (natGatewayId?.hashCode() ?: 0)
        result = 31 * result + (provisionedBandwidth?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NatGateway

        if (connectivityType != other.connectivityType) return false
        if (createTime != other.createTime) return false
        if (deleteTime != other.deleteTime) return false
        if (failureCode != other.failureCode) return false
        if (failureMessage != other.failureMessage) return false
        if (natGatewayAddresses != other.natGatewayAddresses) return false
        if (natGatewayId != other.natGatewayId) return false
        if (provisionedBandwidth != other.provisionedBandwidth) return false
        if (state != other.state) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.NatGateway = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether the NAT gateway supports public or private connectivity.
         */
        var connectivityType: aws.sdk.kotlin.services.ec2.model.ConnectivityType? = null
        /**
         * The date and time the NAT gateway was created.
         */
        var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time the NAT gateway was deleted, if applicable.
         */
        var deleteTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the NAT gateway could not be created, specifies the error code for the failure.
         * (InsufficientFreeAddressesInSubnet | Gateway.NotAttached |
         * InvalidAllocationID.NotFound | Resource.AlreadyAssociated |
         * InternalError | InvalidSubnetID.NotFound)
         */
        var failureCode: kotlin.String? = null
        /**
         * If the NAT gateway could not be created, specifies the error message for the failure, that corresponds to the error code.
         * For InsufficientFreeAddressesInSubnet: "Subnet has insufficient free addresses to create this NAT gateway"
         * For Gateway.NotAttached: "Network vpc-xxxxxxxx has no Internet gateway attached"
         * For InvalidAllocationID.NotFound: "Elastic IP address eipalloc-xxxxxxxx could not be associated with this NAT gateway"
         * For Resource.AlreadyAssociated: "Elastic IP address eipalloc-xxxxxxxx is already associated"
         * For InternalError: "Network interface eni-xxxxxxxx, created and used internally by this NAT gateway is in an invalid state. Please try again."
         * For InvalidSubnetID.NotFound: "The specified subnet subnet-xxxxxxxx does not exist or could not be found."
         */
        var failureMessage: kotlin.String? = null
        /**
         * Information about the IP addresses and network interface associated with the NAT gateway.
         */
        var natGatewayAddresses: List<NatGatewayAddress>? = null
        /**
         * The ID of the NAT gateway.
         */
        var natGatewayId: kotlin.String? = null
        /**
         * Reserved. If you need to sustain traffic greater than the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">documented limits, contact us through
         * the <a href="https://console.aws.amazon.com/support/home?">Support Center.
         */
        var provisionedBandwidth: aws.sdk.kotlin.services.ec2.model.ProvisionedBandwidth? = null
        /**
         * The state of the NAT gateway.
         * pending: The NAT gateway is being created and is not ready to process
         * traffic.
         * failed: The NAT gateway could not be created. Check the
         * failureCode and failureMessage fields for the reason.
         * available: The NAT gateway is able to process traffic. This status remains
         * until you delete the NAT gateway, and does not indicate the health of the NAT gateway.
         * deleting: The NAT gateway is in the process of being terminated and may
         * still be processing traffic.
         * deleted: The NAT gateway has been terminated and is no longer processing
         * traffic.
         */
        var state: aws.sdk.kotlin.services.ec2.model.NatGatewayState? = null
        /**
         * The ID of the subnet in which the NAT gateway is located.
         */
        var subnetId: kotlin.String? = null
        /**
         * The tags for the NAT gateway.
         */
        var tags: List<Tag>? = null
        /**
         * The ID of the VPC in which the NAT gateway is located.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.NatGateway) : this() {
            this.connectivityType = x.connectivityType
            this.createTime = x.createTime
            this.deleteTime = x.deleteTime
            this.failureCode = x.failureCode
            this.failureMessage = x.failureMessage
            this.natGatewayAddresses = x.natGatewayAddresses
            this.natGatewayId = x.natGatewayId
            this.provisionedBandwidth = x.provisionedBandwidth
            this.state = x.state
            this.subnetId = x.subnetId
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.NatGateway = NatGateway(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ProvisionedBandwidth] inside the given [block]
         */
        fun provisionedBandwidth(block: aws.sdk.kotlin.services.ec2.model.ProvisionedBandwidth.Builder.() -> kotlin.Unit) {
            this.provisionedBandwidth = aws.sdk.kotlin.services.ec2.model.ProvisionedBandwidth.invoke(block)
        }
    }
}
