// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an entry in a network ACL.
 */
class NetworkAclEntry private constructor(builder: Builder) {
    /**
     * The IPv4 network range to allow or deny, in CIDR notation.
     */
    val cidrBlock: kotlin.String? = builder.cidrBlock
    /**
     * Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).
     */
    val egress: kotlin.Boolean? = builder.egress
    /**
     * ICMP protocol: The ICMP type and code.
     */
    val icmpTypeCode: aws.sdk.kotlin.services.ec2.model.IcmpTypeCode? = builder.icmpTypeCode
    /**
     * The IPv6 network range to allow or deny, in CIDR notation.
     */
    val ipv6CidrBlock: kotlin.String? = builder.ipv6CidrBlock
    /**
     * TCP or UDP protocols: The range of ports the rule applies to.
     */
    val portRange: aws.sdk.kotlin.services.ec2.model.PortRange? = builder.portRange
    /**
     * The protocol number. A value of "-1" means all protocols.
     */
    val protocol: kotlin.String? = builder.protocol
    /**
     * Indicates whether to allow or deny the traffic that matches the rule.
     */
    val ruleAction: aws.sdk.kotlin.services.ec2.model.RuleAction? = builder.ruleAction
    /**
     * The rule number for the entry. ACL entries are processed in ascending order by rule number.
     */
    val ruleNumber: kotlin.Int? = builder.ruleNumber

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.NetworkAclEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkAclEntry(")
        append("cidrBlock=$cidrBlock,")
        append("egress=$egress,")
        append("icmpTypeCode=$icmpTypeCode,")
        append("ipv6CidrBlock=$ipv6CidrBlock,")
        append("portRange=$portRange,")
        append("protocol=$protocol,")
        append("ruleAction=$ruleAction,")
        append("ruleNumber=$ruleNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrBlock?.hashCode() ?: 0
        result = 31 * result + (egress?.hashCode() ?: 0)
        result = 31 * result + (icmpTypeCode?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (portRange?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (ruleAction?.hashCode() ?: 0)
        result = 31 * result + (ruleNumber ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkAclEntry

        if (cidrBlock != other.cidrBlock) return false
        if (egress != other.egress) return false
        if (icmpTypeCode != other.icmpTypeCode) return false
        if (ipv6CidrBlock != other.ipv6CidrBlock) return false
        if (portRange != other.portRange) return false
        if (protocol != other.protocol) return false
        if (ruleAction != other.ruleAction) return false
        if (ruleNumber != other.ruleNumber) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.NetworkAclEntry = Builder(this).apply(block).build()

    class Builder {
        /**
         * The IPv4 network range to allow or deny, in CIDR notation.
         */
        var cidrBlock: kotlin.String? = null
        /**
         * Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).
         */
        var egress: kotlin.Boolean? = null
        /**
         * ICMP protocol: The ICMP type and code.
         */
        var icmpTypeCode: aws.sdk.kotlin.services.ec2.model.IcmpTypeCode? = null
        /**
         * The IPv6 network range to allow or deny, in CIDR notation.
         */
        var ipv6CidrBlock: kotlin.String? = null
        /**
         * TCP or UDP protocols: The range of ports the rule applies to.
         */
        var portRange: aws.sdk.kotlin.services.ec2.model.PortRange? = null
        /**
         * The protocol number. A value of "-1" means all protocols.
         */
        var protocol: kotlin.String? = null
        /**
         * Indicates whether to allow or deny the traffic that matches the rule.
         */
        var ruleAction: aws.sdk.kotlin.services.ec2.model.RuleAction? = null
        /**
         * The rule number for the entry. ACL entries are processed in ascending order by rule number.
         */
        var ruleNumber: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.NetworkAclEntry) : this() {
            this.cidrBlock = x.cidrBlock
            this.egress = x.egress
            this.icmpTypeCode = x.icmpTypeCode
            this.ipv6CidrBlock = x.ipv6CidrBlock
            this.portRange = x.portRange
            this.protocol = x.protocol
            this.ruleAction = x.ruleAction
            this.ruleNumber = x.ruleNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.NetworkAclEntry = NetworkAclEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.IcmpTypeCode] inside the given [block]
         */
        fun icmpTypeCode(block: aws.sdk.kotlin.services.ec2.model.IcmpTypeCode.Builder.() -> kotlin.Unit) {
            this.icmpTypeCode = aws.sdk.kotlin.services.ec2.model.IcmpTypeCode.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PortRange] inside the given [block]
         */
        fun portRange(block: aws.sdk.kotlin.services.ec2.model.PortRange.Builder.() -> kotlin.Unit) {
            this.portRange = aws.sdk.kotlin.services.ec2.model.PortRange.invoke(block)
        }
    }
}
