// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about the private DNS name for the service endpoint. For more information
 * about these parameters, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/ndpoint-services-dns-validation.html">VPC Endpoint Service
 * Private DNS Name Verification in the
 * Amazon Virtual Private Cloud User Guide.
 */
class PrivateDnsNameConfiguration private constructor(builder: Builder) {
    /**
     * The name of the record subdomain the service provider needs to create. The service provider adds the value text to the name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The verification state of the VPC endpoint service.
     * >Consumers
     * of the endpoint service can use the private name only when the state is
     * verified.
     */
    val state: aws.sdk.kotlin.services.ec2.model.DnsNameState? = builder.state
    /**
     * The endpoint service verification type, for example TXT.
     */
    val type: kotlin.String? = builder.type
    /**
     * The value the service provider adds to the private DNS name domain record before verification.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.PrivateDnsNameConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PrivateDnsNameConfiguration(")
        append("name=$name,")
        append("state=$state,")
        append("type=$type,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PrivateDnsNameConfiguration

        if (name != other.name) return false
        if (state != other.state) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.PrivateDnsNameConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the record subdomain the service provider needs to create. The service provider adds the value text to the name.
         */
        var name: kotlin.String? = null
        /**
         * The verification state of the VPC endpoint service.
         * >Consumers
         * of the endpoint service can use the private name only when the state is
         * verified.
         */
        var state: aws.sdk.kotlin.services.ec2.model.DnsNameState? = null
        /**
         * The endpoint service verification type, for example TXT.
         */
        var type: kotlin.String? = null
        /**
         * The value the service provider adds to the private DNS name domain record before verification.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameConfiguration) : this() {
            this.name = x.name
            this.state = x.state
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.PrivateDnsNameConfiguration = PrivateDnsNameConfiguration(this)
    }
}
