// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class PurchaseHostReservationRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The currency in which the totalUpfrontPrice, LimitPrice,
     * and totalHourlyPrice amounts are specified. At this time, the only
     * supported currency is USD.
     */
    val currencyCode: aws.sdk.kotlin.services.ec2.model.CurrencyCodeValues? = builder.currencyCode
    /**
     * The IDs of the Dedicated Hosts with which the reservation will be associated.
     */
    val hostIdSet: List<String>? = builder.hostIdSet
    /**
     * The specified limit is checked against the total upfront cost of the reservation
     * (calculated as the offering's upfront cost multiplied by the host count). If the total
     * upfront cost is greater than the specified price limit, the request fails. This is used
     * to ensure that the purchase does not exceed the expected upfront cost of the purchase.
     * At this time, the only supported currency is USD. For example, to indicate
     * a limit price of USD 100, specify 100.00.
     */
    val limitPrice: kotlin.String? = builder.limitPrice
    /**
     * The ID of the offering.
     */
    val offeringId: kotlin.String? = builder.offeringId
    /**
     * The tags to apply to the Dedicated Host Reservation during purchase.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.PurchaseHostReservationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PurchaseHostReservationRequest(")
        append("clientToken=$clientToken,")
        append("currencyCode=$currencyCode,")
        append("hostIdSet=$hostIdSet,")
        append("limitPrice=$limitPrice,")
        append("offeringId=$offeringId,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (hostIdSet?.hashCode() ?: 0)
        result = 31 * result + (limitPrice?.hashCode() ?: 0)
        result = 31 * result + (offeringId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PurchaseHostReservationRequest

        if (clientToken != other.clientToken) return false
        if (currencyCode != other.currencyCode) return false
        if (hostIdSet != other.hostIdSet) return false
        if (limitPrice != other.limitPrice) return false
        if (offeringId != other.offeringId) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.PurchaseHostReservationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: kotlin.String? = null
        /**
         * The currency in which the totalUpfrontPrice, LimitPrice,
         * and totalHourlyPrice amounts are specified. At this time, the only
         * supported currency is USD.
         */
        var currencyCode: aws.sdk.kotlin.services.ec2.model.CurrencyCodeValues? = null
        /**
         * The IDs of the Dedicated Hosts with which the reservation will be associated.
         */
        var hostIdSet: List<String>? = null
        /**
         * The specified limit is checked against the total upfront cost of the reservation
         * (calculated as the offering's upfront cost multiplied by the host count). If the total
         * upfront cost is greater than the specified price limit, the request fails. This is used
         * to ensure that the purchase does not exceed the expected upfront cost of the purchase.
         * At this time, the only supported currency is USD. For example, to indicate
         * a limit price of USD 100, specify 100.00.
         */
        var limitPrice: kotlin.String? = null
        /**
         * The ID of the offering.
         */
        var offeringId: kotlin.String? = null
        /**
         * The tags to apply to the Dedicated Host Reservation during purchase.
         */
        var tagSpecifications: List<TagSpecification>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.PurchaseHostReservationRequest) : this() {
            this.clientToken = x.clientToken
            this.currencyCode = x.currencyCode
            this.hostIdSet = x.hostIdSet
            this.limitPrice = x.limitPrice
            this.offeringId = x.offeringId
            this.tagSpecifications = x.tagSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.PurchaseHostReservationRequest = PurchaseHostReservationRequest(this)
    }
}
