// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the configuration settings for the modified Reserved Instances.
 */
class ReservedInstancesConfiguration private constructor(builder: Builder) {
    /**
     * The Availability Zone for the modified Reserved Instances.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The number of modified Reserved Instances.
     * This is a required field for a request.
     */
    val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The instance type for the modified Reserved Instances.
     */
    val instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = builder.instanceType
    /**
     * The network platform of the modified Reserved Instances, which is either EC2-Classic or EC2-VPC.
     */
    val platform: kotlin.String? = builder.platform
    /**
     * Whether the Reserved Instance is applied to instances in a Region or instances in a specific Availability Zone.
     */
    val scope: aws.sdk.kotlin.services.ec2.model.Scope? = builder.scope

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ReservedInstancesConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedInstancesConfiguration(")
        append("availabilityZone=$availabilityZone,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("platform=$platform,")
        append("scope=$scope)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedInstancesConfiguration

        if (availabilityZone != other.availabilityZone) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (platform != other.platform) return false
        if (scope != other.scope) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ReservedInstancesConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone for the modified Reserved Instances.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The number of modified Reserved Instances.
         * This is a required field for a request.
         */
        var instanceCount: kotlin.Int? = null
        /**
         * The instance type for the modified Reserved Instances.
         */
        var instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = null
        /**
         * The network platform of the modified Reserved Instances, which is either EC2-Classic or EC2-VPC.
         */
        var platform: kotlin.String? = null
        /**
         * Whether the Reserved Instance is applied to instances in a Region or instances in a specific Availability Zone.
         */
        var scope: aws.sdk.kotlin.services.ec2.model.Scope? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ReservedInstancesConfiguration) : this() {
            this.availabilityZone = x.availabilityZone
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.platform = x.platform
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ReservedInstancesConfiguration = ReservedInstancesConfiguration(this)
    }
}
