// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Reserved Instance modification.
 */
class ReservedInstancesModification private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The time when the modification request was created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The time for the modification to become effective.
     */
    val effectiveDate: aws.smithy.kotlin.runtime.time.Instant? = builder.effectiveDate
    /**
     * Contains target configurations along with their corresponding new Reserved Instance IDs.
     */
    val modificationResults: List<ReservedInstancesModificationResult>? = builder.modificationResults
    /**
     * The IDs of one or more Reserved Instances.
     */
    val reservedInstancesIds: List<ReservedInstancesId>? = builder.reservedInstancesIds
    /**
     * A unique ID for the Reserved Instance modification.
     */
    val reservedInstancesModificationId: kotlin.String? = builder.reservedInstancesModificationId
    /**
     * The status of the Reserved Instances modification request.
     */
    val status: kotlin.String? = builder.status
    /**
     * The reason for the status.
     */
    val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The time when the modification request was last updated.
     */
    val updateDate: aws.smithy.kotlin.runtime.time.Instant? = builder.updateDate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ReservedInstancesModification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedInstancesModification(")
        append("clientToken=$clientToken,")
        append("createDate=$createDate,")
        append("effectiveDate=$effectiveDate,")
        append("modificationResults=$modificationResults,")
        append("reservedInstancesIds=$reservedInstancesIds,")
        append("reservedInstancesModificationId=$reservedInstancesModificationId,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("updateDate=$updateDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (effectiveDate?.hashCode() ?: 0)
        result = 31 * result + (modificationResults?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesIds?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesModificationId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (updateDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedInstancesModification

        if (clientToken != other.clientToken) return false
        if (createDate != other.createDate) return false
        if (effectiveDate != other.effectiveDate) return false
        if (modificationResults != other.modificationResults) return false
        if (reservedInstancesIds != other.reservedInstancesIds) return false
        if (reservedInstancesModificationId != other.reservedInstancesModificationId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (updateDate != other.updateDate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ReservedInstancesModification = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         */
        var clientToken: kotlin.String? = null
        /**
         * The time when the modification request was created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time for the modification to become effective.
         */
        var effectiveDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains target configurations along with their corresponding new Reserved Instance IDs.
         */
        var modificationResults: List<ReservedInstancesModificationResult>? = null
        /**
         * The IDs of one or more Reserved Instances.
         */
        var reservedInstancesIds: List<ReservedInstancesId>? = null
        /**
         * A unique ID for the Reserved Instance modification.
         */
        var reservedInstancesModificationId: kotlin.String? = null
        /**
         * The status of the Reserved Instances modification request.
         */
        var status: kotlin.String? = null
        /**
         * The reason for the status.
         */
        var statusMessage: kotlin.String? = null
        /**
         * The time when the modification request was last updated.
         */
        var updateDate: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ReservedInstancesModification) : this() {
            this.clientToken = x.clientToken
            this.createDate = x.createDate
            this.effectiveDate = x.effectiveDate
            this.modificationResults = x.modificationResults
            this.reservedInstancesIds = x.reservedInstancesIds
            this.reservedInstancesModificationId = x.reservedInstancesModificationId
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.updateDate = x.updateDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ReservedInstancesModification = ReservedInstancesModification(this)
    }
}
