// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class RevokeSecurityGroupIngressRequest private constructor(builder: Builder) {
    /**
     * The CIDR IP address range. You can't specify this parameter when specifying a source security group.
     */
    val cidrIp: kotlin.String? = builder.cidrIp
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number,
     * use -1 to specify all ICMP types.
     */
    val fromPort: kotlin.Int? = builder.fromPort
    /**
     * The ID of the security group. You must specify either the security group ID or the
     * security group name in the request. For security groups in a nondefault VPC, you must
     * specify the security group ID.
     */
    val groupId: kotlin.String? = builder.groupId
    /**
     * &#91;EC2-Classic, default VPC&#93; The name of the security group. You must specify either the
     * security group ID or the security group name in the request.
     */
    val groupName: kotlin.String? = builder.groupName
    /**
     * The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same set of permissions.
     */
    val ipPermissions: List<IpPermission>? = builder.ipPermissions
    /**
     * The IP protocol name (tcp, udp, icmp) or number
     * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
     * Use -1 to specify all.
     */
    val ipProtocol: kotlin.String? = builder.ipProtocol
    /**
     * The IDs of the security group rules.
     */
    val securityGroupRuleIds: List<String>? = builder.securityGroupRuleIds
    /**
     * &#91;EC2-Classic, default VPC&#93; The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same VPC. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
     */
    val sourceSecurityGroupName: kotlin.String? = builder.sourceSecurityGroupName
    /**
     * &#91;EC2-Classic&#93; The Amazon Web Services account ID of the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
     */
    val sourceSecurityGroupOwnerId: kotlin.String? = builder.sourceSecurityGroupOwnerId
    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number,
     * use -1 to specify all ICMP codes for the ICMP type.
     */
    val toPort: kotlin.Int? = builder.toPort

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.RevokeSecurityGroupIngressRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RevokeSecurityGroupIngressRequest(")
        append("cidrIp=$cidrIp,")
        append("dryRun=$dryRun,")
        append("fromPort=$fromPort,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("ipPermissions=$ipPermissions,")
        append("ipProtocol=$ipProtocol,")
        append("securityGroupRuleIds=$securityGroupRuleIds,")
        append("sourceSecurityGroupName=$sourceSecurityGroupName,")
        append("sourceSecurityGroupOwnerId=$sourceSecurityGroupOwnerId,")
        append("toPort=$toPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrIp?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (fromPort ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (ipPermissions?.hashCode() ?: 0)
        result = 31 * result + (ipProtocol?.hashCode() ?: 0)
        result = 31 * result + (securityGroupRuleIds?.hashCode() ?: 0)
        result = 31 * result + (sourceSecurityGroupName?.hashCode() ?: 0)
        result = 31 * result + (sourceSecurityGroupOwnerId?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RevokeSecurityGroupIngressRequest

        if (cidrIp != other.cidrIp) return false
        if (dryRun != other.dryRun) return false
        if (fromPort != other.fromPort) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (ipPermissions != other.ipPermissions) return false
        if (ipProtocol != other.ipProtocol) return false
        if (securityGroupRuleIds != other.securityGroupRuleIds) return false
        if (sourceSecurityGroupName != other.sourceSecurityGroupName) return false
        if (sourceSecurityGroupOwnerId != other.sourceSecurityGroupOwnerId) return false
        if (toPort != other.toPort) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.RevokeSecurityGroupIngressRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The CIDR IP address range. You can't specify this parameter when specifying a source security group.
         */
        var cidrIp: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number,
         * use -1 to specify all ICMP types.
         */
        var fromPort: kotlin.Int? = null
        /**
         * The ID of the security group. You must specify either the security group ID or the
         * security group name in the request. For security groups in a nondefault VPC, you must
         * specify the security group ID.
         */
        var groupId: kotlin.String? = null
        /**
         * &#91;EC2-Classic, default VPC&#93; The name of the security group. You must specify either the
         * security group ID or the security group name in the request.
         */
        var groupName: kotlin.String? = null
        /**
         * The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same set of permissions.
         */
        var ipPermissions: List<IpPermission>? = null
        /**
         * The IP protocol name (tcp, udp, icmp) or number
         * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
         * Use -1 to specify all.
         */
        var ipProtocol: kotlin.String? = null
        /**
         * The IDs of the security group rules.
         */
        var securityGroupRuleIds: List<String>? = null
        /**
         * &#91;EC2-Classic, default VPC&#93; The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same VPC. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
         */
        var sourceSecurityGroupName: kotlin.String? = null
        /**
         * &#91;EC2-Classic&#93; The Amazon Web Services account ID of the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.
         */
        var sourceSecurityGroupOwnerId: kotlin.String? = null
        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number,
         * use -1 to specify all ICMP codes for the ICMP type.
         */
        var toPort: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.RevokeSecurityGroupIngressRequest) : this() {
            this.cidrIp = x.cidrIp
            this.dryRun = x.dryRun
            this.fromPort = x.fromPort
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.ipPermissions = x.ipPermissions
            this.ipProtocol = x.ipProtocol
            this.securityGroupRuleIds = x.securityGroupRuleIds
            this.sourceSecurityGroupName = x.sourceSecurityGroupName
            this.sourceSecurityGroupOwnerId = x.sourceSecurityGroupOwnerId
            this.toPort = x.toPort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.RevokeSecurityGroupIngressRequest = RevokeSecurityGroupIngressRequest(this)
    }
}
