// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the launch specification for a Scheduled Instance.
 * If you are launching the Scheduled Instance in EC2-VPC, you must specify the ID of the subnet.
 * You can specify the subnet using either SubnetId or NetworkInterface.
 */
class ScheduledInstancesLaunchSpecification private constructor(builder: Builder) {
    /**
     * The block device mapping entries.
     */
    val blockDeviceMappings: List<ScheduledInstancesBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * Default: false
     */
    val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The IAM instance profile.
     */
    val iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesIamInstanceProfile? = builder.iamInstanceProfile
    /**
     * The ID of the Amazon Machine Image (AMI).
     */
    val imageId: kotlin.String? = builder.imageId
    /**
     * The instance type.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The ID of the kernel.
     */
    val kernelId: kotlin.String? = builder.kernelId
    /**
     * The name of the key pair.
     */
    val keyName: kotlin.String? = builder.keyName
    /**
     * Enable or disable monitoring for the instances.
     */
    val monitoring: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesMonitoring? = builder.monitoring
    /**
     * The network interfaces.
     */
    val networkInterfaces: List<ScheduledInstancesNetworkInterface>? = builder.networkInterfaces
    /**
     * The placement information.
     */
    val placement: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesPlacement? = builder.placement
    /**
     * The ID of the RAM disk.
     */
    val ramdiskId: kotlin.String? = builder.ramdiskId
    /**
     * The IDs of the security groups.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The ID of the subnet in which to launch the instances.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * The base64-encoded MIME user data.
     */
    val userData: kotlin.String? = builder.userData

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ScheduledInstancesLaunchSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledInstancesLaunchSpecification(")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("ebsOptimized=$ebsOptimized,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("placement=$placement,")
        append("ramdiskId=$ramdiskId,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetId=$subnetId,")
        append("userData=$userData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDeviceMappings?.hashCode() ?: 0
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledInstancesLaunchSpecification

        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (placement != other.placement) return false
        if (ramdiskId != other.ramdiskId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetId != other.subnetId) return false
        if (userData != other.userData) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ScheduledInstancesLaunchSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * The block device mapping entries.
         */
        var blockDeviceMappings: List<ScheduledInstancesBlockDeviceMapping>? = null
        /**
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * Default: false
         */
        var ebsOptimized: kotlin.Boolean? = null
        /**
         * The IAM instance profile.
         */
        var iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesIamInstanceProfile? = null
        /**
         * The ID of the Amazon Machine Image (AMI).
         */
        var imageId: kotlin.String? = null
        /**
         * The instance type.
         */
        var instanceType: kotlin.String? = null
        /**
         * The ID of the kernel.
         */
        var kernelId: kotlin.String? = null
        /**
         * The name of the key pair.
         */
        var keyName: kotlin.String? = null
        /**
         * Enable or disable monitoring for the instances.
         */
        var monitoring: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesMonitoring? = null
        /**
         * The network interfaces.
         */
        var networkInterfaces: List<ScheduledInstancesNetworkInterface>? = null
        /**
         * The placement information.
         */
        var placement: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesPlacement? = null
        /**
         * The ID of the RAM disk.
         */
        var ramdiskId: kotlin.String? = null
        /**
         * The IDs of the security groups.
         */
        var securityGroupIds: List<String>? = null
        /**
         * The ID of the subnet in which to launch the instances.
         */
        var subnetId: kotlin.String? = null
        /**
         * The base64-encoded MIME user data.
         */
        var userData: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesLaunchSpecification) : this() {
            this.blockDeviceMappings = x.blockDeviceMappings
            this.ebsOptimized = x.ebsOptimized
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.placement = x.placement
            this.ramdiskId = x.ramdiskId
            this.securityGroupIds = x.securityGroupIds
            this.subnetId = x.subnetId
            this.userData = x.userData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ScheduledInstancesLaunchSpecification = ScheduledInstancesLaunchSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstancesIamInstanceProfile] inside the given [block]
         */
        fun iamInstanceProfile(block: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesIamInstanceProfile.Builder.() -> kotlin.Unit) {
            this.iamInstanceProfile = aws.sdk.kotlin.services.ec2.model.ScheduledInstancesIamInstanceProfile.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstancesMonitoring] inside the given [block]
         */
        fun monitoring(block: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesMonitoring.Builder.() -> kotlin.Unit) {
            this.monitoring = aws.sdk.kotlin.services.ec2.model.ScheduledInstancesMonitoring.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstancesPlacement] inside the given [block]
         */
        fun placement(block: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesPlacement.Builder.() -> kotlin.Unit) {
            this.placement = aws.sdk.kotlin.services.ec2.model.ScheduledInstancesPlacement.invoke(block)
        }
    }
}
