// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a network interface for a Scheduled Instance.
 */
class ScheduledInstancesNetworkInterface private constructor(builder: Builder) {
    /**
     * Indicates whether to assign a public IPv4 address to instances launched in a VPC. The
     * public IPv4 address can only be assigned to a network interface for eth0, and can only be
     * assigned to a new network interface, not an existing one. You cannot specify more than one
     * network interface in the request. If launching into a default subnet, the default value is
     * true.
     */
    val associatePublicIpAddress: kotlin.Boolean? = builder.associatePublicIpAddress
    /**
     * Indicates whether to delete the interface when the instance is terminated.
     */
    val deleteOnTermination: kotlin.Boolean? = builder.deleteOnTermination
    /**
     * The description.
     */
    val description: kotlin.String? = builder.description
    /**
     * The index of the device for the network interface attachment.
     */
    val deviceIndex: kotlin.Int? = builder.deviceIndex
    /**
     * The IDs of the security groups.
     */
    val groups: List<String>? = builder.groups
    /**
     * The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.
     */
    val ipv6AddressCount: kotlin.Int? = builder.ipv6AddressCount
    /**
     * The specific IPv6 addresses from the subnet range.
     */
    val ipv6Addresses: List<ScheduledInstancesIpv6Address>? = builder.ipv6Addresses
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The IPv4 address of the network interface within the subnet.
     */
    val privateIpAddress: kotlin.String? = builder.privateIpAddress
    /**
     * The private IPv4 addresses.
     */
    val privateIpAddressConfigs: List<ScheduledInstancesPrivateIpAddressConfig>? = builder.privateIpAddressConfigs
    /**
     * The number of secondary private IPv4 addresses.
     */
    val secondaryPrivateIpAddressCount: kotlin.Int? = builder.secondaryPrivateIpAddressCount
    /**
     * The ID of the subnet.
     */
    val subnetId: kotlin.String? = builder.subnetId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ScheduledInstancesNetworkInterface = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledInstancesNetworkInterface(")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("deleteOnTermination=$deleteOnTermination,")
        append("description=$description,")
        append("deviceIndex=$deviceIndex,")
        append("groups=$groups,")
        append("ipv6AddressCount=$ipv6AddressCount,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddressConfigs=$privateIpAddressConfigs,")
        append("secondaryPrivateIpAddressCount=$secondaryPrivateIpAddressCount,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatePublicIpAddress?.hashCode() ?: 0
        result = 31 * result + (deleteOnTermination?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceIndex ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (ipv6AddressCount ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddressConfigs?.hashCode() ?: 0)
        result = 31 * result + (secondaryPrivateIpAddressCount ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledInstancesNetworkInterface

        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (deleteOnTermination != other.deleteOnTermination) return false
        if (description != other.description) return false
        if (deviceIndex != other.deviceIndex) return false
        if (groups != other.groups) return false
        if (ipv6AddressCount != other.ipv6AddressCount) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddressConfigs != other.privateIpAddressConfigs) return false
        if (secondaryPrivateIpAddressCount != other.secondaryPrivateIpAddressCount) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ScheduledInstancesNetworkInterface = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether to assign a public IPv4 address to instances launched in a VPC. The
         * public IPv4 address can only be assigned to a network interface for eth0, and can only be
         * assigned to a new network interface, not an existing one. You cannot specify more than one
         * network interface in the request. If launching into a default subnet, the default value is
         * true.
         */
        var associatePublicIpAddress: kotlin.Boolean? = null
        /**
         * Indicates whether to delete the interface when the instance is terminated.
         */
        var deleteOnTermination: kotlin.Boolean? = null
        /**
         * The description.
         */
        var description: kotlin.String? = null
        /**
         * The index of the device for the network interface attachment.
         */
        var deviceIndex: kotlin.Int? = null
        /**
         * The IDs of the security groups.
         */
        var groups: List<String>? = null
        /**
         * The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.
         */
        var ipv6AddressCount: kotlin.Int? = null
        /**
         * The specific IPv6 addresses from the subnet range.
         */
        var ipv6Addresses: List<ScheduledInstancesIpv6Address>? = null
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: kotlin.String? = null
        /**
         * The IPv4 address of the network interface within the subnet.
         */
        var privateIpAddress: kotlin.String? = null
        /**
         * The private IPv4 addresses.
         */
        var privateIpAddressConfigs: List<ScheduledInstancesPrivateIpAddressConfig>? = null
        /**
         * The number of secondary private IPv4 addresses.
         */
        var secondaryPrivateIpAddressCount: kotlin.Int? = null
        /**
         * The ID of the subnet.
         */
        var subnetId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ScheduledInstancesNetworkInterface) : this() {
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.deleteOnTermination = x.deleteOnTermination
            this.description = x.description
            this.deviceIndex = x.deviceIndex
            this.groups = x.groups
            this.ipv6AddressCount = x.ipv6AddressCount
            this.ipv6Addresses = x.ipv6Addresses
            this.networkInterfaceId = x.networkInterfaceId
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddressConfigs = x.privateIpAddressConfigs
            this.secondaryPrivateIpAddressCount = x.secondaryPrivateIpAddressCount
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ScheduledInstancesNetworkInterface = ScheduledInstancesNetworkInterface(this)
    }
}
