// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a security group rule.
 */
class SecurityGroupRule private constructor(builder: Builder) {
    /**
     * The IPv4 CIDR range.
     */
    val cidrIpv4: kotlin.String? = builder.cidrIpv4
    /**
     * The IPv6 CIDR range.
     */
    val cidrIpv6: kotlin.String? = builder.cidrIpv6
    /**
     * The security group rule description.
     */
    val description: kotlin.String? = builder.description
    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type. A value
     * of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must
     * specify all codes.
     */
    val fromPort: kotlin.Int? = builder.fromPort
    /**
     * The ID of the security group.
     */
    val groupId: kotlin.String? = builder.groupId
    /**
     * The ID of the Amazon Web Services account that owns the security group.
     */
    val groupOwnerId: kotlin.String? = builder.groupOwnerId
    /**
     * The IP protocol name (tcp, udp, icmp,
     * icmpv6) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
     * Use -1 to specify all protocols.
     */
    val ipProtocol: kotlin.String? = builder.ipProtocol
    /**
     * Indicates whether the security group rule is an outbound rule.
     */
    val isEgress: kotlin.Boolean? = builder.isEgress
    /**
     * The ID of the prefix list.
     */
    val prefixListId: kotlin.String? = builder.prefixListId
    /**
     * Describes the security group that is referenced in the rule.
     */
    val referencedGroupInfo: aws.sdk.kotlin.services.ec2.model.ReferencedSecurityGroup? = builder.referencedGroupInfo
    /**
     * The ID of the security group rule.
     */
    val securityGroupRuleId: kotlin.String? = builder.securityGroupRuleId
    /**
     * The tags applied to the security group rule.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    val toPort: kotlin.Int? = builder.toPort

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.SecurityGroupRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityGroupRule(")
        append("cidrIpv4=$cidrIpv4,")
        append("cidrIpv6=$cidrIpv6,")
        append("description=$description,")
        append("fromPort=$fromPort,")
        append("groupId=$groupId,")
        append("groupOwnerId=$groupOwnerId,")
        append("ipProtocol=$ipProtocol,")
        append("isEgress=$isEgress,")
        append("prefixListId=$prefixListId,")
        append("referencedGroupInfo=$referencedGroupInfo,")
        append("securityGroupRuleId=$securityGroupRuleId,")
        append("tags=$tags,")
        append("toPort=$toPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrIpv4?.hashCode() ?: 0
        result = 31 * result + (cidrIpv6?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fromPort ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupOwnerId?.hashCode() ?: 0)
        result = 31 * result + (ipProtocol?.hashCode() ?: 0)
        result = 31 * result + (isEgress?.hashCode() ?: 0)
        result = 31 * result + (prefixListId?.hashCode() ?: 0)
        result = 31 * result + (referencedGroupInfo?.hashCode() ?: 0)
        result = 31 * result + (securityGroupRuleId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecurityGroupRule

        if (cidrIpv4 != other.cidrIpv4) return false
        if (cidrIpv6 != other.cidrIpv6) return false
        if (description != other.description) return false
        if (fromPort != other.fromPort) return false
        if (groupId != other.groupId) return false
        if (groupOwnerId != other.groupOwnerId) return false
        if (ipProtocol != other.ipProtocol) return false
        if (isEgress != other.isEgress) return false
        if (prefixListId != other.prefixListId) return false
        if (referencedGroupInfo != other.referencedGroupInfo) return false
        if (securityGroupRuleId != other.securityGroupRuleId) return false
        if (tags != other.tags) return false
        if (toPort != other.toPort) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.SecurityGroupRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * The IPv4 CIDR range.
         */
        var cidrIpv4: kotlin.String? = null
        /**
         * The IPv6 CIDR range.
         */
        var cidrIpv6: kotlin.String? = null
        /**
         * The security group rule description.
         */
        var description: kotlin.String? = null
        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type. A value
         * of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must
         * specify all codes.
         */
        var fromPort: kotlin.Int? = null
        /**
         * The ID of the security group.
         */
        var groupId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the security group.
         */
        var groupOwnerId: kotlin.String? = null
        /**
         * The IP protocol name (tcp, udp, icmp,
         * icmpv6) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers).
         * Use -1 to specify all protocols.
         */
        var ipProtocol: kotlin.String? = null
        /**
         * Indicates whether the security group rule is an outbound rule.
         */
        var isEgress: kotlin.Boolean? = null
        /**
         * The ID of the prefix list.
         */
        var prefixListId: kotlin.String? = null
        /**
         * Describes the security group that is referenced in the rule.
         */
        var referencedGroupInfo: aws.sdk.kotlin.services.ec2.model.ReferencedSecurityGroup? = null
        /**
         * The ID of the security group rule.
         */
        var securityGroupRuleId: kotlin.String? = null
        /**
         * The tags applied to the security group rule.
         */
        var tags: List<Tag>? = null
        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         */
        var toPort: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.SecurityGroupRule) : this() {
            this.cidrIpv4 = x.cidrIpv4
            this.cidrIpv6 = x.cidrIpv6
            this.description = x.description
            this.fromPort = x.fromPort
            this.groupId = x.groupId
            this.groupOwnerId = x.groupOwnerId
            this.ipProtocol = x.ipProtocol
            this.isEgress = x.isEgress
            this.prefixListId = x.prefixListId
            this.referencedGroupInfo = x.referencedGroupInfo
            this.securityGroupRuleId = x.securityGroupRuleId
            this.tags = x.tags
            this.toPort = x.toPort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.SecurityGroupRule = SecurityGroupRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ReferencedSecurityGroup] inside the given [block]
         */
        fun referencedGroupInfo(block: aws.sdk.kotlin.services.ec2.model.ReferencedSecurityGroup.Builder.() -> kotlin.Unit) {
            this.referencedGroupInfo = aws.sdk.kotlin.services.ec2.model.ReferencedSecurityGroup.invoke(block)
        }
    }
}
