// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a snapshot.
 */
class SnapshotInfo private constructor(builder: Builder) {
    /**
     * Description specified by the CreateSnapshotRequest that has been applied to all
     * snapshots.
     */
    val description: kotlin.String? = builder.description
    /**
     * Indicates whether the snapshot is encrypted.
     */
    val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The ARN of the Outpost on which the snapshot is stored. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">Amazon EBS local snapshots on Outposts in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * Account id used when creating this snapshot.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * Progress this snapshot has made towards completing.
     */
    val progress: kotlin.String? = builder.progress
    /**
     * Snapshot id that can be used to describe this snapshot.
     */
    val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * Time this snapshot was started. This is the same for all snapshots initiated by the
     * same request.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Current state of the snapshot.
     */
    val state: aws.sdk.kotlin.services.ec2.model.SnapshotState? = builder.state
    /**
     * Tags associated with this snapshot.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Source volume from which this snapshot was created.
     */
    val volumeId: kotlin.String? = builder.volumeId
    /**
     * Size of the volume from which this snapshot was created.
     */
    val volumeSize: kotlin.Int? = builder.volumeSize

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.SnapshotInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnapshotInfo(")
        append("description=$description,")
        append("encrypted=$encrypted,")
        append("outpostArn=$outpostArn,")
        append("ownerId=$ownerId,")
        append("progress=$progress,")
        append("snapshotId=$snapshotId,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("tags=$tags,")
        append("volumeId=$volumeId,")
        append("volumeSize=$volumeSize)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnapshotInfo

        if (description != other.description) return false
        if (encrypted != other.encrypted) return false
        if (outpostArn != other.outpostArn) return false
        if (ownerId != other.ownerId) return false
        if (progress != other.progress) return false
        if (snapshotId != other.snapshotId) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (volumeId != other.volumeId) return false
        if (volumeSize != other.volumeSize) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.SnapshotInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * Description specified by the CreateSnapshotRequest that has been applied to all
         * snapshots.
         */
        var description: kotlin.String? = null
        /**
         * Indicates whether the snapshot is encrypted.
         */
        var encrypted: kotlin.Boolean? = null
        /**
         * The ARN of the Outpost on which the snapshot is stored. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">Amazon EBS local snapshots on Outposts in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var outpostArn: kotlin.String? = null
        /**
         * Account id used when creating this snapshot.
         */
        var ownerId: kotlin.String? = null
        /**
         * Progress this snapshot has made towards completing.
         */
        var progress: kotlin.String? = null
        /**
         * Snapshot id that can be used to describe this snapshot.
         */
        var snapshotId: kotlin.String? = null
        /**
         * Time this snapshot was started. This is the same for all snapshots initiated by the
         * same request.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Current state of the snapshot.
         */
        var state: aws.sdk.kotlin.services.ec2.model.SnapshotState? = null
        /**
         * Tags associated with this snapshot.
         */
        var tags: List<Tag>? = null
        /**
         * Source volume from which this snapshot was created.
         */
        var volumeId: kotlin.String? = null
        /**
         * Size of the volume from which this snapshot was created.
         */
        var volumeSize: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.SnapshotInfo) : this() {
            this.description = x.description
            this.encrypted = x.encrypted
            this.outpostArn = x.outpostArn
            this.ownerId = x.ownerId
            this.progress = x.progress
            this.snapshotId = x.snapshotId
            this.startTime = x.startTime
            this.state = x.state
            this.tags = x.tags
            this.volumeId = x.volumeId
            this.volumeSize = x.volumeSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.SnapshotInfo = SnapshotInfo(this)
    }
}
