// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a subnet.
 */
class Subnet private constructor(builder: Builder) {
    /**
     * Indicates whether a network interface created in this subnet (including a network
     * interface created by RunInstances) receives an IPv6 address.
     */
    val assignIpv6AddressOnCreation: kotlin.Boolean? = builder.assignIpv6AddressOnCreation
    /**
     * The Availability Zone of the subnet.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The AZ ID of the subnet.
     */
    val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The number of unused private IPv4 addresses in the subnet. The IPv4 addresses for any
     * stopped instances are considered unavailable.
     */
    val availableIpAddressCount: kotlin.Int? = builder.availableIpAddressCount
    /**
     * The IPv4 CIDR block assigned to the subnet.
     */
    val cidrBlock: kotlin.String? = builder.cidrBlock
    /**
     * The customer-owned IPv4 address pool associated with the subnet.
     */
    val customerOwnedIpv4Pool: kotlin.String? = builder.customerOwnedIpv4Pool
    /**
     * Indicates whether this is the default subnet for the Availability Zone.
     */
    val defaultForAz: kotlin.Boolean? = builder.defaultForAz
    /**
     * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet
     * should return synthetic IPv6 addresses for IPv4-only destinations.
     */
    val enableDns64: kotlin.Boolean? = builder.enableDns64
    /**
     * Indicates the device position for local network interfaces in this subnet. For example,
     * 1 indicates local network interfaces in this subnet are the secondary
     * network interface (eth1).
     */
    val enableLniAtDeviceIndex: kotlin.Int? = builder.enableLniAtDeviceIndex
    /**
     * Information about the IPv6 CIDR blocks associated with the subnet.
     */
    val ipv6CidrBlockAssociationSet: List<SubnetIpv6CidrBlockAssociation>? = builder.ipv6CidrBlockAssociationSet
    /**
     * Indicates whether this is an IPv6 only subnet.
     */
    val ipv6Native: kotlin.Boolean? = builder.ipv6Native
    /**
     * Indicates whether a network interface created in this subnet (including a network
     * interface created by RunInstances) receives a customer-owned IPv4 address.
     */
    val mapCustomerOwnedIpOnLaunch: kotlin.Boolean? = builder.mapCustomerOwnedIpOnLaunch
    /**
     * Indicates whether instances launched in this subnet receive a public IPv4 address.
     */
    val mapPublicIpOnLaunch: kotlin.Boolean? = builder.mapPublicIpOnLaunch
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The ID of the Amazon Web Services account that owns the subnet.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The type of hostnames to assign to instances in the subnet at launch. An instance hostname
     * is based on the IPv4 address or ID of the instance.
     */
    val privateDnsNameOptionsOnLaunch: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsOnLaunch? = builder.privateDnsNameOptionsOnLaunch
    /**
     * The current state of the subnet.
     */
    val state: aws.sdk.kotlin.services.ec2.model.SubnetState? = builder.state
    /**
     * The Amazon Resource Name (ARN) of the subnet.
     */
    val subnetArn: kotlin.String? = builder.subnetArn
    /**
     * The ID of the subnet.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * Any tags assigned to the subnet.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC the subnet is in.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.Subnet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Subnet(")
        append("assignIpv6AddressOnCreation=$assignIpv6AddressOnCreation,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("availableIpAddressCount=$availableIpAddressCount,")
        append("cidrBlock=$cidrBlock,")
        append("customerOwnedIpv4Pool=$customerOwnedIpv4Pool,")
        append("defaultForAz=$defaultForAz,")
        append("enableDns64=$enableDns64,")
        append("enableLniAtDeviceIndex=$enableLniAtDeviceIndex,")
        append("ipv6CidrBlockAssociationSet=$ipv6CidrBlockAssociationSet,")
        append("ipv6Native=$ipv6Native,")
        append("mapCustomerOwnedIpOnLaunch=$mapCustomerOwnedIpOnLaunch,")
        append("mapPublicIpOnLaunch=$mapPublicIpOnLaunch,")
        append("outpostArn=$outpostArn,")
        append("ownerId=$ownerId,")
        append("privateDnsNameOptionsOnLaunch=$privateDnsNameOptionsOnLaunch,")
        append("state=$state,")
        append("subnetArn=$subnetArn,")
        append("subnetId=$subnetId,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignIpv6AddressOnCreation?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (availableIpAddressCount ?: 0)
        result = 31 * result + (cidrBlock?.hashCode() ?: 0)
        result = 31 * result + (customerOwnedIpv4Pool?.hashCode() ?: 0)
        result = 31 * result + (defaultForAz?.hashCode() ?: 0)
        result = 31 * result + (enableDns64?.hashCode() ?: 0)
        result = 31 * result + (enableLniAtDeviceIndex ?: 0)
        result = 31 * result + (ipv6CidrBlockAssociationSet?.hashCode() ?: 0)
        result = 31 * result + (ipv6Native?.hashCode() ?: 0)
        result = 31 * result + (mapCustomerOwnedIpOnLaunch?.hashCode() ?: 0)
        result = 31 * result + (mapPublicIpOnLaunch?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (privateDnsNameOptionsOnLaunch?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnetArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Subnet

        if (assignIpv6AddressOnCreation != other.assignIpv6AddressOnCreation) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (availableIpAddressCount != other.availableIpAddressCount) return false
        if (cidrBlock != other.cidrBlock) return false
        if (customerOwnedIpv4Pool != other.customerOwnedIpv4Pool) return false
        if (defaultForAz != other.defaultForAz) return false
        if (enableDns64 != other.enableDns64) return false
        if (enableLniAtDeviceIndex != other.enableLniAtDeviceIndex) return false
        if (ipv6CidrBlockAssociationSet != other.ipv6CidrBlockAssociationSet) return false
        if (ipv6Native != other.ipv6Native) return false
        if (mapCustomerOwnedIpOnLaunch != other.mapCustomerOwnedIpOnLaunch) return false
        if (mapPublicIpOnLaunch != other.mapPublicIpOnLaunch) return false
        if (outpostArn != other.outpostArn) return false
        if (ownerId != other.ownerId) return false
        if (privateDnsNameOptionsOnLaunch != other.privateDnsNameOptionsOnLaunch) return false
        if (state != other.state) return false
        if (subnetArn != other.subnetArn) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.Subnet = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether a network interface created in this subnet (including a network
         * interface created by RunInstances) receives an IPv6 address.
         */
        var assignIpv6AddressOnCreation: kotlin.Boolean? = null
        /**
         * The Availability Zone of the subnet.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The AZ ID of the subnet.
         */
        var availabilityZoneId: kotlin.String? = null
        /**
         * The number of unused private IPv4 addresses in the subnet. The IPv4 addresses for any
         * stopped instances are considered unavailable.
         */
        var availableIpAddressCount: kotlin.Int? = null
        /**
         * The IPv4 CIDR block assigned to the subnet.
         */
        var cidrBlock: kotlin.String? = null
        /**
         * The customer-owned IPv4 address pool associated with the subnet.
         */
        var customerOwnedIpv4Pool: kotlin.String? = null
        /**
         * Indicates whether this is the default subnet for the Availability Zone.
         */
        var defaultForAz: kotlin.Boolean? = null
        /**
         * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet
         * should return synthetic IPv6 addresses for IPv4-only destinations.
         */
        var enableDns64: kotlin.Boolean? = null
        /**
         * Indicates the device position for local network interfaces in this subnet. For example,
         * 1 indicates local network interfaces in this subnet are the secondary
         * network interface (eth1).
         */
        var enableLniAtDeviceIndex: kotlin.Int? = null
        /**
         * Information about the IPv6 CIDR blocks associated with the subnet.
         */
        var ipv6CidrBlockAssociationSet: List<SubnetIpv6CidrBlockAssociation>? = null
        /**
         * Indicates whether this is an IPv6 only subnet.
         */
        var ipv6Native: kotlin.Boolean? = null
        /**
         * Indicates whether a network interface created in this subnet (including a network
         * interface created by RunInstances) receives a customer-owned IPv4 address.
         */
        var mapCustomerOwnedIpOnLaunch: kotlin.Boolean? = null
        /**
         * Indicates whether instances launched in this subnet receive a public IPv4 address.
         */
        var mapPublicIpOnLaunch: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        var outpostArn: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the subnet.
         */
        var ownerId: kotlin.String? = null
        /**
         * The type of hostnames to assign to instances in the subnet at launch. An instance hostname
         * is based on the IPv4 address or ID of the instance.
         */
        var privateDnsNameOptionsOnLaunch: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsOnLaunch? = null
        /**
         * The current state of the subnet.
         */
        var state: aws.sdk.kotlin.services.ec2.model.SubnetState? = null
        /**
         * The Amazon Resource Name (ARN) of the subnet.
         */
        var subnetArn: kotlin.String? = null
        /**
         * The ID of the subnet.
         */
        var subnetId: kotlin.String? = null
        /**
         * Any tags assigned to the subnet.
         */
        var tags: List<Tag>? = null
        /**
         * The ID of the VPC the subnet is in.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.Subnet) : this() {
            this.assignIpv6AddressOnCreation = x.assignIpv6AddressOnCreation
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.availableIpAddressCount = x.availableIpAddressCount
            this.cidrBlock = x.cidrBlock
            this.customerOwnedIpv4Pool = x.customerOwnedIpv4Pool
            this.defaultForAz = x.defaultForAz
            this.enableDns64 = x.enableDns64
            this.enableLniAtDeviceIndex = x.enableLniAtDeviceIndex
            this.ipv6CidrBlockAssociationSet = x.ipv6CidrBlockAssociationSet
            this.ipv6Native = x.ipv6Native
            this.mapCustomerOwnedIpOnLaunch = x.mapCustomerOwnedIpOnLaunch
            this.mapPublicIpOnLaunch = x.mapPublicIpOnLaunch
            this.outpostArn = x.outpostArn
            this.ownerId = x.ownerId
            this.privateDnsNameOptionsOnLaunch = x.privateDnsNameOptionsOnLaunch
            this.state = x.state
            this.subnetArn = x.subnetArn
            this.subnetId = x.subnetId
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.Subnet = Subnet(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsOnLaunch] inside the given [block]
         */
        fun privateDnsNameOptionsOnLaunch(block: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsOnLaunch.Builder.() -> kotlin.Unit) {
            this.privateDnsNameOptionsOnLaunch = aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsOnLaunch.invoke(block)
        }
    }
}
