// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The number of units to request. You can choose to set the target capacity in terms of
 * instances or a performance characteristic that is important to your application workload,
 * such as vCPUs, memory, or I/O. If the request type is maintain, you can
 * specify a target capacity of 0 and add capacity later.
 * You can use the On-Demand Instance MaxTotalPrice parameter, the Spot Instance
 * MaxTotalPrice, or both to ensure that your fleet cost does not exceed your
 * budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances in your request, EC2 Fleet
 * will launch instances until it reaches the maximum amount that you're willing to pay. When
 * the maximum amount you're willing to pay is reached, the fleet stops launching instances
 * even if it hasn’t met the target capacity. The MaxTotalPrice parameters are
 * located in <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_OnDemandOptions.html">OnDemandOptions
 * and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotOptions">SpotOptions.
 */
class TargetCapacitySpecification private constructor(builder: Builder) {
    /**
     * The default TotalTargetCapacity, which is either Spot or
     * On-Demand.
     */
    val defaultTargetCapacityType: aws.sdk.kotlin.services.ec2.model.DefaultTargetCapacityType? = builder.defaultTargetCapacityType
    /**
     * The number of On-Demand units to request. If you specify a target capacity for Spot units, you cannot specify a target capacity for On-Demand units.
     */
    val onDemandTargetCapacity: kotlin.Int? = builder.onDemandTargetCapacity
    /**
     * The maximum number of Spot units to launch. If you specify a target capacity for On-Demand units, you cannot specify a target capacity for Spot units.
     */
    val spotTargetCapacity: kotlin.Int? = builder.spotTargetCapacity
    /**
     * The unit for the target capacity.
     * Default: units (translates to number of instances)
     */
    val targetCapacityUnitType: aws.sdk.kotlin.services.ec2.model.TargetCapacityUnitType? = builder.targetCapacityUnitType
    /**
     * The number of units to request, filled using
     * DefaultTargetCapacityType.
     */
    val totalTargetCapacity: kotlin.Int? = builder.totalTargetCapacity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.TargetCapacitySpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetCapacitySpecification(")
        append("defaultTargetCapacityType=$defaultTargetCapacityType,")
        append("onDemandTargetCapacity=$onDemandTargetCapacity,")
        append("spotTargetCapacity=$spotTargetCapacity,")
        append("targetCapacityUnitType=$targetCapacityUnitType,")
        append("totalTargetCapacity=$totalTargetCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultTargetCapacityType?.hashCode() ?: 0
        result = 31 * result + (onDemandTargetCapacity ?: 0)
        result = 31 * result + (spotTargetCapacity ?: 0)
        result = 31 * result + (targetCapacityUnitType?.hashCode() ?: 0)
        result = 31 * result + (totalTargetCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetCapacitySpecification

        if (defaultTargetCapacityType != other.defaultTargetCapacityType) return false
        if (onDemandTargetCapacity != other.onDemandTargetCapacity) return false
        if (spotTargetCapacity != other.spotTargetCapacity) return false
        if (targetCapacityUnitType != other.targetCapacityUnitType) return false
        if (totalTargetCapacity != other.totalTargetCapacity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.TargetCapacitySpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * The default TotalTargetCapacity, which is either Spot or
         * On-Demand.
         */
        var defaultTargetCapacityType: aws.sdk.kotlin.services.ec2.model.DefaultTargetCapacityType? = null
        /**
         * The number of On-Demand units to request. If you specify a target capacity for Spot units, you cannot specify a target capacity for On-Demand units.
         */
        var onDemandTargetCapacity: kotlin.Int? = null
        /**
         * The maximum number of Spot units to launch. If you specify a target capacity for On-Demand units, you cannot specify a target capacity for Spot units.
         */
        var spotTargetCapacity: kotlin.Int? = null
        /**
         * The unit for the target capacity.
         * Default: units (translates to number of instances)
         */
        var targetCapacityUnitType: aws.sdk.kotlin.services.ec2.model.TargetCapacityUnitType? = null
        /**
         * The number of units to request, filled using
         * DefaultTargetCapacityType.
         */
        var totalTargetCapacity: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.TargetCapacitySpecification) : this() {
            this.defaultTargetCapacityType = x.defaultTargetCapacityType
            this.onDemandTargetCapacity = x.onDemandTargetCapacity
            this.spotTargetCapacity = x.spotTargetCapacity
            this.targetCapacityUnitType = x.targetCapacityUnitType
            this.totalTargetCapacity = x.totalTargetCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.TargetCapacitySpecification = TargetCapacitySpecification(this)
    }
}
