// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the transit gateway multicast domain.
 */
class TransitGatewayMulticastDomain private constructor(builder: Builder) {
    /**
     * The time the transit gateway multicast domain was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The options for the transit gateway multicast domain.
     */
    val options: aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomainOptions? = builder.options
    /**
     * The ID of the Amazon Web Services account that owns the transit gateway multicast domain.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The state of the transit gateway multicast domain.
     */
    val state: aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomainState? = builder.state
    /**
     * The tags for the transit gateway multicast domain.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the transit gateway.
     */
    val transitGatewayId: kotlin.String? = builder.transitGatewayId
    /**
     * The Amazon Resource Name (ARN) of the transit gateway multicast domain.
     */
    val transitGatewayMulticastDomainArn: kotlin.String? = builder.transitGatewayMulticastDomainArn
    /**
     * The ID of the transit gateway multicast domain.
     */
    val transitGatewayMulticastDomainId: kotlin.String? = builder.transitGatewayMulticastDomainId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomain = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayMulticastDomain(")
        append("creationTime=$creationTime,")
        append("options=$options,")
        append("ownerId=$ownerId,")
        append("state=$state,")
        append("tags=$tags,")
        append("transitGatewayId=$transitGatewayId,")
        append("transitGatewayMulticastDomainArn=$transitGatewayMulticastDomainArn,")
        append("transitGatewayMulticastDomainId=$transitGatewayMulticastDomainId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayMulticastDomainArn?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayMulticastDomainId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransitGatewayMulticastDomain

        if (creationTime != other.creationTime) return false
        if (options != other.options) return false
        if (ownerId != other.ownerId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (transitGatewayMulticastDomainArn != other.transitGatewayMulticastDomainArn) return false
        if (transitGatewayMulticastDomainId != other.transitGatewayMulticastDomainId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomain = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time the transit gateway multicast domain was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The options for the transit gateway multicast domain.
         */
        var options: aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomainOptions? = null
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway multicast domain.
         */
        var ownerId: kotlin.String? = null
        /**
         * The state of the transit gateway multicast domain.
         */
        var state: aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomainState? = null
        /**
         * The tags for the transit gateway multicast domain.
         */
        var tags: List<Tag>? = null
        /**
         * The ID of the transit gateway.
         */
        var transitGatewayId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the transit gateway multicast domain.
         */
        var transitGatewayMulticastDomainArn: kotlin.String? = null
        /**
         * The ID of the transit gateway multicast domain.
         */
        var transitGatewayMulticastDomainId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomain) : this() {
            this.creationTime = x.creationTime
            this.options = x.options
            this.ownerId = x.ownerId
            this.state = x.state
            this.tags = x.tags
            this.transitGatewayId = x.transitGatewayId
            this.transitGatewayMulticastDomainArn = x.transitGatewayMulticastDomainArn
            this.transitGatewayMulticastDomainId = x.transitGatewayMulticastDomainId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomain = TransitGatewayMulticastDomain(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomainOptions] inside the given [block]
         */
        fun options(block: aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomainOptions.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomainOptions.invoke(block)
        }
    }
}
