// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a security group and Amazon Web Services account ID pair.
 */
class UserIdGroupPair private constructor(builder: Builder) {
    /**
     * A description for the security group rule that references this user ID group
     * pair.
     * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9,
     * spaces, and ._-:/()#,@&#91;&#93;+=;{}!$*
     */
    val description: kotlin.String? = builder.description
    /**
     * The ID of the security group.
     */
    val groupId: kotlin.String? = builder.groupId
    /**
     * The name of the security group. In a request, use this parameter for a security group
     * in EC2-Classic or a default VPC only. For a security group in a nondefault VPC, use the
     * security group ID.
     * For a referenced security group in another VPC, this value is not returned if the
     * referenced security group is deleted.
     */
    val groupName: kotlin.String? = builder.groupName
    /**
     * The status of a VPC peering connection, if applicable.
     */
    val peeringStatus: kotlin.String? = builder.peeringStatus
    /**
     * The ID of an Amazon Web Services account.
     * For a referenced security group in another VPC, the account ID of the referenced
     * security group is returned in the response. If the referenced security group is deleted,
     * this value is not returned.
     * &#91;EC2-Classic&#93; Required when adding or removing rules that reference a security group
     * in another Amazon Web Services account.
     */
    val userId: kotlin.String? = builder.userId
    /**
     * The ID of the VPC for the referenced security group, if applicable.
     */
    val vpcId: kotlin.String? = builder.vpcId
    /**
     * The ID of the VPC peering connection, if applicable.
     */
    val vpcPeeringConnectionId: kotlin.String? = builder.vpcPeeringConnectionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.UserIdGroupPair = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserIdGroupPair(")
        append("description=$description,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("peeringStatus=$peeringStatus,")
        append("userId=$userId,")
        append("vpcId=$vpcId,")
        append("vpcPeeringConnectionId=$vpcPeeringConnectionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (peeringStatus?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserIdGroupPair

        if (description != other.description) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (peeringStatus != other.peeringStatus) return false
        if (userId != other.userId) return false
        if (vpcId != other.vpcId) return false
        if (vpcPeeringConnectionId != other.vpcPeeringConnectionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.UserIdGroupPair = Builder(this).apply(block).build()

    class Builder {
        /**
         * A description for the security group rule that references this user ID group
         * pair.
         * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9,
         * spaces, and ._-:/()#,@&#91;&#93;+=;{}!$*
         */
        var description: kotlin.String? = null
        /**
         * The ID of the security group.
         */
        var groupId: kotlin.String? = null
        /**
         * The name of the security group. In a request, use this parameter for a security group
         * in EC2-Classic or a default VPC only. For a security group in a nondefault VPC, use the
         * security group ID.
         * For a referenced security group in another VPC, this value is not returned if the
         * referenced security group is deleted.
         */
        var groupName: kotlin.String? = null
        /**
         * The status of a VPC peering connection, if applicable.
         */
        var peeringStatus: kotlin.String? = null
        /**
         * The ID of an Amazon Web Services account.
         * For a referenced security group in another VPC, the account ID of the referenced
         * security group is returned in the response. If the referenced security group is deleted,
         * this value is not returned.
         * &#91;EC2-Classic&#93; Required when adding or removing rules that reference a security group
         * in another Amazon Web Services account.
         */
        var userId: kotlin.String? = null
        /**
         * The ID of the VPC for the referenced security group, if applicable.
         */
        var vpcId: kotlin.String? = null
        /**
         * The ID of the VPC peering connection, if applicable.
         */
        var vpcPeeringConnectionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.UserIdGroupPair) : this() {
            this.description = x.description
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.peeringStatus = x.peeringStatus
            this.userId = x.userId
            this.vpcId = x.vpcId
            this.vpcPeeringConnectionId = x.vpcPeeringConnectionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.UserIdGroupPair = UserIdGroupPair(this)
    }
}
