// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the modification status of an EBS volume.
 * If the volume has never been modified, some element values will be null.
 */
class VolumeModification private constructor(builder: Builder) {
    /**
     * The modification completion or failure time.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The current modification state. The modification state is null for unmodified
     * volumes.
     */
    val modificationState: aws.sdk.kotlin.services.ec2.model.VolumeModificationState? = builder.modificationState
    /**
     * The original IOPS rate of the volume.
     */
    val originalIops: kotlin.Int? = builder.originalIops
    /**
     * The original setting for Amazon EBS Multi-Attach.
     */
    val originalMultiAttachEnabled: kotlin.Boolean? = builder.originalMultiAttachEnabled
    /**
     * The original size of the volume, in GiB.
     */
    val originalSize: kotlin.Int? = builder.originalSize
    /**
     * The original throughput of the volume, in MiB/s.
     */
    val originalThroughput: kotlin.Int? = builder.originalThroughput
    /**
     * The original EBS volume type of the volume.
     */
    val originalVolumeType: aws.sdk.kotlin.services.ec2.model.VolumeType? = builder.originalVolumeType
    /**
     * The modification progress, from 0 to 100 percent complete.
     */
    val progress: kotlin.Long? = builder.progress
    /**
     * The modification start time.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * A status message about the modification progress or failure.
     */
    val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The target IOPS rate of the volume.
     */
    val targetIops: kotlin.Int? = builder.targetIops
    /**
     * The target setting for Amazon EBS Multi-Attach.
     */
    val targetMultiAttachEnabled: kotlin.Boolean? = builder.targetMultiAttachEnabled
    /**
     * The target size of the volume, in GiB.
     */
    val targetSize: kotlin.Int? = builder.targetSize
    /**
     * The target throughput of the volume, in MiB/s.
     */
    val targetThroughput: kotlin.Int? = builder.targetThroughput
    /**
     * The target EBS volume type of the volume.
     */
    val targetVolumeType: aws.sdk.kotlin.services.ec2.model.VolumeType? = builder.targetVolumeType
    /**
     * The ID of the volume.
     */
    val volumeId: kotlin.String? = builder.volumeId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VolumeModification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeModification(")
        append("endTime=$endTime,")
        append("modificationState=$modificationState,")
        append("originalIops=$originalIops,")
        append("originalMultiAttachEnabled=$originalMultiAttachEnabled,")
        append("originalSize=$originalSize,")
        append("originalThroughput=$originalThroughput,")
        append("originalVolumeType=$originalVolumeType,")
        append("progress=$progress,")
        append("startTime=$startTime,")
        append("statusMessage=$statusMessage,")
        append("targetIops=$targetIops,")
        append("targetMultiAttachEnabled=$targetMultiAttachEnabled,")
        append("targetSize=$targetSize,")
        append("targetThroughput=$targetThroughput,")
        append("targetVolumeType=$targetVolumeType,")
        append("volumeId=$volumeId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (modificationState?.hashCode() ?: 0)
        result = 31 * result + (originalIops ?: 0)
        result = 31 * result + (originalMultiAttachEnabled?.hashCode() ?: 0)
        result = 31 * result + (originalSize ?: 0)
        result = 31 * result + (originalThroughput ?: 0)
        result = 31 * result + (originalVolumeType?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (targetIops ?: 0)
        result = 31 * result + (targetMultiAttachEnabled?.hashCode() ?: 0)
        result = 31 * result + (targetSize ?: 0)
        result = 31 * result + (targetThroughput ?: 0)
        result = 31 * result + (targetVolumeType?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VolumeModification

        if (endTime != other.endTime) return false
        if (modificationState != other.modificationState) return false
        if (originalIops != other.originalIops) return false
        if (originalMultiAttachEnabled != other.originalMultiAttachEnabled) return false
        if (originalSize != other.originalSize) return false
        if (originalThroughput != other.originalThroughput) return false
        if (originalVolumeType != other.originalVolumeType) return false
        if (progress != other.progress) return false
        if (startTime != other.startTime) return false
        if (statusMessage != other.statusMessage) return false
        if (targetIops != other.targetIops) return false
        if (targetMultiAttachEnabled != other.targetMultiAttachEnabled) return false
        if (targetSize != other.targetSize) return false
        if (targetThroughput != other.targetThroughput) return false
        if (targetVolumeType != other.targetVolumeType) return false
        if (volumeId != other.volumeId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VolumeModification = Builder(this).apply(block).build()

    class Builder {
        /**
         * The modification completion or failure time.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current modification state. The modification state is null for unmodified
         * volumes.
         */
        var modificationState: aws.sdk.kotlin.services.ec2.model.VolumeModificationState? = null
        /**
         * The original IOPS rate of the volume.
         */
        var originalIops: kotlin.Int? = null
        /**
         * The original setting for Amazon EBS Multi-Attach.
         */
        var originalMultiAttachEnabled: kotlin.Boolean? = null
        /**
         * The original size of the volume, in GiB.
         */
        var originalSize: kotlin.Int? = null
        /**
         * The original throughput of the volume, in MiB/s.
         */
        var originalThroughput: kotlin.Int? = null
        /**
         * The original EBS volume type of the volume.
         */
        var originalVolumeType: aws.sdk.kotlin.services.ec2.model.VolumeType? = null
        /**
         * The modification progress, from 0 to 100 percent complete.
         */
        var progress: kotlin.Long? = null
        /**
         * The modification start time.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A status message about the modification progress or failure.
         */
        var statusMessage: kotlin.String? = null
        /**
         * The target IOPS rate of the volume.
         */
        var targetIops: kotlin.Int? = null
        /**
         * The target setting for Amazon EBS Multi-Attach.
         */
        var targetMultiAttachEnabled: kotlin.Boolean? = null
        /**
         * The target size of the volume, in GiB.
         */
        var targetSize: kotlin.Int? = null
        /**
         * The target throughput of the volume, in MiB/s.
         */
        var targetThroughput: kotlin.Int? = null
        /**
         * The target EBS volume type of the volume.
         */
        var targetVolumeType: aws.sdk.kotlin.services.ec2.model.VolumeType? = null
        /**
         * The ID of the volume.
         */
        var volumeId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VolumeModification) : this() {
            this.endTime = x.endTime
            this.modificationState = x.modificationState
            this.originalIops = x.originalIops
            this.originalMultiAttachEnabled = x.originalMultiAttachEnabled
            this.originalSize = x.originalSize
            this.originalThroughput = x.originalThroughput
            this.originalVolumeType = x.originalVolumeType
            this.progress = x.progress
            this.startTime = x.startTime
            this.statusMessage = x.statusMessage
            this.targetIops = x.targetIops
            this.targetMultiAttachEnabled = x.targetMultiAttachEnabled
            this.targetSize = x.targetSize
            this.targetThroughput = x.targetThroughput
            this.targetVolumeType = x.targetVolumeType
            this.volumeId = x.volumeId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VolumeModification = VolumeModification(this)
    }
}
