// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.AssignPrivateIpAddressesResponse
import aws.sdk.kotlin.services.ec2.model.AssignedPrivateIpAddress
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.sdk.kotlin.services.ec2.model.Ipv4PrefixSpecification
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class AssignPrivateIpAddressesOperationDeserializer: HttpDeserialize<AssignPrivateIpAddressesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssignPrivateIpAddressesResponse {
        if (!response.status.isSuccess()) {
            throwAssignPrivateIpAddressesError(context, response)
        }
        val builder = AssignPrivateIpAddressesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssignPrivateIpAddressesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeAssignPrivateIpAddressesOperationBody(builder: AssignPrivateIpAddressesResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val ASSIGNEDIPV4PREFIXES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("assignedIpv4PrefixSet"), XmlCollectionName("item"))
    val ASSIGNEDPRIVATEIPADDRESSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("assignedPrivateIpAddressesSet"), XmlCollectionName("item"))
    val NETWORKINTERFACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("networkInterfaceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("AssignPrivateIpAddressesResult"))
        field(ASSIGNEDIPV4PREFIXES_DESCRIPTOR)
        field(ASSIGNEDPRIVATEIPADDRESSES_DESCRIPTOR)
        field(NETWORKINTERFACEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSIGNEDIPV4PREFIXES_DESCRIPTOR.index -> builder.assignedIpv4Prefixes =
                    deserializer.deserializeList(ASSIGNEDIPV4PREFIXES_DESCRIPTOR) {
                        val col0 = mutableListOf<Ipv4PrefixSpecification>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIpv4PrefixSpecificationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSIGNEDPRIVATEIPADDRESSES_DESCRIPTOR.index -> builder.assignedPrivateIpAddresses =
                    deserializer.deserializeList(ASSIGNEDPRIVATEIPADDRESSES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssignedPrivateIpAddress>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssignedPrivateIpAddressDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NETWORKINTERFACEID_DESCRIPTOR.index -> builder.networkInterfaceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwAssignPrivateIpAddressesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw Ec2Exception("Failed to parse response as 'ec2Query' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    throw Ec2Exception(errorDetails.message)
}
